/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jcodings.Encoding;
import org.jruby.AbstractRubyMethod;
import org.jruby.CompatVersion;
import org.jruby.EvalType;
import org.jruby.IncludedModule;
import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.PrependedModule;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyNameError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.anno.TypePopulator;
import org.jruby.common.IRubyWarnings;
import org.jruby.embed.Extension;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.internal.runtime.methods.AttrWriterMethod;
import org.jruby.internal.runtime.methods.CacheableMethod;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefineMethodMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.Framing;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.Scoping;
import org.jruby.internal.runtime.methods.SynchronizedDynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMethod;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.javasupport.binding.Initializer;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.runtime.profile.MethodEnhancer;
import org.jruby.util.ClassProvider;
import org.jruby.util.IdUtil;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.WeakHashSet;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Module"})
public class RubyModule
extends RubyObject {
    private static final Logger LOG;
    protected static final String ERR_INSECURE_SET_CONSTANT = "Insecure: can't modify constant";
    public static final ObjectAllocator MODULE_ALLOCATOR;
    protected static final CacheEntryFactory NormalCacheEntryFactory;
    private volatile CacheEntryFactory cacheEntryFactory;
    public KindOf kindOf = KindOf.DEFAULT_KIND_OF;
    public final int id;
    public RubyModule parent;
    protected String baseName;
    private String anonymousName;
    private String cachedName;
    private volatile Map<String, ConstantEntry> constants = Collections.EMPTY_MAP;
    private volatile Map<String, Autoload> autoloads = Collections.EMPTY_MAP;
    protected volatile Map<String, DynamicMethod> methods = Collections.EMPTY_MAP;
    protected Map<String, CacheEntry> cachedMethods = Collections.EMPTY_MAP;
    protected int generation;
    protected Integer generationObject;
    protected volatile Set<RubyClass> includingHierarchies = Collections.EMPTY_SET;
    protected volatile RubyModule methodLocation = this;
    private volatile transient Set<ClassProvider> classProviders = Collections.EMPTY_SET;
    protected RubyClass superClass;
    @Deprecated
    public int index;
    @Deprecated
    public static final Set<String> SCOPE_CAPTURING_METHODS;
    protected ClassIndex classIndex = ClassIndex.NO_INDEX;
    private volatile Map<String, IRubyObject> classVariables = Collections.EMPTY_MAP;
    private volatile Map<RubyClass, RubyModule> refinements = Collections.EMPTY_MAP;
    private volatile Map<RubyClass, IncludedModuleWrapper> activatedRefinements = Collections.EMPTY_MAP;
    volatile RubyClass refinedClass = null;
    private volatile RubyModule definedAt = null;
    private static final AtomicReferenceFieldUpdater<RubyModule, Map> CLASSVARS_UPDATER;
    protected final Invalidator methodInvalidator;
    private boolean javaProxy = false;

    public static RubyClass createModuleClass(Ruby runtime, RubyClass moduleClass) {
        moduleClass.setClassIndex(ClassIndex.MODULE);
        moduleClass.setReifiedClass(RubyModule.class);
        moduleClass.kindOf = new JavaClassKindOf(RubyModule.class);
        moduleClass.defineAnnotatedMethods(RubyModule.class);
        moduleClass.defineAnnotatedMethods(ModuleKernelMethods.class);
        return moduleClass;
    }

    public void checkValidBindTargetFrom(ThreadContext context, RubyModule originModule) throws RaiseException {
        if (originModule.isModule()) {
            return;
        }
        if (!this.hasModuleInHierarchy(originModule)) {
            if (originModule instanceof MetaClass) {
                throw context.runtime.newTypeError("can't bind singleton method to a different class");
            }
            throw context.runtime.newTypeError("bind argument must be an instance of " + originModule.getName());
        }
    }

    public ClassIndex getClassIndex() {
        return this.classIndex;
    }

    void setClassIndex(ClassIndex classIndex) {
        this.classIndex = classIndex;
        this.index = classIndex.ordinal();
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.MODULE;
    }

    @Override
    public boolean isModule() {
        return true;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isInstance(IRubyObject object) {
        return this.kindOf.isKindOf(object, this);
    }

    public Map<String, ConstantEntry> getConstantMap() {
        return this.constants;
    }

    public synchronized Map<String, ConstantEntry> getConstantMapForWrite() {
        return this.constants == Collections.EMPTY_MAP ? (this.constants = new ConcurrentHashMap<String, ConstantEntry>(4, 0.9f, 1)) : this.constants;
    }

    private Map<String, Autoload> getAutoloadMap() {
        return this.autoloads;
    }

    private synchronized Map<String, Autoload> getAutoloadMapForWrite() {
        return this.autoloads == Collections.EMPTY_MAP ? (this.autoloads = new ConcurrentHashMap<String, Autoload>(4, 0.9f, 1)) : this.autoloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncludingHierarchy(IncludedModule hierarchy) {
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> including = this.includingHierarchies;
            if (including == Collections.EMPTY_SET) {
                including = this.includingHierarchies = new WeakHashSet<RubyClass>(4);
            }
            including.add(hierarchy);
        }
    }

    protected RubyModule(Ruby runtime, RubyClass metaClass, boolean objectSpace) {
        super(runtime, metaClass, objectSpace);
        this.id = runtime.allocModuleId();
        runtime.addModule(this);
        this.setFlag(2048, !this.isClass());
        this.generation = runtime.getNextModuleGeneration();
        this.generationObject = this.generation;
        this.cacheEntryFactory = runtime.getInstanceConfig().isProfiling() ? new ProfilingCacheEntryFactory(runtime, NormalCacheEntryFactory) : NormalCacheEntryFactory;
        this.methodInvalidator = OptoFactory.newMethodInvalidator(this);
    }

    protected RubyModule(Ruby runtime, RubyClass metaClass) {
        this(runtime, metaClass, runtime.isObjectSpaceEnabled());
    }

    protected RubyModule(Ruby runtime) {
        this(runtime, runtime.getModule());
    }

    public boolean needsImplementer() {
        return this.getFlag(2048);
    }

    public static RubyModule newModule(Ruby runtime) {
        return new RubyModule(runtime);
    }

    public static RubyModule newModule(Ruby runtime, String name2, RubyModule parent, boolean setParent) {
        RubyModule module = RubyModule.newModule(runtime);
        module.setBaseName(name2);
        if (setParent) {
            module.setParent(parent);
        }
        parent.setConstant(name2, module);
        return module;
    }

    public synchronized void addClassProvider(ClassProvider provider) {
        if (!this.classProviders.contains(provider)) {
            HashSet<ClassProvider> cp = new HashSet<ClassProvider>(this.classProviders);
            cp.add(provider);
            this.classProviders = cp;
        }
    }

    public synchronized void removeClassProvider(ClassProvider provider) {
        HashSet<ClassProvider> cp = new HashSet<ClassProvider>(this.classProviders);
        cp.remove(provider);
        this.classProviders = cp;
    }

    private void checkForCyclicInclude(RubyModule m) throws RaiseException {
        if (this.getNonIncludedClass() == m.getNonIncludedClass()) {
            throw this.getRuntime().newArgumentError("cyclic include detected");
        }
    }

    protected void checkForCyclicPrepend(RubyModule m) throws RaiseException {
        if (this.getNonIncludedClass() == m.getNonIncludedClass()) {
            throw this.getRuntime().newArgumentError(this.getName() + " cyclic prepend detected " + m.getName());
        }
    }

    private RubyClass searchProvidersForClass(String name2, RubyClass superClazz) {
        for (ClassProvider classProvider : this.classProviders) {
            RubyClass clazz = classProvider.defineClassUnder(this, name2, superClazz);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    private RubyModule searchProvidersForModule(String name2) {
        for (ClassProvider classProvider : this.classProviders) {
            RubyModule module = classProvider.defineModuleUnder(this, name2);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
        if (superClass != null && superClass.isSynchronized()) {
            this.becomeSynchronized();
        }
    }

    public RubyModule getParent() {
        return this.parent;
    }

    public void setParent(RubyModule parent) {
        this.parent = parent;
    }

    public RubyModule getMethodLocation() {
        return this.methodLocation;
    }

    public void setMethodLocation(RubyModule module) {
        this.methodLocation = module;
    }

    public Map<String, DynamicMethod> getMethods() {
        return this.methods;
    }

    public synchronized Map<String, DynamicMethod> getMethodsForWrite() {
        Map<String, DynamicMethod> myMethods = this.methods;
        return myMethods == Collections.EMPTY_MAP ? (this.methods = new ConcurrentHashMap<String, DynamicMethod>(0, 0.9f, 1)) : myMethods;
    }

    private void putMethod(String name2, DynamicMethod method) {
        if (this.hasPrepends()) {
            method = new WrapperMethod(this.methodLocation, method, method.getVisibility());
        }
        this.methodLocation.getMethodsForWrite().put(name2, method);
        this.getRuntime().addProfiledMethod(name2, method);
    }

    public boolean isIncluded() {
        return false;
    }

    public boolean isPrepended() {
        return false;
    }

    public RubyModule getNonIncludedClass() {
        return this;
    }

    public RubyModule getDelegate() {
        return this;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name2) {
        this.baseName = name2;
        this.cachedName = null;
    }

    public String getName() {
        if (this.cachedName != null) {
            return this.cachedName;
        }
        return this.calculateName();
    }

    public String getSimpleName() {
        if (this.baseName != null) {
            return this.baseName;
        }
        return this.calculateAnonymousName();
    }

    private String calculateName() {
        boolean cache = true;
        if (this.getBaseName() == null) {
            return this.calculateAnonymousName();
        }
        Ruby runtime = this.getRuntime();
        String name2 = this.getBaseName();
        RubyClass objectClass = runtime.getObject();
        int parentCount = 0;
        for (RubyModule p2 = this.getParent(); p2 != null && p2 != objectClass && p2 != this; p2 = p2.getParent()) {
            ++parentCount;
        }
        String[] parentNames = new String[parentCount];
        int i2 = parentCount - 1;
        int totalLength = name2.length() + parentCount * 2;
        RubyModule p3 = this.getParent();
        while (p3 != null && p3 != objectClass && p3 != this) {
            Object pName = p3.getBaseName();
            if (pName == null) {
                cache = false;
                pName = p3.getName();
            }
            parentNames[i2] = pName;
            totalLength += ((String)pName).length();
            p3 = p3.getParent();
            --i2;
        }
        StringBuilder builder = new StringBuilder(totalLength);
        for (String parentName : parentNames) {
            builder.append(parentName).append("::");
        }
        builder.append(name2);
        String fullName = builder.toString();
        if (cache) {
            this.cachedName = fullName;
        }
        return fullName;
    }

    private String calculateAnonymousName() {
        if (this.anonymousName == null) {
            StringBuilder anonBase = new StringBuilder(24);
            anonBase.append("#<").append(this.metaClass.getRealClass().getName()).append(":0x");
            anonBase.append(Integer.toHexString(System.identityHashCode(this))).append('>');
            this.anonymousName = anonBase.toString();
        }
        return this.anonymousName;
    }

    @JRubyMethod(name={"refine"}, required=1, reads={FrameField.SCOPE})
    public IRubyObject refine(ThreadContext context, IRubyObject classArg, Block block) {
        RubyClass classWeAreRefining;
        RubyModule refinement;
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError("no block given");
        }
        if (block.isEscaped()) {
            throw context.runtime.newArgumentError("can't pass a Proc as a block to Module#refine");
        }
        if (!(classArg instanceof RubyClass)) {
            throw context.runtime.newTypeError(classArg, context.runtime.getClassClass());
        }
        if (this.refinements == Collections.EMPTY_MAP) {
            this.refinements = new IdentityHashMap<RubyClass, RubyModule>();
        }
        if (this.activatedRefinements == Collections.EMPTY_MAP) {
            this.activatedRefinements = new IdentityHashMap<RubyClass, IncludedModuleWrapper>();
        }
        if ((refinement = this.refinements.get(classWeAreRefining = (RubyClass)classArg)) == null) {
            refinement = this.createNewRefinedModule(context, classWeAreRefining);
            this.addActivatedRefinement(context, classWeAreRefining, refinement);
        }
        this.yieldRefineBlock(context, refinement, block);
        return refinement;
    }

    private RubyModule createNewRefinedModule(ThreadContext context, RubyClass classWeAreRefining) {
        RubyModule newRefinement = new RubyModule(context.runtime);
        newRefinement.setSuperClass(classWeAreRefining);
        newRefinement.setFlag(8192, true);
        newRefinement.setFlag(2048, false);
        newRefinement.refinedClass = classWeAreRefining;
        newRefinement.definedAt = this;
        this.refinements.put(classWeAreRefining, newRefinement);
        return newRefinement;
    }

    private void yieldRefineBlock(ThreadContext context, RubyModule refinement, Block block) {
        block.setEvalType(EvalType.MODULE_EVAL);
        block.getBinding().setSelf(refinement);
        block.yieldSpecific(context);
    }

    private RubyClass getAlreadyActivatedRefinementWrapper(RubyClass classWeAreRefining, RubyModule refinement) {
        RubyClass moduleWrapperForRefinement = this.activatedRefinements.get(classWeAreRefining);
        if (moduleWrapperForRefinement == null) {
            return classWeAreRefining;
        }
        for (RubyClass c = moduleWrapperForRefinement; c != null && c.isIncluded(); c = c.getSuperClass()) {
            if (c.getNonIncludedClass() != refinement) continue;
            return null;
        }
        return moduleWrapperForRefinement;
    }

    private void addActivatedRefinement(ThreadContext context, RubyClass classWeAreRefining, RubyModule refinement) {
        RubyClass superClass = null;
        RubyClass c = this.activatedRefinements.get(classWeAreRefining);
        if (c != null) {
            superClass = c;
            while (c != null && c.isIncluded()) {
                if (((IncludedModuleWrapper)c).getNonIncludedClass() == refinement) {
                    return;
                }
                c = c.getSuperClass();
            }
        }
        refinement.setFlag(16384, true);
        IncludedModuleWrapper iclass = new IncludedModuleWrapper(context.runtime, superClass, refinement);
        c = iclass;
        c.refinedClass = classWeAreRefining;
        for (refinement = refinement.getSuperClass(); refinement != null; refinement = refinement.getSuperClass()) {
            refinement.setFlag(16384, true);
            c.setSuperClass(new IncludedModuleWrapper(context.runtime, c.getSuperClass(), refinement));
            c = c.getSuperClass();
            c.refinedClass = classWeAreRefining;
        }
        this.activatedRefinements.put(classWeAreRefining, iclass);
    }

    @JRubyMethod(name={"using"}, required=1, frame=true, reads={FrameField.SCOPE})
    public IRubyObject using(ThreadContext context, IRubyObject refinedModule) {
        if (context.getFrameSelf() != this) {
            throw context.runtime.newRuntimeError("Module#using is not called on self");
        }
        if (context.getCurrentScope().getStaticScope().getIRScope() instanceof IRMethod) {
            throw context.runtime.newRuntimeError("Module#using is not permitted in methods");
        }
        StaticScope staticScope = context.getCurrentStaticScope();
        RubyModule overlayModule = staticScope.getOverlayModuleForWrite(context);
        RubyModule.usingModule(context, overlayModule, refinedModule);
        return this;
    }

    public static void usingModule(ThreadContext context, RubyModule cref, IRubyObject refinedModule) {
        if (!(refinedModule instanceof RubyModule)) {
            throw context.runtime.newTypeError(refinedModule, context.runtime.getModule());
        }
        RubyModule.usingModuleRecursive(cref, (RubyModule)refinedModule);
    }

    private static void usingModuleRecursive(RubyModule cref, RubyModule refinedModule) {
        Map<RubyClass, RubyModule> refinements;
        RubyClass superClass = refinedModule.getSuperClass();
        if (superClass != null) {
            RubyModule.usingModuleRecursive(cref, superClass);
        }
        if ((refinements = refinedModule.refinements) == null) {
            return;
        }
        for (Map.Entry<RubyClass, RubyModule> entry : refinements.entrySet()) {
            RubyModule.usingRefinement(cref, entry.getKey(), entry.getValue());
        }
    }

    private static RubyModule getAlreadyRefinementWrapper(RubyModule cref, RubyClass classWeAreRefining, RubyModule refinement) {
        RubyModule moduleWrapperForRefinment = cref.refinements.get(classWeAreRefining);
        if (moduleWrapperForRefinment == null) {
            return classWeAreRefining;
        }
        for (RubyModule c = moduleWrapperForRefinment; c != null && c.isIncluded(); c = c.getSuperClass()) {
            if (c.getNonIncludedClass() != refinement) continue;
            return null;
        }
        return moduleWrapperForRefinment;
    }

    private static void usingRefinement(RubyModule cref, RubyClass classWeAreRefining, RubyModule refinement) {
        IncludedModuleWrapper lookup;
        RubyModule superClass;
        if (cref.refinements == Collections.EMPTY_MAP) {
            cref.refinements = new HashMap<RubyClass, RubyModule>();
        }
        if ((superClass = RubyModule.getAlreadyRefinementWrapper(cref, classWeAreRefining, refinement)) == null) {
            return;
        }
        refinement.setFlag(16384, true);
        IncludedModuleWrapper iclass = lookup = new IncludedModuleWrapper(cref.getRuntime(), (RubyClass)superClass, refinement);
        lookup.refinedClass = classWeAreRefining;
        for (refinement = refinement.getSuperClass(); refinement != null && refinement != classWeAreRefining; refinement = refinement.getSuperClass()) {
            refinement.setFlag(16384, true);
            IncludedModuleWrapper newInclude = new IncludedModuleWrapper(cref.getRuntime(), lookup.getSuperClass(), refinement);
            lookup.setSuperClass(newInclude);
            lookup = newInclude;
            lookup.refinedClass = classWeAreRefining;
        }
        cref.refinements.put(classWeAreRefining, iclass);
    }

    @Deprecated
    public IncludedModuleWrapper newIncludeClass(RubyClass superClazz) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClazz, this);
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    public RubyClass getClass(String name2) {
        IRubyObject module = this.getConstantAt(name2);
        if (module instanceof RubyClass) {
            return (RubyClass)module;
        }
        return null;
    }

    @Deprecated
    public RubyClass fastGetClass(String internedName) {
        return this.getClass(internedName);
    }

    public synchronized void prependModule(IRubyObject arg2) {
        assert (arg2 != null);
        this.testFrozen("module");
        if (!(arg2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg2.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg2;
        this.checkForCyclicInclude(module);
        if (this.hasModuleInHierarchy((RubyModule)arg2)) {
            this.invalidateCacheDescendants();
            return;
        }
        this.infectBy(module);
        this.doPrependModule(module);
        this.invalidateCoreClasses();
        this.invalidateCacheDescendants();
        this.invalidateConstantCacheForModuleInclusion(module);
    }

    public synchronized void includeModule(IRubyObject arg2) {
        assert (arg2 != null);
        this.testFrozen("module");
        if (!(arg2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg2.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg2;
        this.checkForCyclicInclude(module);
        if (this.hasModuleInPrepends(((RubyModule)arg2).getNonIncludedClass())) {
            this.invalidateCacheDescendants();
            return;
        }
        this.infectBy(module);
        this.doIncludeModule(module);
        this.invalidateCoreClasses();
        this.invalidateCacheDescendants();
        this.invalidateConstantCacheForModuleInclusion(module);
    }

    public void defineAnnotatedMethod(Class clazz, String name2) {
        boolean foundMethod = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name2) || !this.defineAnnotatedMethod(method, MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader()))) continue;
            foundMethod = true;
        }
        if (!foundMethod) {
            throw new RuntimeException("No JRubyMethod present for method " + name2 + "on class " + clazz.getName());
        }
    }

    public final void defineAnnotatedConstants(Class clazz) {
        for (Field field2 : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field2.getModifiers())) continue;
            this.defineAnnotatedConstant(field2);
        }
    }

    public final boolean defineAnnotatedConstant(Field field2) {
        IRubyObject realVal;
        JRubyConstant jrubyConstant = field2.getAnnotation(JRubyConstant.class);
        if (jrubyConstant == null) {
            return false;
        }
        Class<?> tp = field2.getType();
        try {
            realVal = tp == Integer.class || tp == Integer.TYPE || tp == Short.class || tp == Short.TYPE || tp == Byte.class || tp == Byte.TYPE ? RubyNumeric.int2fix(this.getRuntime(), field2.getInt(null)) : (tp == Boolean.class || tp == Boolean.TYPE ? (field2.getBoolean(null) ? this.getRuntime().getTrue() : this.getRuntime().getFalse()) : this.getRuntime().getNil());
        }
        catch (Exception e) {
            realVal = this.getRuntime().getNil();
        }
        String[] names2 = jrubyConstant.value();
        if (names2.length == 0) {
            this.setConstant(field2.getName(), realVal);
        } else {
            for (String name2 : names2) {
                this.setConstant(name2, realVal);
            }
        }
        return true;
    }

    @Extension
    public void defineAnnotatedMethods(Class clazz) {
        this.defineAnnotatedMethodsIndividually(clazz);
    }

    public static TypePopulator loadPopulatorFor(Class<?> type2) {
        block6: {
            if (Options.DEBUG_FULLTRACE.load().booleanValue() || Options.REFLECTED_HANDLES.load().booleanValue()) {
                LOG.debug("trace mode, using default populator", new Object[0]);
            } else {
                try {
                    String qualifiedName = "org.jruby.gen." + type2.getCanonicalName().replace('.', '$');
                    String fullName = qualifiedName + "$POPULATOR";
                    String fullPath = fullName.replace('.', '/') + ".class";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("looking for populator " + fullName, new Object[0]);
                    }
                    if (Ruby.getClassLoader().getResource(fullPath) != null) {
                        Class<?> populatorClass = Class.forName(qualifiedName + "$POPULATOR");
                        return (TypePopulator)populatorClass.newInstance();
                    }
                    LOG.debug("could not find it, using default populator", new Object[0]);
                }
                catch (Throwable ex) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("could not find populator, using default (" + ex + ')', new Object[0]);
                }
            }
        }
        return new TypePopulator.ReflectiveTypePopulator(type2);
    }

    public final void defineAnnotatedMethodsIndividually(Class clazz) {
        this.getRuntime().POPULATORS.get(clazz).populate(this, clazz);
    }

    public final boolean defineAnnotatedMethod(String name2, List<JavaMethodDescriptor> methods2, MethodFactory methodFactory) {
        JavaMethodDescriptor desc = methods2.get(0);
        if (methods2.size() == 1) {
            return this.defineAnnotatedMethod(name2, desc, methodFactory);
        }
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, methods2);
        RubyModule.define(this, desc, name2, dynamicMethod);
        return true;
    }

    public final boolean defineAnnotatedMethod(Method method, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = method.getAnnotation(JRubyMethod.class);
        if (jrubyMethod == null) {
            return false;
        }
        JavaMethodDescriptor desc = new JavaMethodDescriptor(method);
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc);
        RubyModule.define(this, desc, method.getName(), dynamicMethod);
        return true;
    }

    public final boolean defineAnnotatedMethod(String name2, JavaMethodDescriptor desc, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = desc.anno;
        if (jrubyMethod == null) {
            return false;
        }
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc);
        RubyModule.define(this, desc, name2, dynamicMethod);
        return true;
    }

    public void undefineMethod(String name2) {
        this.methodLocation.addMethod(name2, UndefinedMethod.getInstance());
    }

    public void undef(ThreadContext context, String name2) {
        Ruby runtime = context.runtime;
        this.testFrozen("module");
        if (name2.equals("__id__") || name2.equals("__send__") || name2.equals("object_id")) {
            runtime.getWarnings().warn(IRubyWarnings.ID.UNDEFINING_BAD, "undefining `" + name2 + "' may cause serious problem");
        }
        if (name2.equals("method_missing")) {
            IRubyObject oldExc = runtime.getGlobalVariables().get("$!");
            try {
                this.removeMethod(context, name2);
            }
            catch (RaiseException t) {
                if (!(t.getException() instanceof RubyNameError)) {
                    throw t;
                }
                runtime.getGlobalVariables().set("$!", oldExc);
            }
            return;
        }
        DynamicMethod method = this.searchMethod(name2);
        if (method.isUndefined()) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                IRubyObject obj = ((MetaClass)c).getAttached();
                if (obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw runtime.newNameError("Undefined method " + name2 + " for" + s0 + " '" + c.getName() + "'", name2);
        }
        this.methodLocation.addMethod(name2, UndefinedMethod.getInstance());
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(context, "singleton_method_undefined", runtime.newSymbol(name2));
        } else {
            this.callMethod(context, "method_undefined", (IRubyObject)runtime.newSymbol(name2));
        }
    }

    @JRubyMethod(name={"include?"}, required=1)
    public IRubyObject include_p(ThreadContext context, IRubyObject arg2) {
        if (!arg2.isModule()) {
            throw context.runtime.newTypeError(arg2, context.runtime.getModule());
        }
        RubyModule moduleToCompare = (RubyModule)arg2;
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isSame(moduleToCompare)) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    @JRubyMethod(name={"singleton_class?"})
    public IRubyObject singleton_class_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isSingleton());
    }

    public void addMethod(String name2, DynamicMethod method) {
        this.testFrozen("class/module");
        if (this instanceof MetaClass) {
            RubyBasicObject attached = (RubyBasicObject)((MetaClass)this).getAttached();
            attached.testFrozen();
        }
        this.addMethodInternal(name2, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMethodInternal(String name2, DynamicMethod method) {
        Map<String, DynamicMethod> map = this.methodLocation.getMethodsForWrite();
        synchronized (map) {
            this.addMethodAtBootTimeOnly(name2, method);
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
    }

    public final void addMethodAtBootTimeOnly(String name2, DynamicMethod method) {
        if (this.hasPrepends()) {
            method = new WrapperMethod(this.methodLocation, method, method.getVisibility());
        }
        this.methodLocation.getMethodsForWrite().put(name2, method);
        this.getRuntime().addProfiledMethod(name2, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(ThreadContext context, String name2) {
        Map<String, DynamicMethod> methodsForWrite;
        this.testFrozen("class/module");
        switch (name2) {
            case "object_id": {
                RubyModule.warnMethodRemoval(context, name2);
                break;
            }
            case "__send__": {
                RubyModule.warnMethodRemoval(context, name2);
                break;
            }
            case "initialize": {
                RubyModule.warnMethodRemoval(context, name2);
            }
        }
        Map<String, DynamicMethod> map = methodsForWrite = this.methodLocation.getMethodsForWrite();
        synchronized (map) {
            DynamicMethod method = methodsForWrite.remove(name2);
            if (method == null) {
                throw context.runtime.newNameError("method '" + name2 + "' not defined in " + this.getName(), name2);
            }
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(context, "singleton_method_removed", context.runtime.newSymbol(name2));
        } else {
            this.callMethod(context, "method_removed", (IRubyObject)context.runtime.newSymbol(name2));
        }
    }

    private static void warnMethodRemoval(ThreadContext context, String name2) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.UNDEFINING_BAD, "removing `" + name2 + "' may cause serious problems");
    }

    public DynamicMethod searchMethod(String name2) {
        return this.searchWithCache((String)name2).method;
    }

    public CacheEntry searchWithCache(String name2) {
        return this.searchWithCache(name2, true);
    }

    public DynamicMethod searchWithRefinements(String name2, StaticScope refinedScope) {
        DynamicMethod method = this.searchMethodWithRefinementsInner(name2, refinedScope);
        if (method instanceof CacheableMethod) {
            method = ((CacheableMethod)((Object)method)).getMethodForCaching();
        }
        if (method != null) {
            return method;
        }
        return UndefinedMethod.INSTANCE;
    }

    public CacheEntry searchWithCache(String name2, boolean cacheUndef) {
        CacheEntry entry = this.cacheHit(name2);
        if (entry != null) {
            return entry;
        }
        int token = this.getGeneration();
        DynamicMethod method = this.searchMethodInner(name2);
        if (method instanceof CacheableMethod) {
            method = ((CacheableMethod)((Object)method)).getMethodForCaching();
        }
        return method != null ? this.addToCache(name2, method, token) : (cacheUndef ? this.addToCache(name2, UndefinedMethod.getInstance(), token) : this.cacheEntryFactory.newCacheEntry(name2, method, token));
    }

    @Deprecated
    public final int getCacheToken() {
        return this.generation;
    }

    public final int getGeneration() {
        return this.generation;
    }

    public final Integer getGenerationObject() {
        return this.generationObject;
    }

    private final Map<String, CacheEntry> getCachedMethods() {
        return this.cachedMethods;
    }

    private final Map<String, CacheEntry> getCachedMethodsForWrite() {
        Map<String, CacheEntry> myCachedMethods = this.cachedMethods;
        return myCachedMethods == Collections.EMPTY_MAP ? (this.cachedMethods = new ConcurrentHashMap<String, CacheEntry>(0, 0.75f, 1)) : myCachedMethods;
    }

    private CacheEntry cacheHit(String name2) {
        CacheEntry cacheEntry = this.getCachedMethods().get(name2);
        if (cacheEntry != null && cacheEntry.token == this.getGeneration()) {
            return cacheEntry;
        }
        return null;
    }

    private void invalidateConstantCacheForModuleInclusion(RubyModule module) {
        for (RubyModule mod : this.gatherModules(module)) {
            for (String key2 : mod.getConstantMap().keySet()) {
                this.invalidateConstantCache(key2);
            }
        }
    }

    public void becomeSynchronized() {
        this.cacheEntryFactory = new SynchronizedCacheEntryFactory(this.cacheEntryFactory);
    }

    public boolean isSynchronized() {
        return this.cacheEntryFactory.hasCacheEntryFactory(SynchronizedCacheEntryFactory.class);
    }

    private CacheEntry addToCache(String name2, DynamicMethod method, int token) {
        CacheEntry entry = this.cacheEntryFactory.newCacheEntry(name2, method, token);
        this.methodLocation.getCachedMethodsForWrite().put(name2, entry);
        return entry;
    }

    public DynamicMethod searchMethodInner(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            DynamicMethod method = module.searchMethodCommon(name2);
            if (method == null) continue;
            return method.isNull() ? null : method;
        }
        return null;
    }

    public DynamicMethod searchMethodWithRefinementsInner(String name2, StaticScope refinedScope) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            DynamicMethod method = IRRuntimeHelpers.getRefinedMethodForClass(refinedScope, this.getNonIncludedClass(), name2);
            if (method != null && !method.isNull()) {
                return method;
            }
            method = module.searchMethodCommon(name2);
            if (method == null) continue;
            return method.isNull() ? null : method;
        }
        return null;
    }

    protected DynamicMethod searchMethodCommon(String name2) {
        return this.getMethods().get(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCacheDescendants() {
        LOG.debug("{} invalidating descendants", this.baseName);
        if (this.includingHierarchies.isEmpty()) {
            this.methodInvalidator.invalidate();
            return;
        }
        ArrayList<Invalidator> invalidators = new ArrayList<Invalidator>();
        invalidators.add(this.methodInvalidator);
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            for (RubyClass includingHierarchy : this.includingHierarchies) {
                includingHierarchy.addInvalidatorsAndFlush(invalidators);
            }
        }
        this.methodInvalidator.invalidateAll(invalidators);
    }

    protected void invalidateCoreClasses() {
        if (!this.getRuntime().isBootingCore()) {
            if (this == this.getRuntime().getFixnum()) {
                this.getRuntime().reopenFixnum();
            } else if (this == this.getRuntime().getFloat()) {
                this.getRuntime().reopenFloat();
            }
        }
    }

    public Invalidator getInvalidator() {
        return this.methodInvalidator;
    }

    public void updateGeneration() {
        this.generation = this.getRuntime().getNextModuleGeneration();
        this.generationObject = this.generation;
    }

    @Deprecated
    protected void invalidateCacheDescendantsInner() {
        this.methodInvalidator.invalidate();
    }

    protected void invalidateConstantCache(String constantName) {
        this.getRuntime().getConstantInvalidator(constantName).invalidate();
    }

    public DynamicMethod retrieveMethod(String name2) {
        return this.getMethods().get(name2);
    }

    public RubyModule findImplementer(RubyModule clazz) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(clazz)) continue;
            return module;
        }
        return null;
    }

    public void addModuleFunction(String name2, DynamicMethod method) {
        this.addMethod(name2, method);
        this.getSingletonClass().addMethod(name2, method);
    }

    public synchronized void defineAlias(String name2, String oldName) {
        this.testFrozen("module");
        if (oldName.equals(name2)) {
            return;
        }
        DynamicMethod method = this.searchForAliasMethod(this.getRuntime(), oldName);
        this.putMethod(name2, new AliasMethod(this, method, oldName));
        this.methodLocation.invalidateCoreClasses();
        this.methodLocation.invalidateCacheDescendants();
    }

    public synchronized void defineAliases(List<String> aliases2, String oldName) {
        this.testFrozen("module");
        DynamicMethod method = this.searchForAliasMethod(this.getRuntime(), oldName);
        for (String name2 : aliases2) {
            if (oldName.equals(name2)) continue;
            this.putMethod(name2, new AliasMethod(this, method, oldName));
        }
        this.methodLocation.invalidateCoreClasses();
        this.methodLocation.invalidateCacheDescendants();
    }

    private DynamicMethod searchForAliasMethod(Ruby runtime, String name2) {
        DynamicMethod method = this.deepMethodSearch(name2, runtime);
        return method;
    }

    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz) {
        return this.defineOrGetClassUnder(name2, superClazz, null);
    }

    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz, ObjectAllocator allocator) {
        RubyClass clazz;
        Ruby runtime = this.getRuntime();
        IRubyObject classObj = this.getConstantAtSpecial(name2);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw runtime.newTypeError(name2 + " is not a class");
            }
            clazz = (RubyClass)classObj;
            if (superClazz != null) {
                RubyClass tmp;
                for (tmp = clazz.getSuperClass(); tmp != null && tmp.isIncluded(); tmp = tmp.getSuperClass()) {
                }
                if (tmp != null) {
                    tmp = tmp.getRealClass();
                }
                if (tmp != superClazz) {
                    throw runtime.newTypeError("superclass mismatch for class " + name2);
                }
            }
        } else if (this.classProviders == null || (clazz = this.searchProvidersForClass(name2, superClazz)) == null) {
            if (superClazz == null) {
                superClazz = runtime.getObject();
            }
            if (allocator == null) {
                allocator = superClazz == runtime.getObject() ? (RubyInstanceConfig.REIFY_RUBY_CLASSES ? REIFYING_OBJECT_ALLOCATOR : (Options.REIFY_VARIABLES.load().booleanValue() ? IVAR_INSPECTING_OBJECT_ALLOCATOR : OBJECT_ALLOCATOR)) : superClazz.getAllocator();
            }
            clazz = RubyClass.newClass(runtime, superClazz, name2, allocator, this, true);
        }
        return clazz;
    }

    public RubyModule defineOrGetModuleUnder(String name2) {
        RubyModule module;
        Ruby runtime = this.getRuntime();
        IRubyObject moduleObj = this.getConstantAtSpecial(name2);
        if (moduleObj != null) {
            if (!moduleObj.isModule()) {
                throw runtime.newTypeError(name2 + " is not a module");
            }
            module = (RubyModule)moduleObj;
        } else if (this.classProviders == null || (module = this.searchProvidersForModule(name2)) == null) {
            module = RubyModule.newModule(runtime, name2, this, true);
        }
        return module;
    }

    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return this.getRuntime().defineClassUnder(name2, superClass, allocator, this);
    }

    public RubyModule defineModuleUnder(String name2) {
        return this.getRuntime().defineModuleUnder(name2, this);
    }

    private void addAccessor(ThreadContext context, RubySymbol identifier, Visibility visibility, boolean readable, boolean writeable) {
        String internedIdentifier = identifier.toString();
        Ruby runtime = context.runtime;
        if (visibility == Visibility.MODULE_FUNCTION) {
            runtime.getWarnings().warn(IRubyWarnings.ID.ACCESSOR_MODULE_FUNCTION, "attribute accessor as module_function");
            visibility = Visibility.PRIVATE;
        }
        if (!IdUtil.isLocal(internedIdentifier) && !IdUtil.isConstant(internedIdentifier)) {
            throw runtime.newNameError("invalid attribute name", internedIdentifier);
        }
        String variableName = TypeConverter.checkID(runtime, '@' + internedIdentifier).toString();
        if (readable) {
            this.addMethod(internedIdentifier, new AttrReaderMethod(this.methodLocation, visibility, variableName));
            this.callMethod(context, "method_added", (IRubyObject)identifier);
        }
        if (writeable) {
            identifier = TypeConverter.checkID(runtime, internedIdentifier + '=');
            internedIdentifier = identifier.toString();
            this.addMethod(internedIdentifier, new AttrWriterMethod(this.methodLocation, visibility, variableName));
            this.callMethod(context, "method_added", (IRubyObject)identifier);
        }
    }

    public void setMethodVisibility(IRubyObject[] methods2, Visibility visibility) {
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            this.exportMethod(methods2[i2].asJavaString(), visibility);
        }
    }

    public void exportMethod(String name2, Visibility visibility) {
        Ruby runtime = this.getRuntime();
        DynamicMethod method = this.deepMethodSearch(name2, runtime);
        if (method.getVisibility() != visibility) {
            if (this == method.getImplementationClass()) {
                method.setVisibility(visibility);
            } else {
                this.methodLocation.addMethod(name2, new WrapperMethod(this, method, visibility));
            }
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
    }

    private DynamicMethod deepMethodSearch(String name2, Ruby runtime) {
        DynamicMethod method = this.searchMethod(name2);
        if (method.isUndefined() && this.isModule()) {
            method = runtime.getObject().searchMethod(name2);
        }
        if (method.isUndefined()) {
            throw runtime.newNameError(RubyModule.undefinedMethodMessage(name2, this.getName(), this.isModule()), name2);
        }
        return method;
    }

    public static String undefinedMethodMessage(String name2, String modName, boolean isModule) {
        return "undefined method `" + name2 + "' for " + (isModule ? "module" : "class") + " `" + modName + "'";
    }

    public boolean isMethodBound(String name2, boolean checkVisibility) {
        DynamicMethod method = this.searchMethod(name2);
        if (!method.isUndefined()) {
            return !checkVisibility || method.getVisibility() != Visibility.PRIVATE;
        }
        return false;
    }

    public boolean isMethodBound(String name2, boolean checkVisibility, boolean checkRespondTo) {
        if (!checkRespondTo) {
            return this.isMethodBound(name2, checkVisibility);
        }
        DynamicMethod method = this.searchMethod(name2);
        if (!method.isUndefined() && !method.isNotImplemented()) {
            return !checkVisibility || method.getVisibility() != Visibility.PRIVATE;
        }
        return false;
    }

    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility) {
        return this.newMethod(receiver2, methodName, bound, visibility, false, true);
    }

    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing) {
        return this.newMethod(receiver2, methodName, bound, visibility, respondToMissing, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing, boolean priv) {
        DynamicMethod method = this.searchMethod(methodName);
        if (method.isUndefined() || visibility != null && method.getVisibility() != visibility) {
            if (!respondToMissing) throw this.getRuntime().newNameError("undefined method `" + methodName + "' for class `" + this.getName() + "'", methodName);
            if (!receiver2.respondsToMissing(methodName, priv)) throw this.getRuntime().newNameError("undefined method `" + methodName + "' for class `" + this.getName() + "'", methodName);
            method = new RespondToMissingMethod(this, Visibility.PUBLIC, methodName);
        }
        RubyModule implementationModule = method.getImplementationClass();
        RubyModule originModule = this;
        while (originModule != implementationModule && originModule.isSingleton()) {
            originModule = ((MetaClass)originModule).getRealClass();
        }
        AbstractRubyMethod newMethod = bound ? RubyMethod.newMethod(implementationModule, methodName, originModule, methodName, method, receiver2) : RubyUnboundMethod.newUnboundMethod(implementationModule, methodName, originModule, methodName, method);
        newMethod.infectBy(this);
        return newMethod;
    }

    @JRubyMethod(name={"define_method"}, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, Block block) {
        Visibility visibility = context.getCurrentVisibility();
        return this.defineMethodFromBlock(context, arg0, block, visibility);
    }

    public IRubyObject defineMethodFromBlock(ThreadContext context, IRubyObject arg0, Block block, Visibility visibility) {
        IRBlockBody body;
        IRClosure closure;
        IRMethod method;
        Ruby runtime = context.runtime;
        RubySymbol nameSym = TypeConverter.checkID(arg0);
        String name2 = nameSym.toString();
        if (!block.isGiven()) {
            throw runtime.newArgumentError("tried to create Proc object without a block");
        }
        if (block.getBody() instanceof IRBlockBody && runtime.getInstanceConfig().getCompileMode().shouldJIT() && (method = (closure = (body = (IRBlockBody)block.getBody()).getScope()).convertToMethod(name2)) != null) {
            DefineMethodMethod newMethod = new DefineMethodMethod(method, visibility, this, context.getFrameBlock());
            Helpers.addInstanceMethod(this, name2, newMethod, visibility, context, runtime);
            return nameSym;
        }
        block = block.cloneBlockAndFrame();
        RubyProc proc = runtime.newProc(Block.Type.LAMBDA, block);
        proc.getBlock().type = Block.Type.LAMBDA;
        DynamicMethod newMethod = this.createProcMethod(name2, visibility, proc);
        Helpers.addInstanceMethod(this, name2, newMethod, visibility, context, runtime);
        return nameSym;
    }

    @JRubyMethod(name={"define_method"}, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        Visibility visibility = context.getCurrentVisibility();
        return this.defineMethodFromCallable(context, arg0, arg1, visibility);
    }

    public IRubyObject defineMethodFromCallable(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Visibility visibility) {
        DynamicMethod newMethod;
        Ruby runtime = context.runtime;
        RubySymbol nameSym = TypeConverter.checkID(arg0);
        String name2 = nameSym.toString();
        if (runtime.getProc().isInstance(arg1)) {
            RubyProc proc = (RubyProc)arg1;
            newMethod = this.createProcMethod(name2, visibility, proc);
        } else if (arg1 instanceof AbstractRubyMethod) {
            AbstractRubyMethod method = (AbstractRubyMethod)arg1;
            this.checkValidBindTargetFrom(context, (RubyModule)method.owner(context));
            newMethod = new WrapperMethod(this, method.getMethod(), visibility);
        } else {
            throw runtime.newTypeError("wrong argument type " + arg1.getType().getName() + " (expected Proc/Method)");
        }
        Helpers.addInstanceMethod(this, name2, newMethod, visibility, context, runtime);
        return nameSym;
    }

    @Deprecated
    public IRubyObject define_method(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.define_method(context, args2[0], block);
            }
            case 2: {
                return this.define_method(context, args2[0], args2[1], block);
            }
        }
        throw context.runtime.newArgumentError("wrong number of arguments (" + args2.length + " for 2)");
    }

    private DynamicMethod createProcMethod(String name2, Visibility visibility, RubyProc proc) {
        Block block = proc.getBlock();
        block.getBinding().getFrame().setKlazz(this);
        block.getBinding().getFrame().setName(name2);
        block.getBinding().setMethod(name2);
        block.type = Block.Type.LAMBDA;
        block.getBody().getStaticScope().makeArgumentScope();
        return new ProcMethod(this, proc, visibility);
    }

    public IRubyObject name() {
        return this.name19();
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name19() {
        Ruby runtime = this.getRuntime();
        if (this.getBaseName() == null) {
            return runtime.getNil();
        }
        return runtime.newString(this.getName());
    }

    protected IRubyObject cloneMethods(RubyModule clone2) {
        RubyModule realType = this.getNonIncludedClass();
        for (Map.Entry<String, DynamicMethod> entry : this.getMethods().entrySet()) {
            DynamicMethod method = entry.getValue();
            if (!method.isImplementedBy(realType) && !method.isUndefined()) continue;
            DynamicMethod clonedMethod = method.dup();
            clonedMethod.setImplementationClass(clone2);
            clone2.putMethod(entry.getKey(), clonedMethod);
        }
        return clone2;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this instanceof RubyClass) {
            this.checkSafeTypeToCopy((RubyClass)original);
        }
        super.initialize_copy(original);
        RubyModule originalModule = (RubyModule)original;
        if (!this.getMetaClass().isSingleton()) {
            this.setMetaClass(originalModule.getSingletonClassClone());
        }
        this.setSuperClass(originalModule.getSuperClass());
        if (originalModule.hasVariables()) {
            this.syncVariables(originalModule);
        }
        this.syncConstants(originalModule);
        originalModule.cloneMethods(this);
        return this;
    }

    private void checkSafeTypeToCopy(RubyClass original) {
        Ruby runtime = this.getRuntime();
        if (original == runtime.getBasicObject()) {
            throw runtime.newTypeError("can't copy the root class");
        }
        if (this.getSuperClass() == runtime.getBasicObject()) {
            throw runtime.newTypeError("already initialized class");
        }
        if (original.isSingleton()) {
            throw runtime.newTypeError("can't copy singleton class");
        }
    }

    public void syncConstants(RubyModule other) {
        if (other.getConstantMap() != Collections.EMPTY_MAP) {
            this.getConstantMapForWrite().putAll(other.getConstantMap());
        }
    }

    public void syncClassVariables(RubyModule other) {
        if (other.getClassVariablesForRead() != Collections.EMPTY_MAP) {
            this.getClassVariables().putAll(other.getClassVariablesForRead());
        }
    }

    @JRubyMethod(name={"included_modules"})
    public RubyArray included_modules(ThreadContext context) {
        RubyArray ary = context.runtime.newArray();
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isIncluded()) continue;
            ary.append(p2.getNonIncludedClass());
        }
        return ary;
    }

    public boolean hasPrepends() {
        return this.methodLocation != this;
    }

    @JRubyMethod(name={"ancestors"})
    public RubyArray ancestors(ThreadContext context) {
        return context.runtime.newArray(this.getAncestorList());
    }

    @Deprecated
    public RubyArray ancestors() {
        return this.getRuntime().newArray(this.getAncestorList());
    }

    public List<IRubyObject> getAncestorList() {
        ArrayList<IRubyObject> list2 = new ArrayList<IRubyObject>();
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.methodLocation != module) continue;
            list2.add(module.getDelegate().getNonIncludedClass());
        }
        return list2;
    }

    public boolean hasModuleInPrepends(RubyModule type2) {
        for (RubyModule module = this; module != this.methodLocation; module = module.getSuperClass()) {
            if (type2 != module.getNonIncludedClass()) continue;
            return true;
        }
        return false;
    }

    public boolean hasModuleInHierarchy(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.getNonIncludedClass() != type2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.id);
    }

    @Override
    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public IRubyObject to_s() {
        if (this.isSingleton()) {
            IRubyObject attached = ((MetaClass)this).getAttached();
            StringBuilder buffer = new StringBuilder("#<Class:");
            if (attached != null) {
                if (attached instanceof RubyClass || attached instanceof RubyModule) {
                    buffer.append(attached.inspect());
                } else {
                    buffer.append(attached.anyToString());
                }
            }
            buffer.append('>');
            return this.getRuntime().newString(buffer.toString());
        }
        return this.getRuntime().newString(this.getName());
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(this.isInstance(obj));
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyModule)) {
            return context.runtime.getFalse();
        }
        RubyModule otherModule = (RubyModule)other;
        if (otherModule.isIncluded()) {
            return context.runtime.newBoolean(otherModule.isSame(this));
        }
        return context.runtime.newBoolean(this.isSame(otherModule));
    }

    @Override
    @JRubyMethod(name={"freeze"})
    public final IRubyObject freeze(ThreadContext context) {
        this.to_s();
        return super.freeze(context);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        if (this.isKindOfModule((RubyModule)obj)) {
            return this.getRuntime().getTrue();
        }
        if (((RubyModule)obj).isKindOfModule(this)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject obj) {
        return obj == this ? this.getRuntime().getFalse() : this.op_le(obj);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject obj) {
        return this == obj ? this.getRuntime().getFalse() : this.op_ge(obj);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().newFixnum(0);
        }
        if (!(obj instanceof RubyModule)) {
            return this.getRuntime().getNil();
        }
        RubyModule module = (RubyModule)obj;
        if (module.isKindOfModule(this)) {
            return this.getRuntime().newFixnum(1);
        }
        if (this.isKindOfModule(module)) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().getNil();
    }

    public boolean isKindOfModule(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(type2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSame(RubyModule module) {
        return this == module;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        if (block.isGiven()) {
            this.module_exec(context, new IRubyObject[]{this}, block);
        }
        return context.nil;
    }

    public void addReadWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, TypeConverter.checkID(context.runtime, name2), Visibility.PUBLIC, true, true);
    }

    public void addReadAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, TypeConverter.checkID(context.runtime, name2), Visibility.PUBLIC, true, false);
    }

    public void addWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, TypeConverter.checkID(context.runtime, name2), Visibility.PUBLIC, false, true);
    }

    @JRubyMethod(name={"attr"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (args2.length == 2 && (args2[1] == runtime.getTrue() || args2[1] == runtime.getFalse())) {
            runtime.getWarnings().warn(IRubyWarnings.ID.OBSOLETE_ARGUMENT, "optional boolean argument is obsoleted");
            this.addAccessor(context, TypeConverter.checkID(args2[0]), context.getCurrentVisibility(), args2[0].isTrue(), args2[1].isTrue());
            return runtime.getNil();
        }
        return this.attr_reader(context, args2);
    }

    @Deprecated
    public IRubyObject attr19(ThreadContext context, IRubyObject[] args2) {
        return this.attr(context, args2);
    }

    @Deprecated
    public IRubyObject attr_reader(IRubyObject[] args2) {
        return this.attr_reader(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_reader"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_reader(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, TypeConverter.checkID(args2[i2]), visibility, true, false);
        }
        return context.nil;
    }

    @JRubyMethod(name={"attr_writer"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_writer(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, TypeConverter.checkID(args2[i2]), visibility, false, true);
        }
        return context.nil;
    }

    @Deprecated
    public IRubyObject attr_accessor(IRubyObject[] args2) {
        return this.attr_accessor(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_accessor"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_accessor(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, TypeConverter.checkID(args2[i2]), visibility, true, true);
        }
        return context.nil;
    }

    private RubyArray instance_methods(IRubyObject[] args2, Visibility visibility, boolean not) {
        boolean includeSuper = args2.length > 0 ? args2[0].isTrue() : true;
        return this.instanceMethods(visibility, includeSuper, true, not);
    }

    public RubyArray instanceMethods(IRubyObject[] args2, Visibility visibility, boolean obj, boolean not) {
        boolean includeSuper = args2.length > 0 ? args2[0].isTrue() : true;
        return this.instanceMethods(visibility, includeSuper, obj, not);
    }

    public RubyArray instanceMethods(Visibility visibility, boolean includeSuper, boolean obj, boolean not) {
        Ruby runtime = this.getRuntime();
        RubyArray ary = runtime.newArray();
        HashSet<String> seen = new HashSet<String>();
        this.populateInstanceMethodNames(seen, ary, visibility, obj, not, includeSuper);
        return ary;
    }

    public void populateInstanceMethodNames(Set<String> seen, RubyArray ary, Visibility visibility, boolean obj, boolean not, boolean recur) {
        Ruby runtime = this.getRuntime();
        RubyModule mod = this;
        boolean prepended2 = false;
        if (!recur && this.methodLocation != this) {
            mod = this.methodLocation;
            prepended2 = true;
        }
        while (mod != null) {
            RubyModule realType = mod.getNonIncludedClass();
            for (Map.Entry<String, DynamicMethod> entry : mod.getMethods().entrySet()) {
                String methodName = entry.getKey();
                if (seen.contains(methodName)) continue;
                seen.add(methodName);
                DynamicMethod method = entry.getValue();
                if (!method.isImplementedBy(realType) && !method.isImplementedBy(mod) || (not || method.getVisibility() != visibility) && (!not || method.getVisibility() == visibility) || method.isUndefined()) continue;
                ary.append(runtime.newSymbol(methodName));
            }
            if (!(mod.isIncluded() && !prepended2 || obj && mod.isSingleton() || recur)) break;
            mod = mod.getSuperClass();
        }
    }

    public RubyArray instance_methods(IRubyObject[] args2) {
        return this.instance_methods19(args2);
    }

    @JRubyMethod(name={"instance_methods"}, optional=1)
    public RubyArray instance_methods19(IRubyObject[] args2) {
        return this.instanceMethods(args2, Visibility.PRIVATE, false, true);
    }

    public RubyArray public_instance_methods(IRubyObject[] args2) {
        return this.public_instance_methods19(args2);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1)
    public RubyArray public_instance_methods19(IRubyObject[] args2) {
        return this.instanceMethods(args2, Visibility.PUBLIC, false, false);
    }

    @JRubyMethod(name={"instance_method"}, required=1)
    public IRubyObject instance_method(IRubyObject symbol) {
        return this.newMethod(null, symbol.asJavaString(), false, null);
    }

    @JRubyMethod(name={"public_instance_method"}, required=1)
    public IRubyObject public_instance_method(IRubyObject symbol) {
        return this.newMethod(null, symbol.asJavaString(), false, Visibility.PUBLIC);
    }

    public RubyArray protected_instance_methods(IRubyObject[] args2) {
        return this.protected_instance_methods19(args2);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1)
    public RubyArray protected_instance_methods19(IRubyObject[] args2) {
        return this.instanceMethods(args2, Visibility.PROTECTED, false, false);
    }

    public RubyArray private_instance_methods(IRubyObject[] args2) {
        return this.private_instance_methods19(args2);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1)
    public RubyArray private_instance_methods19(IRubyObject[] args2) {
        return this.instanceMethods(args2, Visibility.PRIVATE, false, false);
    }

    @JRubyMethod(name={"prepend_features"}, required=1, visibility=Visibility.PRIVATE)
    public RubyModule prepend_features(IRubyObject include2) {
        if (!this.isModule()) {
            throw this.getRuntime().newTypeError((IRubyObject)this, this.getRuntime().getModule());
        }
        if (!(include2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(include2, this.getRuntime().getModule());
        }
        if (!include2.isModule() && !include2.isClass()) {
            throw this.getRuntime().newTypeError(include2, this.getRuntime().getModule());
        }
        ((RubyModule)include2).prependModule(this);
        return this;
    }

    @JRubyMethod(name={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public RubyModule append_features(IRubyObject include2) {
        if (!this.isModule()) {
            throw this.getRuntime().newTypeError((IRubyObject)this, this.getRuntime().getModule());
        }
        if (!(include2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(include2, this.getRuntime().getModule());
        }
        if (!include2.isModule() && !include2.isClass()) {
            throw this.getRuntime().newTypeError(include2, this.getRuntime().getModule());
        }
        ((RubyModule)include2).includeModule(this);
        return this;
    }

    @JRubyMethod(name={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extend_object(IRubyObject obj) {
        obj.getSingletonClass().includeModule(this);
        return obj;
    }

    @JRubyMethod(name={"include"}, rest=true)
    public RubyModule include(IRubyObject[] modules) {
        IRubyObject module;
        ThreadContext context = this.getRuntime().getCurrentContext();
        int i2 = modules.length;
        while (--i2 >= 0) {
            module = modules[i2];
            if (module.isModule()) continue;
            throw context.runtime.newTypeError(module, context.runtime.getModule());
        }
        for (i2 = modules.length - 1; i2 >= 0; --i2) {
            module = modules[i2];
            module.callMethod(context, "append_features", this);
            module.callMethod(context, "included", this);
        }
        return this;
    }

    @JRubyMethod(name={"include"}, required=1)
    public RubyModule include(ThreadContext context, IRubyObject module) {
        if (!module.isModule()) {
            throw context.runtime.newTypeError(module, context.runtime.getModule());
        }
        module.callMethod(context, "append_features", this);
        module.callMethod(context, "included", this);
        return this;
    }

    @JRubyMethod(name={"included"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject included(ThreadContext context, IRubyObject other) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"extended"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extended(ThreadContext context, IRubyObject other, Block block) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"mix"}, visibility=Visibility.PRIVATE)
    public IRubyObject mix(ThreadContext context, IRubyObject mod) {
        Ruby runtime = context.runtime;
        if (!mod.isModule()) {
            throw runtime.newTypeError(mod, runtime.getModule());
        }
        for (Map.Entry<String, DynamicMethod> entry : ((RubyModule)mod).methods.entrySet()) {
            if (!this.methodLocation.getMethods().containsKey(entry.getKey())) continue;
            throw runtime.newArgumentError("method would conflict - " + entry.getKey());
        }
        for (Map.Entry<String, DynamicMethod> entry : ((RubyModule)mod).methods.entrySet()) {
            this.methodLocation.getMethodsForWrite().put(entry.getKey(), entry.getValue().dup());
        }
        return mod;
    }

    @JRubyMethod(name={"mix"}, visibility=Visibility.PRIVATE)
    public IRubyObject mix(ThreadContext context, IRubyObject mod, IRubyObject hash0) {
        Ruby runtime = context.runtime;
        RubyHash methodNames = null;
        if (!mod.isModule()) {
            throw runtime.newTypeError(mod, runtime.getModule());
        }
        if (!(hash0 instanceof RubyHash)) {
            throw runtime.newTypeError(hash0, runtime.getHash());
        }
        methodNames = (RubyHash)hash0;
        for (Map.Entry entry : methodNames.directEntrySet()) {
            String name2 = ((IRubyObject)entry.getValue()).toString();
            if (!this.methods.containsKey(((IRubyObject)entry.getValue()).toString())) continue;
            throw runtime.newArgumentError("constant would conflict - " + name2);
        }
        for (Map.Entry entry : ((RubyModule)mod).methods.entrySet()) {
            if (!this.methods.containsKey(entry.getKey())) continue;
            throw runtime.newArgumentError("method would conflict - " + (String)entry.getKey());
        }
        for (Map.Entry entry : ((RubyModule)mod).methods.entrySet()) {
            String name2 = (String)entry.getKey();
            IRubyObject mapped = methodNames.fastARef(runtime.newSymbol(name2));
            if (mapped != NEVER) {
                if (mapped == context.nil) continue;
                name2 = mapped.toString();
            }
            this.methodLocation.getMethodsForWrite().put(name2, ((DynamicMethod)entry.getValue()).dup());
        }
        return mod;
    }

    private void setVisibility(ThreadContext context, IRubyObject[] args2, Visibility visibility) {
        if (args2.length == 0) {
            context.setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(args2, visibility);
        }
    }

    @JRubyMethod(name={"public"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPublic(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.setVisibility(context, args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"protected"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbProtected(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.setVisibility(context, args2, Visibility.PROTECTED);
        return this;
    }

    @JRubyMethod(name={"private"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPrivate(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.setVisibility(context, args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"module_function"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule module_function(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (args2.length == 0) {
            context.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(args2, Visibility.PRIVATE);
            for (int i2 = 0; i2 < args2.length; ++i2) {
                String name2 = args2[i2].asJavaString().intern();
                DynamicMethod method = this.deepMethodSearch(name2, runtime);
                this.getSingletonClass().addMethod(name2, new WrapperMethod((RubyModule)this.getSingletonClass(), method, Visibility.PUBLIC));
                this.callMethod(context, "singleton_method_added", (IRubyObject)context.runtime.fastNewSymbol(name2));
            }
        }
        return this;
    }

    @JRubyMethod(name={"method_added"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_added(ThreadContext context, IRubyObject nothing) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"method_removed"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_removed(ThreadContext context, IRubyObject nothing) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"method_undefined"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_undefined(ThreadContext context, IRubyObject nothing) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"method_defined?"}, required=1)
    public RubyBoolean method_defined_p(ThreadContext context, IRubyObject symbol) {
        return this.isMethodBound(symbol.asJavaString(), true) ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    @JRubyMethod(name={"public_method_defined?"}, required=1)
    public IRubyObject public_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method = this.searchMethod(symbol.asJavaString());
        return context.runtime.newBoolean(!method.isUndefined() && method.getVisibility() == Visibility.PUBLIC);
    }

    @JRubyMethod(name={"protected_method_defined?"}, required=1)
    public IRubyObject protected_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method = this.searchMethod(symbol.asJavaString());
        return context.runtime.newBoolean(!method.isUndefined() && method.getVisibility() == Visibility.PROTECTED);
    }

    @JRubyMethod(name={"private_method_defined?"}, required=1)
    public IRubyObject private_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method = this.searchMethod(symbol.asJavaString());
        return context.runtime.newBoolean(!method.isUndefined() && method.getVisibility() == Visibility.PRIVATE);
    }

    @JRubyMethod(name={"public_class_method"}, rest=true)
    public RubyModule public_class_method(IRubyObject[] args2) {
        this.checkFrozen();
        this.getSingletonClass().setMethodVisibility(args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"private_class_method"}, rest=true)
    public RubyModule private_class_method(IRubyObject[] args2) {
        this.checkFrozen();
        this.getSingletonClass().setMethodVisibility(args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"alias_method"}, required=2, visibility=Visibility.PRIVATE)
    public RubyModule alias_method(ThreadContext context, IRubyObject newId, IRubyObject oldId) {
        String newName = newId.asJavaString();
        this.defineAlias(newName, oldId.asJavaString());
        RubySymbol newSym = TypeConverter.checkID(newId);
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_added", newSym);
        } else {
            this.callMethod(context, "method_added", (IRubyObject)newSym);
        }
        return this;
    }

    @JRubyMethod(name={"undef_method"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule undef_method(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.undef(context, args2[i2].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this, arg0, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this, arg0, arg1, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this, arg0, arg1, arg2, block, EvalType.MODULE_EVAL);
    }

    @Deprecated
    public IRubyObject module_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.specificEval(context, this, args2, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_exec", "class_exec"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_exec(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, IRubyObject.NULL_ARRAY, block, EvalType.MODULE_EVAL);
        }
        throw context.runtime.newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"module_exec", "class_exec"}, rest=true, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, args2, block, EvalType.MODULE_EVAL);
        }
        throw context.runtime.newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"remove_method"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule remove_method(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.removeMethod(context, TypeConverter.checkID(args2[i2]).toString());
        }
        return this;
    }

    public static void marshalTo(RubyModule module, MarshalStream output) throws IOException {
        output.registerLinkTarget(module);
        output.writeString(MarshalStream.getPathFromClass(module));
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyModule result2 = UnmarshalStream.getModuleFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result2);
        return result2;
    }

    @JRubyMethod(name={"nesting"}, reads={FrameField.SCOPE}, meta=true)
    public static RubyArray nesting(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass object = runtime.getObject();
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyArray result2 = runtime.newArray();
        StaticScope current2 = scope;
        while (current2.getModule() != object) {
            result2.append(current2.getModule());
            current2 = current2.getPreviousCRefScope();
        }
        return result2;
    }

    private void doIncludeModule(RubyModule baseModule) {
        List<RubyModule> modulesToInclude = this.gatherModules(baseModule);
        RubyModule currentInclusionPoint = this.methodLocation;
        block0: for (RubyModule nextModule : modulesToInclude) {
            this.checkForCyclicInclude(nextModule);
            boolean superclassSeen = false;
            for (RubyClass nextClass = this.methodLocation.getSuperClass(); nextClass != null; nextClass = nextClass.getSuperClass()) {
                if (this.doesTheClassWrapTheModule(nextClass, nextModule)) {
                    if (superclassSeen) continue block0;
                    currentInclusionPoint = nextClass;
                    continue block0;
                }
                superclassSeen = true;
            }
            currentInclusionPoint = this.proceedWithInclude(currentInclusionPoint, nextModule.getDelegate());
        }
    }

    private void doPrependModule(RubyModule baseModule) {
        List<RubyModule> modulesToInclude = this.gatherModules(baseModule);
        Object insertBelowSuperClass = null;
        if (this.methodLocation == this) {
            PrependedModule prep = new PrependedModule(this.getRuntime(), this.getSuperClass(), this);
            if (this instanceof RubyClass) {
                RubyClass insertBelowClass = (RubyClass)this;
                if (insertBelowClass.getSuperClass() != null) {
                    insertBelowClass.getSuperClass().replaceSubclass(insertBelowClass, prep);
                }
                prep.addSubclass(insertBelowClass);
            }
            this.setSuperClass(prep);
        }
        RubyModule currentInclusionPoint = this;
        block0: for (RubyModule nextModule : modulesToInclude) {
            this.checkForCyclicInclude(nextModule);
            boolean superclassSeen = false;
            for (RubyClass nextClass = this.getSuperClass(); nextClass != null; nextClass = nextClass.getSuperClass()) {
                if (this.doesTheClassWrapTheModule(nextClass, nextModule)) {
                    if (superclassSeen) continue block0;
                    currentInclusionPoint = nextClass;
                    continue block0;
                }
                superclassSeen = true;
            }
            currentInclusionPoint = this.proceedWithPrepend(currentInclusionPoint, nextModule);
        }
    }

    private boolean doesTheClassWrapTheModule(RubyClass theClass, RubyModule theModule) {
        return theClass.isIncluded() && theClass.getDelegate() == theModule.getDelegate();
    }

    private List<RubyModule> gatherModules(RubyModule baseModule) {
        ArrayList<RubyModule> modulesToInclude = new ArrayList<RubyModule>();
        while (baseModule != null) {
            modulesToInclude.add(baseModule.getDelegate());
            baseModule = baseModule.getSuperClass();
        }
        return modulesToInclude;
    }

    private RubyModule proceedWithInclude(RubyModule insertAbove, RubyModule moduleToInclude) {
        IncludedModuleWrapper wrapper = new IncludedModuleWrapper(this.getRuntime(), insertAbove.getSuperClass(), moduleToInclude);
        if (insertAbove instanceof RubyClass) {
            RubyClass insertAboveClass = (RubyClass)insertAbove;
            if (insertAboveClass.getSuperClass() != null) {
                insertAboveClass.getSuperClass().replaceSubclass(insertAboveClass, wrapper);
            }
            wrapper.addSubclass(insertAboveClass);
        }
        insertAbove.setSuperClass(wrapper);
        insertAbove = insertAbove.getSuperClass();
        return insertAbove;
    }

    private RubyModule proceedWithPrepend(RubyModule insertBelow, RubyModule moduleToPrepend) {
        if (!moduleToPrepend.isPrepended()) {
            moduleToPrepend = moduleToPrepend.getNonIncludedClass();
        }
        return this.proceedWithInclude(insertBelow, moduleToPrepend);
    }

    @JRubyMethod(name={"class_variable_defined?"}, required=1)
    public IRubyObject class_variable_defined_p(ThreadContext context, IRubyObject var) {
        String internedName = this.validateClassVariable(var, var.asJavaString().intern());
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(internedName)) continue;
            return context.runtime.getTrue();
        } while ((module = module.getSuperClass()) != null);
        return context.runtime.getFalse();
    }

    public IRubyObject class_variable_get(IRubyObject var) {
        return this.getClassVar(var, this.validateClassVariable(var, var.asJavaString()).intern());
    }

    @JRubyMethod(name={"class_variable_get"})
    public IRubyObject class_variable_get19(IRubyObject var) {
        return this.class_variable_get(var);
    }

    public IRubyObject class_variable_set(IRubyObject var, IRubyObject value2) {
        return this.setClassVar(this.validateClassVariable(var, var.asJavaString()).intern(), value2);
    }

    @JRubyMethod(name={"class_variable_set"})
    public IRubyObject class_variable_set19(IRubyObject var, IRubyObject value2) {
        return this.class_variable_set(var, value2);
    }

    public IRubyObject remove_class_variable(ThreadContext context, IRubyObject name2) {
        return this.removeClassVariable(name2.asJavaString());
    }

    @JRubyMethod(name={"remove_class_variable"})
    public IRubyObject remove_class_variable19(ThreadContext context, IRubyObject name2) {
        return this.remove_class_variable(context, name2);
    }

    @Deprecated
    public RubyArray class_variables19(ThreadContext context) {
        return this.class_variables(context);
    }

    @JRubyMethod(name={"class_variables"})
    public RubyArray class_variables(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyArray ary = runtime.newArray();
        Collection<String> names2 = this.classVariablesCommon(true);
        for (String name2 : names2) {
            ary.add(runtime.newSymbol(name2));
        }
        return ary;
    }

    @JRubyMethod(name={"class_variables"})
    public RubyArray class_variables(ThreadContext context, IRubyObject inherit) {
        Ruby runtime = context.runtime;
        RubyArray ary = runtime.newArray();
        Collection<String> names2 = this.classVariablesCommon(inherit.isTrue());
        for (String name2 : names2) {
            ary.add(runtime.newSymbol(name2));
        }
        return ary;
    }

    private Collection<String> classVariablesCommon(boolean inherit) {
        HashSet<String> names2 = new HashSet<String>();
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            names2.addAll(p2.getClassVariableNameList());
            if (!inherit) break;
        }
        return names2;
    }

    public RubyBoolean const_defined_p(ThreadContext context, IRubyObject symbol) {
        return this.const_defined_p19(context, new IRubyObject[]{symbol});
    }

    @JRubyMethod(name={"const_defined?"}, required=1, optional=1)
    public RubyBoolean const_defined_p19(ThreadContext context, IRubyObject[] args2) {
        IRubyObject obj;
        String fullName;
        Ruby runtime = context.runtime;
        boolean inherit = args2.length == 1 || !args2[1].isNil() && args2[1].isTrue();
        IRubyObject symbol = args2[0];
        String name2 = fullName = symbol.asJavaString();
        int sep = name2.indexOf("::");
        if (symbol instanceof RubySymbol && sep != -1) {
            throw runtime.newNameError("wrong constant name", name2);
        }
        RubyModule mod = this;
        if (sep == 0) {
            mod = runtime.getObject();
            name2 = name2.substring(2);
        }
        if (name2.length() == 0) {
            throw runtime.newNameError("wrong constant name ", fullName);
        }
        while ((sep = name2.indexOf("::")) != -1) {
            String segment = name2.substring(0, sep);
            if (segment.length() == 0) {
                throw runtime.newNameError("wrong constant name " + fullName, name2);
            }
            obj = mod.getConstantNoConstMissing(this.validateConstant(segment, symbol), inherit, inherit);
            if (obj == null) {
                return runtime.getFalse();
            }
            if (!(obj instanceof RubyModule)) {
                throw runtime.newTypeError(segment + " does not refer to class/module");
            }
            mod = (RubyModule)obj;
            name2 = name2.substring(sep + 2);
        }
        obj = mod.getConstantSkipAutoload(this.validateConstant(name2, symbol), inherit, inherit);
        return runtime.newBoolean(obj != null);
    }

    public IRubyObject const_get(IRubyObject symbol) {
        return this.const_get_2_0(this.getRuntime().getCurrentContext(), new IRubyObject[]{symbol});
    }

    public IRubyObject const_get_1_9(ThreadContext context, IRubyObject[] args2) {
        return this.const_get_2_0(context, args2);
    }

    @JRubyMethod(name={"const_get"}, required=1, optional=1)
    public IRubyObject const_get_2_0(ThreadContext context, IRubyObject[] args2) {
        String fullName;
        Ruby runtime = context.runtime;
        boolean inherit = args2.length == 1 || !args2[1].isNil() && args2[1].isTrue();
        IRubyObject symbol = args2[0];
        String name2 = fullName = symbol.asJavaString();
        int sep = name2.indexOf("::");
        if (symbol instanceof RubySymbol && sep != -1) {
            throw runtime.newNameError("wrong constant name", name2);
        }
        RubyModule mod = this;
        if (sep == 0) {
            mod = runtime.getObject();
            name2 = name2.substring(2);
        }
        if (name2.length() == 0) {
            throw runtime.newNameError("wrong constant name ", fullName);
        }
        while ((sep = name2.indexOf("::")) != -1) {
            String segment = name2.substring(0, sep);
            IRubyObject obj = mod.getConstant(this.validateConstant(segment, symbol), inherit, inherit);
            if (!(obj instanceof RubyModule)) {
                throw runtime.newTypeError(segment + " does not refer to class/module");
            }
            mod = (RubyModule)obj;
            name2 = name2.substring(sep + 2);
        }
        return mod.getConstant(this.validateConstant(name2, symbol), inherit, inherit);
    }

    @JRubyMethod(name={"const_set"}, required=2)
    public IRubyObject const_set(IRubyObject symbol, IRubyObject value2) {
        return this.setConstant(this.validateConstant(symbol).intern(), value2);
    }

    @JRubyMethod(name={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_const(ThreadContext context, IRubyObject rubyName) {
        String name2 = this.validateConstant(rubyName);
        IRubyObject value2 = this.deleteConstant(name2);
        if (value2 != null) {
            this.invalidateConstantCache(name2);
            if (value2 != UNDEF) {
                return value2;
            }
            this.removeAutoload(name2);
            return context.runtime.getNil();
        }
        if (this.hasConstantInHierarchy(name2)) {
            throw this.cannotRemoveError(name2);
        }
        throw context.runtime.newNameError("constant " + name2 + " not defined for " + this.getName(), name2);
    }

    private boolean hasConstantInHierarchy(String name2) {
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.hasConstant(name2)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"const_missing"}, required=1)
    public IRubyObject const_missing(ThreadContext context, IRubyObject rubyName, Block block) {
        Ruby runtime = context.runtime;
        String shortName = rubyName.asJavaString();
        String longName = this != runtime.getObject() ? this.getName() + "::" + shortName : shortName;
        throw runtime.newNameError("uninitialized constant " + longName, (IRubyObject)this, rubyName);
    }

    public RubyArray constants(ThreadContext context) {
        return this.constants19(context);
    }

    @JRubyMethod(name={"constants"})
    public RubyArray constants19(ThreadContext context) {
        return this.constantsCommon19(context, true, true);
    }

    @JRubyMethod(name={"constants"})
    public RubyArray constants19(ThreadContext context, IRubyObject allConstants) {
        return this.constantsCommon19(context, false, allConstants.isTrue());
    }

    public RubyArray constantsCommon19(ThreadContext context, boolean replaceModule, boolean allConstants) {
        Ruby runtime = context.runtime;
        RubyArray array = runtime.newArray();
        Collection<String> constantNames = this.constantsCommon(runtime, replaceModule, allConstants, false);
        for (String name2 : constantNames) {
            array.add(runtime.newSymbol(name2));
        }
        return array;
    }

    public Collection<String> constantsCommon(Ruby runtime, boolean replaceModule, boolean allConstants) {
        return this.constantsCommon(runtime, replaceModule, allConstants, true);
    }

    public Collection<String> constantsCommon(Ruby runtime, boolean replaceModule, boolean allConstants, boolean includePrivate) {
        Collection<String> constantNames;
        RubyClass objectClass = runtime.getObject();
        if (allConstants) {
            if (replaceModule && runtime.getModule() == this || objectClass == this) {
                constantNames = objectClass.getConstantNames(includePrivate);
            } else {
                HashSet<String> names2 = new HashSet<String>();
                for (RubyModule module = this; module != null && module != objectClass; module = module.getSuperClass()) {
                    names2.addAll(module.getConstantNames(includePrivate));
                }
                constantNames = names2;
            }
        } else {
            constantNames = replaceModule && runtime.getModule() == this || objectClass == this ? objectClass.getConstantNames(includePrivate) : this.getConstantNames(includePrivate);
        }
        return constantNames;
    }

    public void deprecateConstant(Ruby runtime, String name2) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            throw runtime.newNameError("constant " + this.getName() + "::" + name2 + " not defined", name2);
        }
        this.storeConstant(name2, entry.value, entry.hidden, true);
        this.invalidateConstantCache(name2);
    }

    @JRubyMethod
    public IRubyObject deprecate_constant(ThreadContext context, IRubyObject rname) {
        this.checkFrozen();
        this.deprecateConstant(context.runtime, this.validateConstant(rname));
        return this;
    }

    @JRubyMethod(rest=true)
    public IRubyObject deprecate_constant(ThreadContext context, IRubyObject[] names2) {
        for (IRubyObject rname : names2) {
            this.deprecate_constant(context, rname);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject private_constant(ThreadContext context, IRubyObject rubyName) {
        this.checkFrozen();
        String name2 = this.validateConstant(rubyName);
        this.setConstantVisibility(context, name2, true);
        this.invalidateConstantCache(name2);
        return this;
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject private_constant(ThreadContext context, IRubyObject[] rubyNames) {
        for (IRubyObject rubyName : rubyNames) {
            this.private_constant(context, rubyName);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject public_constant(ThreadContext context, IRubyObject rubyName) {
        this.checkFrozen();
        String name2 = this.validateConstant(rubyName);
        this.setConstantVisibility(context, name2, false);
        this.invalidateConstantCache(name2);
        return this;
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject public_constant(ThreadContext context, IRubyObject[] rubyNames) {
        for (IRubyObject rubyName : rubyNames) {
            this.public_constant(context, rubyName);
        }
        return this;
    }

    @JRubyMethod(name={"prepend"}, rest=true)
    public IRubyObject prepend(ThreadContext context, IRubyObject[] modules) {
        int i2 = modules.length;
        while (--i2 >= 0) {
            IRubyObject obj = modules[i2];
            if (obj.isModule()) continue;
            throw context.runtime.newTypeError(obj, context.runtime.getModule());
        }
        for (i2 = modules.length - 1; i2 >= 0; --i2) {
            modules[i2].callMethod(context, "prepend_features", this);
            modules[i2].callMethod(context, "prepended", this);
        }
        return this;
    }

    @JRubyMethod(name={"prepended"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject prepended(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    private void setConstantVisibility(ThreadContext context, String name2, boolean hidden) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            throw context.runtime.newNameError("constant " + this.getName() + "::" + name2 + " not defined", name2);
        }
        this.storeConstant(name2, entry.value, hidden);
    }

    public IRubyObject setClassVar(String name2, IRubyObject value2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return module.storeClassVariable(name2, value2);
        } while ((module = module.getSuperClass()) != null);
        return this.storeClassVariable(name2, value2);
    }

    @Deprecated
    public IRubyObject fastSetClassVar(String internedName, IRubyObject value2) {
        return this.setClassVar(internedName, value2);
    }

    public IRubyObject getClassVar(String name2) {
        IRubyObject value2 = this.getClassVarQuiet(name2);
        if (value2 == null) {
            throw this.getRuntime().newNameError("uninitialized class variable %s in %s", (IRubyObject)this, name2);
        }
        return value2;
    }

    public IRubyObject getClassVar(IRubyObject nameObject, String name2) {
        IRubyObject value2 = this.getClassVarQuiet(name2);
        if (value2 == null) {
            throw this.getRuntime().newNameError("uninitialized class variable %s in %s", (IRubyObject)this, nameObject);
        }
        return value2;
    }

    public IRubyObject getClassVarQuiet(String name2) {
        assert (IdUtil.isClassVariable(name2));
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.fetchClassVariable(name2)) == null) continue;
            return value2;
        } while ((module = module.getSuperClass()) != null);
        return null;
    }

    @Deprecated
    public IRubyObject fastGetClassVar(String internedName) {
        return this.getClassVar(internedName);
    }

    public boolean isClassVarDefined(String name2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    @Deprecated
    public boolean fastIsClassVarDefined(String internedName) {
        return this.isClassVarDefined(internedName);
    }

    @Deprecated
    public IRubyObject removeCvar(IRubyObject name2) {
        return this.removeClassVariable(name2.asJavaString());
    }

    public IRubyObject removeClassVariable(String name2) {
        String javaName = this.validateClassVariable(name2);
        IRubyObject value2 = this.deleteClassVariable(javaName);
        if (value2 != null) {
            return value2;
        }
        if (this.isClassVarDefined(javaName)) {
            throw this.cannotRemoveError(javaName);
        }
        throw this.getRuntime().newNameError("class variable " + javaName + " not defined for " + this.getName(), javaName);
    }

    public IRubyObject getConstantAtSpecial(String name2) {
        IRubyObject value2 = this == this.getRuntime().getObject() ? this.getConstantNoConstMissing(name2) : this.fetchConstant(name2);
        return value2 == UNDEF ? this.resolveUndefConstant(name2) : value2;
    }

    public IRubyObject getConstantAt(String name2) {
        return this.getConstantAt(name2, true);
    }

    public IRubyObject getConstantAt(String name2, boolean includePrivate) {
        IRubyObject value2 = this.fetchConstant(name2, includePrivate);
        return value2 == UNDEF ? this.resolveUndefConstant(name2) : value2;
    }

    @Deprecated
    public IRubyObject fastGetConstantAt(String internedName) {
        return this.getConstantAt(internedName);
    }

    public IRubyObject getConstant(String name2) {
        return this.getConstant(name2, true);
    }

    public IRubyObject getConstant(String name2, boolean inherit) {
        return this.getConstant(name2, inherit, true);
    }

    public IRubyObject getConstant(String name2, boolean inherit, boolean includeObject) {
        assert (IdUtil.isConstant(name2));
        IRubyObject value2 = this.getConstantNoConstMissing(name2, inherit, includeObject);
        Ruby runtime = this.getRuntime();
        return value2 != null ? value2 : this.callMethod(runtime.getCurrentContext(), "const_missing", (IRubyObject)runtime.newSymbol(name2));
    }

    @Deprecated
    public IRubyObject fastGetConstant(String internedName) {
        return this.getConstant(internedName);
    }

    @Deprecated
    public IRubyObject fastGetConstant(String internedName, boolean inherit) {
        return this.getConstant(internedName, inherit);
    }

    public IRubyObject getConstantNoConstMissing(String name2) {
        return this.getConstantNoConstMissing(name2, true);
    }

    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit) {
        return this.getConstantNoConstMissing(name2, inherit, true);
    }

    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit, boolean includeObject) {
        IRubyObject constant = RubyModule.iterateConstantNoConstMissing(name2, this, inherit, true);
        if (constant == null && !this.isClass() && includeObject) {
            constant = RubyModule.iterateConstantNoConstMissing(name2, this.getRuntime().getObject(), inherit, true);
        }
        return constant;
    }

    private IRubyObject getConstantSkipAutoload(String name2, boolean inherit, boolean includeObject) {
        IRubyObject constant = RubyModule.iterateConstantNoConstMissing(name2, this, inherit, false);
        if (constant == null && !this.isClass() && includeObject) {
            constant = RubyModule.iterateConstantNoConstMissing(name2, this.getRuntime().getObject(), inherit, false);
        }
        return constant;
    }

    private static IRubyObject iterateConstantNoConstMissing(String name2, RubyModule init, boolean inherit, boolean loadConstant) {
        for (RubyModule mod = init; mod != null; mod = mod.getSuperClass()) {
            IRubyObject value2 = mod.fetchConstant(name2, true);
            if (value2 == UNDEF) {
                return mod.getAutoloadConstant(name2, loadConstant);
            }
            if (value2 != null) {
                return value2;
            }
            if (!inherit) break;
        }
        return null;
    }

    public IRubyObject getConstantFrom(String name2) {
        IRubyObject value2 = this.getConstantFromNoConstMissing(name2);
        return value2 != null ? value2 : this.getConstantFromConstMissing(name2);
    }

    @Deprecated
    public IRubyObject fastGetConstantFrom(String internedName) {
        return this.getConstantFrom(internedName);
    }

    public IRubyObject getConstantFromNoConstMissing(String name2) {
        return this.getConstantFromNoConstMissing(name2, true);
    }

    public IRubyObject getConstantFromNoConstMissing(String name2, boolean includePrivate) {
        assert (name2 == name2.intern()) : name2 + " is not interned";
        Ruby runtime = this.getRuntime();
        RubyClass objectClass = runtime.getObject();
        for (RubyModule mod = this; mod != null; mod = mod.getSuperClass()) {
            IRubyObject value2 = mod.fetchConstant(name2, includePrivate);
            if (value2 == null) continue;
            if (value2 == UNDEF) {
                return mod.resolveUndefConstant(name2);
            }
            if (mod == objectClass && this != objectClass) {
                String badCName = this.getName() + "::" + name2;
                runtime.getWarnings().warn(IRubyWarnings.ID.CONSTANT_BAD_REFERENCE, "toplevel constant " + name2 + " referenced by " + badCName);
            }
            return value2;
        }
        return null;
    }

    @Deprecated
    public IRubyObject fastGetConstantFromNoConstMissing(String internedName) {
        return this.getConstantFromNoConstMissing(internedName);
    }

    public IRubyObject getConstantFromConstMissing(String name2) {
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", (IRubyObject)this.getRuntime().fastNewSymbol(name2));
    }

    @Deprecated
    public IRubyObject fastGetConstantFromConstMissing(String internedName) {
        return this.getConstantFromConstMissing(internedName);
    }

    public final IRubyObject resolveUndefConstant(String name2) {
        return this.getAutoloadConstant(name2);
    }

    public IRubyObject setConstantQuiet(String name2, IRubyObject value2) {
        return this.setConstantCommon(name2, value2, false, false);
    }

    public IRubyObject setConstant(String name2, IRubyObject value2) {
        return this.setConstantCommon(name2, value2, false, true);
    }

    public IRubyObject setConstant(String name2, IRubyObject value2, boolean hidden) {
        return this.setConstantCommon(name2, value2, hidden, true);
    }

    private IRubyObject setConstantCommon(String name2, IRubyObject value2, boolean hidden, boolean warn2) {
        IRubyObject oldValue = this.fetchConstant(name2);
        this.setParentForModule(name2, value2);
        if (oldValue != null) {
            boolean notAutoload;
            boolean bl = notAutoload = oldValue != UNDEF;
            if (notAutoload || !this.setAutoloadConstant(name2, value2)) {
                if (warn2 && notAutoload) {
                    this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_ALREADY_INITIALIZED, "already initialized constant " + name2);
                }
                if (hidden) {
                    this.storeConstant(name2, value2, true);
                } else {
                    this.storeConstant(name2, value2);
                }
            }
        } else if (hidden) {
            this.storeConstant(name2, value2, true);
        } else {
            this.storeConstant(name2, value2);
        }
        this.invalidateConstantCache(name2);
        return value2;
    }

    private void setParentForModule(String name2, IRubyObject value2) {
        if (value2 instanceof RubyModule) {
            RubyModule module = (RubyModule)value2;
            if (module != this && module.getBaseName() == null) {
                module.setBaseName(name2);
                module.setParent(this);
            }
            module.calculateName();
        }
    }

    @Deprecated
    public IRubyObject fastSetConstant(String internedName, IRubyObject value2) {
        return this.setConstant(internedName, value2);
    }

    @Extension
    public void defineConstant(String name2, IRubyObject value2) {
        assert (value2 != null);
        if (!IdUtil.isValidConstantName19(name2)) {
            throw this.getRuntime().newNameError("bad constant name " + name2, name2);
        }
        this.setConstant(name2, value2);
    }

    public boolean isConstantDefined(String name2) {
        assert (IdUtil.isConstant(name2));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFetch(name2)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getAutoloadMap().get(name2) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined(String internedName) {
        assert (internedName.equals(internedName.intern())) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFetch(internedName)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getAutoloadMap().get(internedName) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined19(String internedName) {
        return this.fastIsConstantDefined19(internedName, true);
    }

    public boolean fastIsConstantDefined19(String internedName, boolean inherit) {
        assert (internedName.equals(internedName.intern())) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            IRubyObject value2 = module.constantTableFetch(internedName);
            if (value2 != null) {
                if (value2 != UNDEF) {
                    return true;
                }
                return this.getAutoloadMap().get(internedName) != null;
            }
            if (!inherit) break;
        }
        return false;
    }

    private RaiseException cannotRemoveError(String id2) {
        return this.getRuntime().newNameError("cannot remove " + id2 + " for " + this.getName(), id2);
    }

    public boolean hasInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            return true;
        }
        return false;
    }

    public IRubyObject searchInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            IRubyObject value2 = (IRubyObject)module.getInternalVariable(name2);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public void setInternalModuleVariable(String name2, IRubyObject value2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            module.setInternalVariable(name2, value2);
            return;
        }
        this.setInternalVariable(name2, value2);
    }

    protected Map<String, IRubyObject> getClassVariables() {
        if (CLASSVARS_UPDATER == null) {
            return this.getClassVariablesForWriteSynchronized();
        }
        return this.getClassVariablesForWriteAtomic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IRubyObject> getClassVariablesForWriteSynchronized() {
        Map<String, IRubyObject> myClassVars = this.classVariables;
        if (myClassVars == Collections.EMPTY_MAP) {
            RubyModule rubyModule = this;
            synchronized (rubyModule) {
                myClassVars = this.classVariables;
                if (myClassVars == Collections.EMPTY_MAP) {
                    this.classVariables = new ConcurrentHashMap<String, IRubyObject>(4, 0.75f, 2);
                    return this.classVariables;
                }
                return myClassVars;
            }
        }
        return myClassVars;
    }

    private Map<String, IRubyObject> getClassVariablesForWriteAtomic() {
        ConcurrentHashMap<String, IRubyObject> newClassVars;
        Map<String, IRubyObject> myClassVars;
        do {
            if ((myClassVars = this.classVariables) == Collections.EMPTY_MAP) continue;
            return myClassVars;
        } while (!CLASSVARS_UPDATER.compareAndSet(this, myClassVars, newClassVars = new ConcurrentHashMap<String, IRubyObject>(4, 0.75f, 2)));
        return newClassVars;
    }

    protected Map<String, IRubyObject> getClassVariablesForRead() {
        return this.classVariables;
    }

    public boolean hasClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().containsKey(name2);
    }

    @Deprecated
    public boolean fastHasClassVariable(String internedName) {
        return this.hasClassVariable(internedName);
    }

    public IRubyObject fetchClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().get(name2);
    }

    @Deprecated
    public IRubyObject fastFetchClassVariable(String internedName) {
        return this.fetchClassVariable(internedName);
    }

    public IRubyObject storeClassVariable(String name2, IRubyObject value2) {
        assert (IdUtil.isClassVariable(name2) && value2 != null);
        this.ensureClassVariablesSettable();
        this.getClassVariables().put(name2, value2);
        return value2;
    }

    @Deprecated
    public IRubyObject fastStoreClassVariable(String internedName, IRubyObject value2) {
        return this.storeClassVariable(internedName, value2);
    }

    public IRubyObject deleteClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        this.ensureClassVariablesSettable();
        return this.getClassVariablesForRead().remove(name2);
    }

    public List<String> getClassVariableNameList() {
        return new ArrayList<String>(this.getClassVariablesForRead().keySet());
    }

    protected final String validateClassVariable(String name2) {
        if (IdUtil.isValidClassVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`" + name2 + "' is not allowed as a class variable name", (IRubyObject)this, name2);
    }

    protected final String validateClassVariable(IRubyObject nameObj, String name2) {
        if (IdUtil.isValidClassVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`" + name2 + "' is not allowed as a class variable name", (IRubyObject)this, nameObj);
    }

    protected final void ensureClassVariablesSettable() {
        this.checkAndRaiseIfFrozen();
    }

    public boolean hasConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        return this.constantTableContains(name2);
    }

    @Deprecated
    public boolean fastHasConstant(String internedName) {
        return this.hasConstant(internedName);
    }

    public IRubyObject fetchConstant(String name2) {
        return this.fetchConstant(name2, true);
    }

    public IRubyObject fetchConstant(String name2, boolean includePrivate) {
        assert (IdUtil.isConstant(name2));
        ConstantEntry entry = this.constantEntryFetch(name2);
        if (entry == null) {
            return null;
        }
        if (entry.hidden && !includePrivate) {
            throw this.getRuntime().newNameError("private constant " + this.getName() + "::" + name2 + " referenced", name2);
        }
        if (entry.deprecated) {
            Ruby runtime = this.getRuntime();
            if ("Object".equals(this.getName())) {
                runtime.getWarnings().warn(IRubyWarnings.ID.CONSTANT_DEPRECATED, "constant ::" + name2 + " is deprecated");
            } else {
                runtime.getWarnings().warn(IRubyWarnings.ID.CONSTANT_DEPRECATED, "constant " + this.getName() + "::" + name2 + " is deprecated");
            }
        }
        return entry.value;
    }

    @Deprecated
    public IRubyObject fastFetchConstant(String internedName) {
        return this.fetchConstant(internedName);
    }

    public IRubyObject storeConstant(String name2, IRubyObject value2) {
        assert (IdUtil.isConstant(name2)) : name2 + " is not a valid constant name";
        assert (value2 != null) : "value is null";
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2);
    }

    public IRubyObject storeConstant(String name2, IRubyObject value2, boolean hidden) {
        assert (IdUtil.isConstant(name2)) : name2 + " is not a valid constant name";
        assert (value2 != null) : "value is null";
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2, hidden);
    }

    private IRubyObject storeConstant(String name2, IRubyObject value2, boolean hidden, boolean deprecated) {
        assert (IdUtil.isConstant(name2)) : name2 + " is not a valid constant name";
        assert (value2 != null) : "value is null";
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2, hidden, deprecated);
    }

    @Deprecated
    public IRubyObject fastStoreConstant(String internedName, IRubyObject value2) {
        return this.storeConstant(internedName, value2);
    }

    public IRubyObject deleteConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        this.ensureConstantsSettable();
        return this.constantTableRemove(name2);
    }

    @Deprecated
    public List<Variable<IRubyObject>> getStoredConstantList() {
        return null;
    }

    @Deprecated
    public List<String> getStoredConstantNameList() {
        return new ArrayList<String>(this.getConstantMap().keySet());
    }

    public Collection<String> getConstantNames() {
        return this.getConstantMap().keySet();
    }

    public Collection<String> getConstantNames(boolean includePrivate) {
        if (includePrivate) {
            return this.getConstantNames();
        }
        if (this.getConstantMap().size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> publicNames = new HashSet<String>(this.getConstantMap().size());
        for (Map.Entry<String, ConstantEntry> entry : this.getConstantMap().entrySet()) {
            if (entry.getValue().hidden) continue;
            publicNames.add(entry.getKey());
        }
        return publicNames;
    }

    protected final String validateConstant(IRubyObject name2) {
        return this.validateConstant(name2.asJavaString(), name2);
    }

    protected final String validateConstant(String name2, IRubyObject errorName) {
        RubyString nameString;
        if (IdUtil.isValidConstantName19(name2)) {
            return name2;
        }
        Ruby runtime = this.getRuntime();
        Encoding resultEncoding = runtime.getDefaultInternalEncoding();
        if (resultEncoding == null) {
            resultEncoding = runtime.getDefaultExternalEncoding();
        }
        if ((nameString = errorName.asString()).getEncoding() != resultEncoding && !nameString.isAsciiOnly() || nameString.toString().indexOf(0) > -1) {
            nameString = (RubyString)nameString.inspect();
        }
        throw this.getRuntime().newNameError("wrong constant name " + nameString, name2);
    }

    protected final void ensureConstantsSettable() {
        this.checkAndRaiseIfFrozen();
    }

    private void checkAndRaiseIfFrozen() throws RaiseException {
        if (this.isFrozen()) {
            if (this instanceof RubyClass) {
                if (this.getBaseName() == null) {
                    throw this.getRuntime().newFrozenError(this.getName());
                }
                throw this.getRuntime().newFrozenError("#<Class:" + this.getName() + '>');
            }
            throw this.getRuntime().newFrozenError("Module");
        }
    }

    @Override
    public final void checkFrozen() {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(this.isClass() ? "class" : "module");
        }
    }

    protected boolean constantTableContains(String name2) {
        return this.getConstantMap().containsKey(name2);
    }

    protected IRubyObject constantTableFetch(String name2) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    protected ConstantEntry constantEntryFetch(String name2) {
        return this.getConstantMap().get(name2);
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2) {
        Map<String, ConstantEntry> constMap = this.getConstantMapForWrite();
        boolean hidden = false;
        ConstantEntry entry = constMap.get(name2);
        if (entry != null) {
            hidden = entry.hidden;
        }
        constMap.put(name2, new ConstantEntry(value2, hidden));
        return value2;
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2, boolean hidden) {
        return this.constantTableStore(name2, value2, hidden, false);
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2, boolean hidden, boolean deprecated) {
        Map<String, ConstantEntry> constMap = this.getConstantMapForWrite();
        constMap.put(name2, new ConstantEntry(value2, hidden, deprecated));
        return value2;
    }

    protected IRubyObject constantTableRemove(String name2) {
        ConstantEntry entry = this.getConstantMapForWrite().remove(name2);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    protected final void defineAutoload(String name2, AutoloadMethod loadMethod) {
        Autoload existingAutoload = this.getAutoloadMap().get(name2);
        if (existingAutoload == null || existingAutoload.getValue() == null) {
            this.storeConstant(name2, RubyObject.UNDEF);
            this.getAutoloadMapForWrite().put(name2, new Autoload(loadMethod));
        }
    }

    protected final IRubyObject finishAutoload(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return null;
        }
        IRubyObject value2 = autoload2.getValue();
        if (value2 != null) {
            this.storeConstant(name2, value2);
        }
        this.removeAutoload(name2);
        this.invalidateConstantCache(name2);
        return value2;
    }

    public final IRubyObject getAutoloadConstant(String name2) {
        return this.getAutoloadConstant(name2, true);
    }

    protected IRubyObject getAutoloadConstant(String name2, boolean loadConstant) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return null;
        }
        if (!loadConstant) {
            return RubyObject.UNDEF;
        }
        return autoload2.getConstant(this.getRuntime().getCurrentContext());
    }

    private boolean setAutoloadConstant(String name2, IRubyObject value2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 != null) {
            boolean set = autoload2.setConstant(this.getRuntime().getCurrentContext(), value2);
            if (!set) {
                this.removeAutoload(name2);
            }
            return set;
        }
        return false;
    }

    private void removeAutoload(String name2) {
        this.getAutoloadMapForWrite().remove(name2);
    }

    protected RubyString getAutoloadFile(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        return autoload2 == null ? null : autoload2.getFile();
    }

    private static void define(RubyModule module, JavaMethodDescriptor desc, String simpleName, DynamicMethod dynamicMethod) {
        block18: {
            String baseName;
            RubyClass singletonClass;
            JRubyMethod jrubyMethod;
            block17: {
                String baseName2;
                jrubyMethod = desc.anno;
                CallConfiguration needs = CallConfiguration.valueOf(AnnotationHelper.getCallerCallConfigNameByAnno(jrubyMethod));
                if (needs.framing() == Framing.Full) {
                    HashSet<String> frameAwareMethods = new HashSet<String>();
                    AnnotationHelper.addMethodNamesToSet(frameAwareMethods, jrubyMethod, simpleName);
                    MethodIndex.FRAME_AWARE_METHODS.addAll(frameAwareMethods);
                }
                if (needs.scoping() == Scoping.Full) {
                    HashSet<String> scopeAwareMethods = new HashSet<String>();
                    AnnotationHelper.addMethodNamesToSet(scopeAwareMethods, jrubyMethod, simpleName);
                    MethodIndex.SCOPE_AWARE_METHODS.addAll(scopeAwareMethods);
                }
                if (!jrubyMethod.meta()) break block17;
                singletonClass = module.getSingletonClass();
                dynamicMethod.setImplementationClass(singletonClass);
                if (jrubyMethod.name().length == 0) {
                    baseName2 = desc.name;
                    singletonClass.addMethod(baseName2, dynamicMethod);
                } else {
                    baseName2 = jrubyMethod.name()[0];
                    for (String name2 : jrubyMethod.name()) {
                        singletonClass.addMethod(name2, dynamicMethod);
                    }
                }
                if (jrubyMethod.alias().length <= 0) break block18;
                for (String alias : jrubyMethod.alias()) {
                    singletonClass.defineAlias(alias, baseName2);
                }
                break block18;
            }
            if (jrubyMethod.name().length == 0) {
                baseName = desc.name;
                module.getMethodLocation().addMethod(baseName, dynamicMethod);
            } else {
                baseName = jrubyMethod.name()[0];
                for (String name3 : jrubyMethod.name()) {
                    module.getMethodLocation().addMethod(name3, dynamicMethod);
                }
            }
            if (jrubyMethod.alias().length > 0) {
                for (String alias : jrubyMethod.alias()) {
                    module.defineAlias(alias, baseName);
                }
            }
            if (jrubyMethod.module()) {
                singletonClass = module.getSingletonClass();
                DynamicMethod moduleMethod = dynamicMethod.dup();
                moduleMethod.setImplementationClass(singletonClass);
                moduleMethod.setVisibility(Visibility.PUBLIC);
                if (jrubyMethod.name().length == 0) {
                    baseName = desc.name;
                    singletonClass.addMethod(desc.name, moduleMethod);
                } else {
                    baseName = jrubyMethod.name()[0];
                    for (String name4 : jrubyMethod.name()) {
                        singletonClass.addMethod(name4, moduleMethod);
                    }
                }
                if (jrubyMethod.alias().length > 0) {
                    for (String alias : jrubyMethod.alias()) {
                        singletonClass.defineAlias(alias, baseName);
                    }
                }
            }
        }
    }

    @Deprecated
    public IRubyObject initialize(Block block) {
        return this.initialize(this.getRuntime().getCurrentContext());
    }

    public void setJavaProxy(boolean javaProxy) {
        this.javaProxy = javaProxy;
    }

    public boolean getJavaProxy() {
        return this.javaProxy;
    }

    public boolean getCacheProxy() {
        return this.getFlag(16);
    }

    public void setCacheProxy(boolean cacheProxy) {
        this.setFlag(16, cacheProxy);
    }

    @Override
    public Object toJava(Class target) {
        if (target == Class.class && this.respondsTo("java_class")) {
            return this.callMethod("java_class").toJava(target);
        }
        return super.toJava(target);
    }

    public Set<String> discoverInstanceVariables() {
        HashSet<String> set = new HashSet<String>();
        RubyModule cls = this;
        while (cls != null) {
            for (DynamicMethod method : cls.getNonIncludedClass().getMethodLocation().getMethods().values()) {
                MethodData methodData = method.getMethodData();
                set.addAll(methodData.getIvarNames());
            }
            if (!(cls instanceof RubyClass)) break;
            cls = ((RubyClass)cls).getSuperClass();
        }
        return set;
    }

    public boolean isRefinement() {
        return (this.flags & 0x2000) == 8192;
    }

    public boolean isMethodBuiltin(String methodName) {
        DynamicMethod method = this.searchMethodInner(methodName);
        return method != null && method.isBuiltin();
    }

    public Map<RubyClass, RubyModule> getRefinements() {
        return this.refinements;
    }

    public void setRefinements(Map<RubyClass, RubyModule> refinements) {
        this.refinements = refinements;
    }

    static {
        AtomicReferenceFieldUpdater<RubyModule, Map> updater;
        block2: {
            LOG = LoggerFactory.getLogger(RubyModule.class);
            MODULE_ALLOCATOR = new ObjectAllocator(){

                @Override
                public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                    return new RubyModule(runtime, klass);
                }
            };
            NormalCacheEntryFactory = new CacheEntryFactory(){

                @Override
                public CacheEntry newCacheEntry(String name2, DynamicMethod method, int token) {
                    return new CacheEntry(method, token);
                }
            };
            SCOPE_CAPTURING_METHODS = new HashSet<String>(Arrays.asList("eval", "module_eval", "class_eval", "instance_eval", "module_exec", "class_exec", "instance_exec", "binding", "local_variables"));
            updater = null;
            try {
                updater = AtomicReferenceFieldUpdater.newUpdater(RubyModule.class, Map.class, "classVariables");
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof AccessControlException) break block2;
                throw ex;
            }
        }
        CLASSVARS_UPDATER = updater;
    }

    private static final class Autoload {
        private volatile ThreadContext ctx = null;
        private final Object ctxLock = new Object();
        private volatile IRubyObject value = null;
        private final AutoloadMethod loadMethod;

        Autoload(AutoloadMethod loadMethod) {
            this.loadMethod = loadMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IRubyObject getConstant(ThreadContext ctx) {
            Object object = this.ctxLock;
            synchronized (object) {
                if (this.ctx == null) {
                    this.ctx = ctx;
                } else if (this.isSelf(ctx)) {
                    return this.getValue();
                }
                this.loadMethod.load(ctx.runtime);
            }
            return this.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setConstant(ThreadContext ctx, IRubyObject newValue) {
            Object object = this.ctxLock;
            synchronized (object) {
                boolean isSelf = this.isSelf(ctx);
                if (isSelf) {
                    this.value = newValue;
                }
                return isSelf;
            }
        }

        IRubyObject getValue() {
            return this.value;
        }

        RubyString getFile() {
            return this.loadMethod.getFile();
        }

        private boolean isSelf(ThreadContext rhs) {
            return this.ctx != null && this.ctx.getThread() == rhs.getThread();
        }
    }

    public static interface AutoloadMethod {
        public void load(Ruby var1);

        public RubyString getFile();
    }

    public static class ConstantEntry {
        public final IRubyObject value;
        public final boolean hidden;
        final boolean deprecated;

        public ConstantEntry(IRubyObject value2, boolean hidden) {
            this.value = value2;
            this.hidden = hidden;
            this.deprecated = false;
        }

        ConstantEntry(IRubyObject value2, boolean hidden, boolean deprecated) {
            this.value = value2;
            this.hidden = hidden;
            this.deprecated = deprecated;
        }

        public ConstantEntry dup() {
            return new ConstantEntry(this.value, this.hidden, this.deprecated);
        }
    }

    public static class RespondToMissingMethod
    extends JavaMethod.JavaMethodNBlock {
        final CallSite site;

        public RespondToMissingMethod(RubyModule implClass, Visibility vis, String methodName) {
            super(implClass, vis);
            this.site = new FunctionalCachingCallSite(methodName);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return this.site.call(context, self2, self2, args2, block);
        }

        public boolean equals(Object other) {
            if (!(other instanceof RespondToMissingMethod)) {
                return false;
            }
            RespondToMissingMethod that = (RespondToMissingMethod)other;
            return this.site.methodName.equals(that.site.methodName) && this.isImplementedBy(that.getImplementationClass());
        }

        public int hashCode() {
            return 7 * this.site.methodName.hashCode();
        }
    }

    protected static class ProfilingCacheEntryFactory
    extends WrapperCacheEntryFactory {
        private final MethodEnhancer enhancer;

        public ProfilingCacheEntryFactory(Ruby runtime, CacheEntryFactory previous) {
            super(previous);
            this.enhancer = runtime.getProfilingService().newMethodEnhancer(runtime);
        }

        private MethodEnhancer getMethodEnhancer() {
            return this.enhancer;
        }

        @Override
        public CacheEntry newCacheEntry(String name2, DynamicMethod method, int token) {
            if (method.isUndefined()) {
                return new CacheEntry(method, token);
            }
            CacheEntry delegated = this.previous.newCacheEntry(name2, method, token);
            DynamicMethod enhancedMethod = this.getMethodEnhancer().enhance(name2, delegated.method);
            return new CacheEntry(enhancedMethod, delegated.token);
        }
    }

    protected static class SynchronizedCacheEntryFactory
    extends WrapperCacheEntryFactory {
        public SynchronizedCacheEntryFactory(CacheEntryFactory previous) {
            super(previous);
        }

        @Override
        public CacheEntry newCacheEntry(String name2, DynamicMethod method, int token) {
            if (method.isUndefined()) {
                return new CacheEntry(method, token);
            }
            CacheEntry delegated = this.previous.newCacheEntry(name2, method, token);
            return new CacheEntry(new SynchronizedDynamicMethod(delegated.method), delegated.token);
        }
    }

    protected static abstract class WrapperCacheEntryFactory
    extends CacheEntryFactory {
        protected final CacheEntryFactory previous;

        public WrapperCacheEntryFactory(CacheEntryFactory previous) {
            this.previous = previous;
        }

        public CacheEntryFactory getPrevious() {
            return this.previous;
        }
    }

    protected static abstract class CacheEntryFactory {
        protected CacheEntryFactory() {
        }

        public abstract CacheEntry newCacheEntry(String var1, DynamicMethod var2, int var3);

        public boolean hasCacheEntryFactory(Class cacheEntryFactoryClass) {
            CacheEntryFactory current2 = this;
            while (current2 instanceof WrapperCacheEntryFactory) {
                if (cacheEntryFactoryClass.isAssignableFrom(current2.getClass())) {
                    return true;
                }
                current2 = ((WrapperCacheEntryFactory)current2).getPrevious();
            }
            return cacheEntryFactoryClass.isAssignableFrom(current2.getClass());
        }
    }

    public static final class MethodClumper {
        private HashMap<String, List<JavaMethodDescriptor>> annotatedMethods;
        private HashMap<String, List<JavaMethodDescriptor>> staticAnnotatedMethods;

        public void clump(Class cls) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = Initializer.DECLARED_METHODS.get(cls)) {
                ArrayList<JavaMethodDescriptor> methodDescs;
                HashMap<String, List<JavaMethodDescriptor>> methodsHash;
                String name2;
                JRubyMethod anno = method.getAnnotation(JRubyMethod.class);
                if (anno == null || method.isBridge()) continue;
                JavaMethodDescriptor desc = new JavaMethodDescriptor(method);
                String string2 = name2 = anno.name().length == 0 ? method.getName() : anno.name()[0];
                if (desc.isStatic) {
                    methodsHash = this.staticAnnotatedMethods;
                    if (methodsHash == null) {
                        this.staticAnnotatedMethods = new HashMap();
                        methodsHash = this.staticAnnotatedMethods;
                    }
                } else {
                    methodsHash = this.annotatedMethods;
                    if (methodsHash == null) {
                        this.annotatedMethods = new HashMap();
                        methodsHash = this.annotatedMethods;
                    }
                }
                if ((methodDescs = (ArrayList<JavaMethodDescriptor>)methodsHash.get(name2)) == null) {
                    methodsHash.put(name2, Collections.singletonList(desc));
                    continue;
                }
                CompatVersion oldCompat = ((JavaMethodDescriptor)methodDescs.get((int)0)).anno.compat();
                CompatVersion newCompat = desc.anno.compat();
                int comparison = newCompat.compareTo(oldCompat);
                if (comparison == 1) {
                    methodDescs = new ArrayList<JavaMethodDescriptor>(2);
                    methodsHash.put(name2, methodDescs);
                } else if (comparison != 0) continue;
                if (methodDescs.getClass() != ArrayList.class) {
                    ArrayList<JavaMethodDescriptor> newDescs = new ArrayList<JavaMethodDescriptor>(4);
                    newDescs.addAll(methodDescs);
                    methodDescs = newDescs;
                    methodsHash.put(name2, methodDescs);
                }
                methodDescs.add(desc);
            }
        }

        @Deprecated
        public Map<String, List<JavaMethodDescriptor>> getAllAnnotatedMethods() {
            return null;
        }

        public final Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods() {
            return this.annotatedMethods == null ? Collections.EMPTY_MAP : this.annotatedMethods;
        }

        public final Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods() {
            return this.staticAnnotatedMethods == null ? Collections.EMPTY_MAP : this.staticAnnotatedMethods;
        }
    }

    public static final class JavaClassKindOf
    extends KindOf {
        private final Class klass;

        public JavaClassKindOf(Class klass) {
            this.klass = klass;
        }

        @Override
        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            return this.klass.isInstance(obj);
        }
    }

    public static class KindOf {
        public static final KindOf DEFAULT_KIND_OF = new KindOf();

        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            return obj.getMetaClass().hasModuleInHierarchy(type2);
        }
    }

    public static class ModuleKernelMethods {
        @JRubyMethod
        public static IRubyObject autoload(ThreadContext context, IRubyObject self2, IRubyObject symbol, IRubyObject file2) {
            return RubyKernel.autoload(context, self2, symbol, file2);
        }

        @JRubyMethod(name={"autoload?"})
        public static IRubyObject autoload_p(ThreadContext context, IRubyObject self2, IRubyObject symbol) {
            Ruby runtime = context.runtime;
            String name2 = symbol.asJavaString();
            for (RubyModule mod = RubyKernel.getModuleForAutoload(runtime, self2); mod != null; mod = mod.getSuperClass()) {
                IRubyObject loadedValue = mod.fetchConstant(name2);
                if (loadedValue != null && loadedValue != RubyBasicObject.UNDEF) {
                    return context.nil;
                }
                RubyString file2 = mod.isIncluded() ? mod.getNonIncludedClass().getAutoloadFile(name2) : mod.getAutoloadFile(name2);
                if (file2 == null) continue;
                if (runtime.getLoadService().featureAlreadyLoaded(file2.asJavaString())) {
                    return context.nil;
                }
                return file2;
            }
            return context.nil;
        }
    }
}

