/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.transformations.inlining;

import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.dirgra.Edge;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.ModuleVersionGuardInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class CFGInliner {
    private final CFG cfg;

    public CFGInliner(CFG build) {
        this.cfg = build;
    }

    private SimpleCloneInfo cloneHostInstrs(CFG cfg) {
        SimpleCloneInfo ii = new SimpleCloneInfo(cfg.getScope(), false);
        for (BasicBlock b2 : cfg.getBasicBlocks()) {
            b2.cloneInstrs(ii);
        }
        return ii;
    }

    private CFG cloneSelf(InlineCloneInfo ii) {
        CFG selfClone = new CFG(this.cfg.getScope());
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            if (b2.isEntryBB() || b2.isExitBB()) continue;
            selfClone.addBasicBlock(b2.cloneForInlining(ii));
        }
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            if (b2.isEntryBB() || b2.isExitBB()) continue;
            BasicBlock rb = ii.getRenamedBB(b2);
            for (Edge<BasicBlock> e : this.cfg.getOutgoingEdges(b2)) {
                BasicBlock destination = e.getDestination().getData();
                if (destination.isExitBB()) continue;
                selfClone.addEdge(rb, ii.getRenamedBB(destination), e.getType());
            }
        }
        return selfClone;
    }

    public void inlineMethod(IRScope scope, RubyModule implClass, int classToken, BasicBlock callBB, CallBase call2, boolean cloneHost) {
        IRScope hostScope = this.cfg.getScope();
        if (hostScope.getNearestMethod() == scope) {
            return;
        }
        if (callBB == null) {
            block0: for (BasicBlock x : this.cfg.getBasicBlocks()) {
                for (Instr instr : x.getInstrs()) {
                    if (instr.getIPC() != call2.getIPC()) continue;
                    callBB = x;
                    continue block0;
                }
            }
        }
        if (callBB == null) {
            System.out.println("----------------------------------");
            System.out.println("Did not find BB with call: " + call2);
            System.out.println("Host cfg   :" + this.cfg.toStringGraph());
            System.out.println("Host instrs:" + this.cfg.toStringInstrs());
            System.out.println("----------------------------------");
            return;
        }
        Label splitBBLabel = hostScope.getNewLabel();
        BasicBlock splitBB = callBB.splitAtInstruction(call2, splitBBLabel, false);
        this.cfg.addBasicBlock(splitBB);
        for (Edge edge : this.cfg.getOutgoingEdges(callBB)) {
            this.cfg.addEdge(splitBB, (BasicBlock)edge.getDestination().getData(), edge.getType());
        }
        this.cfg.removeAllOutgoingEdgesForBB(callBB);
        SimpleCloneInfo hostCloneInfo = cloneHost ? this.cloneHostInstrs(this.cfg) : null;
        Operand operand = call2.getReceiver();
        Variable callReceiverVar = operand instanceof Variable ? (Variable)operand : hostScope.createTemporaryVariable();
        InlineCloneInfo ii = new InlineCloneInfo(call2, this.cfg, callReceiverVar, scope);
        CFG methodCFG = scope.getCFG();
        ArrayList<BasicBlock> methodBBs = new ArrayList<BasicBlock>();
        for (BasicBlock basicBlock : methodCFG.getBasicBlocks()) {
            methodBBs.add(basicBlock);
        }
        if (hostScope.getNearestMethod() == scope) {
            CFG selfClone = this.cloneSelf(ii);
            for (BasicBlock b3 : selfClone.getBasicBlocks()) {
                this.cfg.addBasicBlock(b3);
                for (Edge<BasicBlock> e : selfClone.getOutgoingEdges(b3)) {
                    this.cfg.addEdge(b3, e.getDestination().getData(), e.getType());
                }
            }
        } else {
            for (BasicBlock basicBlock : methodCFG.getBasicBlocks()) {
                if (basicBlock.isEntryBB() || basicBlock.isExitBB()) continue;
                this.cfg.addBasicBlock(basicBlock.cloneForInlining(ii));
            }
            for (BasicBlock basicBlock : methodCFG.getBasicBlocks()) {
                if (basicBlock.isEntryBB() || basicBlock.isExitBB()) continue;
                BasicBlock rx = ii.getRenamedBB(basicBlock);
                for (Edge<BasicBlock> e : methodCFG.getOutgoingEdges(basicBlock)) {
                    BasicBlock b4 = e.getDestination().getData();
                    if (b4.isExitBB()) continue;
                    this.cfg.addEdge(rx, ii.getRenamedBB(b4), e.getType());
                }
            }
        }
        assert (methodCFG.outDegree(methodCFG.getEntryBB()) == 2) : "Entry BB of inlinee method does not have outdegree 2: " + methodCFG.toStringGraph();
        for (BasicBlock basicBlock : methodCFG.getOutgoingDestinations(methodCFG.getEntryBB())) {
            if (basicBlock.isExitBB()) continue;
            BasicBlock dstBB = ii.getRenamedBB(basicBlock);
            if (operand != callReceiverVar) {
                dstBB.insertInstr(new CopyInstr(callReceiverVar, operand));
            }
            if (!ii.canMapArgsStatically()) {
                Array args2;
                Operand[] callArgs = call2.cloneCallArgs(hostCloneInfo);
                if (callArgs.length == 1 && callArgs[0] instanceof Splat) {
                    Operand args3 = callArgs[0];
                } else {
                    args2 = new Array(callArgs);
                }
                dstBB.insertInstr(new CopyInstr((Variable)ii.getArgs(), args2));
            }
            this.cfg.addEdge(callBB, dstBB, (Object)CFG.EdgeType.FALL_THROUGH);
        }
        for (Edge edge : methodCFG.getIncomingEdges(methodCFG.getExitBB())) {
            BasicBlock source2 = (BasicBlock)edge.getSource().getData();
            if (source2.isEntryBB()) continue;
            BasicBlock clonedSource = ii.getRenamedBB(source2);
            if (edge.getType() == CFG.EdgeType.EXCEPTION) {
                BasicBlock rescuerOfSplitBB = this.cfg.getRescuerBBFor(splitBB);
                if (rescuerOfSplitBB != null) {
                    this.cfg.addEdge(clonedSource, rescuerOfSplitBB, (Object)CFG.EdgeType.EXCEPTION);
                    continue;
                }
                this.cfg.addEdge(clonedSource, this.cfg.getExitBB(), (Object)CFG.EdgeType.EXIT);
                continue;
            }
            this.cfg.addEdge(clonedSource, splitBB, edge.getType());
        }
        BasicBlock callBBrescuer = this.cfg.getRescuerBBFor(callBB);
        if (callBBrescuer != null) {
            this.cfg.setRescuerBB(splitBB, callBBrescuer);
        }
        for (BasicBlock x : methodBBs) {
            if (x.isEntryBB() || x.isExitBB()) continue;
            BasicBlock xRenamed = ii.getRenamedBB(x);
            BasicBlock xProtector = methodCFG.getRescuerBBFor(x);
            if (xProtector != null) {
                this.cfg.setRescuerBB(xRenamed, ii.getRenamedBB(xProtector));
                continue;
            }
            if (callBBrescuer == null) continue;
            this.cfg.setRescuerBB(xRenamed, callBBrescuer);
        }
        Label label2 = hostScope.getNewLabel();
        callBB.addInstr(new ModuleVersionGuardInstr(implClass, classToken, call2.getReceiver(), label2));
        BasicBlock failurePathBB = new BasicBlock(this.cfg, label2);
        this.cfg.addBasicBlock(failurePathBB);
        failurePathBB.addInstr(call2);
        failurePathBB.addInstr(new JumpInstr(hostCloneInfo == null ? splitBBLabel : hostCloneInfo.getRenamedLabel(splitBBLabel)));
        call2.blockInlining();
        this.cfg.addEdge(callBB, failurePathBB, (Object)CFG.EdgeType.REGULAR);
        this.cfg.addEdge(failurePathBB, splitBB, (Object)CFG.EdgeType.REGULAR);
        Operand closureArg = call2.getClosureArg(null);
        List yieldSites = ii.getYieldSites();
        if (closureArg != null && !yieldSites.isEmpty()) {
            if (yieldSites.size() > 1) {
                throw new RuntimeException("Encountered " + yieldSites.size() + " yield sites.  Convert the yield to a call by converting the closure into a dummy method (have to convert all frame vars to call arguments, or at least convert the frame into a call arg");
            }
            if (!(closureArg instanceof WrappedIRClosure)) {
                throw new RuntimeException("Encountered a dynamic closure arg.  Cannot inline it here!  Convert the yield to a call by converting the closure into a dummy method (have to convert all frame vars to call arguments, or at least convert the frame into a call arg");
            }
            Tuple t = (Tuple)yieldSites.get(0);
            this.inlineClosureAtYieldSite(ii, ((WrappedIRClosure)closureArg).getClosure(), (BasicBlock)t.a, (YieldInstr)t.b);
        }
        this.cfg.collapseStraightLineBBs();
    }

    private void inlineClosureAtYieldSite(InlineCloneInfo ii, IRClosure cl, BasicBlock yieldBB, YieldInstr yield2) {
        BasicBlock splitBB = yieldBB.splitAtInstruction(yield2, this.cfg.getScope().getNewLabel(), false);
        this.cfg.addBasicBlock(splitBB);
        for (Edge<BasicBlock> e : this.cfg.getOutgoingEdges(yieldBB)) {
            this.cfg.addEdge(splitBB, e.getDestination().getData(), e.getType());
        }
        this.cfg.removeAllOutgoingEdgesForBB(yieldBB);
        ii = ii.cloneForInliningClosure(cl);
        ii.setupYieldArgsAndYieldResult(yield2, yieldBB, cl.getBlockBody().getSignature().arityValue());
        CFG closureCFG = cl.getCFG();
        for (BasicBlock basicBlock : closureCFG.getBasicBlocks()) {
            if (basicBlock.isEntryBB() || basicBlock.isExitBB()) continue;
            this.cfg.addBasicBlock(basicBlock.cloneForInlining(ii));
        }
        for (BasicBlock basicBlock : closureCFG.getBasicBlocks()) {
            if (basicBlock.isEntryBB() || basicBlock.isExitBB()) continue;
            BasicBlock bClone = ii.getRenamedBB(basicBlock);
            for (Edge<BasicBlock> e : closureCFG.getOutgoingEdges(basicBlock)) {
                BasicBlock edst = e.getDestination().getData();
                if (edst.isExitBB()) continue;
                this.cfg.addEdge(bClone, ii.getRenamedBB(edst), e.getType());
            }
        }
        for (Edge edge : closureCFG.getOutgoingEdges(closureCFG.getEntryBB())) {
            BasicBlock destination = (BasicBlock)edge.getDestination().getData();
            if (destination.isExitBB()) continue;
            this.cfg.addEdge(yieldBB, ii.getRenamedBB(destination), (Object)CFG.EdgeType.FALL_THROUGH);
        }
        for (Edge edge : closureCFG.getIncomingEdges(closureCFG.getExitBB())) {
            BasicBlock source2 = (BasicBlock)edge.getSource().getData();
            if (source2.isEntryBB()) continue;
            BasicBlock clonedSource = ii.getRenamedBB(source2);
            if (edge.getType() == CFG.EdgeType.EXCEPTION) {
                BasicBlock rescuerOfSplitBB = this.cfg.getRescuerBBFor(splitBB);
                if (rescuerOfSplitBB != null) {
                    this.cfg.addEdge(clonedSource, rescuerOfSplitBB, (Object)CFG.EdgeType.EXCEPTION);
                    continue;
                }
                this.cfg.addEdge(clonedSource, this.cfg.getExitBB(), (Object)CFG.EdgeType.EXIT);
                continue;
            }
            this.cfg.addEdge(clonedSource, splitBB, edge.getType());
        }
        BasicBlock yieldBBrescuer = this.cfg.getRescuerBBFor(yieldBB);
        if (yieldBBrescuer != null) {
            this.cfg.setRescuerBB(splitBB, yieldBBrescuer);
        }
        for (BasicBlock cb : closureCFG.getBasicBlocks()) {
            if (cb.isEntryBB() || cb.isExitBB()) continue;
            BasicBlock cbProtector = ii.getRenamedBB(closureCFG.getRescuerBBFor(cb));
            if (cbProtector != null) {
                this.cfg.setRescuerBB(cb, cbProtector);
                continue;
            }
            if (yieldBBrescuer == null) continue;
            this.cfg.setRescuerBB(cb, yieldBBrescuer);
        }
    }
}

