/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import jnr.posix.JavaSecuredFile;
import org.jruby.Ruby;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.EmptyFileResource;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyNonExistentFile;
import org.jruby.util.JarResource;
import org.jruby.util.NullDeviceResource;
import org.jruby.util.RegularFileResource;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.URLResource;

public class JRubyFile
extends JavaSecuredFile {
    private static final long serialVersionUID = 435364547567567L;

    public static JRubyFile create(String cwd, String pathname2) {
        return JRubyFile.createNoUnicodeConversion(cwd, pathname2);
    }

    public static FileResource createResource(ThreadContext context, String pathname2) {
        return JRubyFile.createResource(context.runtime, pathname2);
    }

    public static FileResource createResourceAsFile(Ruby runtime, String pathname2) {
        return JRubyFile.createResource(runtime, runtime.getCurrentDirectory(), pathname2, true);
    }

    public static FileResource createResource(Ruby runtime, String pathname2) {
        return JRubyFile.createResource(runtime, runtime.getCurrentDirectory(), pathname2, false);
    }

    public static FileResource createResource(Ruby runtime, String cwd, String pathname2) {
        return JRubyFile.createResource(runtime, cwd, pathname2, false);
    }

    private static FileResource createResource(Ruby runtime, String cwd, String pathname2, boolean isFile) {
        EmptyFileResource emptyResource = EmptyFileResource.create(pathname2);
        if (emptyResource != null) {
            return emptyResource;
        }
        JarResource jarResource = JarResource.create(pathname2);
        if (jarResource != null) {
            return jarResource;
        }
        if (Platform.IS_WINDOWS && (pathname2.equalsIgnoreCase("nul") || pathname2.equalsIgnoreCase("nul:"))) {
            return new NullDeviceResource(runtime.getPosix());
        }
        if (pathname2.contains(":")) {
            if (pathname2.startsWith("classpath:")) {
                pathname2 = pathname2.replace("classpath:/", "uri:classloader:/");
            }
            if (pathname2.startsWith("uri:")) {
                return URLResource.create(runtime, pathname2, isFile);
            }
            if (pathname2.startsWith("file:") && "".equals(pathname2 = pathname2.substring(5))) {
                return EmptyFileResource.create(pathname2);
            }
        }
        JRubyFile f = JRubyFile.create(cwd, pathname2);
        if (cwd != null && cwd.startsWith("uri:")) {
            return JRubyFile.createResource(runtime, null, f.getPath());
        }
        return new RegularFileResource(runtime.getPosix(), f);
    }

    public static String normalizeSeps(String path2) {
        if (Platform.IS_WINDOWS) {
            return path2.replace(File.separatorChar, '/');
        }
        return path2;
    }

    private static JRubyFile createNoUnicodeConversion(String cwd, String pathname2) {
        if (pathname2 == null || pathname2.equals("") || Ruby.isSecurityRestricted()) {
            return JRubyNonExistentFile.NOT_EXIST;
        }
        if (pathname2.startsWith("file:")) {
            pathname2 = pathname2.substring(5);
        }
        if (pathname2.startsWith("uri:")) {
            return new JRubyFile(pathname2);
        }
        JavaSecuredFile internal = new JavaSecuredFile(pathname2);
        if (cwd != null && cwd.startsWith("uri:") && !pathname2.startsWith("uri:") && !pathname2.contains("!/") && !internal.isAbsolute()) {
            return new JRubyFile(cwd + "/" + pathname2);
        }
        if (!internal.isAbsolute() && !(internal = new JavaSecuredFile(cwd, pathname2)).isAbsolute()) {
            throw new IllegalArgumentException("Neither current working directory (" + cwd + ") nor pathname (" + pathname2 + ") led to an absolute path");
        }
        return new JRubyFile(internal);
    }

    public static String getFileProperty(String property) {
        return JRubyFile.normalizeSeps(SafePropertyAccessor.getProperty(property, "/"));
    }

    private JRubyFile(File file2) {
        this(file2.getAbsolutePath());
    }

    protected JRubyFile(String filename2) {
        super(filename2);
    }

    @Override
    public String getAbsolutePath() {
        if (super.getPath().startsWith("uri:")) {
            return super.getPath().replaceFirst(":/([^/])", "://$1");
        }
        return JRubyFile.normalizeSeps(new File(super.getPath()).getAbsolutePath());
    }

    @Override
    public String getCanonicalPath() throws IOException {
        try {
            return JRubyFile.normalizeSeps(super.getCanonicalPath());
        }
        catch (IOException e) {
            throw (IOException)new IOException("Unable to canonicalize path: " + this.getAbsolutePath()).initCause(e);
        }
    }

    @Override
    public String getPath() {
        return JRubyFile.normalizeSeps(super.getPath());
    }

    @Override
    public String toString() {
        return JRubyFile.normalizeSeps(super.toString());
    }

    @Override
    public File getAbsoluteFile() {
        return new JRubyFile(this.getAbsolutePath());
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return new JRubyFile(this.getCanonicalPath());
    }

    @Override
    public String getParent() {
        String par = super.getParent();
        if (par != null) {
            par = JRubyFile.normalizeSeps(par);
        }
        return par;
    }

    @Override
    public File getParentFile() {
        String par = this.getParent();
        if (par == null) {
            return this;
        }
        return new JRubyFile(par);
    }

    public static File[] listRoots() {
        File[] roots = File.listRoots();
        File[] smartRoots = new JRubyFile[roots.length];
        int j = roots.length;
        for (int i2 = 0; i2 < j; ++i2) {
            smartRoots[i2] = new JRubyFile(roots[i2].getPath());
        }
        return smartRoots;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        return new JRubyFile(File.createTempFile(prefix, suffix, directory));
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return new JRubyFile(File.createTempFile(prefix, suffix));
    }

    @Override
    public String[] list(FilenameFilter filter) {
        String[] files = super.list(filter);
        if (files == null) {
            return null;
        }
        String[] smartFiles = new String[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = JRubyFile.normalizeSeps(files[i2]);
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles() {
        File[] files = super.listFiles();
        if (files == null) {
            return null;
        }
        File[] smartFiles = new JRubyFile[files.length];
        int j = files.length;
        for (int i2 = 0; i2 < j; ++i2) {
            smartFiles[i2] = JRubyFile.createNoUnicodeConversion(super.getAbsolutePath(), files[i2].getPath());
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        File[] smartFiles = new JRubyFile[files.length];
        int j = files.length;
        for (int i2 = 0; i2 < j; ++i2) {
            smartFiles[i2] = JRubyFile.createNoUnicodeConversion(super.getAbsolutePath(), files[i2].getPath());
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        File[] smartFiles = new JRubyFile[files.length];
        int j = files.length;
        for (int i2 = 0; i2 < j; ++i2) {
            smartFiles[i2] = JRubyFile.createNoUnicodeConversion(super.getAbsolutePath(), files[i2].getPath());
        }
        return smartFiles;
    }
}

