/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callsite;

import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public class SuperCallSite
extends CallSite {
    protected volatile SuperTuple cache = SuperTuple.NULL_CACHE;

    public SuperCallSite() {
        super("super", CallType.SUPER);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, long fixnum) {
        return this.call(context, caller, self2, (IRubyObject)RubyFixnum.newFixnum(context.runtime, fixnum));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, double flote) {
        return this.call(context, caller, self2, (IRubyObject)RubyFloat.newFloat(context.runtime, flote));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject ... args2) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, (RubyModule)selfType, name2, args2);
        }
        return this.cacheAndCall(caller, selfType, args2, context, self2, name2);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, (RubyModule)selfType, name2, args2, block);
        }
        return this.cacheAndCall(caller, selfType, block, args2, context, self2, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        return this.callBlock(context, caller, self2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self2, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject callVarargs(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject ... args2) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller, self2);
            }
            case 1: {
                return this.call(context, caller, self2, args2[0]);
            }
            case 2: {
                return this.call(context, caller, self2, args2[0], args2[1]);
            }
            case 3: {
                return this.call(context, caller, self2, args2[0], args2[1], args2[2]);
            }
        }
        return this.call(context, caller, self2, args2);
    }

    @Override
    public IRubyObject callVarargs(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.call(context, caller, self2, block);
            }
            case 1: {
                return this.call(context, caller, self2, args2[0], block);
            }
            case 2: {
                return this.call(context, caller, self2, args2[0], args2[1], block);
            }
            case 3: {
                return this.call(context, caller, self2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.call(context, caller, self2, args2, block);
    }

    @Override
    public IRubyObject callVarargsIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.callIter(context, caller, self2, block);
            }
            case 1: {
                return this.callIter(context, caller, self2, args2[0], block);
            }
            case 2: {
                return this.callIter(context, caller, self2, args2[0], args2[1], block);
            }
            case 3: {
                return this.callIter(context, caller, self2, args2[0], args2[1], args2[2], block);
            }
        }
        return this.callIter(context, caller, self2, args2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, selfType, name2);
        }
        return this.cacheAndCall(caller, selfType, context, self2, name2);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, (RubyModule)selfType, name2, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self2, name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, Block block) {
        return this.callBlock(context, caller, self2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, (RubyModule)selfType, name2, arg1);
        }
        return this.cacheAndCall(caller, selfType, context, self2, name2, arg1);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, (RubyModule)selfType, name2, arg1, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self2, name2, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, Block block) {
        return this.callBlock(context, caller, self2, arg1, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self2, arg1, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, (RubyModule)selfType, name2, arg1, arg2);
        }
        return this.cacheAndCall(caller, selfType, context, self2, name2, arg1, arg2);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, (RubyModule)selfType, name2, arg1, arg2, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self2, name2, arg1, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.callBlock(context, caller, self2, arg1, arg2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self2, arg1, arg2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, (RubyModule)selfType, name2, arg1, arg2, arg3);
        }
        return this.cacheAndCall(caller, selfType, context, self2, name2, arg1, arg2, arg3);
    }

    private IRubyObject callBlock(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfType = SuperCallSite.pollAndGetClass(context, self2, klazz, name2);
        SuperTuple myCache = this.cache;
        if (selfType != null && myCache.cacheOk(name2, selfType)) {
            return myCache.cache.method.call(context, self2, selfType, name2, arg1, arg2, arg3, block);
        }
        return this.cacheAndCall(caller, selfType, block, context, self2, name2, arg1, arg2, arg3);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.callBlock(context, caller, self2, arg1, arg2, arg3, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject callIter(ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            IRubyObject iRubyObject = this.callBlock(context, caller, self2, arg1, arg2, arg3, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, IRubyObject[] args2, ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method, args2, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, (RubyModule)selfType, name2, args2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, IRubyObject[] args2, ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method, args2);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, (RubyModule)selfType, name2, args2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, selfType, name2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, String name2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, (RubyModule)selfType, name2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method, arg2);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, (RubyModule)selfType, name2, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method, arg2, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, (RubyModule)selfType, name2, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method, arg1, arg2);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, (RubyModule)selfType, name2, arg1, arg2);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method, arg1, arg2, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, (RubyModule)selfType, name2, arg1, arg2, block);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method, arg1, arg2, arg3);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, (RubyModule)selfType, name2, arg1, arg2, arg3);
    }

    protected IRubyObject cacheAndCall(IRubyObject caller, RubyClass selfType, Block block, ThreadContext context, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        CacheEntry entry = selfType != null ? selfType.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method = entry.method;
        if (this.methodMissing(method, caller)) {
            return this.callMethodMissing(context, self2, name2, method, arg1, arg2, arg3, block);
        }
        this.cache = new SuperTuple(name2, entry);
        return method.call(context, self2, selfType, name2, arg1, arg2, arg3, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method, IRubyObject[] args2) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, args2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method, Block block) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method, IRubyObject arg2) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, arg2, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method, IRubyObject[] args2, Block block) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, args2, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method, IRubyObject arg0, Block block) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, arg0, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method, IRubyObject arg0, IRubyObject arg1) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, arg0, arg1, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, arg0, arg1, block);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method, IRubyObject arg0, IRubyObject arg1, IRubyObject arg3) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, arg0, arg1, arg3, Block.NULL_BLOCK);
    }

    protected IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, String name2, DynamicMethod method, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, this.callType, arg0, arg1, arg2, block);
    }

    protected boolean methodMissing(DynamicMethod method, IRubyObject caller) {
        return method.isUndefined();
    }

    protected static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self2, RubyModule frameClass, String frameName) {
        SuperCallSite.checkSuperDisabledOrOutOfMethod(context, frameClass, frameName);
        return Helpers.findImplementerIfNecessary(self2.getMetaClass(), frameClass).getSuperClass();
    }

    protected static void checkSuperDisabledOrOutOfMethod(ThreadContext context, RubyModule frameClass, String frameName) {
        if (frameClass == null) {
            if (frameName != null) {
                throw context.runtime.newNameError("superclass method '" + frameName + "' disabled", frameName);
            }
            throw context.runtime.newNoMethodError("super called outside of method", null, context.runtime.getNil());
        }
    }

    private static class SuperTuple {
        static final SuperTuple NULL_CACHE = new SuperTuple("", CacheEntry.NULL_CACHE);
        public final String name;
        public final CacheEntry cache;

        public SuperTuple(String name2, CacheEntry cache) {
            this.name = name2;
            this.cache = cache;
        }

        public boolean cacheOk(String name2, RubyClass klass) {
            return this.name.equals(name2) && this.cache.typeOk(klass);
        }
    }
}

