/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class IsolatedScriptingContainer
extends ScriptingContainer {
    private static final String JRUBY_HOME = "/META-INF/jruby.home";

    public IsolatedScriptingContainer() {
        this(LocalContextScope.SINGLETON);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, true);
    }

    public IsolatedScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT);
    }

    public IsolatedScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.SINGLETON, behavior);
    }

    public IsolatedScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy) {
        super(scope, behavior, lazy);
        this.setLoadPaths(Arrays.asList("uri:classloader:"));
        this.setEnvironment(null);
    }

    @Override
    public void setEnvironment(Map environment) {
        if (!(environment != null && environment.containsKey("GEM_PATH") && environment.containsKey("GEM_HOME") && environment.containsKey("JARS_HOME"))) {
            HashMap<String, String> env;
            HashMap<String, String> hashMap = env = environment == null ? new HashMap<String, String>() : new HashMap(environment);
            if (!env.containsKey("GEM_PATH")) {
                env.put("GEM_PATH", "uri:classloader://");
            }
            if (!env.containsKey("GEM_HOME")) {
                env.put("GEM_HOME", "uri:classloader://META-INF/jruby.home/lib/ruby/gems/shared");
            }
            if (!env.containsKey("JARS_HOME")) {
                env.put("JARS_HOME", "uri:classloader://jars");
            }
            super.setEnvironment(env);
        } else {
            super.setEnvironment(environment);
        }
    }

    private Bundle toBundle(String symbolicName) {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Bundle bundle = null;
        for (Bundle b2 : context.getBundles()) {
            if (!b2.getSymbolicName().equals(symbolicName)) continue;
            bundle = b2;
            break;
        }
        if (bundle == null) {
            throw new RuntimeException("unknown bundle: " + symbolicName);
        }
        return bundle;
    }

    private String createUri(Bundle cl, String ref) {
        URL url = cl.getResource(ref);
        if (url == null && ref.startsWith("/")) {
            url = cl.getResource(ref.substring(1));
        }
        if (url == null) {
            throw new RuntimeException("reference " + ref + " not found on classloader " + cl);
        }
        System.err.println("=---" + url.toString().replaceFirst(ref + "$", ""));
        return "uri:" + url.toString().replaceFirst(ref + "$", "");
    }

    public void addBundleToLoadPath(Bundle bundle) {
        this.addLoadPath(this.createUri(bundle, "/.jrubydir"));
    }

    public void addBundleToLoadPath(String symbolicName) {
        this.addBundleToLoadPath(this.toBundle(symbolicName));
    }

    public void addBundleToGemPath(Bundle bundle) {
        this.addGemPath(this.createUri(bundle, "/specifications/.jrubydir"));
    }

    public void addBundleToGemPath(String symbolicName) {
        this.addBundleToGemPath(this.toBundle(symbolicName));
    }
}

