/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;

public class Symbol
extends ImmutableLiteral {
    public static final Symbol KW_REST_ARG_DUMMY = new Symbol("", ASCIIEncoding.INSTANCE);
    private final String name;
    private final Encoding encoding;

    public Symbol(String name2, Encoding encoding2) {
        super(OperandType.SYMBOL);
        this.name = name2;
        this.encoding = encoding2;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return RubySymbol.newSymbol(context.runtime, this.getName(), this.encoding);
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return ":'" + this.getName() + "'";
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getName());
        e.encode(this.getEncoding());
    }

    public static Symbol decode(IRReaderDecoder d) {
        return new Symbol(d.decodeString(), d.decodeEncoding());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Symbol(this);
    }
}

