/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;

public class SearchConstInstr
extends ResultBaseInstr
implements FixedArityInstr {
    private final String constName;
    private final boolean noPrivateConsts;
    private volatile transient ConstantCache cache;

    public SearchConstInstr(Variable result2, String constName, Operand startingScope, boolean noPrivateConsts) {
        super(Operation.SEARCH_CONST, result2, new Operand[]{startingScope});
        assert (result2 != null) : "SearchConstInstr result is null";
        this.constName = constName;
        this.noPrivateConsts = noPrivateConsts;
    }

    public Operand getStartingScope() {
        return this.operands[0];
    }

    public String getConstName() {
        return this.constName;
    }

    public boolean isNoPrivateConsts() {
        return this.noPrivateConsts;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new SearchConstInstr(ii.getRenamedVariable(this.result), this.constName, this.getStartingScope().cloneForInlining(ii), this.noPrivateConsts);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getConstName());
        e.encode(this.getStartingScope());
        e.encode(this.isNoPrivateConsts());
    }

    public static SearchConstInstr decode(IRReaderDecoder d) {
        return new SearchConstInstr(d.decodeVariable(), d.decodeString(), d.decodeOperand(), d.decodeBoolean());
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.constName, "no_priv: " + this.noPrivateConsts};
    }

    public ConstantCache getConstantCache() {
        return this.cache;
    }

    public Object cache(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Ruby runtime = context.getRuntime();
        RubyClass object = runtime.getObject();
        StaticScope staticScope = (StaticScope)this.getStartingScope().retrieve(context, self2, currScope, currDynScope, temp);
        IRubyObject constant = staticScope == null ? object.getConstant(this.constName) : staticScope.getConstantInner(this.constName);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = this.noPrivateConsts ? module.getConstantFromNoConstMissing(this.constName, false) : module.getConstantNoConstMissing(this.constName);
        }
        if (constant == null) {
            constant = module.callMethod(context, "const_missing", (IRubyObject)runtime.fastNewSymbol(this.constName));
        } else {
            Invalidator invalidator = runtime.getConstantInvalidator(this.constName);
            this.cache = new ConstantCache(constant, invalidator.getData(), invalidator);
        }
        return constant;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        ConstantCache cache = this.cache;
        if (!ConstantCache.isCached(cache)) {
            return this.cache(context, currScope, currDynScope, self2, temp);
        }
        return cache.value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SearchConstInstr(this);
    }
}

