/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyFile;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.NullChannel;
import org.jruby.util.io.PipeException;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@Deprecated
public class ChannelDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger("ChannelDescriptor");
    private static final boolean DEBUG = false;
    private Channel channel;
    private int internalFileno;
    private FileDescriptor fileDescriptor;
    private ModeFlags originalModes;
    private AtomicInteger refCounter;
    private InputStream baseInputStream;
    private boolean canBeSeekable = true;
    private boolean isInAppendMode = false;
    private boolean readableChannel;
    private boolean writableChannel;
    private boolean seekableChannel;
    @Deprecated
    private static final AtomicInteger NEXT_FILENO = new AtomicInteger(0x3FFFFFFF);
    @Deprecated
    private static final Map<Integer, ChannelDescriptor> FILENO_MAP = Collections.synchronizedMap(new HashMap());

    private ChannelDescriptor(Channel channel, int fileno2, ModeFlags originalModes, FileDescriptor fileDescriptor, AtomicInteger refCounter, boolean canBeSeekable, boolean isInAppendMode) {
        this.refCounter = refCounter;
        this.channel = channel;
        this.internalFileno = fileno2;
        this.originalModes = originalModes;
        this.fileDescriptor = fileDescriptor;
        this.canBeSeekable = canBeSeekable;
        this.isInAppendMode = isInAppendMode;
        this.readableChannel = channel instanceof ReadableByteChannel;
        this.writableChannel = channel instanceof WritableByteChannel;
        this.seekableChannel = channel instanceof FileChannel;
        ChannelDescriptor.registerDescriptor(this);
    }

    private ChannelDescriptor(Channel channel, int fileno2, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(channel, fileno2, originalModes, fileDescriptor, new AtomicInteger(1), true, false);
    }

    public ChannelDescriptor(Channel channel, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(channel, ChannelDescriptor.getNewFileno(), originalModes, fileDescriptor, new AtomicInteger(1), true, false);
    }

    public ChannelDescriptor(Channel channel, ModeFlags originalModes, FileDescriptor fileDescriptor, boolean isInAppendMode) {
        this(channel, ChannelDescriptor.getNewFileno(), originalModes, fileDescriptor, new AtomicInteger(1), true, isInAppendMode);
    }

    public ChannelDescriptor(Channel channel, ModeFlags originalModes) {
        this(channel, ChannelDescriptor.getNewFileno(), originalModes, FilenoUtil.getDescriptorFromChannel(channel), new AtomicInteger(1), true, false);
    }

    public ChannelDescriptor(InputStream baseInputStream, ModeFlags originalModes, FileDescriptor fileDescriptor) {
        this(Channels.newChannel(baseInputStream), ChannelDescriptor.getNewFileno(), originalModes, fileDescriptor, new AtomicInteger(1), true, false);
        this.baseInputStream = baseInputStream;
    }

    public ChannelDescriptor(InputStream baseInputStream, ModeFlags originalModes) {
        this(Channels.newChannel(baseInputStream), ChannelDescriptor.getNewFileno(), originalModes, new FileDescriptor(), new AtomicInteger(1), true, false);
        this.baseInputStream = baseInputStream;
    }

    public ChannelDescriptor(Channel channel, FileDescriptor fileDescriptor) throws InvalidValueException {
        this(channel, ModeFlags.getModesFromChannel(channel), fileDescriptor);
    }

    @Deprecated
    public ChannelDescriptor(Channel channel, int fileno2, FileDescriptor fileDescriptor) throws InvalidValueException {
        this(channel, ModeFlags.getModesFromChannel(channel), fileDescriptor);
    }

    public ChannelDescriptor(Channel channel) throws InvalidValueException {
        this(channel, ModeFlags.getModesFromChannel(channel), FilenoUtil.getDescriptorFromChannel(channel));
    }

    public int getFileno() {
        return this.internalFileno;
    }

    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public Channel getChannel() {
        return this.channel;
    }

    InputStream getBaseInputStream() {
        return this.baseInputStream;
    }

    public boolean isSeekable() {
        return this.canBeSeekable && this.seekableChannel;
    }

    public void setCanBeSeekable(boolean canBeSeekable) {
        this.canBeSeekable = canBeSeekable;
    }

    public boolean isNull() {
        return this.channel instanceof NullChannel;
    }

    public boolean isWritable() {
        return this.writableChannel;
    }

    public boolean isReadable() {
        return this.readableChannel;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void checkOpen() throws BadDescriptorException {
        if (!this.isOpen()) {
            throw new BadDescriptorException();
        }
    }

    public ModeFlags getOriginalModes() {
        return this.originalModes;
    }

    public void checkNewModes(ModeFlags newModes) throws InvalidValueException {
        if (!newModes.isSubsetOf(this.originalModes)) {
            throw new InvalidValueException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup() {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            int newFileno = ChannelDescriptor.getNewFileno();
            return new ChannelDescriptor(this.channel, newFileno, this.originalModes, this.fileDescriptor, this.refCounter, this.canBeSeekable, this.isInAppendMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelDescriptor dup2(int fileno2) {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            return new ChannelDescriptor(this.channel, fileno2, this.originalModes, this.fileDescriptor, this.refCounter, this.canBeSeekable, this.isInAppendMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dup2Into(ChannelDescriptor other) throws BadDescriptorException, IOException {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            this.refCounter.incrementAndGet();
            other.close();
            other.channel = this.channel;
            other.originalModes = this.originalModes;
            other.fileDescriptor = this.fileDescriptor;
            other.refCounter = this.refCounter;
            other.canBeSeekable = this.canBeSeekable;
            other.readableChannel = this.readableChannel;
            other.writableChannel = this.writableChannel;
            other.seekableChannel = this.seekableChannel;
        }
    }

    public ChannelDescriptor reopen(Channel channel, ModeFlags modes) {
        return new ChannelDescriptor(channel, this.internalFileno, modes, this.fileDescriptor);
    }

    public ChannelDescriptor reopen(RandomAccessFile file2, ModeFlags modes) throws IOException {
        return new ChannelDescriptor((Channel)file2.getChannel(), this.internalFileno, modes, file2.getFD());
    }

    public long lseek(long offset2, int whence) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        if (this.seekableChannel) {
            this.checkOpen();
            FileChannel fileChannel = (FileChannel)this.channel;
            try {
                long pos2;
                switch (whence) {
                    case 0: {
                        pos2 = offset2;
                        fileChannel.position(pos2);
                        break;
                    }
                    case 1: {
                        pos2 = fileChannel.position() + offset2;
                        fileChannel.position(pos2);
                        break;
                    }
                    case 2: {
                        pos2 = fileChannel.size() + offset2;
                        fileChannel.position(pos2);
                        break;
                    }
                    default: {
                        throw new InvalidValueException();
                    }
                }
                return pos2;
            }
            catch (IllegalArgumentException e) {
                throw new InvalidValueException();
            }
            catch (IOException ioe) {
                if (ioe.getMessage().equals("Illegal seek")) {
                    throw new PipeException();
                }
                throw ioe;
            }
        }
        throw new PipeException();
    }

    public int read(int number, ByteList byteList) throws IOException, BadDescriptorException {
        this.checkOpen();
        byteList.ensure(byteList.length() + number);
        int bytesRead = this.read(ByteBuffer.wrap(byteList.getUnsafeBytes(), byteList.begin() + byteList.length(), number));
        if (bytesRead > 0) {
            byteList.length(byteList.length() + bytesRead);
        }
        return bytesRead;
    }

    public int read(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        if (!this.isReadable()) {
            throw new BadDescriptorException();
        }
        ReadableByteChannel readChannel = (ReadableByteChannel)this.channel;
        int bytesRead = 0;
        bytesRead = readChannel.read(buffer);
        return bytesRead;
    }

    public int internalWrite(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        if (!this.isWritable()) {
            throw new BadDescriptorException();
        }
        WritableByteChannel writeChannel = (WritableByteChannel)this.channel;
        if (this.isSeekable() && this.originalModes.isAppendable() && !this.isInAppendMode) {
            FileChannel fileChannel = (FileChannel)this.channel;
            fileChannel.position(fileChannel.size());
        }
        return writeChannel.write(buffer);
    }

    public int write(ByteBuffer buffer) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(buffer);
    }

    public int write(ByteList buf) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin(), buf.length()));
    }

    public int write(ByteList buf, int offset2, int len) throws IOException, BadDescriptorException {
        this.checkOpen();
        return this.internalWrite(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin() + offset2, len));
    }

    public int write(int c) throws IOException, BadDescriptorException {
        this.checkOpen();
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put((byte)c);
        buf.flip();
        return this.internalWrite(buf);
    }

    @Deprecated
    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags2) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        return ChannelDescriptor.open(cwd, path2, flags2, 0, POSIXFactory.getPOSIX(), null);
    }

    @Deprecated
    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags2, ClassLoader classLoader) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        return ChannelDescriptor.open(cwd, path2, flags2, 0, POSIXFactory.getPOSIX(), classLoader);
    }

    @Deprecated
    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags2, int perm, POSIX posix) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        return ChannelDescriptor.open(cwd, path2, flags2, perm, posix, null);
    }

    @Deprecated
    public static ChannelDescriptor open(String cwd, String path2, ModeFlags flags2, int perm, POSIX posix, ClassLoader classLoader) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException {
        try {
            if (path2.equals("/dev/null") || path2.equalsIgnoreCase("nul:") || path2.equalsIgnoreCase("nul")) {
                NullChannel nullChannel = new NullChannel();
                return new ChannelDescriptor((Channel)nullChannel, flags2);
            }
            if (path2.startsWith("classpath:/") && classLoader != null) {
                path2 = path2.substring("classpath:/".length());
                InputStream is = classLoader.getResourceAsStream(path2);
                return new ChannelDescriptor((Channel)Channels.newChannel(is), flags2);
            }
            Channel ch = JRubyFile.createResource(posix, cwd, path2).openChannel(flags2, perm);
            return new ChannelDescriptor(ch, flags2);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw npe;
        }
    }

    public void close() throws BadDescriptorException, IOException {
        this.finish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(boolean close2) throws BadDescriptorException, IOException {
        AtomicInteger atomicInteger = this.refCounter;
        synchronized (atomicInteger) {
            int count2;
            if (this.refCounter.get() <= 0) {
                throw new BadDescriptorException();
            }
            if (!this.channel.isOpen()) {
                throw new BadDescriptorException();
            }
            if (close2 && (count2 = this.refCounter.decrementAndGet()) <= 0) {
                try {
                    this.channel.close();
                }
                finally {
                    ChannelDescriptor.unregisterDescriptor(this.internalFileno);
                }
            }
        }
    }

    @Deprecated
    public static int getNewFileno() {
        return NEXT_FILENO.getAndIncrement();
    }

    @Deprecated
    private static void registerDescriptor(ChannelDescriptor descriptor) {
        FILENO_MAP.put(descriptor.getFileno(), descriptor);
    }

    @Deprecated
    private static void unregisterDescriptor(int aFileno) {
        FILENO_MAP.remove(aFileno);
    }

    @Deprecated
    public static ChannelDescriptor getDescriptorByFileno(int aFileno) {
        return FILENO_MAP.get(aFileno);
    }

    @Deprecated
    public static FileDescriptor getDescriptorFromChannel(Channel channel) {
        return FilenoUtil.getDescriptorFromChannel(channel);
    }

    @Deprecated
    public static int getFilenoFromChannel(Channel channel) {
        return FilenoUtil.filenoFrom(channel);
    }
}

