/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.IntHash;
import org.joni.Matcher;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeSupport;
import org.jruby.util.CodeRangeable;
import org.jruby.util.Sprintf;
import sun.misc.Unsafe;

public final class StringSupport {
    public static final int CR_MASK = 48;
    public static final int CR_UNKNOWN = 0;
    public static final int CR_7BIT = 16;
    public static final int CR_VALID = 32;
    public static final int CR_BROKEN = 48;
    public static final Object UNSAFE = StringSupport.getUnsafe();
    private static final int OFFSET = UNSAFE != null ? ((Unsafe)UNSAFE).arrayBaseOffset(byte[].class) : 0;
    public static final int TRANS_SIZE = 256;
    private static final long NONASCII_MASK = -9187201950435737472L;
    private static final int LONG_SIZE = 8;
    private static final int LOWBITS = 7;

    private static Object getUnsafe() {
        try {
            Class<?> sunUnsafe = Class.forName("sun.misc.Unsafe");
            Field f = sunUnsafe.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return Unsafe.class.cast(f.get(sunUnsafe));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String codeRangeAsString(int codeRange) {
        switch (codeRange) {
            case 0: {
                return "unknown";
            }
            case 16: {
                return "7bit";
            }
            case 32: {
                return "valid";
            }
            case 48: {
                return "broken";
            }
        }
        return "???";
    }

    public static int encFastMBCLen(byte[] bytes2, int p2, int e, Encoding enc) {
        return enc.length(bytes2, p2, e);
    }

    public static int length(Encoding enc, byte[] bytes2, int p2, int end2) {
        int n = enc.length(bytes2, p2, end2);
        if (n > 0 && end2 - p2 >= n) {
            return n;
        }
        return end2 - p2 >= enc.minLength() ? enc.minLength() : end2 - p2;
    }

    public static int preciseLength(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (p2 >= end2) {
            return -2;
        }
        int n = enc.length(bytes2, p2, end2);
        if (n > end2 - p2) {
            return StringSupport.MBCLEN_NEEDMORE(n - (end2 - p2));
        }
        return n;
    }

    public static boolean MBCLEN_NEEDMORE_P(int r) {
        return r < -1;
    }

    public static int MBCLEN_NEEDMORE(int n) {
        return -1 - n;
    }

    public static boolean MBCLEN_INVALID_P(int r) {
        return r == -1;
    }

    public static int MBCLEN_CHARFOUND_LEN(int r) {
        return r;
    }

    public static boolean MBCLEN_CHARFOUND_P(int r) {
        return 0 < r;
    }

    public static int CONSTRUCT_MBCLEN_CHARFOUND(int n) {
        return n;
    }

    public static int searchNonAscii(byte[] bytes2, int p2, int end2) {
        while (p2 < end2) {
            if (!Encoding.isAscii(bytes2[p2])) {
                return p2;
            }
            ++p2;
        }
        return -1;
    }

    public static int searchNonAscii(ByteList bytes2) {
        return StringSupport.searchNonAscii(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static int codeRangeScan(Encoding enc, byte[] bytes2, int p2, int len) {
        if (enc == ASCIIEncoding.INSTANCE) {
            return StringSupport.searchNonAscii(bytes2, p2, p2 + len) != -1 ? 32 : 16;
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.codeRangeScanAsciiCompatible(enc, bytes2, p2, len);
        }
        return StringSupport.codeRangeScanNonAsciiCompatible(enc, bytes2, p2, len);
    }

    private static int codeRangeScanAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int len) {
        int end2 = p2 + len;
        if ((p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) == -1) {
            return 16;
        }
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl <= 0) {
                return 48;
            }
            if ((p2 += cl) >= end2 || (p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) != -1) continue;
            return 32;
        }
        return p2 > end2 ? 48 : 32;
    }

    private static int codeRangeScanNonAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int len) {
        int end2 = p2 + len;
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl <= 0) {
                return 48;
            }
            p2 += cl;
        }
        return p2 > end2 ? 48 : 32;
    }

    public static int codeRangeScan(Encoding enc, ByteList bytes2) {
        return StringSupport.codeRangeScan(enc, bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
    }

    public static long codeRangeScanRestartable(Encoding enc, byte[] bytes2, int s2, int end2, int cr) {
        int p2;
        if (cr == 48) {
            return StringSupport.pack(end2 - s2, cr);
        }
        if (enc == ASCIIEncoding.INSTANCE) {
            return StringSupport.pack(end2 - s2, StringSupport.searchNonAscii(bytes2, p2, end2) == -1 && cr != 32 ? 16 : 32);
        }
        if (enc.isAsciiCompatible()) {
            if ((p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) == -1) {
                return StringSupport.pack(end2 - s2, cr != 32 ? 16 : cr);
            }
            while (p2 < end2) {
                int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                if (cl <= 0) {
                    return StringSupport.pack(p2 - s2, cl == -1 ? 48 : 0);
                }
                if ((p2 += cl) >= end2 || (p2 = StringSupport.searchNonAscii(bytes2, p2, end2)) != -1) continue;
                return StringSupport.pack(end2 - s2, 32);
            }
        } else {
            int cl;
            for (p2 = s2; p2 < end2; p2 += cl) {
                cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                if (cl > 0) continue;
                return StringSupport.pack(p2 - s2, cl == -1 ? 48 : 0);
            }
        }
        return StringSupport.pack(p2 - s2, p2 > end2 ? 48 : 32);
    }

    private static int countUtf8LeadBytes(long d) {
        d |= d >>> 1 ^ 0xFFFFFFFFFFFFFFFFL;
        d >>>= 6;
        d &= 0x101010101010101L;
        d += d >>> 8;
        d += d >>> 16;
        d += d >>> 32;
        return (int)(d & 0xFL);
    }

    public static int utf8Length(byte[] bytes2, int p2, int end2) {
        int len = 0;
        if (UNSAFE != null && end2 - p2 > 16) {
            int ep = 0xFFFFFFF8 & p2 + 7;
            while (p2 < ep) {
                if ((bytes2[p2++] & 0xC0) == 128) continue;
                ++len;
            }
            Unsafe us = (Unsafe)UNSAFE;
            int eend = 0xFFFFFFF8 & end2;
            while (p2 < eend) {
                len += StringSupport.countUtf8LeadBytes(us.getLong(bytes2, OFFSET + p2));
                p2 += 8;
            }
        }
        while (p2 < end2) {
            if ((bytes2[p2++] & 0xC0) == 128) continue;
            ++len;
        }
        return len;
    }

    public static int utf8Length(ByteList bytes2) {
        return StringSupport.utf8Length(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static int strLength(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (enc.isFixedWidth()) {
            return (end2 - p2 + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            int c = 0;
            while (p2 < end2) {
                if (Encoding.isAscii(bytes2[p2])) {
                    int q = StringSupport.searchNonAscii(bytes2, p2, end2);
                    if (q == -1) {
                        return c + (end2 - p2);
                    }
                    c += q - p2;
                    p2 = q;
                }
                p2 += StringSupport.length(enc, bytes2, p2, end2);
                ++c;
            }
            return c;
        }
        int c = 0;
        while (end2 > p2) {
            p2 += StringSupport.length(enc, bytes2, p2, end2);
            ++c;
        }
        return c;
    }

    public static int strLength(ByteList bytes2) {
        return StringSupport.strLength(bytes2.getEncoding(), bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static long strLengthWithCodeRange(Encoding enc, byte[] bytes2, int p2, int end2) {
        if (enc.isFixedWidth()) {
            return (end2 - p2 + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.strLengthWithCodeRangeAsciiCompatible(enc, bytes2, p2, end2);
        }
        return StringSupport.strLengthWithCodeRangeNonAsciiCompatible(enc, bytes2, p2, end2);
    }

    private static long strLengthWithCodeRangeAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2) {
        int cr = 0;
        int c = 0;
        while (p2 < end2) {
            int cl;
            if (Encoding.isAscii(bytes2[p2])) {
                int q = StringSupport.searchNonAscii(bytes2, p2, end2);
                if (q == -1) {
                    return StringSupport.pack(c + (end2 - p2), cr == 0 ? 16 : cr);
                }
                c += q - p2;
                p2 = q;
            }
            if ((cl = StringSupport.preciseLength(enc, bytes2, p2, end2)) > 0) {
                cr |= 0x20;
                p2 += cl;
            } else {
                cr = 48;
                ++p2;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 16 : cr);
    }

    private static long strLengthWithCodeRangeNonAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2) {
        int cr = 0;
        int c = 0;
        c = 0;
        while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl > 0) {
                cr |= 0x20;
                p2 += cl;
            } else {
                cr = 48;
                ++p2;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 16 : cr);
    }

    public static long strLengthWithCodeRange(ByteList bytes2) {
        return StringSupport.strLengthWithCodeRange(bytes2.getEncoding(), bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    public static long strLengthWithCodeRange(ByteList bytes2, Encoding enc) {
        return StringSupport.strLengthWithCodeRange(enc, bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize());
    }

    static long pack(int result2, int arg2) {
        return (long)arg2 << 31 | (long)result2;
    }

    public static int unpackResult(long len) {
        return (int)len & Integer.MAX_VALUE;
    }

    public static int unpackArg(long cr) {
        return (int)(cr >>> 31);
    }

    public static int codePoint(Ruby runtime, Encoding enc, byte[] bytes2, int p2, int end2) {
        if (p2 >= end2) {
            throw runtime.newArgumentError("empty string");
        }
        int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
        if (cl <= 0) {
            throw runtime.newArgumentError("invalid byte sequence in " + enc);
        }
        return enc.mbcToCode(bytes2, p2, end2);
    }

    public static int codeLength(Ruby runtime, Encoding enc, int c) {
        int n = enc.codeToMbcLength(c);
        if (n == 0) {
            throw runtime.newRangeError("invalid codepoint " + String.format("0x%x in ", c) + enc.getName());
        }
        return n;
    }

    public static long getAscii(Encoding enc, byte[] bytes2, int p2, int end2) {
        return StringSupport.getAscii(enc, bytes2, p2, end2, 0);
    }

    public static long getAscii(Encoding enc, byte[] bytes2, int p2, int end2, int len) {
        if (p2 >= end2) {
            return StringSupport.pack(-1, len);
        }
        if (enc.isAsciiCompatible()) {
            int c = bytes2[p2] & 0xFF;
            if (!Encoding.isAscii(c)) {
                return StringSupport.pack(-1, len);
            }
            return StringSupport.pack(c, len == 0 ? 0 : 1);
        }
        int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
        if (cl <= 0) {
            return StringSupport.pack(-1, len);
        }
        int c = enc.mbcToCode(bytes2, p2, end2);
        if (!Encoding.isAscii(c)) {
            return StringSupport.pack(-1, len);
        }
        return StringSupport.pack(c, len == 0 ? 0 : cl);
    }

    public static int preciseCodePoint(Encoding enc, byte[] bytes2, int p2, int end2) {
        int l = StringSupport.preciseLength(enc, bytes2, p2, end2);
        if (l > 0) {
            return enc.mbcToCode(bytes2, p2, end2);
        }
        return -1;
    }

    public static int utf8Nth(byte[] bytes2, int p2, int e, int nth) {
        while (p2 < e) {
            if ((bytes2[p2] & 0xC0) != 128) {
                if (nth == 0) break;
                --nth;
            }
            ++p2;
        }
        return p2;
    }

    public static int nth(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        p2 = enc.isSingleByte() ? (p2 += n) : (enc.isFixedWidth() ? (p2 += n * enc.maxLength()) : (enc.isAsciiCompatible() ? StringSupport.nthAsciiCompatible(enc, bytes2, p2, end2, n) : StringSupport.nthNonAsciiCompatible(enc, bytes2, p2, end2, n)));
        return p2 > end2 ? end2 : p2;
    }

    private static int nthAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        while (p2 < end2 && n > 0) {
            int end22 = p2 + n;
            if (end2 < end22) {
                return end2;
            }
            if (Encoding.isAscii(bytes2[p2])) {
                int p22 = StringSupport.searchNonAscii(bytes2, p2, end22);
                if (p22 == -1) {
                    return end22;
                }
                n -= p22 - p2;
                p2 = p22;
            }
            int cl = StringSupport.length(enc, bytes2, p2, end2);
            p2 += cl;
            --n;
        }
        return n != 0 ? end2 : p2;
    }

    private static int nthNonAsciiCompatible(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        while (p2 < end2 && n-- != 0) {
            p2 += StringSupport.length(enc, bytes2, p2, end2);
        }
        return p2;
    }

    public static int utf8Offset(byte[] bytes2, int p2, int end2, int n) {
        int pp = StringSupport.utf8Nth(bytes2, p2, end2, n);
        return pp == -1 ? end2 - p2 : pp - p2;
    }

    public static int offset(Encoding enc, byte[] bytes2, int p2, int end2, int n) {
        int pp = StringSupport.nth(enc, bytes2, p2, end2, n);
        return pp == -1 ? end2 - p2 : pp - p2;
    }

    public static int offset(RubyString str, int pos2) {
        ByteList value2 = str.getByteList();
        return StringSupport.offset(str.getEncoding(), value2.getUnsafeBytes(), value2.getBegin(), value2.getBegin() + value2.getRealSize(), pos2);
    }

    public static int toLower(Encoding enc, int c) {
        return Encoding.isAscii(c) ? AsciiTables.ToLowerCaseTable[c] : c;
    }

    public static int toUpper(Encoding enc, int c) {
        return Encoding.isAscii(c) ? AsciiTables.ToUpperCaseTable[c] : c;
    }

    public static int caseCmp(byte[] bytes1, int p1, byte[] bytes2, int p2, int len) {
        int i2 = -1;
        while (++i2 < len && bytes1[p1 + i2] == bytes2[p2 + i2]) {
        }
        if (i2 < len) {
            return (bytes1[p1 + i2] & 0xFF) > (bytes2[p2 + i2] & 0xFF) ? 1 : -1;
        }
        return 0;
    }

    public static int scanHex(byte[] bytes2, int p2, int len) {
        return StringSupport.scanHex(bytes2, p2, len, ASCIIEncoding.INSTANCE);
    }

    public static int scanHex(byte[] bytes2, int p2, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isXDigit(c = bytes2[p2++] & 0xFF)) {
            v = (v << 4) + enc.xdigitVal(c);
        }
        return v;
    }

    public static int hexLength(byte[] bytes2, int p2, int len) {
        return StringSupport.hexLength(bytes2, p2, len, ASCIIEncoding.INSTANCE);
    }

    public static int hexLength(byte[] bytes2, int p2, int len, Encoding enc) {
        int hlen = 0;
        while (len-- > 0 && enc.isXDigit(bytes2[p2++] & 0xFF)) {
            ++hlen;
        }
        return hlen;
    }

    public static int scanOct(byte[] bytes2, int p2, int len) {
        return StringSupport.scanOct(bytes2, p2, len, ASCIIEncoding.INSTANCE);
    }

    public static int scanOct(byte[] bytes2, int p2, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isDigit(c = bytes2[p2++] & 0xFF) && c < 56) {
            v = (v << 3) + Encoding.digitVal(c);
        }
        return v;
    }

    public static int octLength(byte[] bytes2, int p2, int len) {
        return StringSupport.octLength(bytes2, p2, len, ASCIIEncoding.INSTANCE);
    }

    public static int octLength(byte[] bytes2, int p2, int len, Encoding enc) {
        int c;
        int olen = 0;
        while (len-- > 0 && enc.isDigit(c = bytes2[p2++] & 0xFF) && c < 56) {
            ++olen;
        }
        return olen;
    }

    public static final void checkStringSafety(Ruby runtime, IRubyObject value2) {
        RubyString s2 = value2.asString();
        ByteList bl = s2.getByteList();
        byte[] array = bl.getUnsafeBytes();
        int end2 = bl.length();
        for (int i2 = bl.begin(); i2 < end2; ++i2) {
            if (array[i2] != 0) continue;
            throw runtime.newSecurityError("string contains null byte");
        }
    }

    public static boolean isUnicode(Encoding enc) {
        byte[] name2 = enc.getName();
        return name2.length > 4 && name2[0] == 85 && name2[1] == 84 && name2[2] == 70 && name2[4] != 55;
    }

    public static String escapedCharFormat(int c, boolean isUnicode) {
        String format = isUnicode ? (c < 127 && Encoding.isAscii(c) && ASCIIEncoding.INSTANCE.isPrint(c) ? "%c" : (c < 65536 ? "\\u%04X" : "\\u{%X}")) : (c < 256 ? "\\x%02X" : "\\x{%X}");
        return format;
    }

    public static boolean isIncompleteChar(int b2) {
        return b2 < -1;
    }

    public static int bytesToFixBrokenTrailingCharacter(ByteList val, int usingLength) {
        return StringSupport.bytesToFixBrokenTrailingCharacter(val.getUnsafeBytes(), val.getBegin(), val.getRealSize(), val.getEncoding(), usingLength);
    }

    public static int bytesToFixBrokenTrailingCharacter(byte[] bytes2, int begin2, int byteSize, Encoding encoding2, int usingLength) {
        if (byteSize > 0) {
            int charHead = encoding2.leftAdjustCharHead(bytes2, begin2, begin2 + usingLength - 1, begin2 + usingLength);
            byte byteHead = (byte)(bytes2[begin2 + (charHead -= begin2)] & 0xFF);
            int extra = encoding2.length(byteHead);
            return extra -= usingLength - charHead;
        }
        return 0;
    }

    public static int memchr(byte[] ptr, int start2, int find2, int len) {
        for (int i2 = start2; i2 < start2 + len; ++i2) {
            if (ptr[i2] != find2) continue;
            return i2;
        }
        return -1;
    }

    public static RubyString checkEmbeddedNulls(Ruby runtime, IRubyObject ptr) {
        RubyString str = ptr.convertToString();
        ByteList strByteList = str.getByteList();
        byte[] sBytes = strByteList.unsafeBytes();
        int s2 = strByteList.begin();
        int len = strByteList.length();
        Encoding enc = str.getEncoding();
        int minlen = enc.minLength();
        if (minlen > 1) {
            if (StringSupport.strNullChar(sBytes, s2, len, minlen, enc) != -1) {
                throw runtime.newArgumentError("string contains null char");
            }
            return StringSupport.strFillTerm(str, sBytes, s2, len, minlen, minlen);
        }
        if (StringSupport.memchr(sBytes, s2, 0, len) != -1) {
            throw runtime.newArgumentError("string contains null byte");
        }
        return str;
    }

    public static int strNullChar(byte[] sBytes, int s2, int len, int minlen, Encoding enc) {
        int e = s2 + len;
        while (s2 + minlen <= e) {
            if (StringSupport.zeroFilled(sBytes, s2, minlen)) {
                return s2;
            }
            s2 += enc.length(sBytes, s2, e);
        }
        return -1;
    }

    public static boolean zeroFilled(byte[] sBytes, int s2, int n) {
        while (n > 0) {
            if (sBytes[s2++] != 0) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static RubyString strFillTerm(RubyString str, byte[] sBytes, int s2, int len, int oldtermlen, int termlen) {
        int capa = str.getByteList().getUnsafeBytes().length - str.getByteList().begin();
        if (capa < len + termlen) {
            str.modify(len + termlen);
        } else if (!str.independent()) {
            if (StringSupport.zeroFilled(sBytes, s2 + len, termlen)) {
                return str;
            }
            str.makeIndependent();
        }
        sBytes = str.getByteList().getUnsafeBytes();
        s2 = str.getByteList().begin();
        StringSupport.TERM_FILL(sBytes, s2 + len, termlen);
        return str;
    }

    public static void TERM_FILL(byte[] ptrBytes, int ptr, int termlen) {
        int term_fill_ptr = ptr;
        int term_fill_len = termlen;
        ptrBytes[term_fill_ptr] = 0;
        if (term_fill_len > 1) {
            Arrays.fill(ptrBytes, term_fill_ptr, term_fill_len, (byte)0);
        }
    }

    public static int positionEndForScan(ByteList value2, Matcher matcher, Encoding enc, int begin2, int range) {
        int end2 = matcher.getEnd();
        if (matcher.getBegin() == end2) {
            if (value2.getRealSize() > end2) {
                return end2 + enc.length(value2.getUnsafeBytes(), begin2 + end2, range);
            }
            return end2 + 1;
        }
        return end2;
    }

    public static ByteList dumpCommon(Ruby runtime, ByteList byteList) {
        ByteList buf = null;
        Encoding enc = byteList.getEncoding();
        int p2 = byteList.getBegin();
        int end2 = p2 + byteList.getRealSize();
        byte[] bytes2 = byteList.getUnsafeBytes();
        int len = 2;
        block4: while (p2 < end2) {
            int n;
            int c = bytes2[p2++] & 0xFF;
            switch (c) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 27: 
                case 34: 
                case 92: {
                    len += 2;
                    continue block4;
                }
                case 35: {
                    len += StringSupport.isEVStr(bytes2, p2, end2) ? 2 : 1;
                    continue block4;
                }
            }
            if (ASCIIEncoding.INSTANCE.isPrint(c)) {
                ++len;
                continue;
            }
            if (enc instanceof UTF8Encoding && (n = StringSupport.preciseLength(enc, bytes2, p2 - 1, end2) - 1) > 0) {
                if (buf == null) {
                    buf = new ByteList();
                }
                int cc = StringSupport.codePoint(runtime, enc, bytes2, p2 - 1, end2);
                Sprintf.sprintf(runtime, buf, (CharSequence)"%x", cc);
                len += buf.getRealSize() + 4;
                buf.setRealSize(0);
                p2 += n;
                continue;
            }
            len += 4;
        }
        if (!enc.isAsciiCompatible()) {
            len += ".force_encoding(\"".length() + enc.getName().length + "\")".length();
        }
        ByteList outBytes = new ByteList(len);
        byte[] out = outBytes.getUnsafeBytes();
        int q = 0;
        p2 = byteList.getBegin();
        end2 = p2 + byteList.getRealSize();
        out[q++] = 34;
        while (p2 < end2) {
            int n;
            int c;
            if ((c = bytes2[p2++] & 0xFF) == 34 || c == 92) {
                out[q++] = 92;
                out[q++] = (byte)c;
                continue;
            }
            if (c == 35) {
                if (StringSupport.isEVStr(bytes2, p2, end2)) {
                    out[q++] = 92;
                }
                out[q++] = 35;
                continue;
            }
            if (c == 10) {
                out[q++] = 92;
                out[q++] = 110;
                continue;
            }
            if (c == 13) {
                out[q++] = 92;
                out[q++] = 114;
                continue;
            }
            if (c == 9) {
                out[q++] = 92;
                out[q++] = 116;
                continue;
            }
            if (c == 12) {
                out[q++] = 92;
                out[q++] = 102;
                continue;
            }
            if (c == 11) {
                out[q++] = 92;
                out[q++] = 118;
                continue;
            }
            if (c == 8) {
                out[q++] = 92;
                out[q++] = 98;
                continue;
            }
            if (c == 7) {
                out[q++] = 92;
                out[q++] = 97;
                continue;
            }
            if (c == 27) {
                out[q++] = 92;
                out[q++] = 101;
                continue;
            }
            if (ASCIIEncoding.INSTANCE.isPrint(c)) {
                out[q++] = (byte)c;
                continue;
            }
            out[q++] = 92;
            if (enc instanceof UTF8Encoding && (n = StringSupport.preciseLength(enc, bytes2, p2 - 1, end2) - 1) > 0) {
                int cc = StringSupport.codePoint(runtime, enc, bytes2, p2 - 1, end2);
                p2 += n;
                outBytes.setRealSize(q);
                Sprintf.sprintf(runtime, outBytes, (CharSequence)"u{%x}", cc);
                q = outBytes.getRealSize();
                continue;
            }
            outBytes.setRealSize(q);
            Sprintf.sprintf(runtime, outBytes, (CharSequence)"x%02X", c);
            q = outBytes.getRealSize();
        }
        out[q++] = 34;
        outBytes.setRealSize(q);
        assert (out == outBytes.getUnsafeBytes());
        return outBytes;
    }

    public static boolean isEVStr(byte[] bytes2, int p2, int end2) {
        return p2 < end2 ? StringSupport.isEVStr(bytes2[p2] & 0xFF) : false;
    }

    public static boolean isEVStr(int c) {
        return c == 36 || c == 64 || c == 123;
    }

    public static int countCommon19(ByteList value2, Ruby runtime, boolean[] table, TrTables tables, Encoding enc) {
        int i2 = 0;
        byte[] bytes2 = value2.getUnsafeBytes();
        int p2 = value2.getBegin();
        int end2 = p2 + value2.getRealSize();
        while (p2 < end2) {
            int c;
            if (enc.isAsciiCompatible() && (c = bytes2[p2] & 0xFF) < 128) {
                if (table[c]) {
                    ++i2;
                }
                ++p2;
                continue;
            }
            c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2);
            int cl = StringSupport.codeLength(runtime, enc, c);
            if (StringSupport.trFind(c, table, tables)) {
                ++i2;
            }
            p2 += cl;
        }
        return i2;
    }

    public static int rindex(ByteList source2, int sourceLen, int subLen, int endPosition, CodeRangeable subStringCodeRangeable, Encoding enc) {
        if (subStringCodeRangeable.scanForCodeRange() == 48) {
            return -1;
        }
        if (sourceLen < subLen) {
            return -1;
        }
        if (sourceLen - endPosition < subLen) {
            endPosition = sourceLen - subLen;
        }
        if (sourceLen == 0) {
            return endPosition;
        }
        byte[] bytes2 = source2.getUnsafeBytes();
        int p2 = source2.getBegin();
        int end2 = p2 + source2.getRealSize();
        ByteList subString = subStringCodeRangeable.getByteList();
        byte[] sbytes = subString.bytes();
        subLen = subString.getRealSize();
        int s2 = StringSupport.nth(enc, bytes2, p2, end2, endPosition);
        while (s2 >= 0) {
            if (ByteList.memcmp(bytes2, s2, sbytes, 0, subLen) == 0) {
                return endPosition;
            }
            if (endPosition == 0) break;
            --endPosition;
            s2 = enc.prevCharHead(bytes2, p2, s2, end2);
        }
        return -1;
    }

    public static int strLengthFromRubyString(CodeRangeable string2, Encoding enc) {
        ByteList bytes2 = string2.getByteList();
        if (StringSupport.isSingleByteOptimizable(string2, enc)) {
            return bytes2.getRealSize();
        }
        return StringSupport.strLengthFromRubyStringFull(string2, bytes2, enc);
    }

    public static int strLengthFromRubyString(CodeRangeable string2) {
        ByteList bytes2 = string2.getByteList();
        return StringSupport.strLengthFromRubyStringFull(string2, bytes2, bytes2.getEncoding());
    }

    private static int strLengthFromRubyStringFull(CodeRangeable string2, ByteList bytes2, Encoding enc) {
        if (string2.isCodeRangeValid() && enc instanceof UTF8Encoding) {
            return StringSupport.utf8Length(bytes2);
        }
        long lencr = StringSupport.strLengthWithCodeRange(bytes2, enc);
        int cr = StringSupport.unpackArg(lencr);
        if (cr != 0) {
            string2.setCodeRange(cr);
        }
        return StringSupport.unpackResult(lencr);
    }

    public static TrTables trSetupTable(ByteList value2, Ruby runtime, boolean[] table, TrTables tables, boolean init, Encoding enc) {
        int c;
        TR tr = new TR(value2);
        boolean cflag = false;
        if (value2.getRealSize() > 1) {
            if (enc.isAsciiCompatible()) {
                if ((value2.getUnsafeBytes()[value2.getBegin()] & 0xFF) == 94) {
                    cflag = true;
                    ++tr.p;
                }
            } else {
                int l = StringSupport.preciseLength(enc, tr.buf, tr.p, tr.pend);
                if (enc.mbcToCode(tr.buf, tr.p, tr.pend) == 94) {
                    cflag = true;
                    tr.p += l;
                }
            }
        }
        if (init) {
            for (int i2 = 0; i2 < 256; ++i2) {
                table[i2] = true;
            }
            table[256] = cflag;
        } else if (table[256] && !cflag) {
            table[256] = false;
        }
        boolean[] buf = new boolean[256];
        for (int i3 = 0; i3 < 256; ++i3) {
            buf[i3] = cflag;
        }
        IntHash<IRubyObject> hash2 = null;
        IntHash phash = null;
        while ((c = StringSupport.trNext(tr, runtime, enc)) >= 0) {
            if (c < 256) {
                buf[c & 0xFF] = !cflag;
                continue;
            }
            if (hash2 == null) {
                hash2 = new IntHash<IRubyObject>();
                if (tables == null) {
                    tables = new TrTables();
                }
                if (cflag) {
                    phash = tables.noDel;
                    tables.noDel = hash2;
                } else {
                    phash = tables.del;
                    tables.del = hash2;
                }
            }
            if (phash != null && phash.get(c) == null) continue;
            hash2.put(c, RubyBasicObject.NEVER);
        }
        for (int i4 = 0; i4 < 256; ++i4) {
            table[i4] = table[i4] && buf[i4];
        }
        return tables;
    }

    public static boolean trFind(int c, boolean[] table, TrTables tables) {
        if (c < 256) {
            return table[c];
        }
        if (tables != null) {
            if (tables.del != null) {
                if (tables.noDel == null || tables.noDel.get(c) == null) {
                    return true;
                }
            } else if (tables.noDel != null && tables.noDel.get(c) != null) {
                return false;
            }
        }
        return table[256];
    }

    public static int trNext(TR t, Ruby runtime, Encoding enc) {
        byte[] buf = t.buf;
        if (!t.gen) {
            if (t.p == t.pend) {
                return -1;
            }
            if (t.p < t.pend - 1 && buf[t.p] == 92) {
                ++t.p;
            }
            t.now = StringSupport.codePoint(runtime, enc, buf, t.p, t.pend);
            t.p += StringSupport.codeLength(runtime, enc, t.now);
            if (t.p < t.pend - 1 && buf[t.p] == 45) {
                ++t.p;
                if (t.p < t.pend) {
                    int c = StringSupport.codePoint(runtime, enc, buf, t.p, t.pend);
                    t.p += StringSupport.codeLength(runtime, enc, c);
                    if (t.now > c) {
                        if (t.now < 128 && c < 128) {
                            throw runtime.newArgumentError("invalid range \"" + (char)t.now + "-" + (char)c + "\" in string transliteration");
                        }
                        throw runtime.newArgumentError("invalid range in string transliteration");
                    }
                    t.gen = true;
                    t.max = c;
                }
            }
            return t.now;
        }
        if (++t.now < t.max) {
            return t.now;
        }
        t.gen = false;
        return t.max;
    }

    public static ByteList succCommon(ByteList original) {
        int cl;
        int end2;
        byte[] carry = new byte[7];
        int carryP = 0;
        carry[0] = 1;
        int carryLen = 1;
        ByteList valueCopy = new ByteList(original);
        valueCopy.setEncoding(original.getEncoding());
        Encoding enc = original.getEncoding();
        int p2 = valueCopy.getBegin();
        int s2 = end2 = p2 + valueCopy.getRealSize();
        byte[] bytes2 = valueCopy.getUnsafeBytes();
        NeighborChar neighbor = NeighborChar.FOUND;
        int lastAlnum = -1;
        boolean alnumSeen = false;
        block5: while ((s2 = enc.prevCharHead(bytes2, p2, s2, end2)) != -1) {
            if (neighbor == NeighborChar.NOT_CHAR && lastAlnum != -1 && (ASCIIEncoding.INSTANCE.isAlpha(bytes2[lastAlnum] & 0xFF) ? ASCIIEncoding.INSTANCE.isDigit(bytes2[s2] & 0xFF) : ASCIIEncoding.INSTANCE.isDigit(bytes2[lastAlnum] & 0xFF) && ASCIIEncoding.INSTANCE.isAlpha(bytes2[s2] & 0xFF))) {
                s2 = lastAlnum;
                break;
            }
            cl = StringSupport.preciseLength(enc, bytes2, s2, end2);
            if (cl <= 0) continue;
            neighbor = StringSupport.succAlnumChar(enc, bytes2, s2, cl, carry, 0);
            switch (neighbor) {
                case NOT_CHAR: {
                    continue block5;
                }
                case FOUND: {
                    return valueCopy;
                }
                case WRAPPED: {
                    lastAlnum = s2;
                }
            }
            alnumSeen = true;
            carryP = s2 - p2;
            carryLen = cl;
        }
        if (!alnumSeen) {
            s2 = end2;
            while ((s2 = enc.prevCharHead(bytes2, p2, s2, end2)) != -1) {
                cl = StringSupport.preciseLength(enc, bytes2, s2, end2);
                if (cl <= 0) continue;
                neighbor = StringSupport.succChar(enc, bytes2, s2, cl);
                if (neighbor == NeighborChar.FOUND) {
                    return valueCopy;
                }
                if (StringSupport.preciseLength(enc, bytes2, s2, s2 + 1) != cl) {
                    StringSupport.succChar(enc, bytes2, s2, cl);
                }
                if (!enc.isAsciiCompatible()) {
                    System.arraycopy(bytes2, s2, carry, 0, cl);
                    carryLen = cl;
                }
                carryP = s2 - p2;
            }
        }
        valueCopy.ensure(valueCopy.getBegin() + valueCopy.getRealSize() + carryLen);
        s2 = valueCopy.getBegin() + carryP;
        System.arraycopy(valueCopy.getUnsafeBytes(), s2, valueCopy.getUnsafeBytes(), s2 + carryLen, valueCopy.getRealSize() - carryP);
        System.arraycopy(carry, 0, valueCopy.getUnsafeBytes(), s2, carryLen);
        valueCopy.setRealSize(valueCopy.getRealSize() + carryLen);
        return valueCopy;
    }

    /*
     * Unable to fully structure code
     */
    public static NeighborChar succChar(Encoding enc, byte[] bytes, int p, int len) {
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = len - 1; i >= 0 && bytes[p + i] == -1; --i) {
                bytes[p + i] = 0;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) + 1);
            cl = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (cl > 0) {
                if (cl == len) {
                    return NeighborChar.FOUND;
                }
                for (j = p + cl; j < p + len - cl; ++j) {
                    bytes[j] = -1;
                }
            }
            if (cl != -1 || i >= len - 1) ** continue;
            for (len2 = len - 1; len2 > 0 && StringSupport.preciseLength(enc, bytes, p, p + len2) == -1; --len2) {
            }
            j = p + len2 + 1;
            while (true) {
                if (j < p + len - (len2 + 1)) ** break;
                ** continue;
                bytes[j] = -1;
                ++j;
            }
            break;
        }
    }

    private static NeighborChar succAlnumChar(Encoding enc, byte[] bytes2, int p2, int len, byte[] carry, int carryP) {
        int cType;
        byte[] save = new byte[7];
        int c = enc.mbcToCode(bytes2, p2, p2 + len);
        if (enc.isDigit(c)) {
            cType = 4;
        } else if (enc.isAlpha(c)) {
            cType = 1;
        } else {
            return NeighborChar.NOT_CHAR;
        }
        System.arraycopy(bytes2, p2, save, 0, len);
        NeighborChar ret = StringSupport.succChar(enc, bytes2, p2, len);
        if (ret == NeighborChar.FOUND && enc.isCodeCType(c = enc.mbcToCode(bytes2, p2, p2 + len), cType)) {
            return NeighborChar.FOUND;
        }
        System.arraycopy(save, 0, bytes2, p2, len);
        int range = 1;
        while (true) {
            System.arraycopy(bytes2, p2, save, 0, len);
            ret = StringSupport.predChar(enc, bytes2, p2, len);
            if (ret == NeighborChar.FOUND) {
                c = enc.mbcToCode(bytes2, p2, p2 + len);
                if (!enc.isCodeCType(c, cType)) {
                    System.arraycopy(save, 0, bytes2, p2, len);
                    break;
                }
            } else {
                System.arraycopy(save, 0, bytes2, p2, len);
                break;
            }
            ++range;
        }
        if (range == 1) {
            return NeighborChar.NOT_CHAR;
        }
        if (cType != 4) {
            System.arraycopy(bytes2, p2, carry, carryP, len);
            return NeighborChar.WRAPPED;
        }
        System.arraycopy(bytes2, p2, carry, carryP, len);
        StringSupport.succChar(enc, carry, carryP, len);
        return NeighborChar.WRAPPED;
    }

    /*
     * Unable to fully structure code
     */
    private static NeighborChar predChar(Encoding enc, byte[] bytes, int p, int len) {
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = len - 1; i >= 0 && bytes[p + i] == 0; --i) {
                bytes[p + i] = -1;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) - 1);
            cl = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (cl > 0) {
                if (cl == len) {
                    return NeighborChar.FOUND;
                }
                for (j = p + cl; j < p + len - cl; ++j) {
                    bytes[j] = 0;
                }
            }
            if (cl != -1 || i >= len - 1) ** continue;
            for (len2 = len - 1; len2 > 0 && StringSupport.preciseLength(enc, bytes, p, p + len2) == -1; --len2) {
            }
            j = p + len2 + 1;
            while (true) {
                if (j < p + len - (len2 + 1)) ** break;
                ** continue;
                bytes[j] = 0;
                ++j;
            }
            break;
        }
    }

    public static boolean isSingleByteOptimizable(CodeRangeable string2, Encoding encoding2) {
        return string2.getCodeRange() == 16 || encoding2.maxLength() == 1;
    }

    public static int index(CodeRangeable sourceString, CodeRangeable otherString, int offset2, Encoding enc) {
        if (otherString.scanForCodeRange() == 48) {
            return -1;
        }
        int sourceLen = StringSupport.strLengthFromRubyString(sourceString);
        int otherLen = StringSupport.strLengthFromRubyString(otherString);
        if (offset2 < 0 && (offset2 += sourceLen) < 0) {
            return -1;
        }
        ByteList source2 = sourceString.getByteList();
        ByteList other = otherString.getByteList();
        if (sourceLen - offset2 < otherLen) {
            return -1;
        }
        byte[] bytes2 = source2.getUnsafeBytes();
        int p2 = source2.getBegin();
        int end2 = p2 + source2.getRealSize();
        if (offset2 != 0) {
            offset2 = StringSupport.isSingleByteOptimizable(sourceString, enc) ? offset2 : StringSupport.offset(enc, bytes2, p2, end2, offset2);
            p2 += offset2;
        }
        if (otherLen == 0) {
            return offset2;
        }
        int pos2;
        while ((pos2 = source2.indexOf(other, p2 - source2.getBegin())) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, p2, p2 + (pos2 -= p2 - source2.getBegin()), end2);
            if (t == p2 + pos2) {
                return pos2 + offset2;
            }
            if ((sourceLen -= t - p2) <= 0) {
                return -1;
            }
            offset2 += t - p2;
            p2 = t;
        }
        return pos2;
    }

    public static void associateEncoding(CodeRangeable string2, Encoding enc) {
        ByteList value2 = string2.getByteList();
        if (value2.getEncoding() != enc) {
            if (!CodeRangeSupport.isCodeRangeAsciiOnly(string2) || !enc.isAsciiCompatible()) {
                string2.clearCodeRange();
            }
            value2.setEncoding(enc);
        }
    }

    public static ByteList replaceInternal(int beg, int len, ByteListHolder source2, CodeRangeable repl) {
        int oldLength = source2.getByteList().getRealSize();
        if (beg + len >= oldLength) {
            len = oldLength - beg;
        }
        ByteList replBytes = repl.getByteList();
        int replLength = replBytes.getRealSize();
        int newLength = oldLength + replLength - len;
        byte[] oldBytes = source2.getByteList().getUnsafeBytes();
        int oldBegin = source2.getByteList().getBegin();
        source2.modify(newLength);
        if (replLength != len) {
            System.arraycopy(oldBytes, oldBegin + beg + len, source2.getByteList().getUnsafeBytes(), beg + replLength, oldLength - (beg + len));
        }
        if (replLength > 0) {
            System.arraycopy(replBytes.getUnsafeBytes(), replBytes.getBegin(), source2.getByteList().getUnsafeBytes(), beg, replLength);
        }
        source2.getByteList().setRealSize(newLength);
        return source2.getByteList();
    }

    public static void replaceInternal19(int beg, int len, CodeRangeable source2, CodeRangeable repl) {
        int e;
        Encoding enc = source2.checkEncoding(repl);
        int p2 = source2.getByteList().getBegin();
        if (StringSupport.isSingleByteOptimizable(source2, source2.getByteList().getEncoding())) {
            e = (p2 += beg) + len;
        } else {
            int end2 = p2 + source2.getByteList().getRealSize();
            byte[] bytes2 = source2.getByteList().getUnsafeBytes();
            p2 = StringSupport.nth(enc, bytes2, p2, end2, beg);
            if (p2 == -1) {
                p2 = end2;
            }
            if ((e = StringSupport.nth(enc, bytes2, p2, end2, len)) == -1) {
                e = end2;
            }
        }
        int cr = source2.getCodeRange();
        if (cr == 48) {
            source2.clearCodeRange();
        }
        StringSupport.replaceInternal(p2 - source2.getByteList().getBegin(), e - p2, source2, repl);
        StringSupport.associateEncoding(source2, enc);
        cr = CodeRangeSupport.codeRangeAnd(cr, repl.getCodeRange());
        if (cr != 48) {
            source2.setCodeRange(cr);
        }
    }

    public static enum NeighborChar {
        NOT_CHAR,
        FOUND,
        WRAPPED;

    }

    public static final class TrTables {
        private IntHash<IRubyObject> del;
        private IntHash<IRubyObject> noDel;
    }

    public static final class TR {
        public int p;
        public int pend;
        public int now;
        public int max;
        public boolean gen;
        public byte[] buf;

        public TR(ByteList bytes2) {
            this.p = bytes2.getBegin();
            this.pend = bytes2.getRealSize() + this.p;
            this.buf = bytes2.getUnsafeBytes();
            this.max = 0;
            this.now = 0;
            this.gen = false;
        }
    }
}

