/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.locals.ReadLevelVariableNode;
import org.jruby.truffle.nodes.methods.locals.ReadLevelVariableNodeFactory;
import org.jruby.truffle.nodes.methods.locals.ReadLocalVariableNode;
import org.jruby.truffle.nodes.methods.locals.ReadLocalVariableNodeFactory;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.ParseEnvironment;
import org.jruby.truffle.translator.TranslatorDriver;

public class TranslatorEnvironment {
    private final RubyContext context;
    private final ParseEnvironment parseEnvironment;
    private final FrameDescriptor frameDescriptor;
    private final List<FrameSlot> flipFlopStates = new ArrayList<FrameSlot>();
    private TranslatorDriver parser;
    private final long returnID;
    private final boolean isBlock;
    private final boolean ownScopeForAssignments;
    private final boolean neverAssignInParentScope;
    protected final TranslatorEnvironment parent;
    private boolean needsDeclarationFrame = RubyProc.PROC_BINDING;
    private final SharedMethodInfo sharedMethodInfo;
    private final String namedMethodName;
    private static AtomicInteger tempIndex = new AtomicInteger();
    public boolean hasRestParameter = false;

    public TranslatorEnvironment(RubyContext context, TranslatorEnvironment parent, FrameDescriptor frameDescriptor, TranslatorDriver parser, long returnID, boolean ownScopeForAssignments, boolean neverAssignInParentScope, SharedMethodInfo sharedMethodInfo, String namedMethodName, boolean isBlock) {
        this.context = context;
        this.parent = parent;
        this.frameDescriptor = frameDescriptor;
        this.parser = parser;
        this.returnID = returnID;
        this.ownScopeForAssignments = ownScopeForAssignments;
        this.neverAssignInParentScope = neverAssignInParentScope;
        this.sharedMethodInfo = sharedMethodInfo;
        this.namedMethodName = namedMethodName;
        this.isBlock = isBlock;
        this.parseEnvironment = parent != null ? parent.parseEnvironment : new ParseEnvironment(context);
    }

    public TranslatorEnvironment(RubyContext context, TranslatorEnvironment parent, TranslatorDriver parser, long returnID, boolean ownScopeForAssignments, boolean neverAssignInParentScope, SharedMethodInfo methodIdentifier, String namedMethodName, boolean isBlock) {
        this(context, parent, new FrameDescriptor(context.getCoreLibrary().getNilObject()), parser, returnID, ownScopeForAssignments, neverAssignInParentScope, methodIdentifier, namedMethodName, isBlock);
    }

    public LexicalScope getLexicalScope() {
        return this.parseEnvironment.getLexicalScope();
    }

    public LexicalScope pushLexicalScope() {
        return this.parseEnvironment.pushLexicalScope();
    }

    public void popLexicalScope() {
        this.parseEnvironment.popLexicalScope();
    }

    public TranslatorEnvironment getParent() {
        return this.parent;
    }

    public TranslatorEnvironment getParent(int level2) {
        assert (level2 >= 0);
        if (level2 == 0) {
            return this;
        }
        return this.parent.getParent(level2 - 1);
    }

    public FrameSlot declareVar(String name2) {
        return this.getFrameDescriptor().findOrAddFrameSlot(name2);
    }

    public FrameSlot declareVarWhereAllowed(String name2) {
        if (this.isBlock) {
            return this.parent.declareVarWhereAllowed(name2);
        }
        return this.declareVar(name2);
    }

    public SharedMethodInfo findMethodForLocalVar(String name2) {
        TranslatorEnvironment current2 = this;
        do {
            FrameSlot slot;
            if ((slot = current2.getFrameDescriptor().findFrameSlot(name2)) == null) continue;
            return current2.sharedMethodInfo;
        } while ((current2 = current2.parent) != null);
        return null;
    }

    public RubyNode findOrAddLocalVarNodeDangerous(String name2, SourceSection sourceSection) {
        RubyNode localVar = this.findLocalVarNode(name2, sourceSection);
        if (localVar == null) {
            this.declareVar(name2);
            localVar = this.findLocalVarNode(name2, sourceSection);
        }
        return localVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode findLocalVarNode(String name2, SourceSection sourceSection) {
        TranslatorEnvironment current2 = this;
        int level2 = -1;
        try {
            do {
                ++level2;
                FrameSlot slot = current2.getFrameDescriptor().findFrameSlot(name2);
                if (slot == null) continue;
                if (level2 == 0) {
                    ReadLocalVariableNode readLocalVariableNode = ReadLocalVariableNodeFactory.create(this.context, sourceSection, slot);
                    return readLocalVariableNode;
                }
                ReadLevelVariableNode readLevelVariableNode = ReadLevelVariableNodeFactory.create(this.context, sourceSection, slot, level2);
                return readLevelVariableNode;
            } while ((current2 = current2.parent) != null);
        }
        finally {
            if (current2 != null) {
                current2 = this;
                while (level2-- > 0) {
                    current2.needsDeclarationFrame = true;
                    current2 = current2.parent;
                }
            }
        }
        return null;
    }

    public void setNeedsDeclarationFrame() {
        this.needsDeclarationFrame = true;
    }

    public boolean needsDeclarationFrame() {
        return this.needsDeclarationFrame;
    }

    public FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    public String allocateLocalTemp(String indicator) {
        String name2 = "rubytruffle_temp_" + indicator + "_" + tempIndex.getAndIncrement();
        this.declareVar(name2);
        return name2;
    }

    public long getReturnID() {
        return this.returnID;
    }

    public TranslatorDriver getParser() {
        return this.parser;
    }

    public boolean hasOwnScopeForAssignments() {
        return this.ownScopeForAssignments;
    }

    public boolean getNeverAssignInParentScope() {
        return this.neverAssignInParentScope;
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public List<FrameSlot> getFlipFlopStates() {
        return this.flipFlopStates;
    }

    public String getNamedMethodName() {
        return this.namedMethodName;
    }

    public boolean isBlock() {
        return this.isBlock;
    }
}

