/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.ast.AliasNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.Node;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.literal.ObjectLiteralNode;
import org.jruby.truffle.nodes.methods.AliasNodeFactory;
import org.jruby.truffle.nodes.methods.CatchReturnPlaceholderNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.TranslatorEnvironment;

class ModuleTranslator
extends BodyTranslator {
    public ModuleTranslator(RubyNode currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, Source source2) {
        super(currentNode, context, parent, environment, source2, false);
        this.useClassVariablesAsIfInClass = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodDefinitionNode compileClassNode(SourceSection sourceSection, String name2, Node bodyNode) {
        RubyNode body;
        if (bodyNode != null) {
            this.parentSourceSection = sourceSection;
            try {
                body = bodyNode.accept(this);
            }
            finally {
                this.parentSourceSection = null;
            }
        } else {
            body = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        }
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = SequenceNode.sequence(this.context, sourceSection, this.initFlipFlopStates(sourceSection), body);
        }
        body = new CatchReturnPlaceholderNode(this.context, sourceSection, body, this.environment.getReturnID());
        body = new SetMethodDeclarationContext(this.context, sourceSection, name2, body);
        RubyRootNode rootNode = new RubyRootNode(this.context, sourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body);
        return new MethodDefinitionNode(this.context, sourceSection, this.environment.getSharedMethodInfo().getName(), this.environment.getSharedMethodInfo(), this.environment.needsDeclarationFrame(), Truffle.getRuntime().createCallTarget(rootNode));
    }

    @Override
    public RubyNode visitDefnNode(DefnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        SelfNode classNode = new SelfNode(this.context, sourceSection);
        return this.translateMethodDefinition(sourceSection, classNode, node.getName(), node, node.getArgsNode(), node.getBodyNode());
    }

    @Override
    public RubyNode visitAliasNode(AliasNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        LiteralNode oldName = (LiteralNode)node.getOldName();
        LiteralNode newName = (LiteralNode)node.getNewName();
        return AliasNodeFactory.create(this.context, sourceSection, newName.getName(), oldName.getName(), new SelfNode(this.context, sourceSection));
    }
}

