/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Syntax;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2ConstNode;
import org.jruby.ast.Colon2ImplicitNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.types.INameNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.InvalidSourcePosition;
import org.jruby.truffle.nodes.AssignmentWrapperNode;
import org.jruby.truffle.nodes.ForNode;
import org.jruby.truffle.nodes.ReadConstantNode;
import org.jruby.truffle.nodes.ReadNode;
import org.jruby.truffle.nodes.RubyCallNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.ThreadLocalObjectNode;
import org.jruby.truffle.nodes.WriteConstantNode;
import org.jruby.truffle.nodes.WriteNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.cast.HashCastNodeFactory;
import org.jruby.truffle.nodes.cast.ProcCastNodeFactory;
import org.jruby.truffle.nodes.cast.SplatCastNode;
import org.jruby.truffle.nodes.cast.SplatCastNodeFactory;
import org.jruby.truffle.nodes.cast.StringToSymbolNodeFactory;
import org.jruby.truffle.nodes.cast.ToSNode;
import org.jruby.truffle.nodes.cast.ToSNodeFactory;
import org.jruby.truffle.nodes.control.BreakNode;
import org.jruby.truffle.nodes.control.ElidableResultNode;
import org.jruby.truffle.nodes.control.EnsureNode;
import org.jruby.truffle.nodes.control.FlipFlopNode;
import org.jruby.truffle.nodes.control.IfNode;
import org.jruby.truffle.nodes.control.NotNode;
import org.jruby.truffle.nodes.control.OnceNode;
import org.jruby.truffle.nodes.control.RescueAnyNode;
import org.jruby.truffle.nodes.control.RescueClassesNode;
import org.jruby.truffle.nodes.control.RescueSplatNode;
import org.jruby.truffle.nodes.control.RetryNode;
import org.jruby.truffle.nodes.control.ReturnNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.control.TraceNode;
import org.jruby.truffle.nodes.control.TryNode;
import org.jruby.truffle.nodes.control.WhenSplatNode;
import org.jruby.truffle.nodes.control.WhileNode;
import org.jruby.truffle.nodes.core.ArrayConcatNode;
import org.jruby.truffle.nodes.core.ArrayDropTailNode;
import org.jruby.truffle.nodes.core.ArrayDropTailNodeFactory;
import org.jruby.truffle.nodes.core.ArrayGetTailNode;
import org.jruby.truffle.nodes.core.ArrayGetTailNodeFactory;
import org.jruby.truffle.nodes.core.ArrayIndexNode;
import org.jruby.truffle.nodes.core.ArrayIndexNodeFactory;
import org.jruby.truffle.nodes.core.ArrayNodesFactory;
import org.jruby.truffle.nodes.core.InteroplatedRegexpNode;
import org.jruby.truffle.nodes.core.InterpolatedStringNode;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.globals.CheckMatchVariableTypeNode;
import org.jruby.truffle.nodes.globals.CheckOutputSeparatorVariableTypeNode;
import org.jruby.truffle.nodes.globals.CheckProgramNameVariableTypeNode;
import org.jruby.truffle.nodes.globals.CheckRecordSeparatorVariableTypeNode;
import org.jruby.truffle.nodes.globals.CheckStdoutVariableTypeNode;
import org.jruby.truffle.nodes.globals.GetFromThreadLocalNodeFactory;
import org.jruby.truffle.nodes.globals.ReadMatchReferenceNode;
import org.jruby.truffle.nodes.globals.WrapInThreadLocalNodeFactory;
import org.jruby.truffle.nodes.globals.WriteReadOnlyGlobalNode;
import org.jruby.truffle.nodes.literal.ArrayLiteralNode;
import org.jruby.truffle.nodes.literal.BooleanLiteralNode;
import org.jruby.truffle.nodes.literal.ConcatHashLiteralNode;
import org.jruby.truffle.nodes.literal.FixnumLiteralNode;
import org.jruby.truffle.nodes.literal.FloatLiteralNode;
import org.jruby.truffle.nodes.literal.HashLiteralNode;
import org.jruby.truffle.nodes.literal.NilLiteralNode;
import org.jruby.truffle.nodes.literal.ObjectLiteralNode;
import org.jruby.truffle.nodes.literal.RangeLiteralNodeFactory;
import org.jruby.truffle.nodes.literal.StringLiteralNode;
import org.jruby.truffle.nodes.methods.AddMethodNode;
import org.jruby.truffle.nodes.methods.AliasNodeFactory;
import org.jruby.truffle.nodes.methods.AssertCompilationConstantNodeFactory;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.methods.locals.FlipFlopStateNode;
import org.jruby.truffle.nodes.methods.locals.InitFlipFlopSlotNode;
import org.jruby.truffle.nodes.methods.locals.LevelFlipFlopStateNode;
import org.jruby.truffle.nodes.methods.locals.LocalFlipFlopStateNode;
import org.jruby.truffle.nodes.methods.locals.ReadLocalVariableNodeFactory;
import org.jruby.truffle.nodes.methods.locals.WriteLevelVariableNode;
import org.jruby.truffle.nodes.methods.locals.WriteLocalVariableNode;
import org.jruby.truffle.nodes.methods.locals.WriteLocalVariableNodeFactory;
import org.jruby.truffle.nodes.objects.DefineOrGetClassNode;
import org.jruby.truffle.nodes.objects.DefineOrGetModuleNode;
import org.jruby.truffle.nodes.objects.LexicalScopeNode;
import org.jruby.truffle.nodes.objects.OpenModuleNode;
import org.jruby.truffle.nodes.objects.ReadClassVariableNode;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeFactory;
import org.jruby.truffle.nodes.objects.WriteClassVariableNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.nodes.rubinius.CallRubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.nodes.rubinius.RubiniusSingleBlockArgNode;
import org.jruby.truffle.nodes.yield.YieldNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.DeadNode;
import org.jruby.truffle.translator.MethodTranslator;
import org.jruby.truffle.translator.ModuleTranslator;
import org.jruby.truffle.translator.ReadLocalDummyNode;
import org.jruby.truffle.translator.Translator;
import org.jruby.truffle.translator.TranslatorEnvironment;
import org.jruby.util.KeyValuePair;
import org.jruby.util.cli.Options;

public class BodyTranslator
extends Translator {
    protected final BodyTranslator parent;
    protected final TranslatorEnvironment environment;
    private final boolean topLevel;
    public boolean translatingForStatement = false;
    public boolean useClassVariablesAsIfInClass = false;
    private boolean translatingNextExpression = false;
    private boolean translatingWhile = false;
    private String currentCallMethodName = null;
    private boolean privately = false;
    private static final Set<String> debugIgnoredCalls = new HashSet<String>();
    public static final Set<String> FRAME_LOCAL_GLOBAL_VARIABLES;
    public static final Set<String> THREAD_LOCAL_GLOBAL_VARIABLES;
    private final Set<String> readOnlyGlobalVariables = new HashSet<String>();
    private final Map<String, String> globalVariableAliases = new HashMap<String, String>();

    public BodyTranslator(RubyNode currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, Source source2, boolean topLevel) {
        super(currentNode, context, source2);
        this.parent = parent;
        this.environment = environment;
        this.topLevel = topLevel;
        this.initGlobalVariableAliases();
        this.initReadOnlyGlobalVariables();
    }

    @Override
    public RubyNode visitAliasNode(AliasNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        LiteralNode oldName = (LiteralNode)node.getOldName();
        LiteralNode newName = (LiteralNode)node.getNewName();
        return AliasNodeFactory.create(this.context, sourceSection, newName.getName(), oldName.getName(), new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection));
    }

    @Override
    public RubyNode visitAndNode(AndNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode x = node.getFirstNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : node.getFirstNode().accept(this);
        RubyNode y = node.getSecondNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : node.getSecondNode().accept(this);
        return new org.jruby.truffle.nodes.control.AndNode(this.context, sourceSection, x, y);
    }

    @Override
    public RubyNode visitArgsCatNode(ArgsCatNode node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.collectArgsCatNodes(nodes, node);
        ArrayList<RubyNode> translatedNodes = new ArrayList<RubyNode>();
        for (Node catNode : nodes) {
            translatedNodes.add(catNode.accept(this));
        }
        return new ArrayConcatNode(this.context, this.translate(node.getPosition()), translatedNodes.toArray(new RubyNode[translatedNodes.size()]));
    }

    private void collectArgsCatNodes(List<Node> nodes, ArgsCatNode node) {
        if (node.getFirstNode() instanceof ArgsCatNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatNode)node.getFirstNode());
        } else {
            nodes.add(node.getFirstNode());
        }
        if (node.getSecondNode() instanceof ArgsCatNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatNode)node.getSecondNode());
        } else {
            SplatNode secondNode = new SplatNode(node.getSecondNode().getPosition(), node.getSecondNode());
            nodes.add(secondNode);
        }
    }

    @Override
    public RubyNode visitArgsPushNode(ArgsPushNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return ArrayNodesFactory.PushOneNodeFactory.create(this.context, sourceSection, new RubyNode[]{KernelNodesFactory.DupNodeFactory.create(this.context, sourceSection, new RubyNode[]{node.getFirstNode().accept(this)}), node.getSecondNode().accept(this)});
    }

    @Override
    public RubyNode visitArrayNode(ArrayNode node) {
        List<Node> values2 = node.childNodes();
        RubyNode[] translatedValues = new RubyNode[values2.size()];
        for (int n = 0; n < values2.size(); ++n) {
            translatedValues[n] = values2.get(n).accept(this);
        }
        return new ArrayLiteralNode.UninitialisedArrayLiteralNode(this.context, this.translate(node.getPosition()), translatedValues);
    }

    @Override
    public RubyNode visitAttrAssignNode(AttrAssignNode node) {
        return this.visitAttrAssignNodeExtraArgument(node, null);
    }

    public RubyNode visitAttrAssignNodeExtraArgument(AttrAssignNode node, RubyNode extraArgument) {
        Node fixedArgsNode;
        ArrayNode newArgsNode;
        WriteLocalVariableNode writeValue;
        SourceSection sourceSection = this.translate(node.getPosition());
        FrameSlot frameSlot = this.environment.declareVar(this.environment.allocateLocalTemp("attrasgn"));
        if (extraArgument == null) {
            ArrayList<Node> argChildNodes = new ArrayList<Node>(node.getArgsNode().childNodes());
            Node valueNode = (Node)argChildNodes.get(argChildNodes.size() - 1);
            argChildNodes.remove(argChildNodes.size() - 1);
            writeValue = WriteLocalVariableNodeFactory.create(this.context, sourceSection, frameSlot, valueNode.accept(this));
            argChildNodes.add(new ReadLocalDummyNode(node.getPosition(), sourceSection, frameSlot));
            newArgsNode = new ArrayNode(node.getPosition(), (Node)argChildNodes.get(0));
            argChildNodes.remove(0);
            for (Node child : argChildNodes) {
                newArgsNode.add(child);
            }
        } else {
            RubyNode valueNode = extraArgument;
            writeValue = WriteLocalVariableNodeFactory.create(this.context, sourceSection, frameSlot, valueNode);
            ArrayList<Node> argChildNodes = new ArrayList<Node>();
            if (node.getArgsNode() != null) {
                argChildNodes.addAll(node.getArgsNode().childNodes());
            }
            argChildNodes.add(new ReadLocalDummyNode(node.getPosition(), sourceSection, frameSlot));
            newArgsNode = new ArrayNode(node.getPosition(), (Node)argChildNodes.get(0));
            argChildNodes.remove(0);
            for (Node child : argChildNodes) {
                newArgsNode.add(child);
            }
        }
        if (node.getArgsNode() instanceof ArgsPushNode) {
            if (newArgsNode.size() != 2) {
                throw new UnsupportedOperationException();
            }
            fixedArgsNode = new ArgsPushNode(newArgsNode.getPosition(), newArgsNode.childNodes().get(0), newArgsNode.childNodes().get(1));
        } else {
            fixedArgsNode = newArgsNode;
        }
        CallNode callNode = new CallNode(node.getPosition(), node.getReceiverNode(), node.getName(), fixedArgsNode, null);
        boolean isAccessorOnSelf = node.getReceiverNode() instanceof SelfNode;
        RubyNode actualCall = this.visitCallNodeExtraArgument(callNode, null, isAccessorOnSelf, false);
        return SequenceNode.sequence(this.context, sourceSection, writeValue, actualCall, ReadLocalVariableNodeFactory.create(this.context, sourceSection, frameSlot));
    }

    @Override
    public RubyNode visitBeginNode(BeginNode node) {
        return node.getBodyNode().accept(this);
    }

    @Override
    public RubyNode visitBignumNode(BignumNode node) {
        return new ObjectLiteralNode(this.context, this.translate(node.getPosition()), new RubyBignum(this.context.getCoreLibrary().getBignumClass(), node.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitBlockNode(BlockNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> translatedChildren = new ArrayList<RubyNode>();
        for (Node child : node.childNodes()) {
            RubyNode translatedChild;
            if (child.getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection = sourceSection;
            }
            try {
                translatedChild = child.accept(this);
            }
            finally {
                if (child.getPosition() == InvalidSourcePosition.INSTANCE) {
                    this.parentSourceSection = null;
                }
            }
            if (translatedChild instanceof DeadNode) continue;
            translatedChildren.add(translatedChild);
        }
        if (translatedChildren.size() == 1) {
            return (RubyNode)translatedChildren.get(0);
        }
        return SequenceNode.sequence(this.context, sourceSection, translatedChildren.toArray(new RubyNode[translatedChildren.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitBreakNode(org.jruby.ast.BreakNode node) {
        RubyNode resultNode;
        if (!this.environment.isBlock() && !this.translatingWhile) {
            System.err.printf("%s:%d: Invalid break%n", node.getPosition().getFile(), node.getPosition().getLine() + 1);
            System.err.printf("%s: compile error (SyntaxError)%n", node.getPosition().getFile());
            System.exit(1);
        }
        SourceSection sourceSection = this.translate(node.getPosition());
        if (node.getValueNode() == null) {
            this.parentSourceSection = sourceSection;
            try {
                resultNode = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
            }
            finally {
                this.parentSourceSection = null;
            }
        } else if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
            this.parentSourceSection = sourceSection;
            try {
                resultNode = node.getValueNode().accept(this);
            }
            finally {
                this.parentSourceSection = null;
            }
        } else {
            resultNode = node.getValueNode().accept(this);
        }
        return new BreakNode(this.context, sourceSection, resultNode);
    }

    @Override
    public RubyNode visitCallNode(CallNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (node.getReceiverNode() instanceof ConstNode && ((ConstNode)node.getReceiverNode()).getName().equals("Rubinius")) {
            if (node.getName().equals("primitive")) {
                return this.translateRubiniusPrimitive(sourceSection, node);
            }
            if (node.getName().equals("invoke_primitive")) {
                return this.translateRubiniusInvokePrimitive(sourceSection, node);
            }
            if (node.getName().equals("privately")) {
                return this.translateRubiniusPrivately(sourceSection, node);
            }
            if (node.getName().equals("single_block_arg")) {
                return this.translateRubiniusSingleBlockArg(sourceSection, node);
            }
        }
        return this.visitCallNodeExtraArgument(node, null, false, false);
    }

    private RubyNode translateRubiniusPrimitive(SourceSection sourceSection, CallNode node) {
        if (node.getArgsNode().childNodes().size() != 1 || !(node.getArgsNode().childNodes().get(0) instanceof SymbolNode)) {
            throw new UnsupportedOperationException("Rubinius.primitive must have a single literal symbol argument");
        }
        String primitiveName = ((SymbolNode)node.getArgsNode().childNodes().get(0)).getName();
        RubiniusPrimitiveConstructor primitive = this.context.getRubiniusPrimitiveManager().getPrimitive(primitiveName);
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>();
        int argumentsCount = primitive.getFactory().getExecutionSignature().size();
        if (primitive.getAnnotation().needsSelf()) {
            arguments.add(new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection));
            --argumentsCount;
        }
        for (int n = 0; n < argumentsCount; ++n) {
            arguments.add(new ReadPreArgumentNode(this.context, sourceSection, n, MissingArgumentBehaviour.UNDEFINED));
        }
        return new CallRubiniusPrimitiveNode(this.context, sourceSection, primitive.getFactory().createNode(this.context, sourceSection, arguments.toArray(new RubyNode[arguments.size()])), this.environment.getReturnID());
    }

    private RubyNode translateRubiniusInvokePrimitive(SourceSection sourceSection, CallNode node) {
        if (node.getArgsNode().childNodes().size() < 1 || !(node.getArgsNode().childNodes().get(0) instanceof SymbolNode)) {
            throw new UnsupportedOperationException("Rubinius.invoke_primitive must have at least an initial literal symbol argument");
        }
        String primitiveName = ((SymbolNode)node.getArgsNode().childNodes().get(0)).getName();
        RubiniusPrimitiveConstructor primitive = this.context.getRubiniusPrimitiveManager().getPrimitive(primitiveName);
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>();
        Iterator<Node> childIterator = node.getArgsNode().childNodes().iterator();
        childIterator.next();
        while (childIterator.hasNext()) {
            arguments.add(childIterator.next().accept(this));
        }
        return new CallRubiniusPrimitiveNode(this.context, sourceSection, primitive.getFactory().createNode(this.context, sourceSection, arguments.toArray(new RubyNode[arguments.size()])), this.environment.getReturnID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateRubiniusPrivately(SourceSection sourceSection, CallNode node) {
        if (!(node.getIterNode() instanceof IterNode)) {
            throw new UnsupportedOperationException("Rubinius.privately needs a literal block");
        }
        if (node.getArgsNode() != null && node.getArgsNode().childNodes().size() > 0) {
            throw new UnsupportedOperationException("Rubinius.privately should not have any arguments");
        }
        this.currentCallMethodName = "privately";
        boolean previousPrivately = this.privately;
        this.privately = true;
        try {
            RubyNode rubyNode = ((IterNode)node.getIterNode()).getBodyNode().accept(this);
            return rubyNode;
        }
        finally {
            this.privately = previousPrivately;
        }
    }

    public RubyNode translateRubiniusSingleBlockArg(SourceSection sourceSection, CallNode node) {
        return new RubiniusSingleBlockArgNode(this.context, sourceSection);
    }

    public RubyNode visitCallNodeExtraArgument(CallNode node, RubyNode extraArgument, boolean ignoreVisibility, boolean isVCall) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode receiverTranslated = node.getReceiverNode().accept(this);
        Node args2 = node.getArgsNode();
        Node block = node.getIterNode();
        if (block == null && args2 instanceof IterNode) {
            block = args2;
            args2 = null;
        }
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, block, args2, extraArgument, node.getName());
        RubyCallNode translated = new RubyCallNode(this.context, sourceSection, node.getName(), receiverTranslated, argumentsAndBlock.getBlock(), argumentsAndBlock.isSplatted(), isVCall, this.privately || ignoreVisibility, false, argumentsAndBlock.getArguments());
        return translated;
    }

    protected ArgumentsAndBlockTranslation translateArgumentsAndBlock(SourceSection sourceSection, Node iterNode, Node argsNode, RubyNode extraArgument, String nameToSetWhenTranslatingBlock) {
        RubyNode blockTranslated;
        assert (!(argsNode instanceof IterNode));
        ArrayList<Node> arguments = new ArrayList<Node>();
        Node blockPassNode = null;
        boolean isSplatted = false;
        if (argsNode instanceof ListNode) {
            arguments.addAll(argsNode.childNodes());
        } else if (argsNode instanceof BlockPassNode) {
            BlockPassNode blockPass = (BlockPassNode)argsNode;
            Node blockPassArgs = blockPass.getArgsNode();
            if (blockPassArgs instanceof ListNode) {
                arguments.addAll(blockPassArgs.childNodes());
            } else if (blockPassArgs instanceof ArgsCatNode) {
                arguments.add(blockPassArgs);
            } else if (blockPassArgs != null) {
                throw new UnsupportedOperationException("Don't know how to block pass " + blockPassArgs);
            }
            blockPassNode = blockPass.getBodyNode();
        } else if (argsNode instanceof SplatNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode instanceof ArgsCatNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode != null) {
            isSplatted = true;
            arguments.add(argsNode);
        }
        if (iterNode instanceof BlockPassNode) {
            blockPassNode = ((BlockPassNode)iterNode).getBodyNode();
        }
        this.currentCallMethodName = nameToSetWhenTranslatingBlock;
        if (blockPassNode != null) {
            blockTranslated = ProcCastNodeFactory.create(this.context, sourceSection, blockPassNode.accept(this));
        } else if (iterNode != null) {
            blockTranslated = iterNode.accept(this);
            if (blockTranslated instanceof ObjectLiteralNode && ((ObjectLiteralNode)blockTranslated).getObject() instanceof RubyNilClass) {
                blockTranslated = null;
            }
        } else {
            blockTranslated = null;
        }
        ArrayList<RubyNode> argumentsTranslated = new ArrayList<RubyNode>();
        for (Node argument : arguments) {
            argumentsTranslated.add(argument.accept(this));
        }
        if (extraArgument != null) {
            argumentsTranslated.add(extraArgument);
        }
        RubyNode[] argumentsTranslatedArray = argumentsTranslated.toArray(new RubyNode[argumentsTranslated.size()]);
        return new ArgumentsAndBlockTranslation(blockTranslated, argumentsTranslatedArray, isSplatted);
    }

    @Override
    public RubyNode visitCaseNode(CaseNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode elseNode = node.getElseNode() != null ? node.getElseNode().accept(this) : new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        if (node.getCaseNode() != null) {
            String tempName = this.environment.allocateLocalTemp("case");
            RubyNode readTemp = this.environment.findLocalVarNode(tempName, sourceSection);
            RubyNode assignTemp = ((ReadNode)((Object)readTemp)).makeWriteNode(node.getCaseNode().accept(this));
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                WhenNode when = (WhenNode)node.getCases().get(n);
                List<Node> expressions = when.getExpressionNodes() instanceof ListNode && !(when.getExpressionNodes() instanceof ArrayNode) ? when.getExpressionNodes().childNodes() : Arrays.asList(when.getExpressionNodes());
                ArrayList<RubyNode> comparisons = new ArrayList<RubyNode>();
                for (Node expressionNode : expressions) {
                    RubyNode rubyExpression = expressionNode.accept(this);
                    if (expressionNode instanceof SplatNode) {
                        SplatCastNode splatCastNode = (SplatCastNode)rubyExpression;
                        comparisons.add(new WhenSplatNode(this.context, sourceSection, NodeUtil.cloneNode(readTemp), splatCastNode));
                        continue;
                    }
                    if (expressionNode instanceof ArgsCatNode) {
                        ArrayConcatNode arrayConcatNode = (ArrayConcatNode)rubyExpression;
                        comparisons.add(new WhenSplatNode(this.context, sourceSection, NodeUtil.cloneNode(readTemp), arrayConcatNode));
                        continue;
                    }
                    comparisons.add(new RubyCallNode(this.context, sourceSection, "===", rubyExpression, null, false, NodeUtil.cloneNode(readTemp)));
                }
                RubyNode conditionNode = (RubyNode)comparisons.get(comparisons.size() - 1);
                for (int i2 = comparisons.size() - 2; i2 >= 0; --i2) {
                    conditionNode = new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, (RubyNode)comparisons.get(i2), conditionNode);
                }
                BooleanCastNode conditionCastNode = BooleanCastNodeFactory.create(this.context, sourceSection, conditionNode);
                RubyNode thenNode = when.getBodyNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : when.getBodyNode().accept(this);
                IfNode ifNode = new IfNode(this.context, sourceSection, conditionCastNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            RubyNode ifNode = elseNode;
            return SequenceNode.sequence(this.context, sourceSection, assignTemp, ifNode);
        }
        for (int n = node.getCases().size() - 1; n >= 0; --n) {
            WhenNode when = (WhenNode)node.getCases().get(n);
            List<Node> expressions = when.getExpressionNodes() instanceof ListNode ? when.getExpressionNodes().childNodes() : Arrays.asList(when.getExpressionNodes());
            ArrayList<RubyNode> tests = new ArrayList<RubyNode>();
            for (Node expressionNode : expressions) {
                RubyNode rubyExpression = expressionNode.accept(this);
                tests.add(rubyExpression);
            }
            RubyNode conditionNode = (RubyNode)tests.get(tests.size() - 1);
            for (int i3 = tests.size() - 2; i3 >= 0; --i3) {
                conditionNode = new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, (RubyNode)tests.get(i3), conditionNode);
            }
            BooleanCastNode conditionCastNode = BooleanCastNodeFactory.create(this.context, sourceSection, conditionNode);
            RubyNode thenNode = when.getBodyNode().accept(this);
            IfNode ifNode = new IfNode(this.context, sourceSection, conditionCastNode, thenNode, elseNode);
            elseNode = ifNode;
        }
        return elseNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode openModule(SourceSection sourceSection, RubyNode defineOrGetNode, String name2, Node bodyNode) {
        LexicalScope newLexicalScope = this.environment.pushLexicalScope();
        try {
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, newLexicalScope, name2, false, bodyNode, false);
            TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParser(), this.environment.getParser().allocateReturnID(), true, true, sharedMethodInfo, name2, false);
            ModuleTranslator classTranslator = new ModuleTranslator(this.currentNode, this.context, this, newEnvironment, this.source);
            MethodDefinitionNode definitionMethod = classTranslator.compileClassNode(sourceSection, name2, bodyNode);
            OpenModuleNode openModuleNode = new OpenModuleNode(this.context, sourceSection, defineOrGetNode, definitionMethod, newLexicalScope);
            return openModuleNode;
        }
        finally {
            this.environment.popLexicalScope();
        }
    }

    @Override
    public RubyNode visitClassNode(ClassNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name2 = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        RubyNode superClass = node.getSuperNode() != null ? node.getSuperNode().accept(this) : new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        DefineOrGetClassNode defineOrGetClass = new DefineOrGetClassNode(this.context, sourceSection, name2, lexicalParent, superClass);
        return this.openModule(sourceSection, defineOrGetClass, name2, node.getBodyNode());
    }

    @Override
    public RubyNode visitClassVarAsgnNode(ClassVarAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode rhs = node.getValueNode().accept(this);
        return new WriteClassVariableNode(this.context, sourceSection, node.getName(), this.environment.getLexicalScope(), rhs);
    }

    @Override
    public RubyNode visitClassVarNode(ClassVarNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new ReadClassVariableNode(this.context, sourceSection, node.getName(), this.environment.getLexicalScope());
    }

    @Override
    public RubyNode visitColon2Node(Colon2Node node) {
        if (!(node instanceof Colon2ConstNode)) {
            throw new UnsupportedOperationException(node.toString());
        }
        RubyNode lhs = node.getLeftNode().accept(this);
        return new ReadConstantNode(this.context, this.translate(node.getPosition()), node.getName(), lhs, LexicalScope.NONE);
    }

    @Override
    public RubyNode visitColon3Node(Colon3Node node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ObjectLiteralNode root = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        return new ReadConstantNode(this.context, sourceSection, node.getName(), root, LexicalScope.NONE);
    }

    private RubyNode translateCPath(SourceSection sourceSection, Colon3Node node) {
        if (node instanceof Colon2ImplicitNode) {
            return new LexicalScopeNode(this.context, sourceSection, this.environment.getLexicalScope());
        }
        if (node instanceof Colon2ConstNode) {
            return node.childNodes().get(0).accept(this);
        }
        return new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
    }

    @Override
    public RubyNode visitComplexNode(ComplexNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.translateRationalComplex(sourceSection, "Complex", new FixnumLiteralNode.IntegerFixnumLiteralNode(this.context, sourceSection, 0), node.getNumber().accept(this));
    }

    @Override
    public RubyNode visitConstDeclNode(ConstDeclNode node) {
        RubyNode moduleNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        Node constNode = node.getConstNode();
        if (constNode == null || constNode instanceof Colon2ImplicitNode) {
            moduleNode = new LexicalScopeNode(this.context, sourceSection, this.environment.getLexicalScope());
        } else if (constNode instanceof Colon2ConstNode) {
            constNode = ((Colon2Node)constNode).getLeftNode();
            moduleNode = constNode.accept(this);
        } else if (constNode instanceof Colon3Node) {
            moduleNode = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        } else {
            throw new UnsupportedOperationException();
        }
        return new WriteConstantNode(this.context, sourceSection, node.getName(), this.environment.getLexicalScope(), moduleNode, node.getValueNode().accept(this));
    }

    @Override
    public RubyNode visitConstNode(ConstNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        LexicalScope lexicalScope = this.environment.getLexicalScope();
        LexicalScopeNode moduleNode = new LexicalScopeNode(this.context, sourceSection, lexicalScope);
        return new ReadConstantNode(this.context, sourceSection, node.getName(), moduleNode, lexicalScope);
    }

    @Override
    public RubyNode visitDAsgnNode(DAsgnNode node) {
        return new LocalAsgnNode(node.getPosition(), node.getName(), node.getDepth(), node.getValueNode()).accept(this);
    }

    @Override
    public RubyNode visitDRegxNode(DRegexpNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> children = new ArrayList<RubyNode>();
        for (Node child : node.childNodes()) {
            children.add(child.accept(this));
        }
        InteroplatedRegexpNode i2 = new InteroplatedRegexpNode(this.context, sourceSection, children.toArray(new RubyNode[children.size()]), node.getOptions());
        if (node.getOptions().isOnce()) {
            return new OnceNode(this.context, i2.getEncapsulatingSourceSection(), i2);
        }
        return i2;
    }

    @Override
    public RubyNode visitDStrNode(DStrNode node) {
        return this.translateInterpolatedString(this.translate(node.getPosition()), node.childNodes());
    }

    @Override
    public RubyNode visitDSymbolNode(DSymbolNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode stringNode = this.translateInterpolatedString(sourceSection, node.childNodes());
        return StringToSymbolNodeFactory.create(this.context, sourceSection, stringNode);
    }

    private RubyNode translateInterpolatedString(SourceSection sourceSection, List<Node> childNodes) {
        ArrayList<ToSNode> children = new ArrayList<ToSNode>();
        for (Node child : childNodes) {
            children.add(ToSNodeFactory.create(this.context, sourceSection, child.accept(this)));
        }
        return new InterpolatedStringNode(this.context, sourceSection, children.toArray(new ToSNode[children.size()]));
    }

    @Override
    public RubyNode visitDVarNode(DVarNode node) {
        RubyNode readNode = this.environment.findLocalVarNode(node.getName(), this.translate(node.getPosition()));
        if (readNode == null) {
            int depth = node.getDepth();
            TranslatorEnvironment e = this.environment;
            for (int n = 0; n < depth; ++n) {
                e = e.getParent();
            }
            e.declareVar(node.getName());
            readNode = e.findLocalVarNode(node.getName(), this.translate(node.getPosition()));
        }
        return readNode;
    }

    @Override
    public RubyNode visitDXStrNode(DXStrNode node) {
        DStrNode string2 = new DStrNode(node.getPosition(), node.getEncoding());
        string2.childNodes().addAll(node.childNodes());
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), string2, new Node[0]);
        FCallNode callNode = new FCallNode(node.getPosition(), "`", argsNode, null);
        return ((Node)callNode).accept(this);
    }

    @Override
    public RubyNode visitDefinedNode(DefinedNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        Node expressionNode = node.getExpressionNode();
        while (expressionNode instanceof NewlineNode) {
            expressionNode = ((NewlineNode)expressionNode).getNextNode();
        }
        return new org.jruby.truffle.nodes.DefinedNode(this.context, sourceSection, node.getExpressionNode().accept(this));
    }

    @Override
    public RubyNode visitDefnNode(DefnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode classNode = this.topLevel ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass()) : new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection);
        return this.translateMethodDefinition(sourceSection, classNode, node.getName(), node, node.getArgsNode(), node.getBodyNode());
    }

    @Override
    public RubyNode visitDefsNode(DefsNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode objectNode = node.getReceiverNode().accept(this);
        SingletonClassNode singletonClassNode = SingletonClassNodeFactory.create(this.context, sourceSection, objectNode);
        return new SetMethodDeclarationContext(this.context, sourceSection, "defs", this.translateMethodDefinition(sourceSection, singletonClassNode, node.getName(), node, node.getArgsNode(), node.getBodyNode()));
    }

    protected RubyNode translateMethodDefinition(SourceSection sourceSection, RubyNode classNode, String methodName, Node parseTree, ArgsNode argsNode, Node bodyNode) {
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.environment.getLexicalScope(), methodName, false, parseTree, false);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParser(), this.environment.getParser().allocateReturnID(), true, true, sharedMethodInfo, methodName, false);
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, false, this.source);
        MethodDefinitionNode functionExprNode = (MethodDefinitionNode)methodCompiler.compileFunctionNode(sourceSection, methodName, argsNode, bodyNode, sharedMethodInfo);
        return new AddMethodNode(this.context, sourceSection, classNode, functionExprNode);
    }

    @Override
    public RubyNode visitDotNode(DotNode node) {
        RubyNode begin2 = node.getBeginNode().accept(this);
        RubyNode end2 = node.getEndNode().accept(this);
        SourceSection sourceSection = this.translate(node.getPosition());
        return RangeLiteralNodeFactory.create(this.context, sourceSection, node.isExclusive(), begin2, end2);
    }

    @Override
    public RubyNode visitEncodingNode(EncodingNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new ObjectLiteralNode(this.context, sourceSection, RubyEncoding.getEncoding(node.getEncoding()));
    }

    @Override
    public RubyNode visitEnsureNode(org.jruby.ast.EnsureNode node) {
        RubyNode tryPart = node.getBodyNode().accept(this);
        RubyNode ensurePart = node.getEnsureNode().accept(this);
        return new EnsureNode(this.context, this.translate(node.getPosition()), tryPart, ensurePart);
    }

    @Override
    public RubyNode visitEvStrNode(EvStrNode node) {
        return node.getBody().accept(this);
    }

    @Override
    public RubyNode visitFCallNode(FCallNode node) {
        if (Options.TRUFFLE_DEBUG_ENABLE_ASSERT_CONSTANT.load().booleanValue() && node.getName().equals("truffle_assert_constant")) {
            SourceSection sourceSection = this.translate(node.getPosition());
            return AssertCompilationConstantNodeFactory.create(this.context, sourceSection, node.getArgsNode().childNodes().get(0).accept(this));
        }
        SelfNode receiver2 = new SelfNode(node.getPosition());
        CallNode callNode = new CallNode(node.getPosition(), receiver2, node.getName(), node.getArgsNode(), node.getIterNode());
        return this.visitCallNodeExtraArgument(callNode, null, true, false);
    }

    @Override
    public RubyNode visitFalseNode(FalseNode node) {
        return new BooleanLiteralNode(this.context, this.translate(node.getPosition()), false);
    }

    @Override
    public RubyNode visitFixnumNode(FixnumNode node) {
        long value2 = node.getValue();
        if (CoreLibrary.fitsIntoInteger(value2)) {
            return new FixnumLiteralNode.IntegerFixnumLiteralNode(this.context, this.translate(node.getPosition()), (int)value2);
        }
        return new FixnumLiteralNode.LongFixnumLiteralNode(this.context, this.translate(node.getPosition()), value2);
    }

    @Override
    public RubyNode visitFlipNode(FlipNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode begin2 = node.getBeginNode().accept(this);
        RubyNode end2 = node.getEndNode().accept(this);
        BooleanCastNode beginCast = BooleanCastNodeFactory.create(this.context, sourceSection, begin2);
        BooleanCastNode endCast = BooleanCastNodeFactory.create(this.context, sourceSection, end2);
        FlipFlopStateNode stateNode = this.createFlipFlopState(sourceSection, 0);
        return new FlipFlopNode(this.context, sourceSection, beginCast, endCast, stateNode, node.isExclusive());
    }

    protected FlipFlopStateNode createFlipFlopState(SourceSection sourceSection, int depth) {
        FrameSlot frameSlot = this.environment.declareVar(this.environment.allocateLocalTemp("flipflop"));
        this.environment.getFlipFlopStates().add(frameSlot);
        if (depth == 0) {
            return new LocalFlipFlopStateNode(sourceSection, frameSlot);
        }
        return new LevelFlipFlopStateNode(sourceSection, depth, frameSlot);
    }

    @Override
    public RubyNode visitFloatNode(FloatNode node) {
        return new FloatLiteralNode(this.context, this.translate(node.getPosition()), node.getValue());
    }

    @Override
    public RubyNode visitForNode(org.jruby.ast.ForNode node) {
        String temp = this.environment.allocateLocalTemp("for");
        Node receiver2 = node.getIterNode();
        LocalVarNode readTemp = new LocalVarNode(node.getPosition(), 0, temp);
        Node forVar = node.getVarNode();
        Node assignTemp = BodyTranslator.setRHS(forVar, readTemp);
        BlockNode bodyWithTempAssign = new BlockNode(node.getPosition());
        bodyWithTempAssign.add(assignTemp);
        bodyWithTempAssign.add(node.getBodyNode());
        ArgumentNode blockVar = new ArgumentNode(node.getPosition(), temp);
        ListNode blockArgsPre = new ListNode(node.getPosition(), blockVar);
        ArgsNode blockArgs = new ArgsNode(node.getPosition(), blockArgsPre, null, null, null, null, null, null);
        IterNode block = new IterNode(node.getPosition(), (Node)blockArgs, node.getScope(), bodyWithTempAssign);
        CallNode callNode = new CallNode(node.getPosition(), receiver2, "each", null, block);
        this.translatingForStatement = true;
        RubyCallNode translated = (RubyCallNode)callNode.accept(this);
        this.translatingForStatement = false;
        return new ForNode(this.context, translated.getSourceSection(), translated);
    }

    private static Node setRHS(Node node, Node rhs) {
        if (node instanceof LocalAsgnNode) {
            LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
            return new LocalAsgnNode(node.getPosition(), localAsgnNode.getName(), 0, rhs);
        }
        if (node instanceof DAsgnNode) {
            DAsgnNode dAsgnNode = (DAsgnNode)node;
            return new DAsgnNode(node.getPosition(), dAsgnNode.getName(), 0, rhs);
        }
        if (node instanceof MultipleAsgn19Node) {
            MultipleAsgn19Node multAsgnNode = (MultipleAsgn19Node)node;
            MultipleAsgn19Node newNode = new MultipleAsgn19Node(node.getPosition(), multAsgnNode.getPre(), multAsgnNode.getRest(), multAsgnNode.getPost());
            newNode.setValueNode(rhs);
            return newNode;
        }
        if (node instanceof InstAsgnNode) {
            InstAsgnNode instAsgnNode = (InstAsgnNode)node;
            return new InstAsgnNode(node.getPosition(), instAsgnNode.getName(), rhs);
        }
        if (node instanceof ClassVarAsgnNode) {
            ClassVarAsgnNode instAsgnNode = (ClassVarAsgnNode)node;
            return new ClassVarAsgnNode(node.getPosition(), instAsgnNode.getName(), rhs);
        }
        if (node instanceof ConstDeclNode) {
            ConstDeclNode constDeclNode = (ConstDeclNode)node;
            return new ConstDeclNode(node.getPosition(), constDeclNode.getName(), (INameNode)((Object)constDeclNode.getConstNode()), rhs);
        }
        throw new UnsupportedOperationException("Don't know how to set the RHS of a " + node.getClass().getName());
    }

    private void initReadOnlyGlobalVariables() {
        Set<String> s2 = this.readOnlyGlobalVariables;
        s2.add("$:");
        s2.add("$LOAD_PATH");
        s2.add("$-I");
        s2.add("$\"");
        s2.add("$LOADED_FEATURES");
        s2.add("$<");
        s2.add("$FILENAME");
        s2.add("$?");
        s2.add("$-a");
        s2.add("$-l");
        s2.add("$-p");
    }

    private void initGlobalVariableAliases() {
        Map<String, String> m = this.globalVariableAliases;
        m.put("$-I", "$LOAD_PATH");
        m.put("$:", "$LOAD_PATH");
        m.put("$-d", "$DEBUG");
        m.put("$-v", "$VERBOSE");
        m.put("$-w", "$VERBOSE");
        m.put("$-0", "$/");
    }

    @Override
    public RubyNode visitGlobalAsgnNode(GlobalAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name2 = node.getName();
        if (this.globalVariableAliases.containsKey(name2)) {
            name2 = this.globalVariableAliases.get(name2);
        }
        RubyNode rhs = node.getValueNode().accept(this);
        if (name2.equals("$~")) {
            rhs = new CheckMatchVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name2.equals("$0")) {
            rhs = new CheckProgramNameVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name2.equals("$/")) {
            rhs = new CheckRecordSeparatorVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name2.equals("$,")) {
            rhs = new CheckOutputSeparatorVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name2.equals("$_")) {
            rhs = WrapInThreadLocalNodeFactory.create(this.context, sourceSection, rhs);
        }
        if (this.readOnlyGlobalVariables.contains(name2)) {
            return new WriteReadOnlyGlobalNode(this.context, sourceSection, name2, rhs);
        }
        if (THREAD_LOCAL_GLOBAL_VARIABLES.contains(name2)) {
            ThreadLocalObjectNode threadLocalVariablesObjectNode = new ThreadLocalObjectNode(this.context, sourceSection);
            return new WriteInstanceVariableNode(this.context, sourceSection, name2, threadLocalVariablesObjectNode, rhs, true);
        }
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name2)) {
            RubyNode localVarNode;
            if (this.environment.getNeverAssignInParentScope()) {
                this.environment.declareVar(name2);
            }
            if ((localVarNode = this.environment.findLocalVarNode(node.getName(), sourceSection)) == null) {
                if (this.environment.hasOwnScopeForAssignments()) {
                    this.environment.declareVar(node.getName());
                }
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
                localVarNode = this.environment.findLocalVarNode(node.getName(), sourceSection);
                if (localVarNode == null) {
                    throw new RuntimeException("shoudln't be here");
                }
            }
            return ((ReadNode)((Object)localVarNode)).makeWriteNode(rhs);
        }
        if (name2.equals("$stdout")) {
            rhs = new CheckStdoutVariableTypeNode(this.context, sourceSection, rhs);
        }
        ObjectLiteralNode globalVariablesObjectNode = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getGlobalVariablesObject());
        return new WriteInstanceVariableNode(this.context, sourceSection, name2, globalVariablesObjectNode, rhs, true);
    }

    @Override
    public RubyNode visitGlobalVarNode(GlobalVarNode node) {
        String name2 = node.getName();
        if (this.globalVariableAliases.containsKey(name2)) {
            name2 = this.globalVariableAliases.get(name2);
        }
        SourceSection sourceSection = this.translate(node.getPosition());
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name2)) {
            this.environment.declareVarWhereAllowed(name2);
            RubyNode readNode = this.environment.findLocalVarNode(name2, sourceSection);
            if (name2.equals("$_")) {
                readNode = GetFromThreadLocalNodeFactory.create(this.context, sourceSection, readNode);
            }
            return readNode;
        }
        if (THREAD_LOCAL_GLOBAL_VARIABLES.contains(name2)) {
            ThreadLocalObjectNode threadLocalVariablesObjectNode = new ThreadLocalObjectNode(this.context, sourceSection);
            return new ReadInstanceVariableNode(this.context, sourceSection, name2, threadLocalVariablesObjectNode, true);
        }
        ObjectLiteralNode globalVariablesObjectNode = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getGlobalVariablesObject());
        return new ReadInstanceVariableNode(this.context, sourceSection, name2, globalVariablesObjectNode, true);
    }

    @Override
    public RubyNode visitHashNode(HashNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> hashConcats = new ArrayList<RubyNode>();
        ArrayList<RubyNode> keyValues = new ArrayList<RubyNode>();
        for (KeyValuePair<Node, Node> pair : node.getPairs()) {
            if (pair.getKey() == null) {
                HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, this.translate(node.getPosition()), keyValues.toArray(new RubyNode[keyValues.size()]));
                hashConcats.add(hashLiteralSoFar);
                hashConcats.add(HashCastNodeFactory.create(this.context, sourceSection, pair.getValue().accept(this)));
                keyValues.clear();
                continue;
            }
            keyValues.add(pair.getKey().accept(this));
            if (pair.getValue() == null) {
                keyValues.add(new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()));
                continue;
            }
            keyValues.add(pair.getValue().accept(this));
        }
        HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, this.translate(node.getPosition()), keyValues.toArray(new RubyNode[keyValues.size()]));
        hashConcats.add(hashLiteralSoFar);
        if (hashConcats.size() == 1) {
            return (RubyNode)hashConcats.get(0);
        }
        return new ConcatHashLiteralNode(this.context, sourceSection, hashConcats.toArray(new RubyNode[hashConcats.size()]));
    }

    @Override
    public RubyNode visitIfNode(org.jruby.ast.IfNode node) {
        Node elseBody;
        SourceSection sourceSection = this.translate(node.getPosition());
        Node thenBody = node.getThenBody();
        if (thenBody == null) {
            thenBody = new NilNode(node.getPosition());
        }
        if ((elseBody = node.getElseBody()) == null) {
            elseBody = new NilNode(node.getPosition());
        }
        RubyNode condition = node.getCondition() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : node.getCondition().accept(this);
        BooleanCastNode conditionCast = BooleanCastNodeFactory.create(this.context, sourceSection, condition);
        RubyNode thenBodyTranslated = thenBody.accept(this);
        RubyNode elseBodyTranslated = elseBody.accept(this);
        return new IfNode(this.context, sourceSection, conditionCast, thenBodyTranslated, elseBodyTranslated);
    }

    @Override
    public RubyNode visitInstAsgnNode(InstAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String nameWithoutSigil = node.getName();
        org.jruby.truffle.nodes.objects.SelfNode receiver2 = new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection);
        RubyNode rhs = node.getValueNode() == null ? new DeadNode(this.context, sourceSection, "null RHS of instance variable assignment") : node.getValueNode().accept(this);
        return new WriteInstanceVariableNode(this.context, sourceSection, nameWithoutSigil, receiver2, rhs, false);
    }

    @Override
    public RubyNode visitInstVarNode(InstVarNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String nameWithoutSigil = node.getName();
        org.jruby.truffle.nodes.objects.SelfNode receiver2 = new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection);
        return new ReadInstanceVariableNode(this.context, sourceSection, nameWithoutSigil, receiver2, false);
    }

    @Override
    public RubyNode visitIterNode(IterNode node) {
        ArgsNode argsNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        boolean hasOwnScope = !this.translatingForStatement;
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.environment.getLexicalScope(), this.currentCallMethodName, true, node, false);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParser(), this.environment.getReturnID(), hasOwnScope, false, sharedMethodInfo, this.environment.getNamedMethodName(), true);
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, true, this.source);
        methodCompiler.translatingForStatement = this.translatingForStatement;
        if (node.getVarNode() instanceof ArgsNode) {
            argsNode = (ArgsNode)node.getVarNode();
        } else if (node.getVarNode() instanceof DAsgnNode) {
            ArgumentNode arg2 = new ArgumentNode(node.getPosition(), ((DAsgnNode)node.getVarNode()).getName());
            ArrayNode preArgs = new ArrayNode(node.getPosition(), arg2);
            argsNode = new ArgsNode(node.getPosition(), preArgs, null, null, null, null, null, null);
        } else if (node.getVarNode() == null) {
            argsNode = null;
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.translatingForStatement && this.useClassVariablesAsIfInClass) {
            methodCompiler.useClassVariablesAsIfInClass = true;
        }
        return methodCompiler.compileFunctionNode(this.translate(node.getPosition()), sharedMethodInfo.getName(), argsNode, node.getBodyNode(), sharedMethodInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitLocalAsgnNode(LocalAsgnNode node) {
        RubyNode rhs;
        RubyNode lhs;
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.getNeverAssignInParentScope()) {
            this.environment.declareVar(node.getName());
        }
        if ((lhs = this.environment.findLocalVarNode(node.getName(), sourceSection)) == null) {
            if (this.environment.hasOwnScopeForAssignments()) {
                this.environment.declareVar(node.getName());
            } else {
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
            }
            lhs = this.environment.findLocalVarNode(node.getName(), sourceSection);
            if (lhs == null) {
                throw new RuntimeException("shouldn't be here");
            }
        }
        if (node.getValueNode() == null) {
            rhs = new DeadNode(this.context, sourceSection, "null RHS of local variable assignment");
        } else {
            if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection = sourceSection;
            }
            try {
                rhs = node.getValueNode().accept(this);
            }
            finally {
                if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                    this.parentSourceSection = null;
                }
            }
        }
        return ((ReadNode)((Object)lhs)).makeWriteNode(rhs);
    }

    @Override
    public RubyNode visitLocalVarNode(LocalVarNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name2 = node.getName();
        RubyNode readNode = this.environment.findLocalVarNode(name2, sourceSection);
        if (readNode == null) {
            this.environment.declareVar(node.getName());
            readNode = this.environment.findLocalVarNode(name2, sourceSection);
        }
        return readNode;
    }

    @Override
    public RubyNode visitMatchNode(MatchNode node) {
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), new GlobalVarNode(node.getPosition(), "$_"), new Node[0]);
        CallNode callNode = new CallNode(node.getPosition(), node.getRegexpNode(), "=~", argsNode, null);
        return ((Node)callNode).accept(this);
    }

    @Override
    public RubyNode visitMatch2Node(Match2Node node) {
        RegexpNode regexpNode;
        Regex regex;
        if (node.getReceiverNode() instanceof RegexpNode && (regex = new Regex((regexpNode = (RegexpNode)node.getReceiverNode()).getValue().bytes(), 0, regexpNode.getValue().length(), regexpNode.getOptions().toOptions(), regexpNode.getEncoding(), Syntax.RUBY)).numberOfNames() > 0) {
            Iterator<NameEntry> i2 = regex.namedBackrefIterator();
            while (i2.hasNext()) {
                NameEntry e = i2.next();
                String name2 = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                if (this.environment.hasOwnScopeForAssignments()) {
                    this.environment.declareVar(name2);
                    continue;
                }
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(name2);
            }
        }
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]);
        CallNode callNode = new CallNode(node.getPosition(), node.getReceiverNode(), "=~", argsNode, null);
        return ((Node)callNode).accept(this);
    }

    @Override
    public RubyNode visitMatch3Node(Match3Node node) {
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]);
        CallNode callNode = new CallNode(node.getPosition(), node.getReceiverNode(), "=~", argsNode, null);
        return ((Node)callNode).accept(this);
    }

    @Override
    public RubyNode visitModuleNode(ModuleNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name2 = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        DefineOrGetModuleNode defineModuleNode = new DefineOrGetModuleNode(this.context, sourceSection, name2, lexicalParent);
        return this.openModule(sourceSection, defineModuleNode, name2, node.getBodyNode());
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgnNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgn19Node node) {
        RubyNode result2;
        RubyNode rhsTranslated;
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayNode preArray = (ArrayNode)node.getPre();
        ArrayNode postArray = (ArrayNode)node.getPost();
        Node rhs = node.getValueNode();
        if (rhs == null) {
            this.context.getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, node.getPosition().getFile(), node.getPosition().getLine(), "no RHS for multiple assignment - using nil");
            rhsTranslated = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        } else {
            rhsTranslated = rhs.accept(this);
        }
        if (preArray != null && node.getPost() == null && node.getRest() == null && rhsTranslated instanceof ArrayLiteralNode.UninitialisedArrayLiteralNode && ((ArrayLiteralNode.UninitialisedArrayLiteralNode)rhsTranslated).getValues().length == preArray.size()) {
            RubyNode[] rhsValues = ((ArrayLiteralNode.UninitialisedArrayLiteralNode)rhsTranslated).getValues();
            int assignedValuesCount = preArray.size();
            RubyNode[] sequence = new RubyNode[assignedValuesCount * 2];
            RubyNode[] tempValues = new RubyNode[assignedValuesCount];
            for (int n = 0; n < assignedValuesCount; ++n) {
                String tempName = this.environment.allocateLocalTemp("multi");
                RubyNode readTemp = this.environment.findLocalVarNode(tempName, sourceSection);
                RubyNode assignTemp = ((ReadNode)((Object)NodeUtil.cloneNode(readTemp))).makeWriteNode(rhsValues[n]);
                RubyNode assignFinalValue = this.translateDummyAssignment(preArray.get(n), NodeUtil.cloneNode(readTemp));
                sequence[n] = assignTemp;
                sequence[assignedValuesCount + n] = assignFinalValue;
                tempValues[n] = NodeUtil.cloneNode(readTemp);
            }
            RubyNode blockNode = SequenceNode.sequence(this.context, sourceSection, sequence);
            ArrayLiteralNode.UninitialisedArrayLiteralNode arrayNode = new ArrayLiteralNode.UninitialisedArrayLiteralNode(this.context, sourceSection, tempValues);
            ElidableResultNode elidableResult = new ElidableResultNode(this.context, sourceSection, blockNode, arrayNode);
            result2 = elidableResult;
        } else if (preArray != null) {
            ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = ((ReadNode)((Object)this.environment.findLocalVarNode(tempRHSName, sourceSection))).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            String tempName = this.environment.allocateLocalTemp("array");
            SplatCastNode splatCastNode = SplatCastNodeFactory.create(this.context, sourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, false, this.environment.findLocalVarNode(tempRHSName, sourceSection));
            RubyNode writeTemp = ((ReadNode)((Object)this.environment.findLocalVarNode(tempName, sourceSection))).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            for (int n = 0; n < preArray.size(); ++n) {
                ArrayIndexNode assignedValue = ArrayIndexNodeFactory.create(this.context, sourceSection, n, this.environment.findLocalVarNode(tempName, sourceSection));
                sequence.add(this.translateDummyAssignment(preArray.get(n), assignedValue));
            }
            if (node.getRest() != null) {
                ArrayGetTailNode assignedValue = ArrayGetTailNodeFactory.create(this.context, sourceSection, preArray.size(), this.environment.findLocalVarNode(tempName, sourceSection));
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            result2 = new ElidableResultNode(this.context, sourceSection, SequenceNode.sequence(this.context, sourceSection, sequence), this.environment.findLocalVarNode(tempRHSName, sourceSection));
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() instanceof StarNode) {
            result2 = rhsTranslated;
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && !(rhs instanceof ArrayNode)) {
            ReadNode restRead;
            RubyNode restTranslated = node.getRest().accept(this).getNonProxyNode();
            if (restTranslated instanceof ReadNode) {
                restRead = (ReadNode)((Object)restTranslated);
            } else if (restTranslated instanceof WriteNode) {
                restRead = (ReadNode)((Object)((WriteNode)((Object)restTranslated)).makeReadNode());
            } else {
                throw new RuntimeException("Unknown form of multiple assignment " + node + " at " + node.getPosition());
            }
            SplatCastNode rhsSplatCast = SplatCastNodeFactory.create(this.context, sourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, false, rhsTranslated);
            result2 = restRead.makeWriteNode(rhsSplatCast);
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && rhs instanceof ArrayNode) {
            ReadNode restRead;
            RubyNode restTranslated = node.getRest().accept(this).getNonProxyNode();
            if (restTranslated instanceof ReadNode) {
                restRead = (ReadNode)((Object)restTranslated);
            } else if (restTranslated instanceof WriteNode) {
                restRead = (ReadNode)((Object)((WriteNode)((Object)restTranslated)).makeReadNode());
            } else {
                throw new RuntimeException("Unknown form of multiple assignment " + node + " at " + node.getPosition());
            }
            result2 = restRead.makeWriteNode(rhsTranslated);
        } else if (node.getPre() == null && node.getRest() != null && node.getPost() != null) {
            String tempName = this.environment.allocateLocalTemp("array");
            ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
            SplatCastNode splatCastNode = SplatCastNodeFactory.create(this.context, sourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, false, rhsTranslated);
            RubyNode writeTemp = ((ReadNode)((Object)this.environment.findLocalVarNode(tempName, sourceSection))).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            if (node.getRest() != null) {
                ArrayDropTailNode assignedValue = ArrayDropTailNodeFactory.create(this.context, sourceSection, postArray.size(), this.environment.findLocalVarNode(tempName, sourceSection));
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            for (int n = 0; n < postArray.size(); ++n) {
                ArrayIndexNode assignedValue = ArrayIndexNodeFactory.create(this.context, sourceSection, -(postArray.size() - n), this.environment.findLocalVarNode(tempName, sourceSection));
                sequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
            }
            result2 = SequenceNode.sequence(this.context, sourceSection, sequence);
        } else {
            this.context.getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, node.getPosition().getFile(), node.getPosition().getLine(), node + " unknown form of multiple assignment");
            result2 = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        }
        return new AssignmentWrapperNode(this.context, sourceSection, result2);
    }

    private RubyNode translateDummyAssignment(Node dummyAssignment, RubyNode rhs) {
        RubyNode translated;
        SourceSection sourceSection = this.translate(dummyAssignment.getPosition());
        if (dummyAssignment instanceof LocalAsgnNode) {
            WriteNode dummyTranslated = (WriteNode)((Object)dummyAssignment.accept(this).getNonProxyNode());
            translated = ((ReadNode)((Object)dummyTranslated.makeReadNode())).makeWriteNode(rhs);
        } else if (dummyAssignment instanceof InstAsgnNode) {
            WriteInstanceVariableNode dummyTranslated = (WriteInstanceVariableNode)dummyAssignment.accept(this);
            translated = ((ReadNode)((Object)dummyTranslated.makeReadNode())).makeWriteNode(rhs);
        } else if (dummyAssignment instanceof AttrAssignNode) {
            AttrAssignNode dummyAttrAssignment = (AttrAssignNode)dummyAssignment;
            translated = this.visitAttrAssignNodeExtraArgument(dummyAttrAssignment, rhs);
        } else {
            RubyNode dummyTranslated;
            translated = dummyAssignment instanceof DAsgnNode ? ((dummyTranslated = dummyAssignment.accept(this)).getNonProxyNode() instanceof WriteLevelVariableNode ? ((ReadNode)((Object)((WriteLevelVariableNode)dummyTranslated.getNonProxyNode()).makeReadNode())).makeWriteNode(rhs) : ((ReadNode)((Object)((WriteLocalVariableNode)dummyTranslated.getNonProxyNode()).makeReadNode())).makeWriteNode(rhs)) : ((ReadNode)((Object)this.environment.findLocalVarNode(this.environment.allocateLocalTemp("dummy"), sourceSection))).makeWriteNode(rhs);
        }
        return translated;
    }

    @Override
    public RubyNode visitNewlineNode(NewlineNode node) {
        RubyNode child = node.getNextNode().accept(this);
        return new TraceNode(this.context, child.getSourceSection(), child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitNextNode(NextNode node) {
        RubyNode resultNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        if (node.getValueNode() == null) {
            this.parentSourceSection = sourceSection;
            try {
                resultNode = new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
            }
            finally {
                this.parentSourceSection = null;
            }
        }
        boolean t = this.translatingNextExpression;
        this.translatingNextExpression = true;
        if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
            this.parentSourceSection = sourceSection;
        }
        try {
            resultNode = node.getValueNode().accept(this);
        }
        finally {
            if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection = null;
            }
            this.translatingNextExpression = t;
        }
        return new org.jruby.truffle.nodes.control.NextNode(this.context, sourceSection, resultNode);
    }

    @Override
    public RubyNode visitNilNode(NilNode node) {
        if (node.getPosition() == InvalidSourcePosition.INSTANCE && this.parentSourceSection == null) {
            return new DeadNode(this.context, null, "nil node with no invalid source position - assumed to be implicit null");
        }
        return new NilLiteralNode(this.context, this.translate(node.getPosition()));
    }

    @Override
    public RubyNode visitNthRefNode(NthRefNode node) {
        return new ReadMatchReferenceNode(this.context, this.translate(node.getPosition()), node.getMatchNumber());
    }

    @Override
    public RubyNode visitOpAsgnAndNode(OpAsgnAndNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        Node lhs = node.getFirstNode();
        Node rhs = node.getSecondNode();
        return new AssignmentWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.control.AndNode(this.context, sourceSection, lhs.accept(this), rhs.accept(this)));
    }

    @Override
    public RubyNode visitOpAsgnNode(OpAsgnNode node) {
        if (node.getOperatorName().equals("||")) {
            String temp = this.environment.allocateLocalTemp("opassign");
            LocalAsgnNode writeReceiverToTemp = new LocalAsgnNode(node.getPosition(), temp, 0, node.getReceiverNode());
            LocalVarNode readReceiverFromTemp = new LocalVarNode(node.getPosition(), 0, temp);
            CallNode readMethod = new CallNode(node.getPosition(), readReceiverFromTemp, node.getVariableName(), null, null);
            CallNode writeMethod = new CallNode(node.getPosition(), readReceiverFromTemp, node.getVariableName() + "=", BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]), null);
            SourceSection sourceSection = this.translate(node.getPosition());
            RubyNode lhs = ((Node)readMethod).accept(this);
            RubyNode rhs = ((Node)writeMethod).accept(this);
            return new AssignmentWrapperNode(this.context, sourceSection, SequenceNode.sequence(this.context, sourceSection, ((Node)writeReceiverToTemp).accept(this), new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, lhs, rhs)));
        }
        String temp = this.environment.allocateLocalTemp("opassign");
        LocalAsgnNode writeReceiverToTemp = new LocalAsgnNode(node.getPosition(), temp, 0, node.getReceiverNode());
        LocalVarNode readReceiverFromTemp = new LocalVarNode(node.getPosition(), 0, temp);
        CallNode readMethod = new CallNode(node.getPosition(), readReceiverFromTemp, node.getVariableName(), null, null);
        CallNode operation = new CallNode(node.getPosition(), readMethod, node.getOperatorName(), BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]), null);
        CallNode writeMethod = new CallNode(node.getPosition(), readReceiverFromTemp, node.getVariableName() + "=", BodyTranslator.buildArrayNode(node.getPosition(), operation, new Node[0]), null);
        BlockNode block = new BlockNode(node.getPosition());
        block.add(writeReceiverToTemp);
        block.add(writeMethod);
        return block.accept(this);
    }

    @Override
    public RubyNode visitOpAsgnOrNode(OpAsgnOrNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode lhs = node.getFirstNode().accept(this);
        RubyNode rhs = node.getSecondNode().accept(this);
        if (node.getFirstNode().needsDefinitionCheck()) {
            org.jruby.truffle.nodes.DefinedNode defined = new org.jruby.truffle.nodes.DefinedNode(this.context, lhs.getSourceSection(), lhs);
            lhs = new org.jruby.truffle.nodes.control.AndNode(this.context, lhs.getSourceSection(), defined, lhs);
        }
        return new AssignmentWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, lhs, rhs));
    }

    @Override
    public RubyNode visitOpElementAsgnNode(OpElementAsgnNode node) {
        Node index2 = node.getArgsNode() == null ? null : node.getArgsNode().childNodes().get(0);
        Node operand = node.getValueNode();
        String temp = this.environment.allocateLocalTemp("opelementassign");
        LocalAsgnNode writeArrayToTemp = new LocalAsgnNode(node.getPosition(), temp, 0, node.getReceiverNode());
        LocalVarNode readArrayFromTemp = new LocalVarNode(node.getPosition(), 0, temp);
        CallNode arrayRead = new CallNode(node.getPosition(), readArrayFromTemp, "[]", BodyTranslator.buildArrayNode(node.getPosition(), index2, new Node[0]), null);
        String op = node.getOperatorName();
        Node operation = null;
        operation = op.equals("||") ? new OrNode(node.getPosition(), arrayRead, operand) : (op.equals("&&") ? new AndNode(node.getPosition(), arrayRead, operand) : new CallNode(node.getPosition(), arrayRead, node.getOperatorName(), BodyTranslator.buildArrayNode(node.getPosition(), operand, new Node[0]), null));
        CallNode arrayWrite = new CallNode(node.getPosition(), readArrayFromTemp, "[]=", BodyTranslator.buildArrayNode(node.getPosition(), index2, operation), null);
        BlockNode block = new BlockNode(node.getPosition());
        block.add(writeArrayToTemp);
        block.add(arrayWrite);
        return block.accept(this);
    }

    private static ArrayNode buildArrayNode(ISourcePosition sourcePosition, Node first2, Node ... rest2) {
        if (first2 == null) {
            return new ArrayNode(sourcePosition);
        }
        ArrayNode array = new ArrayNode(sourcePosition, first2);
        for (Node node : rest2) {
            array.add(node);
        }
        return array;
    }

    @Override
    public RubyNode visitOrNode(OrNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode x = node.getFirstNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : node.getFirstNode().accept(this);
        RubyNode y = node.getSecondNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : node.getSecondNode().accept(this);
        return new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, x, y);
    }

    @Override
    public RubyNode visitPreExeNode(PreExeNode node) {
        return node.getBodyNode().accept(this);
    }

    @Override
    public RubyNode visitPostExeNode(PostExeNode node) {
        return node.getBodyNode().accept(this);
    }

    @Override
    public RubyNode visitRationalNode(RationalNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.translateRationalComplex(sourceSection, "Rational", new FixnumLiteralNode.LongFixnumLiteralNode(this.context, sourceSection, node.getNumerator()), new FixnumLiteralNode.LongFixnumLiteralNode(this.context, sourceSection, node.getDenominator()));
    }

    private RubyNode translateRationalComplex(SourceSection sourceSection, String name2, RubyNode a, RubyNode b2) {
        LexicalScope lexicalScope = this.environment.getLexicalScope();
        LexicalScopeNode moduleNode = new LexicalScopeNode(this.context, sourceSection, lexicalScope);
        return new RubyCallNode(this.context, sourceSection, "convert", (RubyNode)new ReadConstantNode(this.context, sourceSection, name2, moduleNode, lexicalScope), null, false, true, false, a, b2);
    }

    @Override
    public RubyNode visitRedoNode(RedoNode node) {
        return new org.jruby.truffle.nodes.control.RedoNode(this.context, this.translate(node.getPosition()));
    }

    @Override
    public RubyNode visitRegexpNode(RegexpNode node) {
        Regex regex = RubyRegexp.compile(this.currentNode, this.context, node.getValue().bytes(), node.getEncoding(), node.getOptions().toOptions());
        RubyRegexp regexp2 = new RubyRegexp(this.context.getCoreLibrary().getRegexpClass(), regex, node.getValue());
        if (node.getOptions().isEncodingNone()) {
            if (!BodyTranslator.all7Bit(node.getValue().bytes())) {
                regexp2.forceEncoding((RubyEncoding)this.context.getCoreLibrary().getEncodingClass().getConstants().get("ASCII_8BIT").getValue());
            } else {
                regexp2.forceEncoding((RubyEncoding)this.context.getCoreLibrary().getEncodingClass().getConstants().get("US_ASCII").getValue());
            }
        } else if (node.getOptions().getKCode().getKCode().equals("SJIS")) {
            regexp2.forceEncoding((RubyEncoding)this.context.getCoreLibrary().getEncodingClass().getConstants().get("Windows_31J").getValue());
        } else if (node.getOptions().getKCode().getKCode().equals("UTF8")) {
            regexp2.forceEncoding((RubyEncoding)this.context.getCoreLibrary().getEncodingClass().getConstants().get("UTF_8").getValue());
        } else {
            regexp2.forceEncoding(RubyEncoding.getEncoding(node.getEncoding()));
        }
        ObjectLiteralNode literalNode = new ObjectLiteralNode(this.context, this.translate(node.getPosition()), regexp2);
        if (node.getOptions().isOnce()) {
            return new OnceNode(this.context, literalNode.getEncapsulatingSourceSection(), literalNode);
        }
        return literalNode;
    }

    public static boolean all7Bit(byte[] bytes2) {
        for (int n = 0; n < bytes2.length; ++n) {
            if (bytes2[n] < 0) {
                return false;
            }
            if (bytes2[n] != 92 || n + 1 >= bytes2.length || bytes2[n + 1] != 120) continue;
            int b2 = Integer.parseInt(new String(Arrays.copyOfRange(bytes2, n + 2, n + 4), StandardCharsets.UTF_8), 16);
            if (b2 > 127) {
                return false;
            }
            n += 3;
        }
        return true;
    }

    @Override
    public RubyNode visitRescueNode(RescueNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode tryPart = node.getBodyNode() != null ? node.getBodyNode().accept(this) : new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        ArrayList<org.jruby.truffle.nodes.control.RescueNode> rescueNodes = new ArrayList<org.jruby.truffle.nodes.control.RescueNode>();
        for (RescueBodyNode rescueBody = node.getRescueNode(); rescueBody != null; rescueBody = rescueBody.getOptRescueNode()) {
            if (rescueBody.getExceptionNodes() != null) {
                org.jruby.truffle.nodes.control.RescueNode rescueNode;
                if (rescueBody.getExceptionNodes() instanceof ArrayNode) {
                    List<Node> exceptionNodes = ((ArrayNode)rescueBody.getExceptionNodes()).childNodes();
                    RubyNode[] handlingClasses = new RubyNode[exceptionNodes.size()];
                    for (int n = 0; n < handlingClasses.length; ++n) {
                        handlingClasses[n] = exceptionNodes.get(n).accept(this);
                    }
                    RubyNode translatedBody = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? new NilLiteralNode(this.context, sourceSection) : rescueBody.getBodyNode().accept(this);
                    rescueNode = new RescueClassesNode(this.context, sourceSection, handlingClasses, translatedBody);
                    rescueNodes.add(rescueNode);
                    continue;
                }
                if (rescueBody.getExceptionNodes() instanceof SplatNode) {
                    SplatNode splat = (SplatNode)rescueBody.getExceptionNodes();
                    RubyNode splatTranslated = splat.getValue() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : splat.getValue().accept(this);
                    RubyNode bodyTranslated = rescueBody.getBodyNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : rescueBody.getBodyNode().accept(this);
                    rescueNode = new RescueSplatNode(this.context, sourceSection, splatTranslated, bodyTranslated);
                    rescueNodes.add(rescueNode);
                    continue;
                }
                this.unimplemented(node);
                continue;
            }
            RubyNode bodyNode = rescueBody.getBodyNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : rescueBody.getBodyNode().accept(this);
            RescueAnyNode rescueNode = new RescueAnyNode(this.context, sourceSection, bodyNode);
            rescueNodes.add(rescueNode);
        }
        RubyNode elsePart = node.getElseNode() != null ? node.getElseNode().accept(this) : new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        return new TryNode(this.context, sourceSection, new ExceptionTranslatingNode(this.context, sourceSection, tryPart), rescueNodes.toArray(new org.jruby.truffle.nodes.control.RescueNode[rescueNodes.size()]), elsePart);
    }

    @Override
    public RubyNode visitRetryNode(org.jruby.ast.RetryNode node) {
        return new RetryNode(this.context, this.translate(node.getPosition()));
    }

    @Override
    public RubyNode visitReturnNode(org.jruby.ast.ReturnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode translatedChild = node.getValueNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : node.getValueNode().accept(this);
        return new ReturnNode(this.context, sourceSection, this.environment.getReturnID(), translatedChild);
    }

    @Override
    public RubyNode visitSClassNode(SClassNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode receiverNode = node.getReceiverNode().accept(this);
        SingletonClassNode singletonClassNode = SingletonClassNodeFactory.create(this.context, sourceSection, receiverNode);
        return this.openModule(sourceSection, singletonClassNode, "(singleton-def)", node.getBodyNode());
    }

    @Override
    public RubyNode visitSValueNode(SValueNode node) {
        return node.getValue().accept(this);
    }

    @Override
    public RubyNode visitSelfNode(SelfNode node) {
        return new org.jruby.truffle.nodes.objects.SelfNode(this.context, this.translate(node.getPosition()));
    }

    @Override
    public RubyNode visitSplatNode(SplatNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode value2 = node.getValue() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : node.getValue().accept(this);
        return SplatCastNodeFactory.create(this.context, sourceSection, SplatCastNode.NilBehavior.EMPTY_ARRAY, false, value2);
    }

    @Override
    public RubyNode visitStrNode(StrNode node) {
        return new StringLiteralNode(this.context, this.translate(node.getPosition()), node.getValue());
    }

    @Override
    public RubyNode visitSymbolNode(SymbolNode node) {
        return new ObjectLiteralNode(this.context, this.translate(node.getPosition()), this.context.newSymbol(node.getName()));
    }

    @Override
    public RubyNode visitTrueNode(TrueNode node) {
        return new BooleanLiteralNode(this.context, this.translate(node.getPosition()), true);
    }

    @Override
    public RubyNode visitUndefNode(UndefNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        org.jruby.truffle.nodes.objects.SelfNode classNode = new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection);
        return new org.jruby.truffle.nodes.methods.UndefNode(this.context, sourceSection, classNode, ((LiteralNode)node.getName()).getName());
    }

    @Override
    public RubyNode visitUntilNode(UntilNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode condition = node.getConditionNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : node.getConditionNode().accept(this);
        BooleanCastNode conditionCast = BooleanCastNodeFactory.create(this.context, sourceSection, condition);
        NotNode conditionCastNot = new NotNode(this.context, sourceSection, conditionCast);
        BooleanCastNode conditionCastNotCast = BooleanCastNodeFactory.create(this.context, sourceSection, conditionCastNot);
        RubyNode body = node.getBodyNode().accept(this);
        if (node.evaluateAtStart()) {
            return WhileNode.createWhile(this.context, sourceSection, conditionCastNotCast, body);
        }
        return WhileNode.createDoWhile(this.context, sourceSection, conditionCastNotCast, body);
    }

    @Override
    public RubyNode visitVCallNode(VCallNode node) {
        SelfNode receiver2 = new SelfNode(node.getPosition());
        CallNode callNode = new CallNode(node.getPosition(), receiver2, node.getName(), null, null);
        return this.visitCallNodeExtraArgument(callNode, null, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitWhileNode(org.jruby.ast.WhileNode node) {
        RubyNode body;
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode condition = node.getConditionNode() == null ? new ObjectLiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()) : node.getConditionNode().accept(this);
        BooleanCastNode conditionCast = BooleanCastNodeFactory.create(this.context, sourceSection, condition);
        this.translatingWhile = true;
        try {
            body = node.getBodyNode().accept(this);
        }
        finally {
            this.translatingWhile = false;
        }
        if (node.evaluateAtStart()) {
            return WhileNode.createWhile(this.context, sourceSection, conditionCast, body);
        }
        return WhileNode.createDoWhile(this.context, sourceSection, conditionCast, body);
    }

    @Override
    public RubyNode visitXStrNode(XStrNode node) {
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), new StrNode(node.getPosition(), node.getValue()), new Node[0]);
        FCallNode callNode = new FCallNode(node.getPosition(), "`", argsNode, null);
        return ((Node)callNode).accept(this);
    }

    @Override
    public RubyNode visitYieldNode(org.jruby.ast.YieldNode node) {
        ArrayList<Node> arguments = new ArrayList<Node>();
        Node argsNode = node.getArgsNode();
        boolean unsplat = argsNode instanceof SplatNode;
        if (unsplat) {
            argsNode = ((SplatNode)argsNode).getValue();
        }
        if (argsNode != null) {
            if (argsNode instanceof ListNode) {
                arguments.addAll(node.getArgsNode().childNodes());
            } else {
                arguments.add(node.getArgsNode());
            }
        }
        ArrayList<RubyNode> argumentsTranslated = new ArrayList<RubyNode>();
        for (Node argument : arguments) {
            argumentsTranslated.add(argument.accept(this));
        }
        RubyNode[] argumentsTranslatedArray = argumentsTranslated.toArray(new RubyNode[argumentsTranslated.size()]);
        return new YieldNode(this.context, this.translate(node.getPosition()), argumentsTranslatedArray, unsplat);
    }

    @Override
    public RubyNode visitZArrayNode(ZArrayNode node) {
        RubyNode[] values2 = new RubyNode[]{};
        return new ArrayLiteralNode.UninitialisedArrayLiteralNode(this.context, this.translate(node.getPosition()), values2);
    }

    @Override
    public RubyNode visitBackRefNode(BackRefNode node) {
        int index2 = 0;
        switch (node.getType()) {
            case '`': {
                index2 = -1;
                break;
            }
            case '\'': {
                index2 = -2;
                break;
            }
            case '&': {
                index2 = -3;
                break;
            }
            case '+': {
                index2 = -4;
                break;
            }
            default: {
                throw new UnsupportedOperationException(Character.toString(node.getType()));
            }
        }
        return new ReadMatchReferenceNode(this.context, this.translate(node.getPosition()), index2);
    }

    @Override
    public RubyNode visitLambdaNode(LambdaNode node) {
        ArgsNode argsNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.environment.getLexicalScope(), "(lambda)", true, node, false);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParser(), this.environment.getReturnID(), false, false, sharedMethodInfo, sharedMethodInfo.getName(), true);
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, false, this.source);
        if (node.getVarNode() instanceof ArgsNode) {
            argsNode = (ArgsNode)node.getVarNode();
        } else if (node.getVarNode() instanceof DAsgnNode) {
            ArgumentNode arg2 = new ArgumentNode(node.getPosition(), ((DAsgnNode)node.getVarNode()).getName());
            ArrayNode preArgs = new ArrayNode(node.getPosition(), arg2);
            argsNode = new ArgsNode(node.getPosition(), preArgs, null, null, null, null, null, null);
        } else if (node.getVarNode() == null) {
            argsNode = null;
        } else {
            throw new UnsupportedOperationException();
        }
        RubyNode definitionNode = methodCompiler.compileFunctionNode(this.translate(node.getPosition()), sharedMethodInfo.getName(), argsNode, node.getBodyNode(), sharedMethodInfo);
        return new org.jruby.truffle.nodes.cast.LambdaNode(this.context, this.translate(node.getPosition()), definitionNode);
    }

    protected RubyNode initFlipFlopStates(SourceSection sourceSection) {
        RubyNode[] initNodes = new RubyNode[this.environment.getFlipFlopStates().size()];
        for (int n = 0; n < initNodes.length; ++n) {
            initNodes[n] = new InitFlipFlopSlotNode(this.context, sourceSection, this.environment.getFlipFlopStates().get(n));
        }
        return SequenceNode.sequence(this.context, sourceSection, initNodes);
    }

    @Override
    protected RubyNode defaultVisit(Node node) {
        return this.unimplemented(node);
    }

    protected RubyNode unimplemented(Node node) {
        this.context.getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, node.getPosition().getFile(), node.getPosition().getLine(), node + " does nothing - translating as nil");
        return new ObjectLiteralNode(this.context, this.translate(node.getPosition()), this.context.getCoreLibrary().getNilObject());
    }

    public TranslatorEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    protected String getIdentifier() {
        if (this.environment.isBlock()) {
            TranslatorEnvironment methodParent = this.environment.getParent();
            while (methodParent.isBlock()) {
                methodParent = methodParent.getParent();
            }
            return methodParent.getNamedMethodName();
        }
        return this.environment.getNamedMethodName();
    }

    @Override
    public RubyNode visitOther(Node node) {
        if (node instanceof ReadLocalDummyNode) {
            ReadLocalDummyNode readLocal = (ReadLocalDummyNode)node;
            return ReadLocalVariableNodeFactory.create(this.context, readLocal.getSourceSection(), readLocal.getFrameSlot());
        }
        throw new UnsupportedOperationException();
    }

    static {
        debugIgnoredCalls.add("downto");
        debugIgnoredCalls.add("each");
        debugIgnoredCalls.add("times");
        debugIgnoredCalls.add("upto");
        FRAME_LOCAL_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$_", "$+", "$&", "$`", "$'"));
        THREAD_LOCAL_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$~", "$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9"));
    }

    protected static class ArgumentsAndBlockTranslation {
        private final RubyNode block;
        private final RubyNode[] arguments;
        private final boolean isSplatted;

        public ArgumentsAndBlockTranslation(RubyNode block, RubyNode[] arguments, boolean isSplatted) {
            this.block = block;
            this.arguments = arguments;
            this.isSplatted = isSplatted;
        }

        public RubyNode getBlock() {
            return this.block;
        }

        public RubyNode[] getArguments() {
            return Arrays.copyOf(this.arguments, this.arguments.length);
        }

        public boolean isSplatted() {
            return this.isSplatted;
        }
    }
}

