/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyThread;

public class ThreadManager {
    private final ReentrantLock globalLock = new ReentrantLock();
    private final RubyThread rootThread;
    private RubyThread currentThread;
    private final Set<RubyThread> runningThreads = Collections.newSetFromMap(new ConcurrentHashMap());

    public ThreadManager(RubyContext context) {
        this.rootThread = new RubyThread(context.getCoreLibrary().getThreadClass(), this);
        this.rootThread.setRootThread(Thread.currentThread());
        this.runningThreads.add(this.rootThread);
        this.enterGlobalLock(this.rootThread);
    }

    public RubyThread getRootThread() {
        return this.rootThread;
    }

    @CompilerDirectives.TruffleBoundary
    public void enterGlobalLock(RubyThread thread2) {
        this.globalLock.lock();
        this.currentThread = thread2;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyThread leaveGlobalLock() {
        if (!this.globalLock.isHeldByCurrentThread()) {
            throw new RuntimeException("You don't own this lock!");
        }
        RubyThread result2 = this.currentThread;
        this.globalLock.unlock();
        return result2;
    }

    public RubyThread getCurrentThread() {
        return this.currentThread;
    }

    public void interruptAllThreads() {
        for (RubyThread thread2 : this.runningThreads) {
            thread2.interrupt();
        }
    }

    public synchronized void registerThread(RubyThread thread2) {
        this.runningThreads.add(thread2);
    }

    public synchronized void unregisterThread(RubyThread thread2) {
        this.runningThreads.remove(thread2);
    }

    public void shutdown() {
        for (RubyThread thread2 : this.runningThreads) {
            thread2.shutdown();
        }
    }
}

