/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.hash;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.RubyHash;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashSearchResult;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.util.cli.Options;

public class HashOperations {
    public static final int SMALL_HASH_SIZE = Options.TRUFFLE_HASHES_SMALL.load();
    private static final int[] CAPACITIES = Arrays.copyOf(RubyHash.MRI_PRIMES, RubyHash.MRI_PRIMES.length - 1);
    private static final int SIGN_BIT_MASK = Integer.MAX_VALUE;

    public static int capacityGreaterThan(int size2) {
        for (int capacity : CAPACITIES) {
            if (capacity <= size2) continue;
            return capacity;
        }
        return CAPACITIES[CAPACITIES.length - 1];
    }

    @CompilerDirectives.TruffleBoundary
    public static org.jruby.truffle.runtime.core.RubyHash verySlowFromEntries(RubyContext context, List<KeyValue> entries2) {
        RubyNode.notDesignedForCompilation();
        org.jruby.truffle.runtime.core.RubyHash hash2 = new org.jruby.truffle.runtime.core.RubyHash(context.getCoreLibrary().getHashClass(), null, null, null, 0, null);
        HashOperations.verySlowSetKeyValues(hash2, entries2);
        return hash2;
    }

    public static void dump(org.jruby.truffle.runtime.core.RubyHash hash2) {
        Entry entry;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(hash2.getSize());
        builder.append("](");
        Entry[] arr$ = (Entry[])hash2.getStore();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            builder.append("(");
            for (Entry entry2 = arr$[i$]; entry2 != null; entry2 = entry2.getNextInLookup()) {
                builder.append("[");
                builder.append(entry2.getKey());
                builder.append(",");
                builder.append(entry2.getValue());
                builder.append("]");
            }
            builder.append(")");
        }
        builder.append(")~>(");
        for (entry = hash2.getFirstInSequence(); entry != null; entry = entry.getNextInSequence()) {
            builder.append("[");
            builder.append(entry.getKey());
            builder.append(",");
            builder.append(entry.getValue());
            builder.append("]");
        }
        builder.append(")<~(");
        for (entry = hash2.getLastInSequence(); entry != null; entry = entry.getPreviousInSequence()) {
            builder.append("[");
            builder.append(entry.getKey());
            builder.append(",");
            builder.append(entry.getValue());
            builder.append("]");
        }
        builder.append(")");
        System.err.println(builder);
    }

    @CompilerDirectives.TruffleBoundary
    public static List<KeyValue> verySlowToKeyValues(org.jruby.truffle.runtime.core.RubyHash hash2) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        if (hash2.getStore() instanceof Entry[]) {
            for (Entry entry = hash2.getFirstInSequence(); entry != null; entry = entry.getNextInSequence()) {
                keyValues.add(new KeyValue(entry.getKey(), entry.getValue()));
            }
        } else if (hash2.getStore() instanceof Object[]) {
            for (int n = 0; n < hash2.getSize(); ++n) {
                keyValues.add(new KeyValue(((Object[])hash2.getStore())[n * 2], ((Object[])hash2.getStore())[n * 2 + 1]));
            }
        } else if (hash2.getStore() != null) {
            throw new UnsupportedOperationException();
        }
        return keyValues;
    }

    @CompilerDirectives.TruffleBoundary
    public static HashSearchResult verySlowFindBucket(org.jruby.truffle.runtime.core.RubyHash hash2, Object key2) {
        int hashed;
        Object hashValue = DebugOperations.send(hash2.getContext(), key2, "hash", null, new Object[0]);
        if (hashValue instanceof Integer) {
            hashed = (Integer)hashValue;
        } else if (hashValue instanceof Long) {
            hashed = (int)((Long)hashValue).longValue();
        } else {
            throw new UnsupportedOperationException();
        }
        Entry[] entries2 = (Entry[])hash2.getStore();
        int bucketIndex = (hashed & Integer.MAX_VALUE) % entries2.length;
        Entry previousEntry = null;
        for (Entry entry = entries2[bucketIndex]; entry != null; entry = entry.getNextInLookup()) {
            if (((Boolean)DebugOperations.send(hash2.getContext(), key2, "eql?", null, entry.getKey())).booleanValue()) {
                return new HashSearchResult(bucketIndex, previousEntry, entry);
            }
            previousEntry = entry;
        }
        return new HashSearchResult(bucketIndex, previousEntry, null);
    }

    public static void setAtBucket(org.jruby.truffle.runtime.core.RubyHash hash2, HashSearchResult hashSearchResult, Object key2, Object value2) {
        if (hashSearchResult.getEntry() == null) {
            Entry entry = new Entry(key2, value2);
            if (hashSearchResult.getPreviousEntry() == null) {
                ((Entry[])hash2.getStore())[hashSearchResult.getIndex()] = entry;
            } else {
                hashSearchResult.getPreviousEntry().setNextInLookup(entry);
            }
            if (hash2.getFirstInSequence() == null) {
                hash2.setFirstInSequence(entry);
                hash2.setLastInSequence(entry);
            } else {
                hash2.getLastInSequence().setNextInSequence(entry);
                entry.setPreviousInSequence(hash2.getLastInSequence());
                hash2.setLastInSequence(entry);
            }
        } else {
            Entry entry = hashSearchResult.getEntry();
            entry.setKey(key2);
            entry.setValue(value2);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean verySlowSetInBuckets(org.jruby.truffle.runtime.core.RubyHash hash2, Object key2, Object value2) {
        if (key2 instanceof RubyString) {
            key2 = DebugOperations.send(hash2.getContext(), DebugOperations.send(hash2.getContext(), key2, "dup", null, new Object[0]), "freeze", null, new Object[0]);
        }
        HashSearchResult hashSearchResult = HashOperations.verySlowFindBucket(hash2, key2);
        HashOperations.setAtBucket(hash2, hashSearchResult, key2, value2);
        return hashSearchResult.getEntry() == null;
    }

    @CompilerDirectives.TruffleBoundary
    public static void verySlowSetKeyValues(org.jruby.truffle.runtime.core.RubyHash hash2, List<KeyValue> keyValues) {
        int size2 = keyValues.size();
        hash2.setStore(new Entry[HashOperations.capacityGreaterThan(size2)], 0, null, null);
        int actualSize = 0;
        for (KeyValue keyValue : keyValues) {
            if (!HashOperations.verySlowSetInBuckets(hash2, keyValue.getKey(), keyValue.getValue())) continue;
            ++actualSize;
        }
        hash2.setSize(actualSize);
    }

    public static int getIndex(int hashed, int entriesLength) {
        return (hashed & Integer.MAX_VALUE) % entriesLength;
    }
}

