/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.MaterializedFrame;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.MethodLike;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.util.cli.Options;

public class RubyProc
extends RubyBasicObject
implements MethodLike {
    public static final boolean PROC_BINDING = Options.TRUFFLE_PROC_BINDING.load();
    private final Type type;
    @CompilerDirectives.CompilationFinal
    private SharedMethodInfo sharedMethodInfo;
    @CompilerDirectives.CompilationFinal
    private CallTarget callTargetForBlocks;
    @CompilerDirectives.CompilationFinal
    private CallTarget callTargetForProcs;
    @CompilerDirectives.CompilationFinal
    private CallTarget callTargetForMethods;
    @CompilerDirectives.CompilationFinal
    private MaterializedFrame declarationFrame;
    @CompilerDirectives.CompilationFinal
    private RubyModule declaringModule;
    @CompilerDirectives.CompilationFinal
    private MethodLike method;
    @CompilerDirectives.CompilationFinal
    private Object self;
    @CompilerDirectives.CompilationFinal
    private RubyProc block;

    public RubyProc(RubyClass procClass, Type type2) {
        super(procClass);
        this.type = type2;
    }

    public RubyProc(RubyClass procClass, Type type2, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForBlocks, CallTarget callTargetForProcs, CallTarget callTargetForMethods, MaterializedFrame declarationFrame, RubyModule declaringModule, MethodLike method, Object self2, RubyProc block) {
        this(procClass, type2);
        this.initialize(sharedMethodInfo, callTargetForBlocks, callTargetForProcs, callTargetForMethods, declarationFrame, declaringModule, method, self2, block);
    }

    public void initialize(SharedMethodInfo sharedMethodInfo, CallTarget callTargetForBlocks, CallTarget callTargetForProcs, CallTarget callTargetForMethods, MaterializedFrame declarationFrame, RubyModule declaringModule, MethodLike method, Object self2, RubyProc block) {
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTargetForBlocks = callTargetForBlocks;
        this.callTargetForProcs = callTargetForProcs;
        this.callTargetForMethods = callTargetForMethods;
        this.declarationFrame = declarationFrame;
        this.declaringModule = declaringModule;
        this.method = method;
        this.self = self2;
        this.block = block;
    }

    public CallTarget getCallTargetForType() {
        switch (this.type) {
            case BLOCK: {
                return this.callTargetForBlocks;
            }
            case PROC: {
                return this.callTargetForProcs;
            }
            case LAMBDA: {
                return this.callTargetForMethods;
            }
        }
        throw new UnsupportedOperationException(this.type.toString());
    }

    public Object rootCall(Object ... args2) {
        RubyNode.notDesignedForCompilation();
        return this.getCallTargetForType().call(RubyArguments.pack(this, this.declarationFrame, this.self, this.block, args2));
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public CallTarget getCallTargetForBlocks() {
        return this.callTargetForBlocks;
    }

    public CallTarget getCallTargetForProcs() {
        return this.callTargetForProcs;
    }

    public CallTarget getCallTargetForMethods() {
        return this.callTargetForMethods;
    }

    public MaterializedFrame getDeclarationFrame() {
        return this.declarationFrame;
    }

    @Override
    public RubyModule getDeclaringModule() {
        return this.declaringModule;
    }

    public MethodLike getMethod() {
        return this.method;
    }

    public Object getSelfCapturedInScope() {
        return this.self;
    }

    public RubyProc getBlockCapturedInScope() {
        return this.block;
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        this.getContext().getObjectSpaceManager().visitFrame(this.declarationFrame, visitor);
    }

    public static class ProcAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyProc(rubyClass, Type.PROC);
        }
    }

    public static enum Type {
        BLOCK,
        PROC,
        LAMBDA;

    }
}

