/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.util.ByteList;

public class RubyEncoding
extends RubyBasicObject {
    private static RubyEncoding[] encodingList = new RubyEncoding[EncodingDB.getEncodings().size()];
    private static Map<String, RubyEncoding> lookup = new HashMap<String, RubyEncoding>();
    private final Encoding encoding;
    private final ByteList name;
    private final boolean dummy;

    public static synchronized RubyEncoding getEncoding(Encoding encoding2) {
        return lookup.get(new String(encoding2.getName(), StandardCharsets.UTF_8).toLowerCase(Locale.ENGLISH));
    }

    public static RubyEncoding getEncoding(String name2) {
        return lookup.get(name2.toLowerCase(Locale.ENGLISH));
    }

    public static RubyEncoding getEncoding(int index2) {
        return encodingList[index2];
    }

    public static void storeEncoding(int encodingListIndex, RubyEncoding encoding2) {
        RubyEncoding.encodingList[encodingListIndex] = encoding2;
        lookup.put(encoding2.getName().toString().toLowerCase(Locale.ENGLISH), encoding2);
    }

    public static void storeAlias(String aliasName, RubyEncoding encoding2) {
        lookup.put(aliasName.toLowerCase(Locale.ENGLISH), encoding2);
    }

    public static RubyEncoding newEncoding(RubyContext context, Encoding encoding2, byte[] name2, int p2, int end2, boolean dummy) {
        return new RubyEncoding(context.getCoreLibrary().getEncodingClass(), encoding2, new ByteList(name2, p2, end2), dummy);
    }

    private RubyEncoding(RubyClass encodingClass, Encoding encoding2, ByteList name2, boolean dummy) {
        super(encodingClass);
        this.encoding = encoding2;
        this.name = name2;
        this.dummy = dummy;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public ByteList getName() {
        return this.name;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public static RubyEncoding[] cloneEncodingList() {
        RubyEncoding[] clone = new RubyEncoding[encodingList.length];
        System.arraycopy(encodingList, 0, clone, 0, encodingList.length);
        return clone;
    }

    public static class EncodingAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            throw new UnsupportedOperationException();
        }
    }
}

