/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import java.math.BigInteger;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

public class RubyBignum
extends RubyBasicObject {
    private BigInteger value;

    public RubyBignum(RubyClass rubyClass, BigInteger value2) {
        super(rubyClass);
        this.value = value2;
    }

    @Override
    public boolean hasNoSingleton() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum negate() {
        return this.create(this.value.negate());
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum abs() {
        return this.create(this.value.abs());
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum create(BigInteger value2) {
        return new RubyBignum(this.getContext().getCoreLibrary().getBignumClass(), value2);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum add(RubyBignum other) {
        return this.create(this.value.add(other.value));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum add(long other) {
        return this.create(this.value.add(BigInteger.valueOf(other)));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum subtract(RubyBignum other) {
        return this.create(this.value.subtract(other.value));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum subtract(long other) {
        return this.create(this.value.subtract(BigInteger.valueOf(other)));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum multiply(RubyBignum other) {
        return this.create(this.value.multiply(other.value));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum multiply(long other) {
        return this.create(this.value.multiply(BigInteger.valueOf(other)));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum pow(int other) {
        return this.create(this.value.pow(other));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum pow(long other) {
        if (other < Integer.MAX_VALUE) {
            return this.pow((int)other);
        }
        BigInteger result2 = BigInteger.ONE;
        for (long n = 0L; n < other; ++n) {
            result2 = result2.multiply(this.value);
        }
        return this.create(result2);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum pow(RubyBignum other) {
        BigInteger result2 = BigInteger.ONE;
        BigInteger n = BigInteger.ZERO;
        while (other.value.compareTo(n) < 0) {
            result2 = result2.multiply(this.value);
            n = n.add(BigInteger.ONE);
        }
        return this.create(result2);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum divide(RubyBignum other) {
        return this.create(this.value.divide(other.value));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum divide(long other) {
        return this.create(this.value.divide(BigInteger.valueOf(other)));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum mod(long other) {
        return this.create(this.value.mod(BigInteger.valueOf(other)));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum mod(RubyBignum other) {
        return this.create(this.value.mod(other.bigIntegerValue()));
    }

    @CompilerDirectives.TruffleBoundary
    public int compare(int other) {
        return this.value.compareTo(BigInteger.valueOf(other));
    }

    @CompilerDirectives.TruffleBoundary
    public int compare(long other) {
        return this.value.compareTo(BigInteger.valueOf(other));
    }

    @CompilerDirectives.TruffleBoundary
    public int compare(RubyBignum other) {
        return this.value.compareTo(other.value);
    }

    @CompilerDirectives.TruffleBoundary
    public int compare(double other) {
        return this.compare((long)other);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isEqualTo(int b2) {
        return this.value.equals(BigInteger.valueOf(b2));
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isEqualTo(long b2) {
        return this.value.equals(BigInteger.valueOf(b2));
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isEqualTo(RubyBignum b2) {
        return this.value.equals(b2.value);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum and(RubyBignum other) {
        return this.create(this.value.and(other.value));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum and(long other) {
        return this.create(this.value.and(BigInteger.valueOf(other)));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum or(RubyBignum other) {
        return this.create(this.value.or(other.value));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum or(long other) {
        return this.create(this.value.or(BigInteger.valueOf(other)));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum xor(RubyBignum other) {
        return this.create(this.value.xor(other.value));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum xor(long other) {
        return this.create(this.value.xor(BigInteger.valueOf(other)));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum shiftLeft(int n) {
        return this.create(this.value.shiftLeft(n));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBignum shiftRight(int n) {
        return this.create(this.value.shiftRight(n));
    }

    @CompilerDirectives.TruffleBoundary
    public long longValue() {
        return this.value.longValue();
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isZero() {
        return this.value.equals(BigInteger.ZERO);
    }

    @CompilerDirectives.TruffleBoundary
    public String toHexString() {
        return this.value.toString(16);
    }

    @CompilerDirectives.TruffleBoundary
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public static class BignumAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyBignum(rubyClass, BigInteger.ZERO);
        }
    }
}

