/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.backtrace;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.backtrace.DebugBacktraceFormatter;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.MethodLike;

public class ImplementationDebugBacktraceFormatter
implements BacktraceFormatter {
    @Override
    public String[] format(RubyContext context, RubyException exception2, Backtrace backtrace2) {
        try {
            List<Activation> activations = backtrace2.getActivations();
            ArrayList<String> lines2 = new ArrayList<String>();
            if (exception2 != null) {
                lines2.add(String.format("%s (%s)", exception2.getMessage(), exception2.getLogicalClass().getName()));
            }
            for (Activation activation : activations) {
                ImplementationDebugBacktraceFormatter.formatActivation(context, activation, lines2);
            }
            return lines2.toArray(new String[lines2.size()]);
        }
        catch (Exception e) {
            throw new TruffleFatalException("Exception while trying to format a Ruby call stack", e);
        }
    }

    private static void formatActivation(RubyContext context, Activation activation, List<String> lines2) {
        lines2.add(DebugBacktraceFormatter.formatBasicLine(activation));
        MaterializedFrame frame = activation.getMaterializedFrame();
        Object[] arguments = frame.getArguments();
        MethodLike method = RubyArguments.getMethod(arguments);
        lines2.add(String.format("      method = %s", method));
        if (method instanceof InternalMethod) {
            InternalMethod internalMethod = (InternalMethod)method;
            if (internalMethod.getDeclaringModule() == null) {
                lines2.add(String.format("        declaring module = null", new Object[0]));
            } else {
                lines2.add(String.format("        declaring module = %s", internalMethod.getDeclaringModule().getName()));
            }
        }
        lines2.add("      declaration frame:");
        ImplementationDebugBacktraceFormatter.formatDeclarationFrame(context, RubyArguments.getDeclarationFrame(arguments), lines2);
        lines2.add(String.format("      self = %s", DebugBacktraceFormatter.debugString(context, RubyArguments.getSelf(arguments))));
        lines2.add(String.format("      block = %s", RubyArguments.getBlock(arguments)));
        lines2.add("      arguments:");
        for (int n = 0; n < RubyArguments.getUserArgumentsCount(arguments); ++n) {
            lines2.add(String.format("        [%d] = %s", n, DebugBacktraceFormatter.debugString(context, RubyArguments.getUserArgument(arguments, n))));
        }
        lines2.add("      frame:");
        ImplementationDebugBacktraceFormatter.formatFrame(context, frame, lines2);
    }

    private static void formatDeclarationFrame(RubyContext context, MaterializedFrame frame, List<String> lines2) {
        if (frame != null) {
            ImplementationDebugBacktraceFormatter.formatDeclarationFrame(context, RubyArguments.getDeclarationFrame(frame.getArguments()), lines2);
            ImplementationDebugBacktraceFormatter.formatFrame(context, frame, lines2);
        }
    }

    private static void formatFrame(RubyContext context, MaterializedFrame frame, List<String> lines2) {
        FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
        for (Object identifier : frameDescriptor.getIdentifiers()) {
            lines2.add(String.format("        %s = %s", identifier, DebugBacktraceFormatter.debugString(context, frame.getValue(frameDescriptor.findFrameSlot(identifier)))));
        }
    }
}

