/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import java.util.HashMap;
import java.util.Map;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class ModuleOperations {
    public static boolean includesModule(RubyModule module, RubyModule other) {
        for (RubyModule ancestor : module.ancestors()) {
            if (ancestor != other) continue;
            return true;
        }
        return false;
    }

    public static boolean assignableTo(RubyClass thisClass, RubyClass otherClass) {
        RubyNode.notDesignedForCompilation();
        return ModuleOperations.includesModule(thisClass, otherClass);
    }

    public static Map<String, RubyConstant> getAllConstants(RubyModule module) {
        CompilerAsserts.neverPartOfCompilation();
        HashMap<String, RubyConstant> constants = new HashMap<String, RubyConstant>();
        constants.putAll(module.getConstants());
        for (RubyModule ancestor : module.parentAncestors()) {
            for (Map.Entry<String, RubyConstant> constant : ancestor.getConstants().entrySet()) {
                if (constants.containsKey(constant.getKey())) continue;
                constants.put(constant.getKey(), constant.getValue());
            }
        }
        return constants;
    }

    public static RubyConstant lookupConstant(RubyContext context, LexicalScope lexicalScope, RubyModule module, String name2) {
        CompilerAsserts.neverPartOfCompilation();
        assert (lexicalScope == null || lexicalScope.getLiveModule() == module);
        RubyConstant constant = module.getConstants().get(name2);
        if (constant != null) {
            return constant;
        }
        if (lexicalScope != null) {
            if (lexicalScope != context.getRootLexicalScope()) {
                lexicalScope = lexicalScope.getParent();
            }
            while (lexicalScope != context.getRootLexicalScope()) {
                constant = lexicalScope.getLiveModule().getConstants().get(name2);
                if (constant != null) {
                    return constant;
                }
                lexicalScope = lexicalScope.getParent();
            }
        }
        for (RubyModule ancestor : module.parentAncestors()) {
            constant = ancestor.getConstants().get(name2);
            if (constant == null) continue;
            return constant;
        }
        if (module.isOnlyAModule()) {
            RubyClass objectClass = context.getCoreLibrary().getObjectClass();
            constant = objectClass.getConstants().get(name2);
            if (constant != null) {
                return constant;
            }
            for (RubyModule ancestor : objectClass.includedModules()) {
                constant = ancestor.getConstants().get(name2);
                if (constant == null) continue;
                return constant;
            }
        }
        return null;
    }

    public static Map<String, InternalMethod> getAllMethods(RubyModule module) {
        CompilerAsserts.neverPartOfCompilation();
        HashMap<String, InternalMethod> methods2 = new HashMap<String, InternalMethod>();
        methods2.putAll(module.getMethods());
        for (RubyModule ancestor : module.parentAncestors()) {
            for (Map.Entry<String, InternalMethod> method : ancestor.getMethods().entrySet()) {
                if (methods2.containsKey(method.getKey())) continue;
                methods2.put(method.getKey(), method.getValue());
            }
        }
        return methods2;
    }

    public static InternalMethod lookupMethod(RubyModule module, String name2) {
        CompilerAsserts.neverPartOfCompilation();
        InternalMethod method = module.getMethods().get(name2);
        if (method != null) {
            return method;
        }
        for (RubyModule ancestor : module.parentAncestors()) {
            method = ancestor.getMethods().get(name2);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static InternalMethod lookupSuperMethod(RubyModule declaringModule, String name2, RubyClass objectMetaClass) {
        CompilerAsserts.neverPartOfCompilation();
        boolean foundDeclaringModule = false;
        for (RubyModule module : objectMetaClass.ancestors()) {
            InternalMethod method;
            if (module == declaringModule) {
                foundDeclaringModule = true;
                continue;
            }
            if (!foundDeclaringModule || (method = module.getMethods().get(name2)) == null) continue;
            return method;
        }
        assert (foundDeclaringModule) : "Did not find the declaring module in " + objectMetaClass.getName() + " ancestors";
        return null;
    }

    public static Map<String, Object> getAllClassVariables(RubyModule module) {
        CompilerAsserts.neverPartOfCompilation();
        HashMap<String, Object> classVariables = new HashMap<String, Object>();
        classVariables.putAll(module.getClassVariables());
        for (RubyModule ancestor : module.parentAncestors()) {
            for (Map.Entry<String, Object> classVariable : ancestor.getClassVariables().entrySet()) {
                if (classVariables.containsKey(classVariable.getKey())) continue;
                classVariables.put(classVariable.getKey(), classVariable.getValue());
            }
        }
        return classVariables;
    }

    public static Object lookupClassVariable(RubyModule module, String name2) {
        CompilerAsserts.neverPartOfCompilation();
        Object value2 = module.getClassVariables().get(name2);
        if (value2 != null) {
            return value2;
        }
        for (RubyModule ancestor : module.parentAncestors()) {
            value2 = ancestor.getClassVariables().get(name2);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public static void setClassVariable(RubyModule module, String name2, Object value2) {
        CompilerAsserts.neverPartOfCompilation();
        if (module.getClassVariables().containsKey(name2)) {
            module.getClassVariables().put(name2, value2);
            return;
        }
        for (RubyModule ancestor : module.parentAncestors()) {
            if (!ancestor.getClassVariables().containsKey(name2)) continue;
            ancestor.getClassVariables().put(name2, value2);
            return;
        }
        module.getClassVariables().put(name2, value2);
    }
}

