/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.yield;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import org.jruby.truffle.nodes.yield.YieldDispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.util.cli.Options;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class CachedYieldDispatchNode
extends YieldDispatchNode {
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private YieldDispatchNode next;

    public CachedYieldDispatchNode(RubyContext context, RubyProc block, YieldDispatchNode next2) {
        super(context);
        this.callNode = Truffle.getRuntime().createDirectCallNode(block.getCallTargetForBlocks());
        this.insert(this.callNode);
        if (Options.TRUFFLE_INLINER_ALWAYS_CLONE_YIELD.load().booleanValue() && this.callNode.isCallTargetCloningAllowed()) {
            this.callNode.cloneCallTarget();
        }
        if (Options.TRUFFLE_INLINER_ALWAYS_INLINE_YIELD.load().booleanValue() && this.callNode.isInlinable()) {
            this.callNode.forceInlining();
        }
        this.next = next2;
    }

    @Override
    public Object dispatch(VirtualFrame frame, RubyProc block, Object[] argumentsObjects) {
        if (block.getCallTargetForBlocks() != this.callNode.getCallTarget()) {
            return this.next.dispatch(frame, block, argumentsObjects);
        }
        return this.callNode.call(frame, RubyArguments.pack(block, block.getDeclarationFrame(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope(), argumentsObjects));
    }

    @Override
    public Object dispatchWithModifiedBlock(VirtualFrame frame, RubyProc block, RubyProc modifiedBlock, Object[] argumentsObjects) {
        if (block.getCallTargetForBlocks() != this.callNode.getCallTarget()) {
            return this.next.dispatch(frame, block, argumentsObjects);
        }
        return this.callNode.call(frame, RubyArguments.pack(block, block.getDeclarationFrame(), block.getSelfCapturedInScope(), modifiedBlock, argumentsObjects));
    }

    @Override
    public Object dispatchWithModifiedSelf(VirtualFrame frame, RubyProc block, Object self2, Object ... argumentsObjects) {
        if (block.getCallTargetForBlocks() != this.callNode.getCallTarget()) {
            return this.next.dispatchWithModifiedSelf(frame, block, self2, argumentsObjects);
        }
        return this.callNode.call(frame, RubyArguments.pack(block, block.getDeclarationFrame(), self2, block.getBlockCapturedInScope(), argumentsObjects));
    }

    @Override
    public String toString() {
        return String.format("CachedYieldDispatchNode(%s)", this.callNode.getCallTarget());
    }
}

