/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.ReadNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public class ReadInstanceVariableNode
extends RubyNode
implements ReadNode {
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private ReadHeadObjectFieldNode readNode;
    private final boolean isGlobal;
    private final BranchProfile nullProfile = BranchProfile.create();
    private final BranchProfile primitiveProfile = BranchProfile.create();

    public ReadInstanceVariableNode(RubyContext context, SourceSection sourceSection, Object name2, RubyNode receiver2, boolean isGlobal) {
        super(context, sourceSection);
        this.receiver = receiver2;
        this.readNode = new ReadHeadObjectFieldNode(name2);
        this.isGlobal = isGlobal;
    }

    @Override
    public int executeIntegerFixnum(VirtualFrame frame) throws UnexpectedResultException {
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof RubyBasicObject) {
            return this.readNode.executeInteger((RubyBasicObject)receiverObject);
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnexpectedResultException(this.getContext().getCoreLibrary().getNilObject());
    }

    @Override
    public long executeLongFixnum(VirtualFrame frame) throws UnexpectedResultException {
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof RubyBasicObject) {
            return this.readNode.executeLong((RubyBasicObject)receiverObject);
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnexpectedResultException(this.getContext().getCoreLibrary().getNilObject());
    }

    @Override
    public double executeFloat(VirtualFrame frame) throws UnexpectedResultException {
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof RubyBasicObject) {
            return this.readNode.executeDouble((RubyBasicObject)receiverObject);
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnexpectedResultException(this.getContext().getCoreLibrary().getNilObject());
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof RubyBasicObject) {
            Object value2 = this.readNode.execute((RubyBasicObject)receiverObject);
            if (value2 == null) {
                this.nullProfile.enter();
                value2 = this.getContext().getCoreLibrary().getNilObject();
            }
            return value2;
        }
        this.primitiveProfile.enter();
        return this.getContext().getCoreLibrary().getNilObject();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        ReadInstanceVariableNode.notDesignedForCompilation();
        if (this.isGlobal) {
            RubyBasicObject receiverValue = (RubyBasicObject)this.receiver.execute(frame);
            if (this.readNode.getName().equals("$~") || this.readNode.getName().equals("$!")) {
                return this.getContext().makeString("global-variable");
            }
            if (this.readNode.isSet(receiverValue)) {
                if (this.readNode.execute(receiverValue) == this.getContext().getCoreLibrary().getNilObject()) {
                    return this.getContext().getCoreLibrary().getNilObject();
                }
                return this.getContext().makeString("global-variable");
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
        RubyContext context = this.getContext();
        Object receiverObject = this.receiver.execute(frame);
        if (receiverObject instanceof RubyBasicObject) {
            RubyBasicObject receiverRubyObject = (RubyBasicObject)receiverObject;
            Shape layout2 = receiverRubyObject.getDynamicObject().getShape();
            Property storageLocation = layout2.getProperty(this.readNode.getName());
            if (storageLocation != null) {
                return context.makeString("instance-variable");
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return false;
    }

    @Override
    public RubyNode makeWriteNode(RubyNode rhs) {
        return new WriteInstanceVariableNode(this.getContext(), this.getSourceSection(), this.readNode.getName(), this.receiver, rhs, this.isGlobal);
    }
}

