/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.locals;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.WriteNode;
import org.jruby.truffle.nodes.methods.locals.FrameSlotNode;
import org.jruby.truffle.nodes.methods.locals.ReadLocalVariableNodeFactory;
import org.jruby.truffle.runtime.RubyContext;

@NodeChild(value="rhs", type=RubyNode.class)
public abstract class WriteLocalVariableNode
extends FrameSlotNode
implements WriteNode {
    public WriteLocalVariableNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot) {
        super(context, sourceSection, frameSlot);
    }

    protected WriteLocalVariableNode(WriteLocalVariableNode prev) {
        this(prev.getContext(), prev.getSourceSection(), prev.frameSlot);
    }

    @Specialization(guards={"isBooleanKind"})
    public boolean doFixnum(VirtualFrame frame, boolean value2) {
        this.setBoolean(frame, value2);
        return value2;
    }

    @Specialization(guards={"isFixnumKind"})
    public int doFixnum(VirtualFrame frame, int value2) {
        this.setFixnum(frame, value2);
        return value2;
    }

    @Specialization(guards={"isLongFixnumKind"})
    public long doLongFixnum(VirtualFrame frame, long value2) {
        this.setLongFixnum(frame, value2);
        return value2;
    }

    @Specialization(guards={"isFloatKind"})
    public double doFloat(VirtualFrame frame, double value2) {
        this.setFloat(frame, value2);
        return value2;
    }

    @Specialization(guards={"isObjectKind"})
    public Object doObject(VirtualFrame frame, Object value2) {
        this.setObject(frame, value2);
        return value2;
    }

    @Override
    public RubyNode makeReadNode() {
        return ReadLocalVariableNodeFactory.create(this.getContext(), this.getSourceSection(), this.frameSlot);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.getContext().makeString("assignment");
    }
}

