/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;

public class ReadKeywordRestArgumentNode
extends RubyNode {
    private final int minimum;
    private final String[] excludedKeywords;

    public ReadKeywordRestArgumentNode(RubyContext context, SourceSection sourceSection, int minimum, String[] excludedKeywords) {
        super(context, sourceSection);
        this.minimum = minimum;
        this.excludedKeywords = excludedKeywords;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        ReadKeywordRestArgumentNode.notDesignedForCompilation();
        RubyHash hash2 = this.getKeywordsHash(frame);
        if (hash2 == null) {
            return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), null, null, null, 0, null);
        }
        ArrayList<KeyValue> entries2 = new ArrayList<KeyValue>();
        block0: for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash2)) {
            for (String excludedKeyword : this.excludedKeywords) {
                if (excludedKeyword.equals(keyValue.getKey().toString())) continue block0;
            }
            entries2.add(new KeyValue(keyValue.getKey(), keyValue.getValue()));
        }
        return HashOperations.verySlowFromEntries(this.getContext(), entries2);
    }

    private RubyHash getKeywordsHash(VirtualFrame frame) {
        if (RubyArguments.getUserArgumentsCount(frame.getArguments()) <= this.minimum) {
            return null;
        }
        Object lastArgument = RubyArguments.getUserArgument(frame.getArguments(), RubyArguments.getUserArgumentsCount(frame.getArguments()) - 1);
        if (lastArgument instanceof RubyHash) {
            return (RubyHash)lastArgument;
        }
        return null;
    }
}

