/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyRange;

@NodeChildren(value={@NodeChild(value="begin"), @NodeChild(value="end")})
public abstract class RangeLiteralNode
extends RubyNode {
    private final boolean excludeEnd;
    private final BranchProfile beginIntegerProfile = BranchProfile.create();
    private final BranchProfile beginLongProfile = BranchProfile.create();
    private final BranchProfile endIntegerProfile = BranchProfile.create();
    private final BranchProfile endLongProfile = BranchProfile.create();
    private final BranchProfile objectProfile = BranchProfile.create();

    public RangeLiteralNode(RubyContext context, SourceSection sourceSection, boolean excludeEnd) {
        super(context, sourceSection);
        this.excludeEnd = excludeEnd;
    }

    public RangeLiteralNode(RangeLiteralNode prev) {
        this(prev.getContext(), prev.getSourceSection(), prev.excludeEnd);
    }

    @Specialization
    public RubyRange.IntegerFixnumRange doRange(int begin2, int end2) {
        return new RubyRange.IntegerFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin2, end2, this.excludeEnd);
    }

    @Specialization
    public RubyRange.LongFixnumRange doRange(int begin2, long end2) {
        return new RubyRange.LongFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin2, end2, this.excludeEnd);
    }

    @Specialization
    public RubyRange.LongFixnumRange doRange(long begin2, int end2) {
        return new RubyRange.LongFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin2, end2, this.excludeEnd);
    }

    @Specialization
    public RubyRange.LongFixnumRange doRange(long begin2, long end2) {
        return new RubyRange.LongFixnumRange(this.getContext().getCoreLibrary().getRangeClass(), begin2, end2, this.excludeEnd);
    }

    @Specialization
    public Object doRange(Object begin2, Object end2) {
        if (begin2 instanceof Integer) {
            this.beginIntegerProfile.enter();
            if (end2 instanceof Integer) {
                this.endIntegerProfile.enter();
                return this.doRange((int)((Integer)begin2), (int)((Integer)end2));
            }
            if (end2 instanceof Long) {
                this.endLongProfile.enter();
                return this.doRange((int)((Integer)begin2), (long)((Long)end2));
            }
        } else if (begin2 instanceof Long) {
            this.beginLongProfile.enter();
            if (end2 instanceof Integer) {
                this.endIntegerProfile.enter();
                return this.doRange((long)((Long)begin2), (int)((Integer)end2));
            }
            if (end2 instanceof Long) {
                this.endLongProfile.enter();
                return this.doRange((long)((Long)begin2), (long)((Long)end2));
            }
        }
        this.objectProfile.enter();
        return new RubyRange.ObjectRange(this.getContext().getCoreLibrary().getRangeClass(), begin2, end2, this.excludeEnd);
    }
}

