/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;

public abstract class HashLiteralNode
extends RubyNode {
    @Node.Children
    protected final RubyNode[] keyValues;
    @Node.Child
    protected CallDispatchHeadNode dupNode;
    @Node.Child
    protected CallDispatchHeadNode freezeNode;

    protected HashLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] keyValues) {
        super(context, sourceSection);
        assert (keyValues.length % 2 == 0);
        this.keyValues = keyValues;
        this.dupNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.freezeNode = DispatchHeadNodeFactory.createMethodCall(context);
    }

    public static HashLiteralNode create(RubyContext context, SourceSection sourceSection, RubyNode[] keyValues) {
        if (keyValues.length == 0) {
            return new EmptyHashLiteralNode(context, sourceSection);
        }
        if (keyValues.length <= HashOperations.SMALL_HASH_SIZE * 2) {
            return new SmallHashLiteralNode(context, sourceSection, keyValues);
        }
        return new GenericHashLiteralNode(context, sourceSection, keyValues);
    }

    @Override
    public abstract RubyHash executeRubyHash(VirtualFrame var1);

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeRubyHash(frame);
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        for (RubyNode child : this.keyValues) {
            child.executeVoid(frame);
        }
    }

    public static class GenericHashLiteralNode
    extends HashLiteralNode {
        public GenericHashLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] keyValues) {
            super(context, sourceSection, keyValues);
        }

        @Override
        public RubyHash executeRubyHash(VirtualFrame frame) {
            GenericHashLiteralNode.notDesignedForCompilation();
            ArrayList<KeyValue> entries2 = new ArrayList<KeyValue>();
            for (int n = 0; n < this.keyValues.length; n += 2) {
                Object key2 = this.keyValues[n].execute(frame);
                Object value2 = this.keyValues[n + 1].execute(frame);
                entries2.add(new KeyValue(key2, value2));
            }
            return HashOperations.verySlowFromEntries(this.getContext(), entries2);
        }
    }

    public static class SmallHashLiteralNode
    extends HashLiteralNode {
        @Node.Child
        private CallDispatchHeadNode equalNode;

        public SmallHashLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] keyValues) {
            super(context, sourceSection, keyValues);
            this.equalNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        @Override
        @ExplodeLoop
        public RubyHash executeRubyHash(VirtualFrame frame) {
            Object[] storage = new Object[HashOperations.SMALL_HASH_SIZE * 2];
            int end2 = 0;
            block0: for (int n = 0; n < this.keyValues.length; n += 2) {
                Object key2 = this.keyValues[n].execute(frame);
                if (key2 instanceof RubyString && !((RubyString)key2).isFrozen()) {
                    key2 = this.freezeNode.call(frame, this.dupNode.call(frame, key2, "dup", null, new Object[0]), "freeze", null, new Object[0]);
                }
                Object value2 = this.keyValues[n + 1].execute(frame);
                for (int i2 = 0; i2 < n; i2 += 2) {
                    if (i2 >= end2 || !this.equalNode.callBoolean(frame, key2, "eql?", null, storage[i2])) continue;
                    storage[i2 + 1] = value2;
                    continue block0;
                }
                storage[end2] = key2;
                storage[end2 + 1] = value2;
                end2 += 2;
            }
            return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), null, null, storage, end2 / 2, null);
        }
    }

    public static class EmptyHashLiteralNode
    extends HashLiteralNode {
        public EmptyHashLiteralNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection, new RubyNode[0]);
        }

        @Override
        @ExplodeLoop
        public RubyHash executeRubyHash(VirtualFrame frame) {
            return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), null, null, null, 0, null);
        }
    }
}

