/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class CachedBoxedDispatchNode
extends CachedDispatchNode {
    private final RubyClass expectedClass;
    private final Assumption unmodifiedAssumption;
    private final Object value;
    private final InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private IndirectCallNode indirectCallNode;

    public CachedBoxedDispatchNode(RubyContext context, Object cachedName, DispatchNode next2, RubyClass expectedClass, Object value2, InternalMethod method, boolean indirect, DispatchAction dispatchAction) {
        this(context, cachedName, next2, expectedClass, expectedClass.getUnmodifiedAssumption(), value2, method, indirect, dispatchAction);
    }

    public CachedBoxedDispatchNode(RubyContext context, Object cachedName, DispatchNode next2, RubyClass expectedClass, Assumption unmodifiedAssumption, Object value2, InternalMethod method, boolean indirect, DispatchAction dispatchAction) {
        super(context, cachedName, next2, indirect, dispatchAction);
        this.expectedClass = expectedClass;
        this.unmodifiedAssumption = unmodifiedAssumption;
        this.next = next2;
        this.value = value2;
        this.method = method;
        if (method != null) {
            if (indirect) {
                this.indirectCallNode = Truffle.getRuntime().createIndirectCallNode();
            } else {
                this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
                if (this.callNode.isCallTargetCloningAllowed() && method.getSharedMethodInfo().shouldAlwaysSplit()) {
                    this.insert(this.callNode);
                    this.callNode.cloneCallTarget();
                }
            }
        }
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        if (!this.guardName(methodName) || !(receiverObject instanceof RubyBasicObject) || ((RubyBasicObject)receiverObject).getMetaClass() != this.expectedClass) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, CompilerDirectives.unsafeCast(blockObject, RubyProc.class, true, false), argumentsObjects, "class modified");
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                if (this.isIndirect()) {
                    return this.indirectCallNode.call(frame, this.method.getCallTarget(), RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, CompilerDirectives.unsafeCast(blockObject, RubyProc.class, true, false), CompilerDirectives.unsafeCast(argumentsObjects, Object[].class, true)));
                }
                return this.callNode.call(frame, RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, CompilerDirectives.unsafeCast(blockObject, RubyProc.class, true, false), CompilerDirectives.unsafeCast(argumentsObjects, Object[].class, true)));
            }
            case RESPOND_TO_METHOD: {
                return true;
            }
            case READ_CONSTANT: {
                return this.value;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return String.format("CachedBoxedDispatchNode(:%s, %s@%x, %s, %s)", this.getCachedNameAsSymbol().toString(), this.expectedClass.getName(), this.expectedClass.hashCode(), this.value == null ? "null" : DebugOperations.inspect(this.getContext(), this.value), this.method == null ? "null" : this.method.toString());
    }
}

