/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;

@CoreClass(name="Method")
public abstract class MethodNodes {

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodNode {
        public NameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NameNode(NameNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol name(RubyMethod method) {
            NameNode.notDesignedForCompilation();
            return this.getContext().newSymbol(method.getMethod().getName());
        }
    }

    @CoreMethod(names={"call"}, argumentsAsArray=true)
    public static abstract class CallNode
    extends CoreMethodNode {
        @Node.Child
        private IndirectCallNode callNode;

        public CallNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.callNode = Truffle.getRuntime().createIndirectCallNode();
        }

        public CallNode(CallNode prev) {
            super(prev);
            this.callNode = prev.callNode;
        }

        @Specialization
        public Object call(VirtualFrame frame, RubyMethod method, Object ... arguments) {
            InternalMethod internalMethod = method.getMethod();
            return this.callNode.call(frame, method.getMethod().getCallTarget(), RubyArguments.pack(internalMethod, internalMethod.getDeclarationFrame(), method.getObject(), null, arguments));
        }
    }
}

