/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.IntegerNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=IntegerNodes.class)
public final class IntegerNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ChrNodeFactory.getInstance(), FloorNodeFactory.getInstance(), TimesNodeFactory.getInstance(), ToINodeFactory.getInstance(), UpToNodeFactory.getInstance());
    }

    @GeneratedBy(value=IntegerNodes.UpToNode.class)
    public static final class UpToNodeFactory
    extends NodeFactoryBase<IntegerNodes.UpToNode> {
        private static UpToNodeFactory upToNodeFactoryInstance;

        private UpToNodeFactory() {
            super(IntegerNodes.UpToNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public IntegerNodes.UpToNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UpToNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IntegerNodes.UpToNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UpToUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IntegerNodes.UpToNode> getInstance() {
            if (upToNodeFactoryInstance == null) {
                upToNodeFactoryInstance = new UpToNodeFactory();
            }
            return upToNodeFactoryInstance;
        }

        @GeneratedBy(value=IntegerNodes.UpToNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UpToPolymorphicNode
        extends UpToBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            UpToPolymorphicNode(UpToBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2, arguments2Value);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value);
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=IntegerNodes.UpToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UpToLongNode
        extends UpToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpToLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE, RubyProc.class}, 0, 0);

            UpToLongNode(UpToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                long arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof long");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.upto(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.upto(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IntegerNodes.UpToNode create0(IntegerNodes.UpToNode current2) {
                return new UpToLongNode((UpToBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.UpToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UpToIntNode
        extends UpToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpToIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE, RubyProc.class}, 0, 0);

            UpToIntNode(UpToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.upto(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.upto(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IntegerNodes.UpToNode create0(IntegerNodes.UpToNode current2) {
                return new UpToIntNode((UpToBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.UpToNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UpToUninitializedNode
        extends UpToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UpToUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UpToUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UpToUninitializedNode(UpToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                UpToBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UpToBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IntegerNodes.UpToNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UpToUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IntegerNodes.UpToNode.class)
        private static abstract class UpToBaseNode
        extends IntegerNodes.UpToNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UpToBaseNode next0;

            UpToBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UpToBaseNode(UpToBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                UpToBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UpToBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new UpToUninitializedNode(this);
                    ((UpToUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = UpToBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new UpToUninitializedNode(this), new UpToPolymorphicNode(this), (UpToBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UpToBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (UpToBaseNode)UpToIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                        return (UpToBaseNode)UpToLongNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    UpToBaseNode otherCast = (UpToBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (UpToBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=IntegerNodes.ToINode.class)
    public static final class ToINodeFactory
    extends NodeFactoryBase<IntegerNodes.ToINode> {
        private static ToINodeFactory toINodeFactoryInstance;

        private ToINodeFactory() {
            super(IntegerNodes.ToINode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public IntegerNodes.ToINode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToINodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IntegerNodes.ToINode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToIUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IntegerNodes.ToINode> getInstance() {
            if (toINodeFactoryInstance == null) {
                toINodeFactoryInstance = new ToINodeFactory();
            }
            return toINodeFactoryInstance;
        }

        @GeneratedBy(value=IntegerNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToIPolymorphicNode
        extends ToIBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToIPolymorphicNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=IntegerNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToIRubyBignumNode
        extends ToIBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToIRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ToIRubyBignumNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum"));
                }
                return super.toI(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.toI(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.ToINode create0(IntegerNodes.ToINode current2) {
                return new ToIRubyBignumNode((ToIBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToILongNode
        extends ToIBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToILongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ToILongNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                return super.toI(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.toI(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.ToINode create0(IntegerNodes.ToINode current2) {
                return new ToILongNode((ToIBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToIIntNode
        extends ToIBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToIIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ToIIntNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                return super.toI(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.toI(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.ToINode create0(IntegerNodes.ToINode current2) {
                return new ToIIntNode((ToIBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.ToINode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToIUninitializedNode
        extends ToIBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToIUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToIUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToIUninitializedNode(ToIBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToIBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToIBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.ToINode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToIUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IntegerNodes.ToINode.class)
        private static abstract class ToIBaseNode
        extends IntegerNodes.ToINode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToIBaseNode next0;

            ToIBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToIBaseNode(ToIBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToIBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToIBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToIUninitializedNode(this);
                    ((ToIUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ToIBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ToIUninitializedNode(this), new ToIPolymorphicNode(this), (ToIBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToIBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ToIBaseNode)ToIIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ToIBaseNode)ToILongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ToIBaseNode)ToIRubyBignumNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToIBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToIBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=IntegerNodes.TimesNode.class)
    public static final class TimesNodeFactory
    extends NodeFactoryBase<IntegerNodes.TimesNode> {
        private static TimesNodeFactory timesNodeFactoryInstance;

        private TimesNodeFactory() {
            super(IntegerNodes.TimesNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public IntegerNodes.TimesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return TimesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IntegerNodes.TimesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return TimesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IntegerNodes.TimesNode> getInstance() {
            if (timesNodeFactoryInstance == null) {
                timesNodeFactoryInstance = new TimesNodeFactory();
            }
            return timesNodeFactoryInstance;
        }

        @GeneratedBy(value=IntegerNodes.TimesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class TimesPolymorphicNode
        extends TimesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            TimesPolymorphicNode(TimesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyProc.class ? this.arguments[1].executeRubyProc(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=IntegerNodes.TimesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TimesObjectRubyBignumRubyProcNode
        extends TimesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TimesObjectRubyBignumRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class, RubyProc.class}, 0, 0);

            TimesObjectRubyBignumRubyProcNode(TimesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBignum");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.times(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.times(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static IntegerNodes.TimesNode create0(IntegerNodes.TimesNode current2) {
                return new TimesObjectRubyBignumRubyProcNode((TimesBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.TimesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TimesObjectLongRubyProcNode
        extends TimesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TimesObjectLongRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, RubyProc.class}, 0, 0);

            TimesObjectLongRubyProcNode(TimesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof long");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.times(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.times(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static IntegerNodes.TimesNode create0(IntegerNodes.TimesNode current2) {
                return new TimesObjectLongRubyProcNode((TimesBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.TimesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TimesObjectIntRubyProcNode
        extends TimesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TimesObjectIntRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyProc.class}, 0, 0);

            TimesObjectIntRubyProcNode(TimesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.times(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.times(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static IntegerNodes.TimesNode create0(IntegerNodes.TimesNode current2) {
                return new TimesObjectIntRubyProcNode((TimesBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.TimesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class TimesRubyArrayIntUndefinedPlaceholderNode
        extends TimesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TimesRubyArrayIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            TimesRubyArrayIntUndefinedPlaceholderNode(TimesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                return super.times(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.times(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static IntegerNodes.TimesNode create0(IntegerNodes.TimesNode current2) {
                return new TimesRubyArrayIntUndefinedPlaceholderNode((TimesBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.TimesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class TimesUninitializedNode
        extends TimesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(TimesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            TimesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            TimesUninitializedNode(TimesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                TimesBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    TimesBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static IntegerNodes.TimesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new TimesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IntegerNodes.TimesNode.class)
        private static abstract class TimesBaseNode
        extends IntegerNodes.TimesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected TimesBaseNode next0;

            TimesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            TimesBaseNode(TimesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                TimesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                TimesBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new TimesUninitializedNode(this);
                    ((TimesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = TimesBaseNode.createInfo0(reason2, arguments0Value, arguments1Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new TimesUninitializedNode(this), new TimesPolymorphicNode(this), (TimesBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final TimesBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (TimesBaseNode)TimesRubyArrayIntUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                        return (TimesBaseNode)TimesObjectIntRubyProcNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                        return (TimesBaseNode)TimesObjectLongRubyProcNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                        return (TimesBaseNode)TimesObjectRubyBignumRubyProcNode.create0(this);
                    }
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    TimesBaseNode otherCast = (TimesBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (TimesBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=IntegerNodes.FloorNode.class)
    public static final class FloorNodeFactory
    extends NodeFactoryBase<IntegerNodes.FloorNode> {
        private static FloorNodeFactory floorNodeFactoryInstance;

        private FloorNodeFactory() {
            super(IntegerNodes.FloorNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public IntegerNodes.FloorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FloorNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IntegerNodes.FloorNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FloorUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IntegerNodes.FloorNode> getInstance() {
            if (floorNodeFactoryInstance == null) {
                floorNodeFactoryInstance = new FloorNodeFactory();
            }
            return floorNodeFactoryInstance;
        }

        @GeneratedBy(value=IntegerNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FloorPolymorphicNode
        extends FloorBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            FloorPolymorphicNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=IntegerNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FloorRubyBignumNode
        extends FloorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FloorRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            FloorRubyBignumNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum value2;
                try {
                    value2 = this.executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyBignum executeBignum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum"));
                }
                return super.floor(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.floor(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.FloorNode create0(IntegerNodes.FloorNode current2) {
                return new FloorRubyBignumNode((FloorBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FloorLongNode
        extends FloorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FloorLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            FloorLongNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                return super.floor(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.floor(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.FloorNode create0(IntegerNodes.FloorNode current2) {
                return new FloorLongNode((FloorBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FloorIntNode
        extends FloorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FloorIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            FloorIntNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                return super.floor(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.floor(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.FloorNode create0(IntegerNodes.FloorNode current2) {
                return new FloorIntNode((FloorBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.FloorNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FloorUninitializedNode
        extends FloorBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FloorUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FloorUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FloorUninitializedNode(FloorBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                FloorBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FloorBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.FloorNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FloorUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IntegerNodes.FloorNode.class)
        private static abstract class FloorBaseNode
        extends IntegerNodes.FloorNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FloorBaseNode next0;

            FloorBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FloorBaseNode(FloorBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                FloorBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FloorBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new FloorUninitializedNode(this);
                    ((FloorUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = FloorBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new FloorUninitializedNode(this), new FloorPolymorphicNode(this), (FloorBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FloorBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (FloorBaseNode)FloorIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (FloorBaseNode)FloorLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (FloorBaseNode)FloorRubyBignumNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((FloorBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (FloorBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=IntegerNodes.ChrNode.class)
    public static final class ChrNodeFactory
    extends NodeFactoryBase<IntegerNodes.ChrNode> {
        private static ChrNodeFactory chrNodeFactoryInstance;

        private ChrNodeFactory() {
            super(IntegerNodes.ChrNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public IntegerNodes.ChrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ChrNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IntegerNodes.ChrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ChrUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IntegerNodes.ChrNode> getInstance() {
            if (chrNodeFactoryInstance == null) {
                chrNodeFactoryInstance = new ChrNodeFactory();
            }
            return chrNodeFactoryInstance;
        }

        @GeneratedBy(value=IntegerNodes.ChrNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ChrPolymorphicNode
        extends ChrBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ChrPolymorphicNode(ChrBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=IntegerNodes.ChrNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ChrIntNode
        extends ChrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChrIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ChrIntNode(ChrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.chr(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.chr(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.ChrNode create0(IntegerNodes.ChrNode current2) {
                return new ChrIntNode((ChrBaseNode)current2);
            }
        }

        @GeneratedBy(value=IntegerNodes.ChrNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ChrUninitializedNode
        extends ChrBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChrUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ChrUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ChrUninitializedNode(ChrBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ChrBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ChrBaseNode rootNode = DSLShare.findRoot(this);
                    throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.arguments[0]}, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arguments0Value);
            }

            static IntegerNodes.ChrNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ChrUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IntegerNodes.ChrNode.class)
        private static abstract class ChrBaseNode
        extends IntegerNodes.ChrNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ChrBaseNode next0;

            ChrBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ChrBaseNode(ChrBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ChrBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ChrBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ChrUninitializedNode(this);
                    ((ChrUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ChrBaseNode.createInfo0(reason2, arguments0Value))) == null) {
                    returnNode = DSLShare.rewriteToPolymorphic(this, new ChrUninitializedNode(this), new ChrPolymorphicNode(this), (ChrBaseNode)this.copy(), newNode, message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ChrBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ChrBaseNode)ChrIntNode.create0(this);
                }
                return null;
            }

            @Override
            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ChrBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ChrBaseNode)newNext;
            }

            @Override
            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
            }

            @Override
            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }
}

