/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Float")
public abstract class FloatNodes {

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(double value2) {
            return this.getContext().makeString(Double.toString(value2));
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToFNode(ToFNode prev) {
            super(prev);
        }

        @Specialization
        public double toF(double value2) {
            return value2;
        }
    }

    @CoreMethod(names={"to_i", "to_int", "truncate"})
    public static abstract class ToINode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public ToINode(ToINode prev) {
            super(prev);
            this.fixnumOrBignum = prev.fixnumOrBignum;
        }

        @Specialization
        public Object toI(double value2) {
            if (Double.isInfinite(value2)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(value2)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("NaN", this));
            }
            return this.fixnumOrBignum.fixnumOrBignum(value2);
        }
    }

    @CoreMethod(names={"round"})
    public static abstract class RoundNode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;
        private final BranchProfile greaterZero = BranchProfile.create();
        private final BranchProfile lessZero = BranchProfile.create();

        public RoundNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public RoundNode(RoundNode prev) {
            super(prev);
            this.fixnumOrBignum = prev.fixnumOrBignum;
        }

        @Specialization
        public Object round(double n) {
            if (Double.isInfinite(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("NaN", this));
            }
            double f = n;
            if (f > 0.0) {
                this.greaterZero.enter();
                f = Math.floor(f);
                if (n - f >= 0.5) {
                    f += 1.0;
                }
            } else if (f < 0.0) {
                this.lessZero.enter();
                f = Math.ceil(f);
                if (f - n >= 0.5) {
                    f -= 1.0;
                }
            }
            return this.fixnumOrBignum.fixnumOrBignum(f);
        }
    }

    @CoreMethod(names={"nan?"})
    public static abstract class NaNNode
    extends CoreMethodNode {
        public NaNNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NaNNode(NaNNode prev) {
            super(prev);
        }

        @Specialization
        public boolean nan(double value2) {
            return Double.isNaN(value2);
        }
    }

    @CoreMethod(names={"infinite?"})
    public static abstract class InfiniteNode
    extends CoreMethodNode {
        public InfiniteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InfiniteNode(InfiniteNode prev) {
            super(prev);
        }

        @Specialization
        public Object infinite(double value2) {
            if (Double.isInfinite(value2)) {
                if (value2 < 0.0) {
                    return -1;
                }
                return 1;
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"floor"})
    public static abstract class FloorNode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public FloorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public FloorNode(FloorNode prev) {
            super(prev);
            this.fixnumOrBignum = prev.fixnumOrBignum;
        }

        @Specialization
        public Object floor(double n) {
            return this.fixnumOrBignum.fixnumOrBignum(Math.floor(n));
        }
    }

    @CoreMethod(names={"ceil"})
    public static abstract class CeilNode
    extends CoreMethodNode {
        public CeilNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CeilNode(CeilNode prev) {
            super(prev);
        }

        @Specialization
        public double ceil(double n) {
            return Math.ceil(n);
        }
    }

    @CoreMethod(names={"abs"})
    public static abstract class AbsNode
    extends CoreMethodNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AbsNode(AbsNode prev) {
            super(prev);
        }

        @Specialization
        public double abs(double n) {
            return Math.abs(n);
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterNode(GreaterNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(double a, int b2) {
            return a > (double)b2;
        }

        @Specialization
        public boolean equal(double a, long b2) {
            return a > (double)b2;
        }

        @Specialization
        public boolean equal(double a, double b2) {
            return a > b2;
        }

        @Specialization
        public boolean equal(double a, RubyBignum b2) {
            return a > b2.doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public boolean less(double a, RubyBasicObject other) {
            throw new RaiseException(new RubyException(this.getContext().getCoreLibrary().getArgumentErrorClass(), this.getContext().makeString(String.format("comparison of Float with %s failed", other.getLogicalClass().getName())), RubyCallStack.getBacktrace(this)));
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterEqualNode(GreaterEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greaterEqual(double a, int b2) {
            return a >= (double)b2;
        }

        @Specialization
        public boolean greaterEqual(double a, long b2) {
            return a >= (double)b2;
        }

        @Specialization
        public boolean greaterEqual(double a, double b2) {
            return a >= b2;
        }

        @Specialization
        public boolean greaterEqual(double a, RubyBignum b2) {
            return a >= b2.doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public boolean less(double a, RubyBasicObject other) {
            throw new RaiseException(new RubyException(this.getContext().getCoreLibrary().getArgumentErrorClass(), this.getContext().makeString(String.format("comparison of Float with %s failed", other.getLogicalClass().getName())), RubyCallStack.getBacktrace(this)));
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        @Specialization
        public int compare(double a, double b2) {
            return Double.compare(a, b2);
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(double a, int b2) {
            return a == (double)b2;
        }

        @Specialization
        public boolean equal(double a, long b2) {
            return a == (double)b2;
        }

        @Specialization
        public boolean equal(double a, double b2) {
            return a == b2;
        }

        @Specialization
        public boolean equal(double a, RubyBignum b2) {
            return a == b2.doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public boolean less(double a, RubyBasicObject other) {
            return false;
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessEqualNode(LessEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean lessEqual(double a, int b2) {
            return a <= (double)b2;
        }

        @Specialization
        public boolean lessEqual(double a, long b2) {
            return a <= (double)b2;
        }

        @Specialization
        public boolean lessEqual(double a, double b2) {
            return a <= b2;
        }

        @Specialization
        public boolean lessEqual(double a, RubyBignum b2) {
            return a <= b2.doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public boolean less(double a, RubyBasicObject other) {
            throw new RaiseException(new RubyException(this.getContext().getCoreLibrary().getArgumentErrorClass(), this.getContext().makeString(String.format("comparison of Float with %s failed", other.getLogicalClass().getName())), RubyCallStack.getBacktrace(this)));
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessNode(LessNode prev) {
            super(prev);
        }

        @Specialization
        public boolean less(double a, int b2) {
            return a < (double)b2;
        }

        @Specialization
        public boolean less(double a, long b2) {
            return a < (double)b2;
        }

        @Specialization
        public boolean less(double a, double b2) {
            return a < b2;
        }

        @Specialization
        public boolean less(double a, RubyBignum b2) {
            return a < b2.doubleValue();
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public boolean less(double a, RubyBasicObject other) {
            throw new RaiseException(new RubyException(this.getContext().getCoreLibrary().getArgumentErrorClass(), this.getContext().makeString(String.format("comparison of Float with %s failed", other.getLogicalClass().getName())), RubyCallStack.getBacktrace(this)));
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodNode {
        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DivModNode(DivModNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray divMod(double a, int b2) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public RubyArray divMod(double a, long b2) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public RubyArray divMod(double a, double b2) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public RubyArray divMod(double a, RubyBignum b2) {
            throw new UnsupportedOperationException();
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends CoreMethodNode {
        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ModNode(ModNode prev) {
            super(prev);
        }

        @Specialization
        public double mod(double a, int b2) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public double mod(double a, long b2) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public double mod(double a, double b2) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public double mod(double a, RubyBignum b2) {
            throw new UnsupportedOperationException();
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode redoCoercedNode;

        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DivNode(DivNode prev) {
            super(prev);
            this.redoCoercedNode = prev.redoCoercedNode;
        }

        @Specialization
        public double div(double a, int b2) {
            return a / (double)b2;
        }

        @Specialization
        public double div(double a, long b2) {
            return a / (double)b2;
        }

        @Specialization
        public double div(double a, double b2) {
            return a / b2;
        }

        @Specialization
        public double div(double a, RubyBignum b2) {
            return a / b2.doubleValue();
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isDouble(arguments[1])", "!isRubyBignum(arguments[1])"})
        public Object div(VirtualFrame frame, double a, Object b2) {
            if (this.redoCoercedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.redoCoercedNode = DispatchHeadNodeFactory.createMethodCall(this.getContext(), true);
            }
            return this.redoCoercedNode.call(frame, a, "redo_coerced", null, this.getContext().getSymbolTable().getSymbol("/"), b2);
        }
    }

    @CoreMethod(names={"**"}, required=1)
    public static abstract class PowNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode complexConvertNode;
        @Node.Child
        private CallDispatchHeadNode complexPowNode;
        @Node.Child
        private CallDispatchHeadNode rationalPowNode;
        private final ConditionProfile complexProfile = ConditionProfile.createBinaryProfile();

        public PowNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PowNode(PowNode prev) {
            super(prev);
            this.rationalPowNode = prev.rationalPowNode;
        }

        @Specialization
        public double pow(double a, int b2) {
            return Math.pow(a, b2);
        }

        @Specialization
        public double pow(double a, long b2) {
            return Math.pow(a, b2);
        }

        @Specialization
        public Object pow(VirtualFrame frame, double a, double b2) {
            if (this.complexProfile.profile(a < 0.0 && b2 != (double)Math.round(b2))) {
                if (this.complexConvertNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.complexConvertNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                    this.complexPowNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                Object aComplex = this.complexConvertNode.call(frame, this.getContext().getCoreLibrary().getComplexClass(), "convert", null, a, 0);
                return this.complexPowNode.call(frame, aComplex, "**", null, b2);
            }
            return Math.pow(a, b2);
        }

        @Specialization
        public double pow(double a, RubyBignum b2) {
            return Math.pow(a, b2.doubleValue());
        }

        @Specialization(guards={"isRational(arguments[1])"})
        public Object pow(VirtualFrame frame, double a, RubyBasicObject b2) {
            if (this.rationalPowNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.rationalPowNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.rationalPowNode.call(frame, a, "pow_rational", null, b2);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode rationalConvertNode;
        @Node.Child
        private CallDispatchHeadNode rationalPowNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
            this.rationalConvertNode = prev.rationalConvertNode;
            this.rationalPowNode = prev.rationalPowNode;
        }

        @Specialization
        public double mul(double a, int b2) {
            return a * (double)b2;
        }

        @Specialization
        public double mul(double a, long b2) {
            return a * (double)b2;
        }

        @Specialization
        public double mul(double a, double b2) {
            return a * b2;
        }

        @Specialization
        public double mul(double a, RubyBignum b2) {
            return a * b2.doubleValue();
        }

        @Specialization(guards={"isRational(arguments[1])"})
        public Object mul(VirtualFrame frame, double a, RubyBasicObject b2) {
            if (this.rationalConvertNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.rationalConvertNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                this.rationalPowNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object aRational = this.rationalConvertNode.call(frame, this.getContext().getCoreLibrary().getRationalClass(), "convert", null, a, 1);
            return this.rationalPowNode.call(frame, aRational, "*", null, b2);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends CoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SubNode(SubNode prev) {
            super(prev);
        }

        @Specialization
        public double sub(double a, int b2) {
            return a - (double)b2;
        }

        @Specialization
        public double sub(double a, long b2) {
            return a - (double)b2;
        }

        @Specialization
        public double sub(double a, double b2) {
            return a - b2;
        }

        @Specialization
        public double sub(double a, RubyBignum b2) {
            return a - b2.doubleValue();
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends CoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
        }

        @Specialization
        public double add(double a, int b2) {
            return a + (double)b2;
        }

        @Specialization
        public double add(double a, long b2) {
            return a + (double)b2;
        }

        @Specialization
        public double add(double a, double b2) {
            return a + b2;
        }

        @Specialization
        public double add(double a, RubyBignum b2) {
            return a + b2.doubleValue();
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NegNode(NegNode prev) {
            super(prev);
        }

        @Specialization
        public double neg(double value2) {
            return -value2;
        }
    }
}

