/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import jnr.posix.FileStat;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyFile;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;

@CoreClass(name="File")
public abstract class FileNodes {

    @CoreMethod(names={"write"}, required=1)
    public static abstract class WriteNode
    extends CoreMethodNode {
        public WriteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public WriteNode(WriteNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass write(RubyFile file2, RubyString string2) {
            WriteNode.notDesignedForCompilation();
            try {
                Writer writer = file2.getWriter();
                writer.write(string2.toString());
                writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"symlink?"}, onSingleton=true, required=1)
    public static abstract class SymlinkQueryNode
    extends CoreMethodNode {
        public SymlinkQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SymlinkQueryNode(SymlinkQueryNode prev) {
            super(prev);
        }

        @Specialization
        public boolean symlinkQuery(RubyString fileName) {
            SymlinkQueryNode.notDesignedForCompilation();
            try {
                FileStat stat2 = this.getContext().getRuntime().getPosix().allocateStat();
                if (this.getContext().getRuntime().getPosix().lstat(fileName.toString(), stat2) < 0) {
                    stat2 = null;
                }
                return stat2 != null && stat2.isSymlink();
            }
            catch (SecurityException re) {
                return false;
            }
        }
    }

    @CoreMethod(names={"size?"}, onSingleton=true, required=1)
    public static abstract class SizeNode
    extends CoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization
        public Object read(RubyString file2) {
            SizeNode.notDesignedForCompilation();
            File f = new File(file2.toString());
            if (!f.exists()) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            long size2 = f.length();
            if (size2 == 0L) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return size2;
        }
    }

    @CoreMethod(names={"read"})
    public static abstract class ReadNode
    extends CoreMethodNode {
        public ReadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReadNode(ReadNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString read(RubyFile file2) {
            ReadNode.notDesignedForCompilation();
            try {
                int c;
                Reader reader = file2.getReader();
                StringBuilder builder = new StringBuilder();
                while ((c = reader.read()) != -1) {
                    builder.append((char)c);
                }
                return this.getContext().makeString(builder.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CoreMethod(names={"read"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class ReadFunctionNode
    extends CoreMethodNode {
        public ReadFunctionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReadFunctionNode(ReadFunctionNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString read(RubyString path2) {
            ReadFunctionNode.notDesignedForCompilation();
            try {
                return new RubyString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(Files.readAllBytes(Paths.get(path2.toString(), new String[0]))));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CoreMethod(names={"puts"}, required=1)
    public static abstract class PutsNode
    extends CoreMethodNode {
        public PutsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PutsNode(PutsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass puts(RubyFile file2, RubyString string2) {
            PutsNode.notDesignedForCompilation();
            try {
                Writer writer = file2.getWriter();
                writer.write(string2.toString());
                writer.write("\n");
                writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"path"}, onSingleton=true, required=1)
    public static abstract class PathNode
    extends CoreMethodNode {
        public PathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PathNode(PathNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString path(RubyString path2) {
            PathNode.notDesignedForCompilation();
            return this.getContext().makeString(path2.toString());
        }
    }

    @CoreMethod(names={"join"}, onSingleton=true, argumentsAsArray=true)
    public static abstract class JoinNode
    extends CoreMethodNode {
        public JoinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public JoinNode(JoinNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString join(Object[] parts) {
            JoinNode.notDesignedForCompilation();
            StringBuilder builder = new StringBuilder();
            JoinNode.join(builder, parts);
            return this.getContext().makeString(builder.toString());
        }

        @CompilerDirectives.TruffleBoundary
        public static void join(StringBuilder builder, Object[] parts) {
            JoinNode.notDesignedForCompilation();
            for (int n = 0; n < parts.length; ++n) {
                if (n > 0) {
                    builder.append(File.separator);
                }
                if (parts[n] instanceof RubyArray) {
                    JoinNode.join(builder, ((RubyArray)parts[n]).slowToArray());
                    continue;
                }
                builder.append(parts[n].toString());
            }
        }
    }

    @CoreMethod(names={"file?"}, onSingleton=true, required=1)
    public static abstract class FileNode
    extends CoreMethodNode {
        public FileNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FileNode(FileNode prev) {
            super(prev);
        }

        @Specialization
        public boolean file(RubyString path2) {
            FileNode.notDesignedForCompilation();
            return new File(path2.toString()).isFile();
        }
    }

    @CoreMethod(names={"expand_path"}, onSingleton=true, required=1, optional=1)
    public static abstract class ExpandPathNode
    extends CoreMethodNode {
        public ExpandPathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExpandPathNode(ExpandPathNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString expandPath(RubyString path2, UndefinedPlaceholder dir) {
            return this.getContext().makeString(RubyFile.expandPath(path2.toString()));
        }

        @Specialization
        public RubyString expandPath(RubyString path2, RubyString dir) {
            ExpandPathNode.notDesignedForCompilation();
            return this.getContext().makeString(RubyFile.expandPath(path2.toString(), dir.toString()));
        }
    }

    @CoreMethod(names={"exist?", "exists?"}, onSingleton=true, required=1)
    public static abstract class ExistsNode
    extends CoreMethodNode {
        public ExistsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExistsNode(ExistsNode prev) {
            super(prev);
        }

        @Specialization
        public boolean exists(RubyString path2) {
            ExistsNode.notDesignedForCompilation();
            return new File(path2.toString()).exists();
        }
    }

    @CoreMethod(names={"executable?"}, onSingleton=true, required=1)
    public static abstract class ExecutableNode
    extends CoreMethodNode {
        public ExecutableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExecutableNode(ExecutableNode prev) {
            super(prev);
        }

        @Specialization
        public boolean executable(RubyString path2) {
            ExecutableNode.notDesignedForCompilation();
            return new File(path2.toString()).canExecute();
        }
    }

    @CoreMethod(names={"each_line"}, needsBlock=true)
    public static abstract class EachLineNode
    extends YieldingCoreMethodNode {
        public EachLineNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachLineNode(EachLineNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass eachLine(VirtualFrame frame, RubyFile file2, RubyProc block) {
            EachLineNode.notDesignedForCompilation();
            RubyContext context = this.getContext();
            BufferedReader lineReader = new BufferedReader(file2.getReader());
            while (true) {
                String line;
                try {
                    line = lineReader.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (line == null) break;
                this.yield(frame, block, context.makeString(line));
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"dirname"}, onSingleton=true, required=1)
    public static abstract class DirnameNode
    extends CoreMethodNode {
        public DirnameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DirnameNode(DirnameNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString dirname(RubyString path2) {
            DirnameNode.notDesignedForCompilation();
            String parent = new File(path2.toString()).getParent();
            if (parent == null) {
                return this.getContext().makeString(".");
            }
            return this.getContext().makeString(parent);
        }
    }

    @CoreMethod(names={"directory?"}, onSingleton=true, required=1)
    public static abstract class DirectoryNode
    extends CoreMethodNode {
        public DirectoryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DirectoryNode(DirectoryNode prev) {
            super(prev);
        }

        @Specialization
        public boolean directory(RubyString path2) {
            DirectoryNode.notDesignedForCompilation();
            return new File(path2.toString()).isDirectory();
        }
    }

    @CoreMethod(names={"delete", "unlink"}, onSingleton=true, required=1)
    public static abstract class DeleteNode
    extends CoreMethodNode {
        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DeleteNode(DeleteNode prev) {
            super(prev);
        }

        @Specialization
        public int delete(RubyString file2) {
            DeleteNode.notDesignedForCompilation();
            if (!new File(file2.toString()).delete()) {
                throw new UnsupportedOperationException();
            }
            return 1;
        }
    }

    @CoreMethod(names={"close"})
    public static abstract class CloseNode
    extends CoreMethodNode {
        public CloseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CloseNode(CloseNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass close(RubyFile file2) {
            CloseNode.notDesignedForCompilation();
            file2.close();
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"absolute_path"}, onSingleton=true, required=1)
    public static abstract class AbsolutePathNode
    extends CoreMethodNode {
        public AbsolutePathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AbsolutePathNode(AbsolutePathNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString absolutePath(RubyString path2) {
            AbsolutePathNode.notDesignedForCompilation();
            return this.getContext().makeString(new File(path2.toString()).getAbsolutePath());
        }
    }
}

