/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.globals.GetFromThreadLocalNode;
import org.jruby.truffle.nodes.globals.WrapInThreadLocalNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubySymbol;

@CoreClass(name="Binding")
public abstract class BindingNodes {

    @CoreMethod(names={"local_variable_set"}, required=2)
    public static abstract class LocalVariableSetNode
    extends CoreMethodNode {
        public LocalVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LocalVariableSetNode(LocalVariableSetNode prev) {
            super(prev);
        }

        @Specialization
        public Object localVariableSetNode(RubyBinding binding2, RubySymbol symbol, Object value2) {
            FrameSlot frameSlot;
            MaterializedFrame frame;
            block2: {
                LocalVariableSetNode.notDesignedForCompilation();
                if (symbol.toString().equals("$_")) {
                    value2 = WrapInThreadLocalNode.wrap(this.getContext(), value2);
                }
                frame = binding2.getFrame();
                do {
                    if ((frameSlot = frame.getFrameDescriptor().findFrameSlot(symbol.toString())) != null) break block2;
                } while ((frame = RubyArguments.getDeclarationFrame(frame.getArguments())) != null);
                throw new UnsupportedOperationException();
            }
            frame.setObject(frameSlot, value2);
            return value2;
        }
    }

    @CoreMethod(names={"local_variable_get"}, required=1)
    public static abstract class LocalVariableGetNode
    extends CoreMethodNode {
        public LocalVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LocalVariableGetNode(LocalVariableGetNode prev) {
            super(prev);
        }

        @Specialization
        public Object localVariableGet(RubyBinding binding2, RubySymbol symbol) {
            LocalVariableGetNode.notDesignedForCompilation();
            MaterializedFrame frame = binding2.getFrame();
            Object value2 = frame.getValue(frame.getFrameDescriptor().findFrameSlot(symbol.toString()));
            if (symbol.toString().equals("$_")) {
                value2 = GetFromThreadLocalNode.get(this.getContext(), value2);
            }
            return value2;
        }
    }
}

