/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.nodes.core.ArraySliceNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=ArraySliceNode.class)
public final class ArraySliceNodeFactory
extends NodeFactoryBase<ArraySliceNode> {
    private static ArraySliceNodeFactory instance;

    private ArraySliceNodeFactory() {
        super(ArraySliceNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, Integer.TYPE, Integer.TYPE, RubyNode.class}});
    }

    @Override
    public ArraySliceNode createNode(Object ... arguments) {
        if (arguments.length == 5 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection) && arguments[2] instanceof Integer && arguments[3] instanceof Integer && (arguments[4] == null || arguments[4] instanceof RubyNode)) {
            return ArraySliceNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (Integer)arguments[2], (Integer)arguments[3], (RubyNode)arguments[4]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArraySliceNode create(RubyContext context, SourceSection sourceSection, int from, int to, RubyNode array) {
        return ArraySliceUninitializedNode.create0(context, sourceSection, from, to, array);
    }

    public static NodeFactory<ArraySliceNode> getInstance() {
        if (instance == null) {
            instance = new ArraySliceNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArraySliceNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArraySlicePolymorphicNode
    extends ArraySliceBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;

        ArraySlicePolymorphicNode(ArraySliceBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object arrayValue = this.array.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            return this.next0.executeChained0(frameValue, arrayValue);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArraySliceRubyArray4Node
    extends ArraySliceBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArraySliceRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArraySliceRubyArray4Node(ArraySliceBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isObject(arrayValue)) {
                return super.sliceObject(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isObject] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isObject(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.sliceObject(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArraySliceNode create0(ArraySliceNode current2) {
            return new ArraySliceRubyArray4Node((ArraySliceBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArraySliceRubyArray3Node
    extends ArraySliceBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArraySliceRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArraySliceRubyArray3Node(ArraySliceBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isFloat(arrayValue)) {
                return super.sliceFloat(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isFloat] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isFloat(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.sliceFloat(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArraySliceNode create0(ArraySliceNode current2) {
            return new ArraySliceRubyArray3Node((ArraySliceBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArraySliceRubyArray2Node
    extends ArraySliceBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArraySliceRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArraySliceRubyArray2Node(ArraySliceBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isLongFixnum(arrayValue)) {
                return super.sliceLongFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isLongFixnum] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isLongFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.sliceLongFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArraySliceNode create0(ArraySliceNode current2) {
            return new ArraySliceRubyArray2Node((ArraySliceBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArraySliceRubyArray1Node
    extends ArraySliceBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArraySliceRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArraySliceRubyArray1Node(ArraySliceBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isIntegerFixnum(arrayValue)) {
                return super.sliceIntegerFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isIntegerFixnum] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isIntegerFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.sliceIntegerFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArraySliceNode create0(ArraySliceNode current2) {
            return new ArraySliceRubyArray1Node((ArraySliceBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArraySliceRubyArray0Node
    extends ArraySliceBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArraySliceRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArraySliceRubyArray0Node(ArraySliceBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isNull(arrayValue)) {
                return super.sliceNull(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isNull] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isNull(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.sliceNull(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArraySliceNode create0(ArraySliceNode current2) {
            return new ArraySliceRubyArray0Node((ArraySliceBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArraySliceUninitializedNode
    extends ArraySliceBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArraySliceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArraySliceUninitializedNode(RubyContext context, SourceSection sourceSection, int from, int to, RubyNode array) {
            super(context, sourceSection, from, to, array);
        }

        ArraySliceUninitializedNode(ArraySliceBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arrayValue) {
            ArraySliceBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArraySliceBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.array}, arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arrayValue);
        }

        static ArraySliceNode create0(RubyContext context, SourceSection sourceSection, int from, int to, RubyNode array) {
            return new ArraySliceUninitializedNode(context, sourceSection, from, to, array);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    private static abstract class ArraySliceBaseNode
    extends ArraySliceNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected ArraySliceBaseNode next0;

        ArraySliceBaseNode(RubyContext context, SourceSection sourceSection, int from, int to, RubyNode array) {
            super(context, sourceSection, from, to);
            this.array = array;
        }

        ArraySliceBaseNode(ArraySliceBaseNode copy) {
            super(copy);
        }

        protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

        protected final RubyArray rewrite0(VirtualFrame frameValue, Object arrayValue, String reason2) {
            String message2;
            ArraySliceBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArraySliceBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                newNode = new ArraySliceUninitializedNode(this);
                ((ArraySliceUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ArraySliceBaseNode.createInfo0(reason2, arrayValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new ArraySliceUninitializedNode(this), new ArraySlicePolymorphicNode(this), (ArraySliceBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, arrayValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArraySliceBaseNode specialize0(Object arrayValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                if (ArrayGuards.isNull(arrayValueCast)) {
                    return (ArraySliceBaseNode)ArraySliceRubyArray0Node.create0(this);
                }
                if (ArrayGuards.isIntegerFixnum(arrayValueCast)) {
                    return (ArraySliceBaseNode)ArraySliceRubyArray1Node.create0(this);
                }
                if (ArrayGuards.isLongFixnum(arrayValueCast)) {
                    return (ArraySliceBaseNode)ArraySliceRubyArray2Node.create0(this);
                }
                if (ArrayGuards.isFloat(arrayValueCast)) {
                    return (ArraySliceBaseNode)ArraySliceRubyArray3Node.create0(this);
                }
                if (ArrayGuards.isObject(arrayValueCast)) {
                    return (ArraySliceBaseNode)ArraySliceRubyArray4Node.create0(this);
                }
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.array = other == null ? null : ((ArraySliceBaseNode)other).array;
            this.next0 = newNext == null ? null : (ArraySliceBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object arrayValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

