/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.nodes.core.ArrayIndexNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@GeneratedBy(value=ArrayIndexNode.class)
public final class ArrayIndexNodeFactory
extends NodeFactoryBase<ArrayIndexNode> {
    private static ArrayIndexNodeFactory instance;

    private ArrayIndexNodeFactory() {
        super(ArrayIndexNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, Integer.TYPE, RubyNode.class}});
    }

    @Override
    public ArrayIndexNode createNode(Object ... arguments) {
        if (arguments.length == 4 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection) && arguments[2] instanceof Integer && (arguments[3] == null || arguments[3] instanceof RubyNode)) {
            return ArrayIndexNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (Integer)arguments[2], (RubyNode)arguments[3]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayIndexNode create(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
        return ArrayIndexUninitializedNode.create0(context, sourceSection, index2, array);
    }

    public static NodeFactory<ArrayIndexNode> getInstance() {
        if (instance == null) {
            instance = new ArrayIndexNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayIndexPolymorphicNode
    extends ArrayIndexBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;

        ArrayIndexPolymorphicNode(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arrayValue = this.array.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            return this.next0.executeChained0(frameValue, arrayValue);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayIndexObject3Node
    extends ArrayIndexBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayIndexObject3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayIndexObject3Node(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isObject(arrayValue)) {
                return super.getObject(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isObject] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isObject(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getObject(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayIndexNode create0(ArrayIndexNode current2) {
            return new ArrayIndexObject3Node((ArrayIndexBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayIndexObject2Node
    extends ArrayIndexBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayIndexObject2Node.class, new Class[]{ArrayIndexDoubleNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayIndexObject2Node(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isFloat(arrayValue)) {
                return super.getFloat(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isFloat] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isFloat(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getFloat(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayIndexNode create0(ArrayIndexNode current2) {
            return new ArrayIndexObject2Node((ArrayIndexBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayIndexDoubleNode
    extends ArrayIndexBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayIndexDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ArrayIndexObject2Node.class}, new Class[]{RubyArray.class}, 0, 0);

        ArrayIndexDoubleNode(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value2;
            try {
                value2 = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray"));
            }
            if (ArrayGuards.isFloat(arrayValue)) {
                try {
                    return super.getFloatInBounds(arrayValue);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, "Thrown UnexpectedResultException"));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, "One of guards [isFloat] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isFloat(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                try {
                    return super.getFloatInBounds(arrayValueCast);
                }
                catch (UnexpectedResultException rewriteEx) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.rewrite0(frameValue, arrayValue, "Thrown UnexpectedResultException");
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayIndexNode create0(ArrayIndexNode current2) {
            return new ArrayIndexDoubleNode((ArrayIndexBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayIndexObject1Node
    extends ArrayIndexBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayIndexObject1Node.class, new Class[]{ArrayIndexLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayIndexObject1Node(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isLongFixnum(arrayValue)) {
                return super.getLongFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isLongFixnum] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isLongFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getLongFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayIndexNode create0(ArrayIndexNode current2) {
            return new ArrayIndexObject1Node((ArrayIndexBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayIndexLongNode
    extends ArrayIndexBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayIndexLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ArrayIndexObject1Node.class}, new Class[]{RubyArray.class}, 0, 0);

        ArrayIndexLongNode(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value2;
            try {
                value2 = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray"));
            }
            if (ArrayGuards.isLongFixnum(arrayValue)) {
                try {
                    return super.getLongFixnumInBounds(arrayValue);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, "Thrown UnexpectedResultException"));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, "One of guards [isLongFixnum] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isLongFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                try {
                    return super.getLongFixnumInBounds(arrayValueCast);
                }
                catch (UnexpectedResultException rewriteEx) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.rewrite0(frameValue, arrayValue, "Thrown UnexpectedResultException");
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayIndexNode create0(ArrayIndexNode current2) {
            return new ArrayIndexLongNode((ArrayIndexBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayIndexObject0Node
    extends ArrayIndexBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayIndexObject0Node.class, new Class[]{ArrayIndexIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayIndexObject0Node(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isIntegerFixnum(arrayValue)) {
                return super.getIntegerFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isIntegerFixnum] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isIntegerFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getIntegerFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayIndexNode create0(ArrayIndexNode current2) {
            return new ArrayIndexObject0Node((ArrayIndexBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayIndexIntNode
    extends ArrayIndexBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayIndexIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ArrayIndexObject0Node.class}, new Class[]{RubyArray.class}, 0, 0);

        ArrayIndexIntNode(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value2;
            try {
                value2 = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray"));
            }
            if (ArrayGuards.isIntegerFixnum(arrayValue)) {
                try {
                    return super.getIntegerFixnumInBounds(arrayValue);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, "Thrown UnexpectedResultException"));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, "One of guards [isIntegerFixnum] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isIntegerFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                try {
                    return super.getIntegerFixnumInBounds(arrayValueCast);
                }
                catch (UnexpectedResultException rewriteEx) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.rewrite0(frameValue, arrayValue, "Thrown UnexpectedResultException");
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayIndexNode create0(ArrayIndexNode current2) {
            return new ArrayIndexIntNode((ArrayIndexBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayIndexRubyNilClassNode
    extends ArrayIndexBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayIndexRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayIndexRubyNilClassNode(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value2;
            try {
                value2 = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray"));
            }
            if (ArrayGuards.isNull(arrayValue)) {
                return super.getNull(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, "One of guards [isNull] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isNull(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getNull(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayIndexNode create0(ArrayIndexNode current2) {
            return new ArrayIndexRubyNilClassNode((ArrayIndexBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayIndexUninitializedNode
    extends ArrayIndexBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayIndexUninitializedNode(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
            super(context, sourceSection, index2, array);
        }

        ArrayIndexUninitializedNode(ArrayIndexBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object arrayValue) {
            ArrayIndexBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayIndexBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.array}, arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, arrayValue);
        }

        static ArrayIndexNode create0(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
            return new ArrayIndexUninitializedNode(context, sourceSection, index2, array);
        }
    }

    @GeneratedBy(value=ArrayIndexNode.class)
    private static abstract class ArrayIndexBaseNode
    extends ArrayIndexNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected ArrayIndexBaseNode next0;

        ArrayIndexBaseNode(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
            super(context, sourceSection, index2);
            this.array = array;
        }

        ArrayIndexBaseNode(ArrayIndexBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object arrayValue, String reason2) {
            String message2;
            ArrayIndexBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayIndexBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                newNode = new ArrayIndexUninitializedNode(this);
                ((ArrayIndexUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = ArrayIndexBaseNode.createInfo0(reason2, arrayValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new ArrayIndexUninitializedNode(this), new ArrayIndexPolymorphicNode(this), (ArrayIndexBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, arrayValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayIndexBaseNode specialize0(Object arrayValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                if (ArrayGuards.isNull(arrayValueCast)) {
                    return (ArrayIndexBaseNode)ArrayIndexRubyNilClassNode.create0(this);
                }
                if (ArrayGuards.isIntegerFixnum(arrayValueCast) && !DSLShare.isExcluded(this, ArrayIndexIntNode.METADATA)) {
                    return (ArrayIndexBaseNode)ArrayIndexIntNode.create0(this);
                }
                if (ArrayGuards.isIntegerFixnum(arrayValueCast)) {
                    return (ArrayIndexBaseNode)ArrayIndexObject0Node.create0(this);
                }
                if (ArrayGuards.isLongFixnum(arrayValueCast) && !DSLShare.isExcluded(this, ArrayIndexLongNode.METADATA)) {
                    return (ArrayIndexBaseNode)ArrayIndexLongNode.create0(this);
                }
                if (ArrayGuards.isLongFixnum(arrayValueCast)) {
                    return (ArrayIndexBaseNode)ArrayIndexObject1Node.create0(this);
                }
                if (ArrayGuards.isFloat(arrayValueCast) && !DSLShare.isExcluded(this, ArrayIndexDoubleNode.METADATA)) {
                    return (ArrayIndexBaseNode)ArrayIndexDoubleNode.create0(this);
                }
                if (ArrayGuards.isFloat(arrayValueCast)) {
                    return (ArrayIndexBaseNode)ArrayIndexObject2Node.create0(this);
                }
                if (ArrayGuards.isObject(arrayValueCast)) {
                    return (ArrayIndexBaseNode)ArrayIndexObject3Node.create0(this);
                }
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.array = other == null ? null : ((ArrayIndexBaseNode)other).array;
            this.next0 = newNext == null ? null : (ArrayIndexBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object arrayValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

