/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.literal.ObjectLiteralNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyNilClass;

@NodeInfo(cost=NodeCost.NONE)
public final class SequenceNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] body;

    public static RubyNode sequence(RubyContext context, SourceSection sourceSection, RubyNode ... sequence) {
        return SequenceNode.sequence(context, sourceSection, Arrays.asList(sequence));
    }

    public static RubyNode sequence(RubyContext context, SourceSection sourceSection, List<RubyNode> sequence) {
        List<RubyNode> flattened = SequenceNode.flatten(sequence, true);
        if (flattened.isEmpty()) {
            return new ObjectLiteralNode(context, sourceSection, context.getCoreLibrary().getNilObject());
        }
        if (flattened.size() == 1) {
            return flattened.get(0);
        }
        return new SequenceNode(context, sourceSection, flattened.toArray(new RubyNode[flattened.size()]));
    }

    private static List<RubyNode> flatten(List<RubyNode> sequence, boolean allowTrailingNil) {
        ArrayList<RubyNode> flattened = new ArrayList<RubyNode>();
        for (int n = 0; n < sequence.size(); ++n) {
            boolean lastNode = n == sequence.size() - 1;
            RubyNode node = sequence.get(n);
            if (node instanceof ObjectLiteralNode && ((ObjectLiteralNode)node).getObject() instanceof RubyNilClass) {
                if (!allowTrailingNil || !lastNode) continue;
                flattened.add(node);
                continue;
            }
            if (node instanceof SequenceNode) {
                flattened.addAll(SequenceNode.flatten(Arrays.asList(((SequenceNode)node).body), lastNode));
                continue;
            }
            flattened.add(node);
        }
        return flattened;
    }

    protected SequenceNode(RubyContext context, SourceSection sourceSection, RubyNode ... body) {
        super(context, sourceSection);
        this.body = body;
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        for (int n = 0; n < this.body.length - 1; ++n) {
            this.body[n].executeVoid(frame);
        }
        return this.body[this.body.length - 1].execute(frame);
    }

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        for (int n = 0; n < this.body.length; ++n) {
            this.body[n].executeVoid(frame);
        }
    }
}

