/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.StringToSymbolNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=StringToSymbolNode.class)
public final class StringToSymbolNodeFactory
extends NodeFactoryBase<StringToSymbolNode> {
    private static StringToSymbolNodeFactory instance;

    private StringToSymbolNodeFactory() {
        super(StringToSymbolNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    @Override
    public StringToSymbolNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return StringToSymbolNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static StringToSymbolNode create(RubyContext context, SourceSection sourceSection, RubyNode string2) {
        return StringToSymbolUninitializedNode.create0(context, sourceSection, string2);
    }

    public static NodeFactory<StringToSymbolNode> getInstance() {
        if (instance == null) {
            instance = new StringToSymbolNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=StringToSymbolNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class StringToSymbolPolymorphicNode
    extends StringToSymbolBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> stringPolymorphicType;

        StringToSymbolPolymorphicNode(StringToSymbolBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol value2;
            try {
                value2 = this.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
            Object stringValue = this.string.execute(frameValue);
            return this.next0.executeChained0(frameValue, stringValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.stringPolymorphicType = types[0];
        }

        @Override
        protected RubySymbol executeChained0(VirtualFrame frameValue, Object stringValue) {
            return this.next0.executeChained0(frameValue, stringValue);
        }
    }

    @GeneratedBy(value=StringToSymbolNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class StringToSymbolRubyStringNode
    extends StringToSymbolBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(StringToSymbolRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

        StringToSymbolRubyStringNode(StringToSymbolBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol value2;
            try {
                value2 = this.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyString stringValue;
            try {
                stringValue = this.string.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected stringValue instanceof RubyString");
            }
            return super.doString(stringValue);
        }

        @Override
        protected RubySymbol executeChained0(VirtualFrame frameValue, Object stringValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue)) {
                RubyString stringValueCast = RubyTypesGen.RUBYTYPES.asRubyString(stringValue);
                return super.doString(stringValueCast);
            }
            return this.next0.executeChained0(frameValue, stringValue);
        }

        static StringToSymbolNode create0(StringToSymbolNode current2) {
            return new StringToSymbolRubyStringNode((StringToSymbolBaseNode)current2);
        }
    }

    @GeneratedBy(value=StringToSymbolNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class StringToSymbolUninitializedNode
    extends StringToSymbolBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(StringToSymbolUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        StringToSymbolUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode string2) {
            super(context, sourceSection, string2);
        }

        StringToSymbolUninitializedNode(StringToSymbolBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubySymbol value2;
            try {
                value2 = this.executeRubySymbol(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object stringValue = this.string.execute(frameValue);
            return this.executeUninitialized0(frameValue, stringValue);
        }

        @Override
        protected RubySymbol executeChained0(VirtualFrame frameValue, Object stringValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, stringValue);
        }

        protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object stringValue) {
            StringToSymbolBaseNode newNode = this.specialize0(stringValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                StringToSymbolBaseNode rootNode = DSLShare.findRoot(this);
                throw new UnsupportedSpecializationException(rootNode, new Node[]{rootNode.string}, stringValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return DSLShare.rewriteUninitialized(this, newNode).executeChained0(frameValue, stringValue);
        }

        static StringToSymbolNode create0(RubyContext context, SourceSection sourceSection, RubyNode string2) {
            return new StringToSymbolUninitializedNode(context, sourceSection, string2);
        }
    }

    @GeneratedBy(value=StringToSymbolNode.class)
    private static abstract class StringToSymbolBaseNode
    extends StringToSymbolNode
    implements DSLNode {
        @Node.Child
        protected RubyNode string;
        @Node.Child
        protected StringToSymbolBaseNode next0;

        StringToSymbolBaseNode(RubyContext context, SourceSection sourceSection, RubyNode string2) {
            super(context, sourceSection);
            this.string = string2;
        }

        StringToSymbolBaseNode(StringToSymbolBaseNode copy) {
            super(copy);
        }

        protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

        protected final RubySymbol rewrite0(VirtualFrame frameValue, Object stringValue, String reason2) {
            String message2;
            StringToSymbolBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            StringToSymbolBaseNode newNode = this.specialize0(stringValue);
            if (newNode == null) {
                newNode = new StringToSymbolUninitializedNode(this);
                ((StringToSymbolUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = DSLShare.rewrite(this, newNode, message2 = StringToSymbolBaseNode.createInfo0(reason2, stringValue))) == null) {
                returnNode = DSLShare.rewriteToPolymorphic(this, new StringToSymbolUninitializedNode(this), new StringToSymbolPolymorphicNode(this), (StringToSymbolBaseNode)this.copy(), newNode, message2);
            }
            return returnNode.executeChained0(frameValue, stringValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final StringToSymbolBaseNode specialize0(Object stringValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyString(stringValue)) {
                return (StringToSymbolBaseNode)StringToSymbolRubyStringNode.create0(this);
            }
            return null;
        }

        @Override
        public final void adoptChildren0(Node other, Node newNext) {
            this.string = other == null ? null : ((StringToSymbolBaseNode)other).string;
            this.next0 = newNext == null ? null : (StringToSymbolBaseNode)newNext;
        }

        @Override
        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
        }

        @Override
        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object stringValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("stringValue").append(" = ").append(stringValue);
                if (stringValue != null) {
                    builder.append(" (").append(stringValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

