/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.internal.runtime.methods.InvokeDynamicMethodFactory;
import org.jruby.internal.runtime.methods.MethodNodes;
import org.jruby.internal.runtime.methods.ReflectionMethodFactory;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassDefininngJRubyClassLoader;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class MethodFactory {
    private static final Logger LOG = LoggerFactory.getLogger("MethodFactory");
    public static final Class[] COMPILED_METHOD_PARAMS = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
    public static final boolean CAN_LOAD_BYTECODE;
    private static final boolean reflection;

    public static MethodFactory createFactory(ClassLoader classLoader) {
        if (reflection || !CAN_LOAD_BYTECODE) {
            return new ReflectionMethodFactory();
        }
        if (Options.COMPILE_INVOKEDYNAMIC.load().booleanValue() && Options.INVOKEDYNAMIC_HANDLES.load().booleanValue()) {
            return new InvokeDynamicMethodFactory(classLoader);
        }
        return new InvocationMethodFactory(classLoader);
    }

    public abstract DynamicMethod getCompiledMethod(RubyModule var1, String var2, String var3, Arity var4, Visibility var5, StaticScope var6, Object var7, CallConfiguration var8, ISourcePosition var9, String var10, MethodNodes var11);

    public byte[] getCompiledMethodOffline(String rubyName, String javaName, String classPath, String invokerPath, Arity arity2, StaticScope scope, CallConfiguration callConfig, String filename2, int line, MethodNodes methodNodes) {
        return null;
    }

    public abstract DynamicMethod getCompiledMethodLazily(RubyModule var1, String var2, String var3, Arity var4, Visibility var5, StaticScope var6, Object var7, CallConfiguration var8, ISourcePosition var9, String var10, MethodNodes var11);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, List<JavaMethodDescriptor> var2);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, JavaMethodDescriptor var2);

    public abstract CompiledBlockCallback getBlockCallback(String var1, String var2, int var3, Object var4);

    public abstract CompiledBlockCallback19 getBlockCallback19(String var1, String var2, int var3, Object var4);

    public byte[] getBlockCallbackOffline(String method, String file2, int line, String classPath) {
        return null;
    }

    public byte[] getBlockCallback19Offline(String method, String file2, int line, String classPath) {
        return null;
    }

    static {
        boolean can = false;
        try {
            int bytesRead;
            InputStream unloaderStream = Ruby.getClassLoader().getResourceAsStream("org/jruby/util/JDBCDriverUnloader.class");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((bytesRead = unloaderStream.read(buf)) != -1) {
                baos.write(buf, 0, bytesRead);
            }
            ClassDefininngJRubyClassLoader oscl = new ClassDefininngJRubyClassLoader(Ruby.getClassLoader());
            Class<?> unloaderClass = oscl.defineClass("org.jruby.util.JDBCDriverUnloader", baos.toByteArray());
            unloaderClass.newInstance();
            can = true;
            oscl.close();
        }
        catch (Throwable t) {
            LOG.debug("MethodFactory: failed to load bytecode at runtime, falling back on reflection", t);
        }
        CAN_LOAD_BYTECODE = can;
        boolean reflection_ = false;
        boolean dumping_ = false;
        Object dumpingPath_ = null;
        reflection_ = Ruby.isSecurityRestricted() ? true : RubyInstanceConfig.REFLECTED_HANDLES;
        reflection = reflection_;
    }

    @Deprecated
    public static interface MethodDefiningCallback {
        public void define(RubyModule var1, JavaMethodDescriptor var2, DynamicMethod var3);
    }
}

