/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.RubyInstanceConfig;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRPersistenceValues;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.InstrDecoderMap;
import org.jruby.ir.persistence.OperandDecoderMap;
import org.jruby.parser.StaticScope;

public class IRReaderFile
implements IRReaderDecoder,
IRPersistenceValues {
    private ByteBuffer buf;
    private final InstrDecoderMap instrDecoderMap;
    private final OperandDecoderMap operandDecoderMap;
    private final List<IRScope> scopes = new ArrayList<IRScope>();
    private IRScope currentScope = null;
    private Map<String, Operand> vars = null;

    public IRReaderFile(IRManager manager, File file2) {
        try {
            byte[] bytes2 = new byte[(int)file2.length()];
            if (RubyInstanceConfig.IR_READING_DEBUG) {
                System.out.println("READING IN " + bytes2.length + " BYTES OF DATA FROM " + file2);
            }
            ByteBuffer buffer = ByteBuffer.wrap(bytes2);
            FileInputStream fis = new FileInputStream(file2);
            FileChannel fc = fis.getChannel();
            fc.read(buffer);
            fis.close();
            this.buf = ByteBuffer.wrap(bytes2);
        }
        catch (IOException ex) {
            Logger.getLogger(IRReaderFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.instrDecoderMap = new InstrDecoderMap(manager, this);
        this.operandDecoderMap = new OperandDecoderMap(manager, this);
    }

    @Override
    public String decodeString() {
        int strLength = this.decodeInt();
        byte[] bytes2 = new byte[strLength];
        this.buf.get(bytes2);
        String newString = new String(bytes2).intern();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("STR<" + newString + ">");
        }
        return newString;
    }

    @Override
    public void addScope(IRScope scope) {
        this.scopes.add(scope);
    }

    @Override
    public IRScope getCurrentScope() {
        return this.currentScope;
    }

    @Override
    public String[] decodeStringArray() {
        int arrayLength = this.decodeInt();
        String[] array = new String[arrayLength];
        for (int i2 = 0; i2 < arrayLength; ++i2) {
            array[i2] = this.decodeString();
        }
        return array;
    }

    @Override
    public Map<String, Operand> getVars() {
        return this.vars;
    }

    @Override
    public List<Instr> decodeInstructionsAt(IRScope scope, int offset2) {
        this.currentScope = scope;
        this.vars = new HashMap<String, Operand>();
        this.buf.position(offset2);
        int numberOfInstructions = this.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("Number of Instructions: " + numberOfInstructions);
        }
        ArrayList<Instr> instrs = new ArrayList<Instr>(numberOfInstructions);
        for (int i2 = 0; i2 < numberOfInstructions; ++i2) {
            Instr decodedInstr = this.decodeInstr();
            if (RubyInstanceConfig.IR_READING_DEBUG) {
                System.out.println(">INSTR = " + decodedInstr);
            }
            instrs.add(decodedInstr);
        }
        return instrs;
    }

    @Override
    public Instr decodeInstr() {
        return this.instrDecoderMap.decode(this.decodeOperation());
    }

    @Override
    public IRScopeType decodeIRScopeType() {
        return IRScopeType.fromOrdinal(this.decodeInt());
    }

    @Override
    public TemporaryVariableType decodeTemporaryVariableType() {
        return TemporaryVariableType.fromOrdinal(this.decodeInt());
    }

    @Override
    public StaticScope.Type decodeStaticScopeType() {
        return StaticScope.Type.fromOrdinal(this.decodeInt());
    }

    @Override
    public Operation decodeOperation() {
        Operation operation = Operation.fromOrdinal(this.decodeInt());
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("INSTR<" + (Object)((Object)operation));
        }
        return operation;
    }

    @Override
    public Operand decodeOperand() {
        OperandType operandType = this.decodeOperandType();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("OP<" + (Object)((Object)operandType));
        }
        Operand decodedOperand = this.operandDecoderMap.decode(operandType);
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println(">OP = " + decodedOperand);
        }
        return decodedOperand;
    }

    @Override
    public Variable decodeVariable() {
        return (Variable)this.decodeOperand();
    }

    @Override
    public Operand[] decodeOperandArray() {
        int size2 = this.decodeInt();
        Operand[] list2 = new Operand[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            list2[i2] = this.decodeOperand();
        }
        return list2;
    }

    @Override
    public List<Operand> decodeOperandList() {
        int size2 = this.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("OPERAND LIST of size: " + size2);
        }
        ArrayList<Operand> list2 = new ArrayList<Operand>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            if (RubyInstanceConfig.IR_READING_DEBUG) {
                System.out.println("OPERAND #" + i2);
            }
            list2.add(this.decodeOperand());
        }
        return list2;
    }

    @Override
    public OperandType decodeOperandType() {
        return OperandType.fromCoded(this.decodeByte());
    }

    @Override
    public boolean decodeBoolean() {
        byte value2 = this.buf.get();
        if (value2 == 116) {
            return true;
        }
        if (value2 == 102) {
            return false;
        }
        throw new IllegalArgumentException("Value (" + value2 + ", " + (char)value2 + ") is not a boolean.");
    }

    @Override
    public byte decodeByte() {
        return this.buf.get();
    }

    @Override
    public char decodeChar() {
        return this.buf.getChar();
    }

    @Override
    public int decodeInt() {
        int b2 = this.buf.get();
        return b2 == -1 ? this.buf.getInt() : b2;
    }

    @Override
    public int decodeIntRaw() {
        return this.buf.getInt();
    }

    @Override
    public long decodeLong() {
        byte b2 = this.buf.get();
        return b2 == -1 ? this.buf.getLong() : (long)b2;
    }

    @Override
    public double decodeDouble() {
        return this.buf.getDouble();
    }

    @Override
    public float decodeFloat() {
        return this.buf.getFloat();
    }

    @Override
    public IRScope decodeScope() {
        return this.scopes.get(this.decodeInt());
    }

    @Override
    public void seek(int headersOffset) {
        this.buf.position(headersOffset);
    }
}

