/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;

public class FrozenString
extends ImmutableLiteral {
    private final ByteList bytelist;
    private RubyString cached;

    public FrozenString(ByteList byteList) {
        super(OperandType.STRING_LITERAL);
        this.bytelist = byteList;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return context.runtime.freezeAndDedupString(RubyString.newString(context.runtime, this.bytelist));
    }

    public int hashCode() {
        return this.bytelist.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof FrozenString && this.bytelist.equals(((FrozenString)other).bytelist);
    }

    public String toString() {
        return "frozen:\"" + this.bytelist + "\"";
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.FrozenString(this);
    }

    public ByteList getByteList() {
        return this.bytelist;
    }
}

