/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.representations.CFG;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;

public class InterpreterContext {
    private final int temporaryVariablecount;
    private final int temporaryBooleanVariablecount;
    private final int temporaryFixnumVariablecount;
    private final int temporaryFloatVariablecount;
    private final String name;
    private final String fileName;
    private final int lineNumber;
    private final StaticScope staticScope;
    private final Instr[] instructions;
    private final boolean hasExplicitCallProtocol;
    private final boolean isDynscopeEliminated;
    private final boolean pushNewDynScope;
    private final boolean reuseParentDynScope;
    private final boolean popDynScope;
    private final boolean receivesKeywordArguments;
    private final boolean metaClassBodyScope;
    private CFG cfg = null;

    public InterpreterContext(IRScope scope, Instr[] instructions) {
        this.cfg = scope.getCFG();
        this.name = scope.getName();
        this.fileName = scope.getFileName();
        this.lineNumber = scope.getLineNumber();
        this.staticScope = scope.getStaticScope();
        this.metaClassBodyScope = scope instanceof IRMetaClassBody;
        this.temporaryVariablecount = scope.getTemporaryVariablesCount();
        this.temporaryBooleanVariablecount = scope.getBooleanVariablesCount();
        this.temporaryFixnumVariablecount = scope.getFixnumVariablesCount();
        this.temporaryFloatVariablecount = scope.getFloatVariablesCount();
        this.instructions = instructions;
        this.hasExplicitCallProtocol = scope.getFlags().contains((Object)IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
        this.reuseParentDynScope = scope.getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE);
        this.isDynscopeEliminated = scope.getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED);
        this.pushNewDynScope = !this.isDynscopeEliminated && !this.reuseParentDynScope;
        this.popDynScope = this.pushNewDynScope || this.reuseParentDynScope;
        this.receivesKeywordArguments = scope.getFlags().contains((Object)IRFlags.RECEIVES_KEYWORD_ARGS);
    }

    public Object[] allocateTemporaryVariables() {
        return this.temporaryVariablecount > 0 ? new Object[this.temporaryVariablecount] : null;
    }

    public boolean[] allocateTemporaryBooleanVariables() {
        return this.temporaryBooleanVariablecount > 0 ? new boolean[this.temporaryBooleanVariablecount] : null;
    }

    public long[] allocateTemporaryFixnumVariables() {
        return this.temporaryFixnumVariablecount > 0 ? new long[this.temporaryFixnumVariablecount] : null;
    }

    public double[] allocateTemporaryFloatVariables() {
        return this.temporaryFloatVariablecount > 0 ? new double[this.temporaryFloatVariablecount] : null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public int getTemporaryVariablecount() {
        return this.temporaryVariablecount;
    }

    public int getTemporaryBooleanVariablecount() {
        return this.temporaryBooleanVariablecount;
    }

    public int getTemporaryFixnumVariablecount() {
        return this.temporaryFixnumVariablecount;
    }

    public int getTemporaryFloatVariablecount() {
        return this.temporaryFloatVariablecount;
    }

    public Instr[] getInstructions() {
        return this.instructions;
    }

    public boolean isDynscopeEliminated() {
        return this.isDynscopeEliminated;
    }

    public DynamicScope newDynamicScope(ThreadContext context) {
        if (this.metaClassBodyScope) {
            return DynamicScope.newDynamicScope(this.staticScope, context.getCurrentScope());
        }
        return DynamicScope.newDynamicScope(this.staticScope);
    }

    public boolean hasExplicitCallProtocol() {
        return this.hasExplicitCallProtocol;
    }

    public boolean pushNewDynScope() {
        return this.pushNewDynScope;
    }

    public boolean reuseParentDynScope() {
        return this.reuseParentDynScope;
    }

    public boolean popDynScope() {
        return this.popDynScope;
    }

    public boolean receivesKeywordArguments() {
        return this.receivesKeywordArguments;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fileName).append(':').append(this.lineNumber);
        if (this.name != null) {
            buf.append(' ').append(this.name);
        }
        buf.append("\nCFG:\n").append(this.cfg.toStringInstrs());
        return buf.toString();
    }
}

