/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jcodings.Encoding;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class BuildCompoundStringInstr
extends ResultBaseInstr {
    private final Encoding encoding;

    public BuildCompoundStringInstr(Variable result2, Operand[] pieces, Encoding encoding2) {
        super(Operation.BUILD_COMPOUND_STRING, result2, pieces);
        this.encoding = encoding2;
    }

    public Operand[] getPieces() {
        return this.getOperands();
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildCompoundStringInstr(ii.getRenamedVariable(this.result), this.cloneOperands(ii), this.encoding);
    }

    public boolean isSameEncodingAndCodeRange(RubyString str, StringLiteral newStr) {
        return newStr.bytelist.getEncoding() == this.encoding && newStr.getCodeRange() == str.getCodeRange();
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        ByteList bytes2 = new ByteList();
        bytes2.setEncoding(this.encoding);
        RubyString str = RubyString.newStringShared(context.runtime, bytes2, 16);
        for (Operand p2 : this.operands) {
            if (p2 instanceof StringLiteral && this.isSameEncodingAndCodeRange(str, (StringLiteral)p2)) {
                str.getByteList().append(((StringLiteral)p2).bytelist);
                str.setCodeRange(str.scanForCodeRange());
                continue;
            }
            IRubyObject pval = (IRubyObject)p2.retrieve(context, self2, currScope, currDynScope, temp);
            str.append19(pval);
        }
        return str;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildCompoundStringInstr(this);
    }
}

