/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import org.jruby.EvalType;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.parser.StaticScope;

public class IRBindingEvalScript
extends IREvalScript {
    private IRScope nearestNonEvalScope;
    private int nearestNonEvalScopeDepth;

    public IRBindingEvalScript(IRManager manager, IRScope lexicalParent, String fileName, int lineNumber, StaticScope staticScope, EvalType evalType) {
        super(manager, lexicalParent, fileName, lineNumber, staticScope, evalType);
        int n = 0;
        IRScope s2 = lexicalParent;
        while (s2 instanceof IRBindingEvalScript) {
            ++n;
            s2 = s2.getLexicalParent();
        }
        this.nearestNonEvalScope = s2;
        this.nearestNonEvalScopeDepth = n;
        this.nearestNonEvalScope.initEvalScopeVariableAllocator(false);
        if (!this.getManager().isDryRun() && staticScope != null) {
            if (evalType == EvalType.MODULE_EVAL) {
                staticScope.setScopeType(this.getScopeType());
            } else {
                staticScope.setScopeType(this.nearestNonEvalScope.getScopeType());
            }
        }
    }

    @Override
    public LocalVariable lookupExistingLVar(String name2) {
        return this.nearestNonEvalScope.evalScopeVars.get(name2);
    }

    @Override
    protected LocalVariable findExistingLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.lookupExistingLVar(name2);
        if (lvar != null || scopeDepth == 0) {
            return lvar;
        }
        return this.nearestNonEvalScope.findExistingLocalVariable(name2, scopeDepth - this.nearestNonEvalScopeDepth - 1);
    }

    @Override
    public LocalVariable getLocalVariable(String name2, int scopeDepth) {
        int lookupDepth = this.isModuleOrInstanceEval() ? scopeDepth - 1 : scopeDepth;
        LocalVariable lvar = this.findExistingLocalVariable(name2, lookupDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, lookupDepth);
        }
        if (lvar.getScopeDepth() != scopeDepth) {
            lvar = lvar.cloneForDepth(scopeDepth);
        }
        return lvar;
    }

    @Override
    public LocalVariable getNewLocalVariable(String name2, int depth) {
        assert (depth == this.nearestNonEvalScopeDepth) : "Local variable depth in IREvalScript:getNewLocalVariable for " + name2 + " must be " + this.nearestNonEvalScopeDepth + ".  Got " + depth;
        ClosureLocalVariable lvar = new ClosureLocalVariable(this, name2, 0, this.nearestNonEvalScope.evalScopeVars.size());
        this.nearestNonEvalScope.evalScopeVars.put(name2, lvar);
        return lvar;
    }

    @Override
    public LocalVariable getNewFlipStateVariable() {
        String flipVarName = "%flip_" + this.allocateNextPrefixedName("%flip");
        LocalVariable v = this.lookupExistingLVar(flipVarName);
        if (v == null) {
            v = this.getNewLocalVariable(flipVarName, 0);
        }
        return v;
    }

    @Override
    public int getUsedVariablesCount() {
        return this.nearestNonEvalScope.evalScopeVars.size() + this.getPrefixCountSize("%flip");
    }
}

