/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedIRMetaClassBody
extends InterpretedIRMethod {
    public InterpretedIRMetaClassBody(IRScope metaClassBody, RubyModule implementationClass) {
        super(metaClassBody, Visibility.PUBLIC, implementationClass);
    }

    @Override
    public List<String[]> getParameterList() {
        return new ArrayList<String[]>();
    }

    protected void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    protected void pre(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block) {
        context.preMethodFrameOnly(this.getImplementationClass(), name2, self2, block);
        if (ic.pushNewDynScope()) {
            context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope(), context.getCurrentScope()));
        }
        context.setCurrentVisibility(this.getVisibility());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        DynamicMethod actualMethod;
        InterpretedIRMethod.DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((actualMethod = box.actualMethod) != null) {
            return actualMethod.call(context, self2, clazz, name2, args2, block);
        }
        InterpreterContext ic = this.ensureInstrsReady();
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        if (ic.hasExplicitCallProtocol()) {
            return Interpreter.INTERPRET_METHOD(context, this, self2, name2, args2, block);
        }
        try {
            this.pre(ic, context, self2, name2, block);
            IRubyObject iRubyObject = Interpreter.INTERPRET_METHOD(context, this, self2, name2, args2, block);
            return iRubyObject;
        }
        finally {
            this.post(ic, context);
        }
    }

    @Override
    public DynamicMethod dup() {
        InterpretedIRMetaClassBody x = new InterpretedIRMetaClassBody(this.method, this.implementationClass);
        x.dupBox(this);
        return x;
    }
}

