/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.security.AccessControlException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import jnr.constants.Constant;
import jnr.constants.ConstantSet;
import jnr.constants.platform.Errno;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.jcodings.Encoding;
import org.joda.time.DateTimeZone;
import org.jruby.Finalizable;
import org.jruby.NativeException;
import org.jruby.ParseResult;
import org.jruby.Profile;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyContinuation;
import org.jruby.RubyConverter;
import org.jruby.RubyDir;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNoMethodError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRandom;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubySignal;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubySystemCallError;
import org.jruby.RubySystemExit;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.RubyTime;
import org.jruby.RubyUnboundMethod;
import org.jruby.TopSelfFactory;
import org.jruby.TruffleBridge;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.executable.RuntimeCache;
import org.jruby.ast.executable.Script;
import org.jruby.ast.executable.ScriptAndCode;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.RubyWarnings;
import org.jruby.compiler.Constantizable;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.embed.Extension;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.ext.JRubyPOSIXHandler;
import org.jruby.ext.LateLoadingLibrary;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.ext.ffi.FFI;
import org.jruby.ext.fiber.ThreadFiber;
import org.jruby.ext.fiber.ThreadFiberLibrary;
import org.jruby.ext.thread.ThreadLibrary;
import org.jruby.ext.tracepoint.TracePoint;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.ir.Compiler;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.persistence.IRReader;
import org.jruby.ir.persistence.IRReaderFile;
import org.jruby.ir.persistence.util.IRFileExpert;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.management.BeanManager;
import org.jruby.management.BeanManagerFactory;
import org.jruby.management.Config;
import org.jruby.management.ParserStats;
import org.jruby.management.Runtime;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.util.TraceClassVisitor;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.platform.Platform;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.CompiledScriptLoader;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.runtime.profile.ProfileCollection;
import org.jruby.runtime.profile.ProfilingService;
import org.jruby.runtime.profile.ProfilingServiceLookup;
import org.jruby.runtime.profile.builtin.ProfiledMethods;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.truffle.TruffleBridgeImpl;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.ByteList;
import org.jruby.util.ClassDefininngJRubyClassLoader;
import org.jruby.util.DefinedMessage;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.WeakHashSet;
import org.jruby.util.func.Function1;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.SelectorPool;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public final class Ruby
implements Constantizable {
    private static final Logger LOG = LoggerFactory.getLogger("Ruby");
    public static final int NIL_PREFILLED_ARRAY_SIZE = 128;
    private final IRubyObject[] nilPrefilledArray = new IRubyObject[128];
    private Map<Integer, RubyClass> errnos = new HashMap<Integer, RubyClass>();
    private RubyRandom.RandomType defaultRand;
    private RubyHash charsetMap;
    private final CallTraceFuncHook callTraceFuncHook = new CallTraceFuncHook();
    private static final Pattern ADDR_NOT_AVAIL_PATTERN = Pattern.compile("assign.*address");
    private ThreadLocal<Map<Object, Object>> inspect = new ThreadLocal();
    private final ConcurrentHashMap<String, Invalidator> constantNameInvalidators = new ConcurrentHashMap(16, 0.75f, 1);
    private final Invalidator checkpointInvalidator;
    private final ThreadService threadService;
    private POSIX posix;
    private final ObjectSpace objectSpace = new ObjectSpace();
    private final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable(this);
    private static final EventHook[] EMPTY_HOOKS = new EventHook[0];
    private volatile EventHook[] eventHooks = new EventHook[0];
    private boolean hasEventHooks;
    private boolean globalAbortOnExceptionEnabled = false;
    private boolean doNotReverseLookupEnabled = false;
    private volatile boolean objectSpaceEnabled;
    private boolean siphashEnabled;
    private long globalState = 1L;
    private IRubyObject topSelf;
    private IRubyObject rootFiber;
    private RubyNil nilObject;
    private IRubyObject[] singleNilArray;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    final RubyFixnum[] fixnumCache = new RubyFixnum[512];
    final Object[] fixnumConstants = new Object[this.fixnumCache.length];
    private boolean verbose;
    private boolean warningsEnabled;
    private boolean debug;
    private IRubyObject verboseValue;
    private RubyThreadGroup defaultThreadGroup;
    private RubyClass basicObjectClass;
    private RubyClass objectClass;
    private RubyClass moduleClass;
    private RubyClass classClass;
    private RubyClass nilClass;
    private RubyClass trueClass;
    private RubyClass falseClass;
    private RubyClass numericClass;
    private RubyClass floatClass;
    private RubyClass integerClass;
    private RubyClass fixnumClass;
    private RubyClass complexClass;
    private RubyClass rationalClass;
    private RubyClass enumeratorClass;
    private RubyClass yielderClass;
    private RubyClass fiberClass;
    private RubyClass generatorClass;
    private RubyClass arrayClass;
    private RubyClass hashClass;
    private RubyClass rangeClass;
    private RubyClass stringClass;
    private RubyClass encodingClass;
    private RubyClass converterClass;
    private RubyClass symbolClass;
    private RubyClass procClass;
    private RubyClass bindingClass;
    private RubyClass methodClass;
    private RubyClass unboundMethodClass;
    private RubyClass matchDataClass;
    private RubyClass regexpClass;
    private RubyClass timeClass;
    private RubyClass bignumClass;
    private RubyClass dirClass;
    private RubyClass fileClass;
    private RubyClass fileStatClass;
    private RubyClass ioClass;
    private RubyClass threadClass;
    private RubyClass threadGroupClass;
    private RubyClass continuationClass;
    private RubyClass structClass;
    private RubyClass tmsStruct;
    private RubyClass passwdStruct;
    private RubyClass groupStruct;
    private RubyClass procStatusClass;
    private RubyClass exceptionClass;
    private RubyClass runtimeError;
    private RubyClass ioError;
    private RubyClass scriptError;
    private RubyClass nameError;
    private RubyClass nameErrorMessage;
    private RubyClass noMethodError;
    private RubyClass signalException;
    private RubyClass rangeError;
    private RubyClass dummyClass;
    private RubyClass systemExit;
    private RubyClass localJumpError;
    private RubyClass nativeException;
    private RubyClass systemCallError;
    private RubyClass fatal;
    private RubyClass interrupt;
    private RubyClass typeError;
    private RubyClass argumentError;
    private RubyClass indexError;
    private RubyClass stopIteration;
    private RubyClass syntaxError;
    private RubyClass standardError;
    private RubyClass loadError;
    private RubyClass notImplementedError;
    private RubyClass securityError;
    private RubyClass noMemoryError;
    private RubyClass regexpError;
    private RubyClass eofError;
    private RubyClass threadError;
    private RubyClass concurrencyError;
    private RubyClass systemStackError;
    private RubyClass zeroDivisionError;
    private RubyClass floatDomainError;
    private RubyClass mathDomainError;
    private RubyClass encodingError;
    private RubyClass encodingCompatibilityError;
    private RubyClass converterNotFoundError;
    private RubyClass undefinedConversionError;
    private RubyClass invalidByteSequenceError;
    private RubyClass fiberError;
    private RubyClass randomClass;
    private RubyClass keyError;
    private RubyClass locationClass;
    private RubyClass interruptedRegexpError;
    private RubyModule kernelModule;
    private RubyModule comparableModule;
    private RubyModule enumerableModule;
    private RubyModule mathModule;
    private RubyModule marshalModule;
    private RubyModule etcModule;
    private RubyModule fileTestModule;
    private RubyModule gcModule;
    private RubyModule objectSpaceModule;
    private RubyModule processModule;
    private RubyModule procUIDModule;
    private RubyModule procGIDModule;
    private RubyModule procSysModule;
    private RubyModule precisionModule;
    private RubyModule errnoModule;
    private DynamicMethod privateMethodMissing;
    private DynamicMethod protectedMethodMissing;
    private DynamicMethod variableMethodMissing;
    private DynamicMethod superMethodMissing;
    private DynamicMethod normalMethodMissing;
    private DynamicMethod defaultMethodMissing;
    private DynamicMethod respondTo;
    private DynamicMethod respondToMissing;
    private GlobalVariable recordSeparatorVar;
    private volatile String currentDirectory;
    private volatile int currentLine = 0;
    private volatile IRubyObject argsFile;
    private final long startTime = System.currentTimeMillis();
    private final RubyInstanceConfig config;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private JavaSupport javaSupport;
    private JRubyClassLoader jrubyClassLoader;
    private BeanManager beanManager;
    private ParserStats parserStats;
    private final JITCompiler jitCompiler;
    private TruffleBridge truffleBridge;
    private static volatile boolean securityRestricted = false;
    private final Parser parser = new Parser(this);
    private LoadService loadService;
    private Encoding defaultInternalEncoding;
    private Encoding defaultExternalEncoding;
    private EncodingService encodingService;
    private GlobalVariables globalVariables = new GlobalVariables(this);
    private final RubyWarnings warnings = new RubyWarnings(this);
    private final Stack<RubyProc> atExitBlocks = new Stack();
    private Profile profile;
    private KCode kcode = KCode.NONE;
    private final AtomicInteger symbolLastId = new AtomicInteger(128);
    private final AtomicInteger moduleLastId = new AtomicInteger(0);
    private final Set<RubyModule> allModules = new WeakHashSet<RubyModule>();
    private final Map<String, DateTimeZone> timeZoneCache = new HashMap<String, DateTimeZone>();
    private Map<Finalizable, Object> finalizers;
    private Map<Finalizable, Object> internalFinalizers;
    private final Object finalizersMutex = new Object();
    private final Object internalFinalizersMutex = new Object();
    private ExecutorService executor;
    private ExecutorService fiberExecutor;
    private final Object hierarchyLock = new Object();
    private final AtomicLong dynamicMethodSerial = new AtomicLong(1L);
    private final AtomicInteger moduleGeneration = new AtomicInteger(1);
    private final Map<String, Map<String, String>> boundMethods = new HashMap<String, Map<String, String>>();
    private final SelectorPool selectorPool = new SelectorPool();
    private final RuntimeCache runtimeCache;
    private final ProfiledMethods profiledMethods;
    public static final String ERRNO_BACKTRACE_MESSAGE = "errno backtraces disabled; run with -Xerrno.backtrace=true to enable";
    public static final String STOPIERATION_BACKTRACE_MESSAGE = "StopIteration backtraces disabled; run with -Xstop_iteration.backtrace=true to enable";
    private final AtomicInteger exceptionCount = new AtomicInteger();
    private final AtomicInteger backtraceCount = new AtomicInteger();
    private final AtomicInteger callerCount = new AtomicInteger();
    private final AtomicInteger warningCount = new AtomicInteger();
    private Invalidator fixnumInvalidator = OptoFactory.newGlobalInvalidator(0);
    private Invalidator floatInvalidator = OptoFactory.newGlobalInvalidator(0);
    private boolean fixnumReopened;
    private boolean floatReopened;
    private volatile boolean bootingCore = true;
    private volatile boolean bootingRuntime = true;
    private RubyHash envObject;
    private final CoverageData coverageData = new CoverageData();
    private static volatile Ruby globalRuntime;
    private static ThreadLocal<Ruby> threadLocalRuntime;
    private final Random random;
    private long hashSeedK0;
    private long hashSeedK1;
    private StaticScopeFactory staticScopeFactory;
    private IRManager irManager;
    private ThreadLocal<Map<String, RubyHash>> recursive = new ThreadLocal();
    private RubySymbol recursiveKey;
    private ThreadLocal<Boolean> inRecursiveListOperation = new ThreadLocal();
    private FFI ffi;
    private JavaProxyClassFactory javaProxyClassFactory;
    private final ProfilingServiceLookup profilingServiceLookup;
    private EnumMap<DefinedMessage, RubyString> definedMessages = new EnumMap(DefinedMessage.class);
    private EnumMap<RubyThread.Status, RubyString> threadStatuses = new EnumMap(RubyThread.Status.class);
    private static final ObjectSpacer DISABLED_OBJECTSPACE;
    private static final ObjectSpacer ENABLED_OBJECTSPACE;
    private final ObjectSpacer objectSpacer;
    private RubyArray emptyFrozenArray;
    private WeakHashMap<RubyString, WeakReference<RubyString>> dedupMap = new WeakHashMap();
    private static final AtomicInteger RUNTIME_NUMBER;
    private final int runtimeNumber = RUNTIME_NUMBER.getAndIncrement();
    private final Config configBean;
    private final Runtime runtimeBean;
    private final FilenoUtil filenoUtil = new FilenoUtil();
    private final Object constant;

    private Ruby(RubyInstanceConfig config) {
        Random myRandom;
        this.config = config;
        this.threadService = new ThreadService(this);
        if (config.isProfiling()) {
            this.profiledMethods = new ProfiledMethods(this);
            this.profilingServiceLookup = new ProfilingServiceLookup(this);
        } else {
            this.profiledMethods = null;
            this.profilingServiceLookup = null;
        }
        this.constant = OptoFactory.newConstantWrapper(Ruby.class, this);
        this.getJRubyClassLoader();
        this.staticScopeFactory = new StaticScopeFactory(this);
        this.beanManager = BeanManagerFactory.create(this, config.isManagementEnabled());
        this.jitCompiler = new JITCompiler(this);
        this.parserStats = new ParserStats(this);
        try {
            myRandom = new SecureRandom();
        }
        catch (Throwable t) {
            LOG.debug("unable to instantiate SecureRandom, falling back on Random", t);
            myRandom = new Random();
        }
        this.random = myRandom;
        if (RubyInstanceConfig.CONSISTENT_HASHING_ENABLED) {
            this.hashSeedK0 = -561135208506705104L;
            this.hashSeedK1 = 7114160726623585955L;
        } else {
            this.hashSeedK0 = this.random.nextLong();
            this.hashSeedK1 = this.random.nextLong();
        }
        this.configBean = new Config(this);
        this.runtimeBean = new Runtime(this);
        this.registerMBeans();
        this.runtimeCache = new RuntimeCache();
        this.runtimeCache.initMethodCache(ClassIndex.MAX_CLASSES.ordinal() * MethodNames.values().length - 1);
        this.checkpointInvalidator = OptoFactory.newConstantInvalidator();
        this.objectSpacer = config.isObjectSpaceEnabled() ? ENABLED_OBJECTSPACE : DISABLED_OBJECTSPACE;
        this.reinitialize(false);
    }

    public void registerMBeans() {
        this.beanManager.register(this.jitCompiler);
        this.beanManager.register(this.configBean);
        this.beanManager.register(this.parserStats);
        this.beanManager.register(this.runtimeBean);
    }

    void reinitialize(boolean reinitCore) {
        this.doNotReverseLookupEnabled = true;
        this.staticScopeFactory = new StaticScopeFactory(this);
        this.in = this.config.getInput();
        this.out = this.config.getOutput();
        this.err = this.config.getError();
        this.objectSpaceEnabled = this.config.isObjectSpaceEnabled();
        this.siphashEnabled = this.config.isSiphashEnabled();
        this.profile = this.config.getProfile();
        this.currentDirectory = this.config.getCurrentDirectory();
        this.kcode = this.config.getKCode();
        if (reinitCore) {
            RubyGlobal.initARGV(this);
        }
    }

    public static Ruby newInstance() {
        return Ruby.newInstance(new RubyInstanceConfig());
    }

    public static Ruby newInstance(RubyInstanceConfig config) {
        Ruby ruby2 = new Ruby(config);
        ruby2.init();
        Ruby.setGlobalRuntimeFirstTimeOnly(ruby2);
        return ruby2;
    }

    public static Ruby newInstance(InputStream in, PrintStream out, PrintStream err) {
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.setInput(in);
        config.setOutput(out);
        config.setError(err);
        return Ruby.newInstance(config);
    }

    public static boolean isGlobalRuntimeReady() {
        return globalRuntime != null;
    }

    private static synchronized void setGlobalRuntimeFirstTimeOnly(Ruby runtime) {
        if (globalRuntime == null) {
            globalRuntime = runtime;
        }
    }

    public static synchronized Ruby getGlobalRuntime() {
        if (globalRuntime == null) {
            Ruby.newInstance();
        }
        return globalRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAsGlobalRuntime() {
        Class<Ruby> clazz = Ruby.class;
        synchronized (Ruby.class) {
            globalRuntime = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearGlobalRuntime() {
        globalRuntime = null;
    }

    public static Ruby getThreadLocalRuntime() {
        return threadLocalRuntime.get();
    }

    public static void setThreadLocalRuntime(Ruby ruby2) {
        threadLocalRuntime.set(ruby2);
    }

    public IRubyObject evalScriptlet(String script) {
        ThreadContext context = this.getCurrentContext();
        DynamicScope currentScope = context.getCurrentScope();
        ManyVarsDynamicScope newScope = new ManyVarsDynamicScope(this.getStaticScopeFactory().newEvalScope(currentScope.getStaticScope()), currentScope);
        return this.evalScriptlet(script, newScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject evalScriptlet(String script, DynamicScope scope) {
        ThreadContext context = this.getCurrentContext();
        Node rootNode = this.parseEval(script, "<script>", scope, 0);
        context.preEvalScriptlet(scope);
        try {
            IRubyObject iRubyObject = (IRubyObject)Interpreter.getInstance().execute(this, rootNode, context.getFrameSelf());
            return iRubyObject;
        }
        finally {
            context.postEvalScriptlet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject executeScript(String script, String filename2) {
        byte[] bytes2 = script.getBytes();
        Node node = this.parseInline(new ByteArrayInputStream(bytes2), filename2, null);
        ThreadContext context = this.getCurrentContext();
        String oldFile = context.getFile();
        int oldLine = context.getLine();
        try {
            context.setFileAndLine(node.getPosition());
            IRubyObject iRubyObject = this.runInterpreter(node);
            return iRubyObject;
        }
        finally {
            context.setFileAndLine(oldFile, oldLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFromMain(InputStream inputStream, String filename2) {
        ValueAccessor d = new ValueAccessor(this.newString(filename2));
        this.getGlobalVariables().define("$PROGRAM_NAME", d, GlobalVariable.Scope.GLOBAL);
        this.getGlobalVariables().define("$0", d, GlobalVariable.Scope.GLOBAL);
        for (Map.Entry entry : this.config.getOptionGlobals().entrySet()) {
            Object value2 = entry.getValue();
            RubyObject varvalue = value2 != null ? this.newString(value2.toString()) : this.getTrue();
            this.getGlobalVariables().set("$" + entry.getKey().toString(), varvalue);
        }
        if (filename2.endsWith(".class")) {
            Script script = CompiledScriptLoader.loadScriptFromFile(this, inputStream, filename2);
            if (script == null) {
                throw new MainExitException(1, "error: .class file specified is not a compiled JRuby script");
            }
            script.setFilename(filename2);
            this.runScript(script);
            return;
        }
        ParseResult parseResult = this.parseFromMain(filename2, inputStream);
        if (this.fetchGlobalConstant("DATA") == null) {
            try {
                inputStream.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (parseResult instanceof RootNode) {
            RootNode scriptNode = (RootNode)parseResult;
            ThreadContext context = this.getCurrentContext();
            String oldFile = context.getFile();
            int oldLine = context.getLine();
            try {
                context.setFileAndLine(scriptNode.getPosition());
                if (this.config.isAssumePrinting() || this.config.isAssumeLoop()) {
                    this.runWithGetsLoop(scriptNode, this.config.isAssumePrinting(), this.config.isProcessLineEnds(), this.config.isSplit());
                }
                this.runNormally(scriptNode);
            }
            finally {
                context.setFileAndLine(oldFile, oldLine);
            }
        } else {
            this.runInterpreter(parseResult);
        }
    }

    public Node parseFromMain(InputStream inputStream, String filename2) {
        if (this.config.isInlineScript()) {
            return this.parseInline(inputStream, filename2, this.getCurrentContext().getCurrentScope());
        }
        return this.parseFileFromMain(inputStream, filename2, this.getCurrentContext().getCurrentScope());
    }

    public ParseResult parseFromMain(String fileName, InputStream in) {
        if (this.config.isInlineScript()) {
            return this.parseInline(in, fileName, this.getCurrentContext().getCurrentScope());
        }
        return this.parseFileFromMain(fileName, in, this.getCurrentContext().getCurrentScope());
    }

    @Deprecated
    public IRubyObject runWithGetsLoop(Node scriptNode, boolean printing, boolean processLineEnds, boolean split2, boolean unused2) {
        return this.runWithGetsLoop(scriptNode, printing, processLineEnds, split2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject runWithGetsLoop(Node scriptNode, boolean printing, boolean processLineEnds, boolean split2) {
        ThreadContext context = this.getCurrentContext();
        scriptNode = this.addGetsLoop((RootNode)scriptNode, printing, processLineEnds, split2);
        Script script = null;
        boolean compile = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        if (compile) {
            block10: {
                try {
                    script = this.tryCompile(scriptNode);
                    if (Options.JIT_LOGGING.load().booleanValue()) {
                        LOG.info("Successfully compiled: " + scriptNode.getPosition().getFile(), new Object[0]);
                    }
                }
                catch (Throwable e) {
                    if (!Options.JIT_LOGGING.load().booleanValue()) break block10;
                    LOG.error("Failed to compile: " + scriptNode.getPosition().getFile(), new Object[0]);
                    if (!Options.JIT_LOGGING_VERBOSE.load().booleanValue()) break block10;
                    LOG.error(e);
                }
            }
            if (!compile || script == null) {
                // empty if block
            }
        }
        Helpers.preLoad(context, ((RootNode)scriptNode).getStaticScope().getVariables());
        try {
            if (script != null) {
                this.runScriptBody(script);
            } else {
                this.runInterpreterBody(scriptNode);
            }
        }
        finally {
            Helpers.postLoad(context);
        }
        return this.getNil();
    }

    private RootNode addGetsLoop(RootNode oldRoot, boolean printing, boolean processLineEndings, boolean split2) {
        BlockNode whileBody;
        ISourcePosition pos2 = oldRoot.getPosition();
        BlockNode newBody = new BlockNode(pos2);
        if (processLineEndings) {
            newBody.add(new GlobalAsgnNode(pos2, "$\\", new GlobalVarNode(pos2, "$/")));
        }
        if (oldRoot.getBodyNode() instanceof BlockNode) {
            whileBody = (BlockNode)oldRoot.getBodyNode();
        } else {
            whileBody = new BlockNode(pos2);
            whileBody.add(oldRoot.getBodyNode());
        }
        GlobalVarNode dollarUnderscore = new GlobalVarNode(pos2, "$_");
        newBody.add(new WhileNode(pos2, new VCallNode(pos2, "gets"), whileBody));
        if (printing) {
            whileBody.prepend(new FCallNode(pos2, "puts", new ArrayNode(pos2, dollarUnderscore), null));
        }
        if (split2) {
            whileBody.prepend(new GlobalAsgnNode(pos2, "$F", new CallNode(pos2, dollarUnderscore, "split", null, null)));
        }
        if (processLineEndings) {
            whileBody.prepend(new CallNode(pos2, dollarUnderscore, "chop!", null, null));
        }
        return new RootNode(pos2, oldRoot.getScope(), newBody);
    }

    @Deprecated
    public IRubyObject runNormally(Node scriptNode, boolean unused2) {
        return this.runNormally(scriptNode);
    }

    public IRubyObject runNormally(Node scriptNode) {
        ScriptAndCode scriptAndCode;
        block6: {
            scriptAndCode = null;
            boolean compile = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
            if (compile || this.config.isShowBytecode()) {
                try {
                    scriptAndCode = this.tryCompile(scriptNode, new ClassDefininngJRubyClassLoader(this.getJRubyClassLoader()));
                    if (scriptAndCode != null && Options.JIT_LOGGING.load().booleanValue()) {
                        LOG.info("done compiling target script: " + scriptNode.getPosition().getFile(), new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (!Options.JIT_LOGGING.load().booleanValue()) break block6;
                    LOG.error("failed to compile target script '" + scriptNode.getPosition().getFile() + "'", new Object[0]);
                    if (!Options.JIT_LOGGING_VERBOSE.load().booleanValue()) break block6;
                    e.printStackTrace();
                }
            }
        }
        if (scriptAndCode != null) {
            if (this.config.isShowBytecode()) {
                TraceClassVisitor tracer = new TraceClassVisitor(new PrintWriter(System.err));
                ClassReader reader = new ClassReader(scriptAndCode.bytecode());
                reader.accept(tracer, 0);
                return this.getNil();
            }
            return this.runScript(scriptAndCode.script());
        }
        return this.runInterpreter(scriptNode);
    }

    public Script tryCompile(Node node) {
        return this.tryCompile(node, new ClassDefininngJRubyClassLoader(this.getJRubyClassLoader())).script();
    }

    private void failForcedCompile(Node scriptNode) throws RaiseException {
        if (this.config.getCompileMode().shouldPrecompileAll()) {
            throw this.newRuntimeError("could not compile and compile mode is 'force': " + scriptNode.getPosition().getFile());
        }
    }

    private void handeCompileError(Node node, Throwable t) {
        if (this.config.isJitLoggingVerbose() || this.config.isDebug()) {
            LOG.error("warning: could not compile: {}; full trace follows", node.getPosition().getFile());
            LOG.error(t.getMessage(), t);
        }
    }

    private ScriptAndCode tryCompile(Node node, ClassDefininngJRubyClassLoader classLoader) {
        try {
            return (ScriptAndCode)Compiler.getInstance().execute(this, node, classLoader);
        }
        catch (NotCompilableException e) {
            if (Options.JIT_LOGGING.load().booleanValue()) {
                LOG.error("failed to compile target script " + node.getPosition().getFile() + ": " + e.getLocalizedMessage(), new Object[0]);
                if (Options.JIT_LOGGING_VERBOSE.load().booleanValue()) {
                    LOG.error(e);
                }
            }
            return null;
        }
    }

    public IRubyObject runScript(Script script) {
        return this.runScript(script, false);
    }

    public IRubyObject runScript(Script script, boolean wrap2) {
        ThreadContext context = this.getCurrentContext();
        try {
            return script.load(context, this.getTopSelf(), wrap2);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    public IRubyObject runScriptBody(Script script) {
        ThreadContext context = this.getCurrentContext();
        try {
            return script.__file__(context, this.getTopSelf(), Block.NULL_BLOCK);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    public IRubyObject runInterpreter(ThreadContext context, ParseResult parseResult, IRubyObject self2) {
        if (this.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.TRUFFLE) {
            assert (parseResult instanceof RootNode);
            this.getTruffleBridge().execute(TranslatorDriver.ParserContext.TOP_LEVEL, this.getTruffleBridge().toTruffle(self2), null, (RootNode)parseResult);
            return this.getNil();
        }
        try {
            return (IRubyObject)Interpreter.getInstance().execute(this, parseResult, self2);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    public IRubyObject runInterpreter(ThreadContext context, Node rootNode, IRubyObject self2) {
        assert (rootNode != null) : "scriptNode is not null";
        if (this.getInstanceConfig().getCompileMode() == RubyInstanceConfig.CompileMode.TRUFFLE) {
            assert (rootNode instanceof RootNode);
            this.getTruffleBridge().execute(TranslatorDriver.ParserContext.TOP_LEVEL, this.getTruffleBridge().toTruffle(self2), null, (RootNode)rootNode);
            return this.getNil();
        }
        try {
            return (IRubyObject)Interpreter.getInstance().execute(this, rootNode, self2);
        }
        catch (JumpException.ReturnJump rj) {
            return (IRubyObject)rj.getValue();
        }
    }

    public IRubyObject runInterpreter(Node scriptNode) {
        return this.runInterpreter(this.getCurrentContext(), scriptNode, this.getTopSelf());
    }

    public IRubyObject runInterpreter(ParseResult parseResult) {
        return this.runInterpreter(this.getCurrentContext(), parseResult, this.getTopSelf());
    }

    public IRubyObject runInterpreterBody(Node scriptNode) {
        assert (scriptNode != null) : "scriptNode is not null";
        assert (scriptNode instanceof RootNode) : "scriptNode is not a RootNode";
        return this.runInterpreter(scriptNode);
    }

    public Parser getParser() {
        return this.parser;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public JITCompiler getJITCompiler() {
        return this.jitCompiler;
    }

    public synchronized TruffleBridge getTruffleBridge() {
        if (this.truffleBridge == null) {
            try {
                this.truffleBridge = new TruffleBridgeImpl(this);
                this.truffleBridge.init();
            }
            catch (NoClassDefFoundError e) {
                throw new UnsupportedOperationException("Support for Truffle has been removed from this distribution", e);
            }
        }
        return this.truffleBridge;
    }

    public synchronized void shutdownTruffleBridge() {
        if (this.truffleBridge != null) {
            this.truffleBridge.shutdown();
        }
    }

    public static Ruby getDefaultInstance() {
        return Ruby.newInstance();
    }

    @Deprecated
    public static Ruby getCurrentInstance() {
        return null;
    }

    @Deprecated
    public static void setCurrentInstance(Ruby runtime) {
    }

    public int allocSymbolId() {
        return this.symbolLastId.incrementAndGet();
    }

    public int allocModuleId() {
        return this.moduleLastId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModule(RubyModule module) {
        Set<RubyModule> set = this.allModules;
        synchronized (set) {
            this.allModules.add(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eachModule(Function1<Object, IRubyObject> func) {
        Set<RubyModule> set = this.allModules;
        synchronized (set) {
            for (RubyModule module : this.allModules) {
                func.apply(module);
            }
        }
    }

    public RubyModule getModule(String name2) {
        return (RubyModule)this.objectClass.getConstantAt(name2);
    }

    @Deprecated
    public RubyModule fastGetModule(String internedName) {
        return this.getModule(internedName);
    }

    public RubyClass getClass(String name2) {
        return this.objectClass.getClass(name2);
    }

    @Deprecated
    public RubyClass fastGetClass(String internedName) {
        return this.getClass(internedName);
    }

    @Extension
    public RubyClass defineClass(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return this.defineClassUnder(name2, superClass, allocator, this.objectClass);
    }

    public RubyClass defineClass(String name2, RubyClass superClass, ObjectAllocator allocator, CallSite[] callSites) {
        return this.defineClassUnder(name2, superClass, allocator, this.objectClass, callSites);
    }

    @Extension
    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator, RubyModule parent) {
        return this.defineClassUnder(name2, superClass, allocator, parent, null);
    }

    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator, RubyModule parent, CallSite[] callSites) {
        boolean parentIsObject;
        IRubyObject classObj = parent.getConstantAt(name2);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw this.newTypeError(name2 + " is not a class");
            }
            RubyClass klazz = (RubyClass)classObj;
            if (klazz.getSuperClass().getRealClass() != superClass) {
                throw this.newNameError(name2 + " is already defined", name2);
            }
            if (klazz.getAllocator() != allocator) {
                klazz.setAllocator(allocator);
            }
            return klazz;
        }
        boolean bl = parentIsObject = parent == this.objectClass;
        if (superClass == null) {
            String className = parentIsObject ? name2 : parent.getName() + "::" + name2;
            this.warnings.warn(IRubyWarnings.ID.NO_SUPER_CLASS, "no super class for `" + className + "', Object assumed");
            superClass = this.objectClass;
        }
        return RubyClass.newClass(this, superClass, name2, allocator, parent, !parentIsObject, callSites);
    }

    @Extension
    public RubyModule defineModule(String name2) {
        return this.defineModuleUnder(name2, this.objectClass);
    }

    @Extension
    public RubyModule defineModuleUnder(String name2, RubyModule parent) {
        boolean parentIsObject;
        IRubyObject moduleObj = parent.getConstantAt(name2);
        boolean bl = parentIsObject = parent == this.objectClass;
        if (moduleObj != null) {
            if (moduleObj.isModule()) {
                return (RubyModule)moduleObj;
            }
            if (parentIsObject) {
                throw this.newTypeError(moduleObj.getMetaClass().getName() + " is not a module");
            }
            throw this.newTypeError(parent.getName() + "::" + moduleObj.getMetaClass().getName() + " is not a module");
        }
        return RubyModule.newModule(this, name2, parent, !parentIsObject);
    }

    public RubyModule getOrCreateModule(String name2) {
        IRubyObject module = this.objectClass.getConstantAt(name2);
        if (module == null) {
            module = this.defineModule(name2);
        } else if (!module.isModule()) {
            throw this.newTypeError(name2 + " is not a Module");
        }
        return (RubyModule)module;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setKCode(KCode kcode) {
        this.kcode = kcode;
    }

    public void defineGlobalConstant(String name2, IRubyObject value2) {
        this.objectClass.defineConstant(name2, value2);
    }

    public IRubyObject fetchGlobalConstant(String name2) {
        return this.objectClass.fetchConstant(name2, false);
    }

    public boolean isClassDefined(String name2) {
        return this.getModule(name2) != null;
    }

    private void init() {
        boolean reflectionWorks;
        this.loadService = this.config.createLoadService(this);
        this.posix = POSIXFactory.getPOSIX(new JRubyPOSIXHandler(this), this.config.isNativeEnabled());
        this.javaSupport = new JavaSupport(this);
        this.executor = new ThreadPoolExecutor(RubyInstanceConfig.POOL_MIN, RubyInstanceConfig.POOL_MAX, (long)RubyInstanceConfig.POOL_TTL, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + this.getRuntimeNumber() + "-Worker"));
        this.fiberExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, (long)RubyInstanceConfig.FIBER_POOL_TTL, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + this.getRuntimeNumber() + "-Fiber"));
        this.initRoot();
        this.threadService.initMainThread();
        ThreadContext tc = this.getCurrentContext();
        tc.prepareTopLevel(this.objectClass, this.topSelf);
        this.bootstrap();
        this.initDefinedMessages();
        this.initThreadStatuses();
        this.irManager = new IRManager();
        new IRScriptBody(this.irManager, "", tc.getCurrentScope().getStaticScope());
        this.dummyClass = new RubyClass(this, this.classClass);
        this.dummyClass.freeze(tc);
        RubyGlobal.createGlobals(tc, this);
        this.getLoadService().init(this.config.getLoadPaths());
        this.initBuiltins();
        try {
            ClassLoader.class.getDeclaredMethod("getResourceAsStream", String.class);
            reflectionWorks = true;
        }
        catch (Exception e) {
            reflectionWorks = false;
        }
        if (!RubyInstanceConfig.DEBUG_PARSER && reflectionWorks && this.getInstanceConfig().getCompileMode() != RubyInstanceConfig.CompileMode.TRUFFLE) {
            this.loadService.require("jruby");
        }
        this.bootingCore = false;
        if (this.getInstanceConfig().getCompileMode() != RubyInstanceConfig.CompileMode.TRUFFLE) {
            this.initRubyKernel();
        }
        if (this.getInstanceConfig().getCompileMode() != RubyInstanceConfig.CompileMode.TRUFFLE) {
            ThreadFiber.initRootFiber(tc);
        }
        if (this.config.isProfiling()) {
            this.getLoadService().require("jruby/profiler/shutdown_hook");
            this.kernelModule.invalidateCacheDescendants();
            RubyKernel.recacheBuiltinMethods(this);
            RubyBasicObject.recacheBuiltinMethods(this);
        }
        if (this.config.getLoadGemfile()) {
            this.loadService.loadFromClassLoader(Ruby.getClassLoader(), "jruby/bundler/startup.rb", false);
        }
        this.setNetworkStack();
        this.bootingRuntime = false;
        for (String scriptName : this.config.getRequiredLibraries()) {
            this.topSelf.callMethod(this.getCurrentContext(), "require", RubyString.newString(this, scriptName));
        }
    }

    private void bootstrap() {
        this.initCore();
        this.initExceptions();
    }

    private void initDefinedMessages() {
        for (DefinedMessage definedMessage : DefinedMessage.values()) {
            RubyString str = RubyString.newString(this, ByteList.create(definedMessage.getText()));
            str.setFrozen(true);
            this.definedMessages.put(definedMessage, str);
        }
    }

    private void initThreadStatuses() {
        for (RubyThread.Status status2 : RubyThread.Status.values()) {
            RubyString str = RubyString.newString(this, status2.bytes);
            str.setFrozen(true);
            this.threadStatuses.put(status2, str);
        }
    }

    private void initRoot() {
        this.basicObjectClass = RubyClass.createBootstrapClass(this, "BasicObject", null, RubyBasicObject.BASICOBJECT_ALLOCATOR);
        this.objectClass = RubyClass.createBootstrapClass(this, "Object", this.basicObjectClass, RubyObject.OBJECT_ALLOCATOR);
        this.moduleClass = RubyClass.createBootstrapClass(this, "Module", this.objectClass, RubyModule.MODULE_ALLOCATOR);
        this.classClass = RubyClass.createBootstrapClass(this, "Class", this.moduleClass, RubyClass.CLASS_ALLOCATOR);
        this.basicObjectClass.setMetaClass(this.classClass);
        this.objectClass.setMetaClass(this.basicObjectClass);
        this.moduleClass.setMetaClass(this.classClass);
        this.classClass.setMetaClass(this.classClass);
        RubyClass metaClass = this.basicObjectClass.makeMetaClass(this.classClass);
        metaClass = this.objectClass.makeMetaClass(metaClass);
        metaClass = this.moduleClass.makeMetaClass(metaClass);
        metaClass = this.classClass.makeMetaClass(metaClass);
        RubyBasicObject.createBasicObjectClass(this, this.basicObjectClass);
        RubyObject.createObjectClass(this, this.objectClass);
        RubyModule.createModuleClass(this, this.moduleClass);
        RubyClass.createClassClass(this, this.classClass);
        this.basicObjectClass.setConstant("BasicObject", this.basicObjectClass);
        this.objectClass.setConstant("Object", this.objectClass);
        this.objectClass.setConstant("Class", this.classClass);
        this.objectClass.setConstant("Module", this.moduleClass);
        RubyModule kernel = RubyKernel.createKernelModule(this);
        this.objectClass.includeModule(this.kernelModule);
        if (this.config.getKernelGsubDefined()) {
            kernel.addMethod("gsub", new JavaMethod(kernel, Visibility.PRIVATE, CallConfiguration.FrameFullScopeNone){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    switch (args2.length) {
                        case 1: {
                            return RubyKernel.gsub(context, self2, args2[0], block);
                        }
                        case 2: {
                            return RubyKernel.gsub(context, self2, args2[0], args2[1], block);
                        }
                    }
                    throw Ruby.this.newArgumentError(String.format("wrong number of arguments %d for 1..2", args2.length));
                }
            });
        }
        this.topSelf = TopSelfFactory.createTopSelf(this, false);
        RubyNil.createNilClass(this);
        RubyBoolean.createFalseClass(this);
        RubyBoolean.createTrueClass(this);
        this.nilObject = new RubyNil(this);
        for (int i2 = 0; i2 < 128; ++i2) {
            this.nilPrefilledArray[i2] = this.nilObject;
        }
        this.singleNilArray = new IRubyObject[]{this.nilObject};
        this.falseObject = new RubyBoolean.False(this);
        this.trueObject = new RubyBoolean.True(this);
    }

    private void initCore() {
        Encoding loadedEncoding;
        if (this.profile.allowClass("Data")) {
            this.defineClass("Data", this.objectClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        }
        RubyComparable.createComparable(this);
        RubyEnumerable.createEnumerableModule(this);
        RubyString.createStringClass(this);
        this.encodingService = new EncodingService(this);
        RubySymbol.createSymbolClass(this);
        this.recursiveKey = this.newSymbol("__recursive_key__");
        if (this.profile.allowClass("ThreadGroup")) {
            RubyThreadGroup.createThreadGroupClass(this);
        }
        if (this.profile.allowClass("Thread")) {
            RubyThread.createThreadClass(this);
        }
        if (this.profile.allowClass("Exception")) {
            RubyException.createExceptionClass(this);
        }
        if (this.profile.allowClass("Numeric")) {
            RubyNumeric.createNumericClass(this);
        }
        if (this.profile.allowClass("Integer")) {
            RubyInteger.createIntegerClass(this);
        }
        if (this.profile.allowClass("Fixnum")) {
            RubyFixnum.createFixnumClass(this);
        }
        RubyEncoding.createEncodingClass(this);
        RubyConverter.createConverterClass(this);
        this.encodingService.defineEncodings();
        this.encodingService.defineAliases();
        String encoding2 = this.config.getExternalEncoding();
        if (encoding2 != null && !encoding2.equals("")) {
            loadedEncoding = this.encodingService.loadEncoding(ByteList.create(encoding2));
            if (loadedEncoding == null) {
                throw new MainExitException(1, "unknown encoding name - " + encoding2);
            }
            this.setDefaultExternalEncoding(loadedEncoding);
        } else {
            Encoding consoleEncoding = this.encodingService.getConsoleEncoding();
            Encoding availableEncoding = consoleEncoding == null ? this.encodingService.getLocaleEncoding() : consoleEncoding;
            this.setDefaultExternalEncoding(availableEncoding);
        }
        encoding2 = this.config.getInternalEncoding();
        if (encoding2 != null && !encoding2.equals("")) {
            loadedEncoding = this.encodingService.loadEncoding(ByteList.create(encoding2));
            if (loadedEncoding == null) {
                throw new MainExitException(1, "unknown encoding name - " + encoding2);
            }
            this.setDefaultInternalEncoding(loadedEncoding);
        }
        if (this.profile.allowClass("Complex")) {
            RubyComplex.createComplexClass(this);
        }
        if (this.profile.allowClass("Rational")) {
            RubyRational.createRationalClass(this);
        }
        if (this.profile.allowClass("Hash")) {
            RubyHash.createHashClass(this);
        }
        if (this.profile.allowClass("Array")) {
            RubyArray.createArrayClass(this);
            this.emptyFrozenArray = this.newEmptyArray();
            this.emptyFrozenArray.setFrozen(true);
        }
        if (this.profile.allowClass("Float")) {
            RubyFloat.createFloatClass(this);
        }
        if (this.profile.allowClass("Bignum")) {
            RubyBignum.createBignumClass(this);
            RubyRandom.createRandomClass(this);
        }
        this.ioClass = RubyIO.createIOClass(this);
        if (this.profile.allowClass("Struct")) {
            RubyStruct.createStructClass(this);
        }
        if (this.profile.allowClass("Tms")) {
            this.tmsStruct = RubyStruct.newInstance(this.structClass, new IRubyObject[]{this.newString("Tms"), this.newSymbol("utime"), this.newSymbol("stime"), this.newSymbol("cutime"), this.newSymbol("cstime")}, Block.NULL_BLOCK);
        }
        if (this.profile.allowClass("Binding")) {
            RubyBinding.createBindingClass(this);
        }
        if (this.profile.allowModule("Math")) {
            RubyMath.createMathModule(this);
        }
        if (this.profile.allowClass("Regexp")) {
            RubyRegexp.createRegexpClass(this);
        }
        if (this.profile.allowClass("Range")) {
            RubyRange.createRangeClass(this);
        }
        if (this.profile.allowModule("ObjectSpace")) {
            RubyObjectSpace.createObjectSpaceModule(this);
        }
        if (this.profile.allowModule("GC")) {
            RubyGC.createGCModule(this);
        }
        if (this.profile.allowClass("Proc")) {
            RubyProc.createProcClass(this);
        }
        if (this.profile.allowClass("Method")) {
            RubyMethod.createMethodClass(this);
        }
        if (this.profile.allowClass("MatchData")) {
            RubyMatchData.createMatchDataClass(this);
        }
        if (this.profile.allowModule("Marshal")) {
            RubyMarshal.createMarshalModule(this);
        }
        if (this.profile.allowClass("Dir")) {
            RubyDir.createDirClass(this);
        }
        if (this.profile.allowModule("FileTest")) {
            RubyFileTest.createFileTestModule(this);
        }
        if (this.profile.allowClass("File")) {
            RubyFile.createFileClass(this);
        }
        if (this.profile.allowClass("File::Stat")) {
            RubyFileStat.createFileStatClass(this);
        }
        if (this.profile.allowModule("Process")) {
            RubyProcess.createProcessModule(this);
        }
        if (this.profile.allowClass("Time")) {
            RubyTime.createTimeClass(this);
        }
        if (this.profile.allowClass("UnboundMethod")) {
            RubyUnboundMethod.defineUnboundMethodClass(this);
        }
        if (this.profile.allowModule("Signal")) {
            RubySignal.createSignal(this);
        }
        if (this.profile.allowClass("Continuation")) {
            RubyContinuation.createContinuation(this);
        }
        if (this.profile.allowClass("Enumerator")) {
            RubyEnumerator.defineEnumerator(this);
        }
        new ThreadLibrary().load(this, false);
        new ThreadFiberLibrary().load(this, false);
        TracePoint.createTracePointClass(this);
    }

    public IRubyObject[] getNilPrefilledArray() {
        return this.nilPrefilledArray;
    }

    private void initExceptions() {
        this.standardError = this.defineClassIfAllowed("StandardError", this.exceptionClass);
        this.runtimeError = this.defineClassIfAllowed("RuntimeError", this.standardError);
        this.ioError = this.defineClassIfAllowed("IOError", this.standardError);
        this.scriptError = this.defineClassIfAllowed("ScriptError", this.exceptionClass);
        this.rangeError = this.defineClassIfAllowed("RangeError", this.standardError);
        this.signalException = this.defineClassIfAllowed("SignalException", this.exceptionClass);
        if (this.profile.allowClass("NameError")) {
            this.nameError = RubyNameError.createNameErrorClass(this, this.standardError);
            this.nameErrorMessage = RubyNameError.createNameErrorMessageClass(this, this.nameError);
        }
        if (this.profile.allowClass("NoMethodError")) {
            this.noMethodError = RubyNoMethodError.createNoMethodErrorClass(this, this.nameError);
        }
        if (this.profile.allowClass("SystemExit")) {
            this.systemExit = RubySystemExit.createSystemExitClass(this, this.exceptionClass);
        }
        if (this.profile.allowClass("LocalJumpError")) {
            this.localJumpError = RubyLocalJumpError.createLocalJumpErrorClass(this, this.standardError);
        }
        if (this.profile.allowClass("NativeException")) {
            this.nativeException = NativeException.createClass(this, this.runtimeError);
        }
        if (this.profile.allowClass("SystemCallError")) {
            this.systemCallError = RubySystemCallError.createSystemCallErrorClass(this, this.standardError);
        }
        this.fatal = this.defineClassIfAllowed("Fatal", this.exceptionClass);
        this.interrupt = this.defineClassIfAllowed("Interrupt", this.signalException);
        this.typeError = this.defineClassIfAllowed("TypeError", this.standardError);
        this.argumentError = this.defineClassIfAllowed("ArgumentError", this.standardError);
        this.indexError = this.defineClassIfAllowed("IndexError", this.standardError);
        this.stopIteration = this.defineClassIfAllowed("StopIteration", this.indexError);
        this.syntaxError = this.defineClassIfAllowed("SyntaxError", this.scriptError);
        this.loadError = this.defineClassIfAllowed("LoadError", this.scriptError);
        this.notImplementedError = this.defineClassIfAllowed("NotImplementedError", this.scriptError);
        this.securityError = this.defineClassIfAllowed("SecurityError", this.standardError);
        this.noMemoryError = this.defineClassIfAllowed("NoMemoryError", this.exceptionClass);
        this.regexpError = this.defineClassIfAllowed("RegexpError", this.standardError);
        this.interruptedRegexpError = this.defineClassIfAllowed("InterruptedRegexpError", this.regexpError);
        this.eofError = this.defineClassIfAllowed("EOFError", this.ioError);
        this.threadError = this.defineClassIfAllowed("ThreadError", this.standardError);
        this.concurrencyError = this.defineClassIfAllowed("ConcurrencyError", this.threadError);
        this.systemStackError = this.defineClassIfAllowed("SystemStackError", this.exceptionClass);
        this.zeroDivisionError = this.defineClassIfAllowed("ZeroDivisionError", this.standardError);
        this.floatDomainError = this.defineClassIfAllowed("FloatDomainError", this.rangeError);
        if (this.profile.allowClass("EncodingError")) {
            this.encodingError = this.defineClass("EncodingError", this.standardError, this.standardError.getAllocator());
            this.encodingCompatibilityError = this.defineClassUnder("CompatibilityError", this.encodingError, this.encodingError.getAllocator(), this.encodingClass);
            this.invalidByteSequenceError = this.defineClassUnder("InvalidByteSequenceError", this.encodingError, this.encodingError.getAllocator(), this.encodingClass);
            this.invalidByteSequenceError.defineAnnotatedMethods(RubyConverter.EncodingErrorMethods.class);
            this.invalidByteSequenceError.defineAnnotatedMethods(RubyConverter.InvalidByteSequenceErrorMethods.class);
            this.undefinedConversionError = this.defineClassUnder("UndefinedConversionError", this.encodingError, this.encodingError.getAllocator(), this.encodingClass);
            this.undefinedConversionError.defineAnnotatedMethods(RubyConverter.EncodingErrorMethods.class);
            this.undefinedConversionError.defineAnnotatedMethods(RubyConverter.UndefinedConversionErrorMethods.class);
            this.converterNotFoundError = this.defineClassUnder("ConverterNotFoundError", this.encodingError, this.encodingError.getAllocator(), this.encodingClass);
            this.fiberError = this.defineClass("FiberError", this.standardError, this.standardError.getAllocator());
        }
        this.concurrencyError = this.defineClassIfAllowed("ConcurrencyError", this.threadError);
        this.keyError = this.defineClassIfAllowed("KeyError", this.indexError);
        this.mathDomainError = this.defineClassUnder("DomainError", this.argumentError, this.argumentError.getAllocator(), this.mathModule);
        this.inRecursiveListOperation.set(false);
        this.initErrno();
    }

    private RubyClass defineClassIfAllowed(String name2, RubyClass superClass) {
        if (superClass != null && this.profile.allowClass(name2)) {
            return this.defineClass(name2, superClass, superClass.getAllocator());
        }
        return null;
    }

    public RubyClass getErrno(int n) {
        return this.errnos.get(n);
    }

    private void initErrno() {
        if (this.profile.allowModule("Errno")) {
            this.errnoModule = this.defineModule("Errno");
            try {
                this.createSysErr(Errno.EAGAIN.intValue(), Errno.EAGAIN.name());
                for (Errno e : Errno.values()) {
                    Errno c = e;
                    if (!Character.isUpperCase(c.name().charAt(0))) continue;
                    this.createSysErr(c.intValue(), c.name());
                }
                this.errnos.put(Errno.ENOSYS.intValue(), this.notImplementedError);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    private void createSysErr(int i2, String name2) {
        if (this.profile.allowClass(name2)) {
            if (this.errnos.get(i2) == null) {
                RubyClass errno2 = this.getErrno().defineClassUnder(name2, this.systemCallError, this.systemCallError.getAllocator());
                this.errnos.put(i2, errno2);
                errno2.defineConstant("Errno", this.newFixnum(i2));
            } else {
                this.getErrno().setConstant(name2, this.errnos.get(i2));
            }
        }
    }

    private void initBuiltins() {
        if (RubyInstanceConfig.DEBUG_PARSER) {
            return;
        }
        this.addLazyBuiltin("java.rb", "java", "org.jruby.javasupport.Java");
        this.addLazyBuiltin("jruby.rb", "jruby", "org.jruby.ext.jruby.JRubyLibrary");
        this.addLazyBuiltin("jruby/util.rb", "jruby/util", "org.jruby.ext.jruby.JRubyUtilLibrary");
        this.addLazyBuiltin("jruby/type.rb", "jruby/type", "org.jruby.ext.jruby.JRubyTypeLibrary");
        this.addLazyBuiltin("nkf.jar", "nkf", "org.jruby.ext.nkf.NKFLibrary");
        this.addLazyBuiltin("stringio.jar", "stringio", "org.jruby.ext.stringio.StringIOLibrary");
        this.addLazyBuiltin("strscan.jar", "strscan", "org.jruby.ext.strscan.StringScannerLibrary");
        this.addLazyBuiltin("zlib.jar", "zlib", "org.jruby.ext.zlib.ZlibLibrary");
        this.addLazyBuiltin("thread.jar", "thread", "org.jruby.ext.thread.ThreadLibrary");
        this.addLazyBuiltin("thread.rb", "thread", "org.jruby.ext.thread.ThreadLibrary");
        this.addLazyBuiltin("digest.jar", "digest.so", "org.jruby.ext.digest.DigestLibrary");
        this.addLazyBuiltin("digest/md5.jar", "digest/md5", "org.jruby.ext.digest.MD5");
        this.addLazyBuiltin("digest/rmd160.jar", "digest/rmd160", "org.jruby.ext.digest.RMD160");
        this.addLazyBuiltin("digest/sha1.jar", "digest/sha1", "org.jruby.ext.digest.SHA1");
        this.addLazyBuiltin("digest/sha2.jar", "digest/sha2", "org.jruby.ext.digest.SHA2");
        this.addLazyBuiltin("bigdecimal.jar", "bigdecimal", "org.jruby.ext.bigdecimal.BigDecimalLibrary");
        this.addLazyBuiltin("io/wait.jar", "io/wait", "org.jruby.ext.io.wait.IOWaitLibrary");
        this.addLazyBuiltin("etc.jar", "etc", "org.jruby.ext.etc.EtcLibrary");
        this.addLazyBuiltin("weakref.rb", "weakref", "org.jruby.ext.weakref.WeakRefLibrary");
        this.addLazyBuiltin("timeout.rb", "timeout", "org.jruby.ext.timeout.Timeout");
        this.addLazyBuiltin("socket.jar", "socket", "org.jruby.ext.socket.SocketLibrary");
        this.addLazyBuiltin("rbconfig.rb", "rbconfig", "org.jruby.ext.rbconfig.RbConfigLibrary");
        this.addLazyBuiltin("jruby/serialization.rb", "serialization", "org.jruby.ext.jruby.JRubySerializationLibrary");
        this.addLazyBuiltin("ffi-internal.jar", "ffi-internal", "org.jruby.ext.ffi.FFIService");
        this.addLazyBuiltin("tempfile.jar", "tempfile", "org.jruby.ext.tempfile.TempfileLibrary");
        this.addLazyBuiltin("fcntl.rb", "fcntl", "org.jruby.ext.fcntl.FcntlLibrary");
        this.addLazyBuiltin("yecht.jar", "yecht", "YechtService");
        this.addLazyBuiltin("pathname.jar", "pathname", "org.jruby.ext.pathname.PathnameLibrary");
        this.addLazyBuiltin("mathn/complex.jar", "mathn/complex", "org.jruby.ext.mathn.Complex");
        this.addLazyBuiltin("mathn/rational.jar", "mathn/rational", "org.jruby.ext.mathn.Rational");
        this.addLazyBuiltin("psych.jar", "psych", "org.jruby.ext.psych.PsychLibrary");
        this.addLazyBuiltin("coverage.jar", "coverage", "org.jruby.ext.coverage.CoverageLibrary");
        this.addBuiltinIfAllowed("continuation.rb", Library.DUMMY);
        this.loadService.provide("enumerator.jar");
        this.loadService.provide("rational.jar");
        this.loadService.provide("complex.jar");
        this.addBuiltinIfAllowed("thread.rb", Library.DUMMY);
        if (RubyInstanceConfig.NATIVE_NET_PROTOCOL) {
            this.addLazyBuiltin("net/protocol.rb", "net/protocol", "org.jruby.ext.net.protocol.NetProtocolBufferedIOLibrary");
        }
        this.addBuiltinIfAllowed("win32ole.jar", new Library(){

            @Override
            public void load(Ruby runtime, boolean wrap2) throws IOException {
                runtime.getLoadService().require("jruby/win32ole/stub");
            }
        });
    }

    private void initRubyKernel() {
        if (RubyInstanceConfig.DEBUG_PARSER) {
            return;
        }
        this.loadService.loadFromClassLoader(Ruby.getClassLoader(), "jruby/kernel.rb", false);
    }

    private void addLazyBuiltin(String name2, String shortName, String className) {
        this.addBuiltinIfAllowed(name2, new LateLoadingLibrary(shortName, className, Ruby.getClassLoader()));
    }

    private void addBuiltinIfAllowed(String name2, Library lib) {
        if (this.profile.allowBuiltin(name2)) {
            this.loadService.addBuiltinLibrary(name2, lib);
        }
    }

    public IRManager getIRManager() {
        return this.irManager;
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    public IRubyObject getRootFiber() {
        return this.rootFiber;
    }

    public void setRootFiber(IRubyObject fiber2) {
        this.rootFiber = fiber2;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDirectory = dir;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentLine(int line) {
        this.currentLine = line;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void setArgsFile(IRubyObject argsFile) {
        this.argsFile = argsFile;
    }

    public IRubyObject getArgsFile() {
        return this.argsFile;
    }

    public RubyModule getEtc() {
        return this.etcModule;
    }

    public void setEtc(RubyModule etcModule) {
        this.etcModule = etcModule;
    }

    public RubyClass getObject() {
        return this.objectClass;
    }

    public RubyClass getBasicObject() {
        return this.basicObjectClass;
    }

    public RubyClass getModule() {
        return this.moduleClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyModule getKernel() {
        return this.kernelModule;
    }

    void setKernel(RubyModule kernelModule) {
        this.kernelModule = kernelModule;
    }

    public DynamicMethod getPrivateMethodMissing() {
        return this.privateMethodMissing;
    }

    public void setPrivateMethodMissing(DynamicMethod method) {
        this.privateMethodMissing = method;
    }

    public DynamicMethod getProtectedMethodMissing() {
        return this.protectedMethodMissing;
    }

    public void setProtectedMethodMissing(DynamicMethod method) {
        this.protectedMethodMissing = method;
    }

    public DynamicMethod getVariableMethodMissing() {
        return this.variableMethodMissing;
    }

    public void setVariableMethodMissing(DynamicMethod method) {
        this.variableMethodMissing = method;
    }

    public DynamicMethod getSuperMethodMissing() {
        return this.superMethodMissing;
    }

    public void setSuperMethodMissing(DynamicMethod method) {
        this.superMethodMissing = method;
    }

    public DynamicMethod getNormalMethodMissing() {
        return this.normalMethodMissing;
    }

    public void setNormalMethodMissing(DynamicMethod method) {
        this.normalMethodMissing = method;
    }

    public DynamicMethod getDefaultMethodMissing() {
        return this.defaultMethodMissing;
    }

    public void setDefaultMethodMissing(DynamicMethod method) {
        this.defaultMethodMissing = method;
    }

    public DynamicMethod getRespondToMethod() {
        return this.respondTo;
    }

    public void setRespondToMethod(DynamicMethod rtm) {
        this.respondTo = rtm;
    }

    public DynamicMethod getRespondToMissingMethod() {
        return this.respondToMissing;
    }

    public void setRespondToMissingMethod(DynamicMethod rtmm) {
        this.respondToMissing = rtmm;
    }

    public RubyClass getDummy() {
        return this.dummyClass;
    }

    public RubyModule getComparable() {
        return this.comparableModule;
    }

    void setComparable(RubyModule comparableModule) {
        this.comparableModule = comparableModule;
    }

    public RubyClass getNumeric() {
        return this.numericClass;
    }

    void setNumeric(RubyClass numericClass) {
        this.numericClass = numericClass;
    }

    public RubyClass getFloat() {
        return this.floatClass;
    }

    void setFloat(RubyClass floatClass) {
        this.floatClass = floatClass;
    }

    public RubyClass getInteger() {
        return this.integerClass;
    }

    void setInteger(RubyClass integerClass) {
        this.integerClass = integerClass;
    }

    public RubyClass getFixnum() {
        return this.fixnumClass;
    }

    void setFixnum(RubyClass fixnumClass) {
        this.fixnumClass = fixnumClass;
    }

    public RubyClass getComplex() {
        return this.complexClass;
    }

    void setComplex(RubyClass complexClass) {
        this.complexClass = complexClass;
    }

    public RubyClass getRational() {
        return this.rationalClass;
    }

    void setRational(RubyClass rationalClass) {
        this.rationalClass = rationalClass;
    }

    public RubyModule getEnumerable() {
        return this.enumerableModule;
    }

    void setEnumerable(RubyModule enumerableModule) {
        this.enumerableModule = enumerableModule;
    }

    public RubyClass getEnumerator() {
        return this.enumeratorClass;
    }

    void setEnumerator(RubyClass enumeratorClass) {
        this.enumeratorClass = enumeratorClass;
    }

    public RubyClass getYielder() {
        return this.yielderClass;
    }

    void setYielder(RubyClass yielderClass) {
        this.yielderClass = yielderClass;
    }

    public RubyClass getGenerator() {
        return this.generatorClass;
    }

    public void setGenerator(RubyClass generatorClass) {
        this.generatorClass = generatorClass;
    }

    public RubyClass getFiber() {
        return this.fiberClass;
    }

    public void setFiber(RubyClass fiberClass) {
        this.fiberClass = fiberClass;
    }

    public RubyClass getString() {
        return this.stringClass;
    }

    void setString(RubyClass stringClass) {
        this.stringClass = stringClass;
    }

    public RubyClass getEncoding() {
        return this.encodingClass;
    }

    void setEncoding(RubyClass encodingClass) {
        this.encodingClass = encodingClass;
    }

    public RubyClass getConverter() {
        return this.converterClass;
    }

    void setConverter(RubyClass converterClass) {
        this.converterClass = converterClass;
    }

    public RubyClass getSymbol() {
        return this.symbolClass;
    }

    void setSymbol(RubyClass symbolClass) {
        this.symbolClass = symbolClass;
    }

    public RubyClass getArray() {
        return this.arrayClass;
    }

    void setArray(RubyClass arrayClass) {
        this.arrayClass = arrayClass;
    }

    public RubyClass getHash() {
        return this.hashClass;
    }

    void setHash(RubyClass hashClass) {
        this.hashClass = hashClass;
    }

    public RubyClass getRange() {
        return this.rangeClass;
    }

    void setRange(RubyClass rangeClass) {
        this.rangeClass = rangeClass;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public IRubyObject[] getSingleNilArray() {
        return this.singleNilArray;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    void setNilClass(RubyClass nilClass) {
        this.nilClass = nilClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    void setTrueClass(RubyClass trueClass) {
        this.trueClass = trueClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    void setFalseClass(RubyClass falseClass) {
        this.falseClass = falseClass;
    }

    public RubyClass getProc() {
        return this.procClass;
    }

    void setProc(RubyClass procClass) {
        this.procClass = procClass;
    }

    public RubyClass getBinding() {
        return this.bindingClass;
    }

    void setBinding(RubyClass bindingClass) {
        this.bindingClass = bindingClass;
    }

    public RubyClass getMethod() {
        return this.methodClass;
    }

    void setMethod(RubyClass methodClass) {
        this.methodClass = methodClass;
    }

    public RubyClass getUnboundMethod() {
        return this.unboundMethodClass;
    }

    void setUnboundMethod(RubyClass unboundMethodClass) {
        this.unboundMethodClass = unboundMethodClass;
    }

    public RubyClass getMatchData() {
        return this.matchDataClass;
    }

    void setMatchData(RubyClass matchDataClass) {
        this.matchDataClass = matchDataClass;
    }

    public RubyClass getRegexp() {
        return this.regexpClass;
    }

    void setRegexp(RubyClass regexpClass) {
        this.regexpClass = regexpClass;
    }

    public RubyClass getTime() {
        return this.timeClass;
    }

    void setTime(RubyClass timeClass) {
        this.timeClass = timeClass;
    }

    public RubyModule getMath() {
        return this.mathModule;
    }

    void setMath(RubyModule mathModule) {
        this.mathModule = mathModule;
    }

    public RubyModule getMarshal() {
        return this.marshalModule;
    }

    void setMarshal(RubyModule marshalModule) {
        this.marshalModule = marshalModule;
    }

    public RubyClass getBignum() {
        return this.bignumClass;
    }

    void setBignum(RubyClass bignumClass) {
        this.bignumClass = bignumClass;
    }

    public RubyClass getDir() {
        return this.dirClass;
    }

    void setDir(RubyClass dirClass) {
        this.dirClass = dirClass;
    }

    public RubyClass getFile() {
        return this.fileClass;
    }

    void setFile(RubyClass fileClass) {
        this.fileClass = fileClass;
    }

    public RubyClass getFileStat() {
        return this.fileStatClass;
    }

    void setFileStat(RubyClass fileStatClass) {
        this.fileStatClass = fileStatClass;
    }

    public RubyModule getFileTest() {
        return this.fileTestModule;
    }

    void setFileTest(RubyModule fileTestModule) {
        this.fileTestModule = fileTestModule;
    }

    public RubyClass getIO() {
        return this.ioClass;
    }

    void setIO(RubyClass ioClass) {
        this.ioClass = ioClass;
    }

    public RubyClass getThread() {
        return this.threadClass;
    }

    void setThread(RubyClass threadClass) {
        this.threadClass = threadClass;
    }

    public RubyClass getThreadGroup() {
        return this.threadGroupClass;
    }

    void setThreadGroup(RubyClass threadGroupClass) {
        this.threadGroupClass = threadGroupClass;
    }

    public RubyThreadGroup getDefaultThreadGroup() {
        return this.defaultThreadGroup;
    }

    void setDefaultThreadGroup(RubyThreadGroup defaultThreadGroup) {
        this.defaultThreadGroup = defaultThreadGroup;
    }

    public RubyClass getContinuation() {
        return this.continuationClass;
    }

    void setContinuation(RubyClass continuationClass) {
        this.continuationClass = continuationClass;
    }

    public RubyClass getStructClass() {
        return this.structClass;
    }

    void setStructClass(RubyClass structClass) {
        this.structClass = structClass;
    }

    public RubyClass getRandomClass() {
        return this.randomClass;
    }

    void setRandomClass(RubyClass randomClass) {
        this.randomClass = randomClass;
    }

    public IRubyObject getTmsStruct() {
        return this.tmsStruct;
    }

    void setTmsStruct(RubyClass tmsStruct) {
        this.tmsStruct = tmsStruct;
    }

    public IRubyObject getPasswdStruct() {
        return this.passwdStruct;
    }

    public void setPasswdStruct(RubyClass passwdStruct) {
        this.passwdStruct = passwdStruct;
    }

    public IRubyObject getGroupStruct() {
        return this.groupStruct;
    }

    public void setGroupStruct(RubyClass groupStruct) {
        this.groupStruct = groupStruct;
    }

    public RubyModule getGC() {
        return this.gcModule;
    }

    void setGC(RubyModule gcModule) {
        this.gcModule = gcModule;
    }

    public RubyModule getObjectSpaceModule() {
        return this.objectSpaceModule;
    }

    void setObjectSpaceModule(RubyModule objectSpaceModule) {
        this.objectSpaceModule = objectSpaceModule;
    }

    public RubyModule getProcess() {
        return this.processModule;
    }

    void setProcess(RubyModule processModule) {
        this.processModule = processModule;
    }

    public RubyClass getProcStatus() {
        return this.procStatusClass;
    }

    void setProcStatus(RubyClass procStatusClass) {
        this.procStatusClass = procStatusClass;
    }

    public RubyModule getProcUID() {
        return this.procUIDModule;
    }

    void setProcUID(RubyModule procUIDModule) {
        this.procUIDModule = procUIDModule;
    }

    public RubyModule getProcGID() {
        return this.procGIDModule;
    }

    void setProcGID(RubyModule procGIDModule) {
        this.procGIDModule = procGIDModule;
    }

    public RubyModule getProcSysModule() {
        return this.procSysModule;
    }

    void setProcSys(RubyModule procSysModule) {
        this.procSysModule = procSysModule;
    }

    public RubyModule getPrecision() {
        return this.precisionModule;
    }

    void setPrecision(RubyModule precisionModule) {
        this.precisionModule = precisionModule;
    }

    public RubyHash getENV() {
        return this.envObject;
    }

    public void setENV(RubyHash env) {
        this.envObject = env;
    }

    public RubyClass getLocation() {
        return this.locationClass;
    }

    public void setLocation(RubyClass location) {
        this.locationClass = location;
    }

    public RubyModule getErrno() {
        return this.errnoModule;
    }

    public RubyClass getException() {
        return this.exceptionClass;
    }

    void setException(RubyClass exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public RubyClass getNameError() {
        return this.nameError;
    }

    public RubyClass getNameErrorMessage() {
        return this.nameErrorMessage;
    }

    public RubyClass getNoMethodError() {
        return this.noMethodError;
    }

    public RubyClass getSignalException() {
        return this.signalException;
    }

    public RubyClass getRangeError() {
        return this.rangeError;
    }

    public RubyClass getSystemExit() {
        return this.systemExit;
    }

    public RubyClass getLocalJumpError() {
        return this.localJumpError;
    }

    public RubyClass getNativeException() {
        return this.nativeException;
    }

    public RubyClass getSystemCallError() {
        return this.systemCallError;
    }

    public RubyClass getKeyError() {
        return this.keyError;
    }

    public RubyClass getFatal() {
        return this.fatal;
    }

    public RubyClass getInterrupt() {
        return this.interrupt;
    }

    public RubyClass getTypeError() {
        return this.typeError;
    }

    public RubyClass getArgumentError() {
        return this.argumentError;
    }

    public RubyClass getIndexError() {
        return this.indexError;
    }

    public RubyClass getStopIteration() {
        return this.stopIteration;
    }

    public RubyClass getSyntaxError() {
        return this.syntaxError;
    }

    public RubyClass getStandardError() {
        return this.standardError;
    }

    public RubyClass getRuntimeError() {
        return this.runtimeError;
    }

    public RubyClass getIOError() {
        return this.ioError;
    }

    public RubyClass getLoadError() {
        return this.loadError;
    }

    public RubyClass getNotImplementedError() {
        return this.notImplementedError;
    }

    public RubyClass getSecurityError() {
        return this.securityError;
    }

    public RubyClass getNoMemoryError() {
        return this.noMemoryError;
    }

    public RubyClass getRegexpError() {
        return this.regexpError;
    }

    public RubyClass getInterruptedRegexpError() {
        return this.interruptedRegexpError;
    }

    public RubyClass getEOFError() {
        return this.eofError;
    }

    public RubyClass getThreadError() {
        return this.threadError;
    }

    public RubyClass getConcurrencyError() {
        return this.concurrencyError;
    }

    public RubyClass getSystemStackError() {
        return this.systemStackError;
    }

    public RubyClass getZeroDivisionError() {
        return this.zeroDivisionError;
    }

    public RubyClass getFloatDomainError() {
        return this.floatDomainError;
    }

    public RubyClass getMathDomainError() {
        return this.mathDomainError;
    }

    public RubyClass getEncodingError() {
        return this.encodingError;
    }

    public RubyClass getEncodingCompatibilityError() {
        return this.encodingCompatibilityError;
    }

    public RubyClass getConverterNotFoundError() {
        return this.converterNotFoundError;
    }

    public RubyClass getFiberError() {
        return this.fiberError;
    }

    public RubyClass getUndefinedConversionError() {
        return this.undefinedConversionError;
    }

    public RubyClass getInvalidByteSequenceError() {
        return this.invalidByteSequenceError;
    }

    public RubyRandom.RandomType getDefaultRand() {
        return this.defaultRand;
    }

    public void setDefaultRand(RubyRandom.RandomType defaultRand) {
        this.defaultRand = defaultRand;
    }

    public RubyHash getCharsetMap() {
        if (this.charsetMap == null) {
            this.charsetMap = new RubyHash(this);
        }
        return this.charsetMap;
    }

    public IRubyObject getVerbose() {
        return this.verboseValue;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean warningsEnabled() {
        return this.warningsEnabled;
    }

    public void setVerbose(IRubyObject verbose) {
        this.verbose = verbose.isTrue();
        this.verboseValue = verbose;
        this.warningsEnabled = !verbose.isNil();
    }

    public IRubyObject getDebug() {
        return this.debug ? this.trueObject : this.falseObject;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(IRubyObject debug) {
        this.debug = debug.isTrue();
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader = Ruby.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public synchronized JRubyClassLoader getJRubyClassLoader() {
        if (!Ruby.isSecurityRestricted() && this.jrubyClassLoader == null) {
            this.jrubyClassLoader = new JRubyClassLoader(this.config.getLoader());
            if (RubyInstanceConfig.JIT_CODE_CACHE != null) {
                if (!RubyInstanceConfig.JIT_CODE_CACHE.trim().isEmpty()) {
                    File file2 = new File(RubyInstanceConfig.JIT_CODE_CACHE);
                    if (!file2.exists() || !file2.isDirectory()) {
                        this.getWarnings().warning("The jit.codeCache '" + RubyInstanceConfig.JIT_CODE_CACHE + "' directory doesn't exit.");
                    } else {
                        try {
                            URL url = file2.toURI().toURL();
                            this.jrubyClassLoader.addURL(url);
                        }
                        catch (MalformedURLException e) {
                            this.getWarnings().warning("Unable to add the jit.codeCache '" + RubyInstanceConfig.JIT_CODE_CACHE + "' directory to the classpath." + e.getMessage());
                        }
                    }
                }
            }
        }
        return this.jrubyClassLoader;
    }

    public void defineVariable(final GlobalVariable variable, GlobalVariable.Scope scope) {
        this.globalVariables.define(variable.name(), new IAccessor(){

            @Override
            public IRubyObject getValue() {
                return variable.get();
            }

            @Override
            public IRubyObject setValue(IRubyObject newValue) {
                return variable.set(newValue);
            }
        }, scope);
    }

    public void defineReadonlyVariable(String name2, IRubyObject value2, GlobalVariable.Scope scope) {
        this.globalVariables.defineReadonly(name2, new ValueAccessor(value2), scope);
    }

    public Node parseFile(InputStream in, String file2, DynamicScope scope) {
        return this.parseFile(in, file2, scope, 0);
    }

    public ParseResult parseFile(String file2, InputStream in, DynamicScope scope) {
        return this.parseFile(file2, in, scope, 0);
    }

    public Node parseFile(InputStream in, String file2, DynamicScope scope, int lineNumber) {
        this.addLoadParseToStats();
        return this.parseFileAndGetAST(in, file2, scope, lineNumber, false);
    }

    public ParseResult parseFile(String file2, InputStream in, DynamicScope scope, int lineNumber) {
        this.addLoadParseToStats();
        if (!RubyInstanceConfig.IR_READING) {
            return this.parseFileAndGetAST(in, file2, scope, lineNumber, false);
        }
        try {
            return IRReader.load(this.getIRManager(), new IRReaderFile(this.getIRManager(), IRFileExpert.getIRPersistedFile(file2)));
        }
        catch (IOException e) {
            return this.parseFileAndGetAST(in, file2, scope, lineNumber, false);
        }
    }

    public Node parseFileFromMain(InputStream in, String file2, DynamicScope scope) {
        this.addLoadParseToStats();
        return this.parseFileFromMainAndGetAST(in, file2, scope);
    }

    public ParseResult parseFileFromMain(String file2, InputStream in, DynamicScope scope) {
        this.addLoadParseToStats();
        if (!RubyInstanceConfig.IR_READING) {
            return this.parseFileFromMainAndGetAST(in, file2, scope);
        }
        try {
            return IRReader.load(this.getIRManager(), new IRReaderFile(this.getIRManager(), IRFileExpert.getIRPersistedFile(file2)));
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace();
            return this.parseFileFromMainAndGetAST(in, file2, scope);
        }
    }

    private Node parseFileFromMainAndGetAST(InputStream in, String file2, DynamicScope scope) {
        return this.parseFileAndGetAST(in, file2, scope, 0, true);
    }

    private Node parseFileAndGetAST(InputStream in, String file2, DynamicScope scope, int lineNumber, boolean isFromMain) {
        ParserConfiguration parserConfig = new ParserConfiguration(this, lineNumber, false, true, this.config);
        this.setupSourceEncoding(parserConfig);
        return this.parser.parse(file2, in, scope, parserConfig);
    }

    public Node parseInline(InputStream in, String file2, DynamicScope scope) {
        this.addEvalParseToStats();
        ParserConfiguration parserConfig = new ParserConfiguration(this, 0, false, true, false, this.config);
        this.setupSourceEncoding(parserConfig);
        return this.parser.parse(file2, in, scope, parserConfig);
    }

    private void setupSourceEncoding(ParserConfiguration parserConfig) {
        if (this.config.getSourceEncoding() != null) {
            if (this.config.isVerbose()) {
                this.config.getError().println("-K is specified; it is for 1.8 compatibility and may cause odd behavior");
            }
            parserConfig.setDefaultEncoding(this.getEncodingService().getEncodingFromString(this.config.getSourceEncoding()));
        } else {
            parserConfig.setDefaultEncoding(this.getEncodingService().getLocaleEncoding());
        }
    }

    public Node parseEval(String content, String file2, DynamicScope scope, int lineNumber) {
        this.addEvalParseToStats();
        return this.parser.parse(file2, content.getBytes(), scope, new ParserConfiguration(this, lineNumber, false, false, this.config));
    }

    @Deprecated
    public Node parse(String content, String file2, DynamicScope scope, int lineNumber, boolean extraPositionInformation) {
        return this.parser.parse(file2, content.getBytes(), scope, new ParserConfiguration(this, lineNumber, extraPositionInformation, false, true, this.config));
    }

    public Node parseEval(ByteList content, String file2, DynamicScope scope, int lineNumber) {
        this.addEvalParseToStats();
        return this.parser.parse(file2, content, scope, new ParserConfiguration(this, lineNumber, false, false, false, this.config));
    }

    public Node parse(ByteList content, String file2, DynamicScope scope, int lineNumber, boolean extraPositionInformation) {
        this.addEvalParseToStats();
        return this.parser.parse(file2, content, scope, new ParserConfiguration(this, lineNumber, extraPositionInformation, false, true, this.config));
    }

    public ThreadService getThreadService() {
        return this.threadService;
    }

    public ThreadContext getCurrentContext() {
        return this.threadService.getCurrentContext();
    }

    public LoadService getLoadService() {
        return this.loadService;
    }

    public Encoding getDefaultInternalEncoding() {
        return this.defaultInternalEncoding;
    }

    public void setDefaultInternalEncoding(Encoding defaultInternalEncoding) {
        this.defaultInternalEncoding = defaultInternalEncoding;
    }

    public Encoding getDefaultExternalEncoding() {
        return this.defaultExternalEncoding;
    }

    public void setDefaultExternalEncoding(Encoding defaultExternalEncoding) {
        this.defaultExternalEncoding = defaultExternalEncoding;
    }

    public EncodingService getEncodingService() {
        return this.encodingService;
    }

    public RubyWarnings getWarnings() {
        return this.warnings;
    }

    public PrintStream getErrorStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stderr")));
    }

    public InputStream getInputStream() {
        return new IOInputStream(this.getGlobalVariables().get("$stdin"));
    }

    public PrintStream getOutputStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stdout")));
    }

    public RubyModule getClassFromPath(String path2) {
        RubyModule c = this.getObject();
        if (path2.length() == 0 || path2.charAt(0) == '#') {
            throw this.newTypeError("can't retrieve anonymous class " + path2);
        }
        int pbeg = 0;
        int p2 = 0;
        int l = path2.length();
        while (p2 < l) {
            IRubyObject cc;
            while (p2 < l && path2.charAt(p2) != ':') {
                ++p2;
            }
            String str = path2.substring(pbeg, p2);
            if (p2 < l && path2.charAt(p2) == ':') {
                if (p2 + 1 < l && path2.charAt(p2 + 1) != ':') {
                    throw this.newTypeError("undefined class/module " + path2.substring(pbeg, p2));
                }
                pbeg = p2 += 2;
            }
            if (!((cc = c.getConstant(str)) instanceof RubyModule)) {
                throw this.newTypeError("" + path2 + " does not refer to class/module");
            }
            c = (RubyModule)cc;
        }
        return c;
    }

    public void printError(RubyException excp) {
        if (excp == null || excp.isNil()) {
            return;
        }
        PrintStream errorStream = this.getErrorStream();
        String backtrace2 = this.config.getTraceType().printBacktrace(excp, errorStream == System.err && this.getPosix().isatty(FileDescriptor.err));
        try {
            errorStream.print(backtrace2);
        }
        catch (Exception e) {
            System.err.print(backtrace2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String scriptName, InputStream in, boolean wrap2) {
        IRubyObject self2 = wrap2 ? TopSelfFactory.createTopSelf(this, true) : this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        String file2 = context.getFile();
        try {
            ThreadContext.pushBacktrace(context, "(root)", file2, 0);
            context.preNodeEval(self2);
            ParseResult parseResult = this.parseFile(scriptName, in, null);
            if (wrap2) {
                ((RootNode)parseResult).getStaticScope().setModule(RubyModule.newModule(this));
            }
            this.runInterpreter(context, parseResult, self2);
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
        finally {
            context.postNodeEval();
            ThreadContext.popBacktrace(context);
        }
    }

    public void compileAndLoadFile(String filename2, InputStream in, boolean wrap2) {
        InputStream readStream = in;
        try {
            Script script = null;
            ScriptAndCode scriptAndCode = null;
            String className = null;
            try {
                int num;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((num = in.read(buffer)) > -1) {
                    baos.write(buffer, 0, num);
                }
                buffer = baos.toByteArray();
                String hash2 = JITCompiler.getHashForBytes(buffer);
                className = "rubyjit.FILE_" + hash2;
                try {
                    Class<?> contents = this.jrubyClassLoader.loadClass(className);
                    if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                        LOG.info("found jitted code for " + filename2 + " at class: " + className, new Object[0]);
                    }
                    script = (Script)contents.newInstance();
                    readStream = new ByteArrayInputStream(buffer);
                }
                catch (ClassNotFoundException cnfe) {
                    if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                        LOG.info("no jitted code in classloader for file " + filename2 + " at class: " + className, new Object[0]);
                    }
                }
                catch (InstantiationException ie) {
                    if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                        LOG.info("jitted code could not be instantiated for file " + filename2 + " at class: " + className, new Object[0]);
                    }
                }
                catch (IllegalAccessException iae) {
                    if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                        LOG.info("jitted code could not be instantiated for file " + filename2 + " at class: " + className, new Object[0]);
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            Node scriptNode = this.parseFile(readStream, filename2, null);
            if (script == null && (scriptAndCode = this.tryCompile(scriptNode, new ClassDefininngJRubyClassLoader(this.jrubyClassLoader))) != null) {
                script = scriptAndCode.script();
            }
            if (script == null) {
                this.failForcedCompile(scriptNode);
                this.runInterpreter(scriptNode);
            } else {
                this.runScript(script, wrap2);
            }
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
    }

    public void loadScript(Script script) {
        this.loadScript(script, false);
    }

    public void loadScript(Script script, boolean wrap2) {
        IRubyObject self2 = this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        try {
            script.load(context, self2, wrap2);
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExtension(String extName, BasicLibraryService extension, boolean wrap2) {
        IRubyObject self2 = wrap2 ? TopSelfFactory.createTopSelf(this, true) : this.getTopSelf();
        ThreadContext context = this.getCurrentContext();
        try {
            context.preExtensionLoad(self2);
            extension.basicLoad(this);
        }
        catch (IOException ioe) {
            throw this.newIOErrorFromException(ioe);
        }
        catch (JumpException.ReturnJump rj) {
            return;
        }
        finally {
            context.postNodeEval();
        }
    }

    public void addBoundMethod(String className, String methodName, String rubyName) {
        Map<String, String> javaToRuby = this.boundMethods.get(className);
        if (javaToRuby == null) {
            javaToRuby = new HashMap<String, String>();
            this.boundMethods.put(className, javaToRuby);
        }
        javaToRuby.put(methodName, rubyName);
    }

    public Map<String, Map<String, String>> getBoundMethods() {
        return this.boundMethods;
    }

    public void setJavaProxyClassFactory(JavaProxyClassFactory factory) {
        this.javaProxyClassFactory = factory;
    }

    public JavaProxyClassFactory getJavaProxyClassFactory() {
        return this.javaProxyClassFactory;
    }

    public synchronized void addEventHook(EventHook hook) {
        if (!RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.getWarnings().warn("tracing (e.g. set_trace_func) will not capture all events without --debug flag");
        }
        EventHook[] hooks = this.eventHooks;
        EventHook[] newHooks = Arrays.copyOf(hooks, hooks.length + 1);
        newHooks[hooks.length] = hook;
        this.eventHooks = newHooks;
        this.hasEventHooks = true;
    }

    public synchronized void removeEventHook(EventHook hook) {
        EventHook[] hooks = this.eventHooks;
        if (hooks.length == 0) {
            return;
        }
        EventHook[] newHooks = new EventHook[hooks.length - 1];
        boolean found = false;
        int j = 0;
        for (int i2 = 0; i2 < hooks.length; ++i2) {
            if (!found && hooks[i2] == hook && !found) {
                found = true;
                continue;
            }
            newHooks[j] = hooks[i2];
            ++j;
        }
        this.eventHooks = newHooks;
        this.hasEventHooks = newHooks.length > 0;
    }

    public void setTraceFunction(RubyProc traceFunction) {
        this.removeEventHook(this.callTraceFuncHook);
        if (traceFunction == null) {
            return;
        }
        this.callTraceFuncHook.setTraceFunc(traceFunction);
        this.addEventHook(this.callTraceFuncHook);
    }

    public void callEventHooks(ThreadContext context, RubyEvent event2, String file2, int line, String name2, IRubyObject type2) {
        if (context.isEventHooksEnabled()) {
            for (EventHook eventHook : this.eventHooks) {
                if (!eventHook.isInterestedInEvent(event2)) continue;
                eventHook.event(context, event2, file2, line, name2, type2);
            }
        }
    }

    public boolean hasEventHooks() {
        return this.hasEventHooks;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public IRubyObject pushExitBlock(RubyProc proc) {
        this.atExitBlocks.push(proc);
        return proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalFinalizer(Finalizable finalizer) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers == null) {
                this.internalFinalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.internalFinalizers.put(finalizer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinalizer(Finalizable finalizer) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers == null) {
                this.finalizers = new WeakHashMap<Finalizable, Object>();
            }
            this.finalizers.put(finalizer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInternalFinalizer(Finalizable finalizer) {
        Object object = this.internalFinalizersMutex;
        synchronized (object) {
            if (this.internalFinalizers != null) {
                this.internalFinalizers.remove(finalizer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFinalizer(Finalizable finalizer) {
        Object object = this.finalizersMutex;
        synchronized (object) {
            if (this.finalizers != null) {
                this.finalizers.remove(finalizer);
            }
        }
    }

    public void tearDown() {
        this.tearDown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tearDown(boolean systemExit) {
        Finalizable f;
        Iterator<Finalizable> finalIter;
        Object trapResultEntries;
        IRubyObject exitHandlerProc;
        int status2 = 0;
        this.recursive = new ThreadLocal();
        ThreadContext context = this.getCurrentContext();
        if (!context.hasAnyScopes()) {
            StaticScope topStaticScope = this.getStaticScopeFactory().newLocalScope(null);
            context.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        }
        while (!this.atExitBlocks.empty()) {
            RubyProc proc = this.atExitBlocks.pop();
            try {
                proc.call(this.getCurrentContext(), IRubyObject.NULL_ARRAY);
            }
            catch (RaiseException rj) {
                RubyException raisedException = rj.getException();
                if (!this.getSystemExit().isInstance(raisedException)) {
                    status2 = 1;
                    this.printError(raisedException);
                    continue;
                }
                IRubyObject statusObj = raisedException.callMethod(this.getCurrentContext(), "status");
                if (statusObj == null || statusObj.isNil()) continue;
                status2 = RubyNumeric.fix2int(statusObj);
            }
        }
        IRubyObject trapResult = RubySignal.__jtrap_osdefault_kernel(this.getNil(), this.newString("EXIT"));
        if (trapResult instanceof RubyArray && (exitHandlerProc = (trapResultEntries = ((RubyArray)trapResult).toJavaArray())[0]) instanceof RubyProc) {
            ((RubyProc)exitHandlerProc).call(this.getCurrentContext(), this.getSingleNilArray());
        }
        if (this.finalizers != null) {
            trapResultEntries = this.finalizersMutex;
            synchronized (trapResultEntries) {
                finalIter = new ArrayList<Finalizable>(this.finalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    f = finalIter.next();
                    if (f != null) {
                        try {
                            f.finalize();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    finalIter.remove();
                }
            }
        }
        trapResultEntries = this.internalFinalizersMutex;
        synchronized (trapResultEntries) {
            if (this.internalFinalizers != null) {
                finalIter = new ArrayList<Finalizable>(this.internalFinalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    f = finalIter.next();
                    if (f != null) {
                        try {
                            f.finalize();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    finalIter.remove();
                }
            }
        }
        this.getThreadService().disposeCurrentThread();
        this.getBeanManager().unregisterCompiler();
        this.getBeanManager().unregisterConfig();
        this.getBeanManager().unregisterParserStats();
        this.getBeanManager().unregisterMethodCache();
        this.getBeanManager().unregisterRuntime();
        this.getSelectorPool().cleanup();
        if (this.getJRubyClassLoader() != null) {
            this.getJRubyClassLoader().tearDown(this.isDebug());
        }
        if (this.config.isProfilingEntireRun()) {
            ProfileCollection profileCollection = this.threadService.getMainThread().getContext().getProfileCollection();
            this.printProfileData(profileCollection);
        }
        if (systemExit && status2 != 0) {
            throw this.newSystemExit(status2);
        }
        if (this != globalRuntime) return;
        Class<Ruby> clazz = Ruby.class;
        synchronized (Ruby.class) {
            if (this != globalRuntime) return;
            globalRuntime = null;
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return;
        }
    }

    public synchronized void printProfileData(ProfileCollection profileData) {
        this.getProfilingService().newProfileReporter(this.getCurrentContext()).report(profileData);
    }

    private ProfilingServiceLookup getProfilingServiceLookup() {
        return this.profilingServiceLookup;
    }

    public ProfilingService getProfilingService() {
        ProfilingServiceLookup lockup = this.getProfilingServiceLookup();
        return lockup == null ? null : lockup.getService();
    }

    public RubyArray newEmptyArray() {
        return RubyArray.newEmptyArray(this);
    }

    public RubyArray newArray() {
        return RubyArray.newArray(this);
    }

    public RubyArray newArrayLight() {
        return RubyArray.newArrayLight(this);
    }

    public RubyArray newArray(IRubyObject object) {
        return RubyArray.newArray(this, object);
    }

    public RubyArray newArray(IRubyObject car, IRubyObject cdr) {
        return RubyArray.newArray(this, car, cdr);
    }

    public RubyArray newArray(IRubyObject ... objects) {
        return RubyArray.newArray(this, objects);
    }

    public RubyArray newArrayNoCopy(IRubyObject ... objects) {
        return RubyArray.newArrayNoCopy(this, objects);
    }

    public RubyArray newArrayNoCopyLight(IRubyObject ... objects) {
        return RubyArray.newArrayNoCopyLight(this, objects);
    }

    public RubyArray newArray(List<IRubyObject> list2) {
        return RubyArray.newArray(this, list2);
    }

    public RubyArray newArray(int size2) {
        return RubyArray.newArray(this, size2);
    }

    public RubyArray getEmptyFrozenArray() {
        return this.emptyFrozenArray;
    }

    public RubyBoolean newBoolean(boolean value2) {
        return value2 ? this.trueObject : this.falseObject;
    }

    public RubyFileStat newFileStat(String filename2, boolean lstat2) {
        return RubyFileStat.newFileStat(this, filename2, lstat2);
    }

    public RubyFileStat newFileStat(FileDescriptor descriptor) {
        return RubyFileStat.newFileStat(this, descriptor);
    }

    public RubyFixnum newFixnum(long value2) {
        return RubyFixnum.newFixnum(this, value2);
    }

    public RubyFixnum newFixnum(int value2) {
        return RubyFixnum.newFixnum(this, value2);
    }

    public RubyFixnum newFixnum(Constant value2) {
        return RubyFixnum.newFixnum(this, value2.intValue());
    }

    public RubyFloat newFloat(double value2) {
        return RubyFloat.newFloat(this, value2);
    }

    public RubyNumeric newNumeric() {
        return RubyNumeric.newNumeric(this);
    }

    public RubyRational newRational(long num, long den) {
        return RubyRational.newRationalRaw(this, this.newFixnum(num), this.newFixnum(den));
    }

    public RubyRational newRationalReduced(long num, long den) {
        return (RubyRational)RubyRational.newRationalConvert(this.getCurrentContext(), this.newFixnum(num), this.newFixnum(den));
    }

    public RubyProc newProc(Block.Type type2, Block block) {
        if (type2 != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        RubyProc proc = RubyProc.newProc(this, block, type2);
        return proc;
    }

    public RubyProc newBlockPassProc(Block.Type type2, Block block) {
        if (type2 != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        RubyProc proc = RubyProc.newProc(this, block, type2);
        return proc;
    }

    public RubyBinding newBinding() {
        return RubyBinding.newBinding(this, this.getCurrentContext().currentBinding());
    }

    public RubyBinding newBinding(Binding binding2) {
        return RubyBinding.newBinding(this, binding2);
    }

    public RubyString newString() {
        return RubyString.newString(this, new ByteList());
    }

    public RubyString newString(String string2) {
        return RubyString.newString(this, string2);
    }

    public RubyString newString(ByteList byteList) {
        return RubyString.newString(this, byteList);
    }

    @Deprecated
    public RubyString newStringShared(ByteList byteList) {
        return RubyString.newStringShared(this, byteList);
    }

    public RubySymbol newSymbol(String name2) {
        return this.symbolTable.getSymbol(name2);
    }

    public RubySymbol newSymbol(ByteList name2) {
        return this.symbolTable.getSymbol(name2);
    }

    public RubySymbol fastNewSymbol(String internedName) {
        return this.symbolTable.fastGetSymbol(internedName);
    }

    public RubyTime newTime(long milliseconds) {
        return RubyTime.newTime(this, milliseconds);
    }

    public RaiseException newRuntimeError(String message2) {
        return this.newRaiseException(this.getRuntimeError(), message2);
    }

    public RaiseException newArgumentError(String message2) {
        return this.newRaiseException(this.getArgumentError(), message2);
    }

    public RaiseException newArgumentError(int got, int expected) {
        return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (" + got + " for " + expected + ")");
    }

    public RaiseException newArgumentError(String name2, int got, int expected) {
        return this.newRaiseException(this.getArgumentError(), "wrong number of arguments calling `" + name2 + "` (" + got + " for " + expected + ")");
    }

    public RaiseException newErrnoEBADFError() {
        return this.newRaiseException(this.getErrno().getClass("EBADF"), "Bad file descriptor");
    }

    public RaiseException newErrnoEISCONNError() {
        return this.newRaiseException(this.getErrno().getClass("EISCONN"), "Socket is already connected");
    }

    public RaiseException newErrnoEINPROGRESSError() {
        return this.newRaiseException(this.getErrno().getClass("EINPROGRESS"), "Operation now in progress");
    }

    public RaiseException newErrnoEINPROGRESSWritableError() {
        return this.newLightweightErrnoException(this.getIO().getClass("EINPROGRESSWaitWritable"), "");
    }

    public RaiseException newErrnoENOPROTOOPTError() {
        return this.newRaiseException(this.getErrno().getClass("ENOPROTOOPT"), "Protocol not available");
    }

    public RaiseException newErrnoEPIPEError() {
        return this.newRaiseException(this.getErrno().getClass("EPIPE"), "Broken pipe");
    }

    public RaiseException newErrnoECONNABORTEDError() {
        return this.newRaiseException(this.getErrno().getClass("ECONNABORTED"), "An established connection was aborted by the software in your host machine");
    }

    public RaiseException newErrnoECONNREFUSEDError() {
        return this.newRaiseException(this.getErrno().getClass("ECONNREFUSED"), "Connection refused");
    }

    public RaiseException newErrnoECONNRESETError() {
        return this.newRaiseException(this.getErrno().getClass("ECONNRESET"), "Connection reset by peer");
    }

    public RaiseException newErrnoEADDRINUSEError() {
        return this.newRaiseException(this.getErrno().getClass("EADDRINUSE"), "Address in use");
    }

    public RaiseException newErrnoEADDRINUSEError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EADDRINUSE"), message2);
    }

    public RaiseException newErrnoEHOSTUNREACHError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EHOSTUNREACH"), message2);
    }

    public RaiseException newErrnoEINVALError() {
        return this.newRaiseException(this.getErrno().getClass("EINVAL"), "Invalid file");
    }

    public RaiseException newErrnoELOOPError() {
        return this.newRaiseException(this.getErrno().getClass("ELOOP"), "Too many levels of symbolic links");
    }

    public RaiseException newErrnoEMFILEError() {
        return this.newRaiseException(this.getErrno().getClass("EMFILE"), "Too many open files");
    }

    public RaiseException newErrnoENFILEError() {
        return this.newRaiseException(this.getErrno().getClass("ENFILE"), "Too many open files in system");
    }

    public RaiseException newErrnoENOENTError() {
        return this.newRaiseException(this.getErrno().getClass("ENOENT"), "File not found");
    }

    public RaiseException newErrnoEACCESError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EACCES"), message2);
    }

    public RaiseException newErrnoEAGAINError(String message2) {
        return this.newLightweightErrnoException(this.getErrno().getClass("EAGAIN"), message2);
    }

    public RaiseException newErrnoEAGAINReadableError(String message2) {
        return this.newLightweightErrnoException(this.getModule("IO").getClass("EAGAINWaitReadable"), message2);
    }

    public RaiseException newErrnoEAGAINWritableError(String message2) {
        return this.newLightweightErrnoException(this.getModule("IO").getClass("EAGAINWaitWritable"), message2);
    }

    public RaiseException newErrnoEISDirError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EISDIR"), message2);
    }

    public RaiseException newErrnoEPERMError(String name2) {
        return this.newRaiseException(this.getErrno().getClass("EPERM"), "Operation not permitted - " + name2);
    }

    public RaiseException newErrnoEISDirError() {
        return this.newErrnoEISDirError("Is a directory");
    }

    public RaiseException newErrnoESPIPEError() {
        return this.newRaiseException(this.getErrno().getClass("ESPIPE"), "Illegal seek");
    }

    public RaiseException newErrnoEBADFError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EBADF"), message2);
    }

    public RaiseException newErrnoEINPROGRESSError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EINPROGRESS"), message2);
    }

    public RaiseException newErrnoEINPROGRESSWritableError(String message2) {
        return this.newLightweightErrnoException(this.getIO().getClass("EINPROGRESSWaitWritable"), message2);
    }

    public RaiseException newErrnoEISCONNError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EISCONN"), message2);
    }

    public RaiseException newErrnoEINVALError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EINVAL"), message2);
    }

    public RaiseException newErrnoENOTDIRError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOTDIR"), message2);
    }

    public RaiseException newErrnoENOTEMPTYError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOTEMPTY"), message2);
    }

    public RaiseException newErrnoENOTSOCKError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOTSOCK"), message2);
    }

    public RaiseException newErrnoENOTCONNError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOTCONN"), message2);
    }

    public RaiseException newErrnoENOTCONNError() {
        return this.newRaiseException(this.getErrno().getClass("ENOTCONN"), "Socket is not connected");
    }

    public RaiseException newErrnoENOENTError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ENOENT"), message2);
    }

    public RaiseException newErrnoESPIPEError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("ESPIPE"), message2);
    }

    public RaiseException newErrnoEEXISTError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EEXIST"), message2);
    }

    public RaiseException newErrnoEDOMError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EDOM"), "Domain error - " + message2);
    }

    public RaiseException newErrnoECHILDError() {
        return this.newRaiseException(this.getErrno().getClass("ECHILD"), "No child processes");
    }

    public RaiseException newErrnoEADDRNOTAVAILError(String message2) {
        return this.newRaiseException(this.getErrno().getClass("EADDRNOTAVAIL"), message2);
    }

    public RaiseException newErrnoESRCHError() {
        return this.newRaiseException(this.getErrno().getClass("ESRCH"), null);
    }

    public RaiseException newErrnoEWOULDBLOCKError() {
        return this.newRaiseException(this.getErrno().getClass("EWOULDBLOCK"), null);
    }

    public RaiseException newErrnoEDESTADDRREQError(String func) {
        return this.newRaiseException(this.getErrno().getClass("EDESTADDRREQ"), func);
    }

    public RaiseException newIndexError(String message2) {
        return this.newRaiseException(this.getIndexError(), message2);
    }

    public RaiseException newSecurityError(String message2) {
        return this.newRaiseException(this.getSecurityError(), message2);
    }

    public RaiseException newSystemCallError(String message2) {
        return this.newRaiseException(this.getSystemCallError(), message2);
    }

    public RaiseException newKeyError(String message2) {
        return this.newRaiseException(this.getKeyError(), message2);
    }

    public RaiseException newErrnoEINTRError() {
        return this.newRaiseException(this.getErrno().getClass("EINTR"), "Interrupted");
    }

    public RaiseException newErrnoFromLastPOSIXErrno() {
        RubyClass errnoClass = this.getErrno(this.getPosix().errno());
        if (errnoClass == null) {
            errnoClass = this.systemCallError;
        }
        return this.newRaiseException(errnoClass, null);
    }

    public RaiseException newErrnoFromInt(int errno2, String methodName, String message2) {
        if (Platform.IS_WINDOWS && ("stat".equals(methodName) || "lstat".equals(methodName))) {
            if (errno2 == 20047) {
                return this.newErrnoENOENTError(message2);
            }
            if (errno2 == Errno.ESRCH.intValue()) {
                return this.newErrnoENOENTError(message2);
            }
        }
        return this.newErrnoFromInt(errno2, message2);
    }

    public RaiseException newErrnoFromInt(int errno2, String message2) {
        RubyClass errnoClass = this.getErrno(errno2);
        if (errnoClass != null) {
            return this.newRaiseException(errnoClass, message2);
        }
        return this.newSystemCallError("Unknown Error (" + errno2 + ") - " + message2);
    }

    public RaiseException newErrnoFromErrno(Errno errno2, String message2) {
        if (errno2 == null || errno2 == Errno.__UNKNOWN_CONSTANT__) {
            return this.newSystemCallError(message2);
        }
        return this.newErrnoFromInt(errno2.intValue(), message2);
    }

    public RaiseException newErrnoFromInt(int errno2) {
        Errno errnoObj = Errno.valueOf(errno2);
        if (errnoObj == null) {
            return this.newSystemCallError("Unknown Error (" + errno2 + ")");
        }
        String message2 = errnoObj.description();
        return this.newErrnoFromInt(errno2, message2);
    }

    public RaiseException newErrnoEADDRFromBindException(BindException be) {
        return this.newErrnoEADDRFromBindException(be, null);
    }

    public RaiseException newErrnoEADDRFromBindException(BindException be, String contextMessage) {
        String msg = be.getMessage();
        msg = msg == null ? "bind" : "bind - " + msg;
        if (contextMessage != null) {
            msg = msg + contextMessage;
        }
        if (ADDR_NOT_AVAIL_PATTERN.matcher(msg).find()) {
            return this.newErrnoEADDRNOTAVAILError(msg);
        }
        return this.newErrnoEADDRINUSEError(msg);
    }

    public RaiseException newTypeError(String message2) {
        return this.newRaiseException(this.getTypeError(), message2);
    }

    public RaiseException newThreadError(String message2) {
        return this.newRaiseException(this.getThreadError(), message2);
    }

    public RaiseException newConcurrencyError(String message2) {
        return this.newRaiseException(this.getConcurrencyError(), message2);
    }

    public RaiseException newSyntaxError(String message2) {
        return this.newRaiseException(this.getSyntaxError(), message2);
    }

    public RaiseException newRegexpError(String message2) {
        return this.newRaiseException(this.getRegexpError(), message2);
    }

    public RaiseException newInterruptedRegexpError(String message2) {
        return this.newRaiseException(this.getInterruptedRegexpError(), message2);
    }

    public RaiseException newRangeError(String message2) {
        return this.newRaiseException(this.getRangeError(), message2);
    }

    public RaiseException newNotImplementedError(String message2) {
        return this.newRaiseException(this.getNotImplementedError(), message2);
    }

    public RaiseException newInvalidEncoding(String message2) {
        return this.newRaiseException(this.fastGetClass("Iconv").getClass("InvalidEncoding"), message2);
    }

    public RaiseException newIllegalSequence(String message2) {
        return this.newRaiseException(this.fastGetClass("Iconv").getClass("IllegalSequence"), message2);
    }

    public RaiseException newNoMethodError(String message2, String name2, IRubyObject args2) {
        return new RaiseException((RubyException)new RubyNoMethodError(this, this.getNoMethodError(), message2, name2, args2), true);
    }

    public RaiseException newNameError(String message2, String name2) {
        return this.newNameError(message2, name2, null);
    }

    public RaiseException newNameErrorObject(String message2, IRubyObject name2) {
        RubyNameError error2 = new RubyNameError(this, this.getNameError(), message2, name2);
        return new RaiseException((RubyException)error2, false);
    }

    public RaiseException newNameError(String message2, String name2, Throwable origException) {
        return this.newNameError(message2, name2, origException, false);
    }

    public RaiseException newNameError(String message2, String name2, Throwable origException, boolean printWhenVerbose) {
        if (origException != null) {
            if (printWhenVerbose && this.isVerbose()) {
                LOG.error(origException.getMessage(), origException);
            } else if (this.isDebug()) {
                LOG.debug(origException.getMessage(), origException);
            }
        }
        return new RaiseException((RubyException)new RubyNameError(this, this.getNameError(), message2, name2), false);
    }

    public RaiseException newLocalJumpError(RubyLocalJumpError.Reason reason2, IRubyObject exitValue, String message2) {
        return new RaiseException((RubyException)new RubyLocalJumpError(this, this.getLocalJumpError(), message2, reason2, exitValue), true);
    }

    public RaiseException newLocalJumpErrorNoBlock() {
        return this.newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, this.getNil(), "no block given");
    }

    public RaiseException newRedoLocalJumpError() {
        return this.newLocalJumpError(RubyLocalJumpError.Reason.REDO, this.getNil(), "unexpected redo");
    }

    public RaiseException newLoadError(String message2) {
        return this.newRaiseException(this.getLoadError(), message2);
    }

    public RaiseException newLoadError(String message2, String path2) {
        RaiseException loadError = this.newRaiseException(this.getLoadError(), message2);
        loadError.getException().setInstanceVariable("@path", this.newString(path2));
        return loadError;
    }

    public RaiseException newFrozenError(String objectType) {
        return this.newFrozenError(objectType, false);
    }

    public RaiseException newFrozenError(String objectType, boolean runtimeError) {
        return this.newRaiseException(this.getRuntimeError(), "can't modify frozen " + objectType);
    }

    public RaiseException newSystemStackError(String message2) {
        return this.newRaiseException(this.getSystemStackError(), message2);
    }

    public RaiseException newSystemStackError(String message2, StackOverflowError soe) {
        if (this.getDebug().isTrue()) {
            LOG.debug(soe.getMessage(), soe);
        }
        return this.newRaiseException(this.getSystemStackError(), message2);
    }

    public RaiseException newSystemExit(int status2) {
        return new RaiseException(RubySystemExit.newInstance(this, status2, "exit"));
    }

    public RaiseException newSystemExit(int status2, String message2) {
        return new RaiseException(RubySystemExit.newInstance(this, status2, message2));
    }

    public RaiseException newIOError(String message2) {
        return this.newRaiseException(this.getIOError(), message2);
    }

    public RaiseException newStandardError(String message2) {
        return this.newRaiseException(this.getStandardError(), message2);
    }

    public RaiseException newIOErrorFromException(IOException e) {
        if (e instanceof ClosedChannelException || "Bad file descriptor".equals(e.getMessage())) {
            throw this.newErrnoEBADFError();
        }
        if (e.getMessage() != null) {
            String errorMessage = e.getMessage();
            if ("File not open".equals(errorMessage)) {
                return this.newIOError(e.getMessage());
            }
            if ("An established connection was aborted by the software in your host machine".equals(errorMessage)) {
                return this.newErrnoECONNABORTEDError();
            }
            if (e.getMessage().equals("Broken pipe")) {
                return this.newErrnoEPIPEError();
            }
            if ("Connection reset by peer".equals(e.getMessage()) || "An existing connection was forcibly closed by the remote host".equals(e.getMessage()) || Platform.IS_WINDOWS && e.getMessage().contains("connection was aborted")) {
                return this.newErrnoECONNRESETError();
            }
            if ("Too many levels of symbolic links".equals(e.getMessage())) {
                return this.newErrnoELOOPError();
            }
            if ("Too many open files".equals(e.getMessage())) {
                return this.newErrnoEMFILEError();
            }
            if ("Too many open files in system".equals(e.getMessage())) {
                return this.newErrnoENFILEError();
            }
            return this.newRaiseException(this.getIOError(), e.getMessage());
        }
        return this.newRaiseException(this.getIOError(), "IO Error");
    }

    public RaiseException newTypeError(IRubyObject receivedObject, RubyClass expectedType) {
        return this.newTypeError(receivedObject, expectedType.getName());
    }

    public RaiseException newTypeError(IRubyObject receivedObject, RubyModule expectedType) {
        return this.newTypeError(receivedObject, expectedType.getName());
    }

    public RaiseException newTypeError(IRubyObject receivedObject, String expectedType) {
        return this.newRaiseException(this.getTypeError(), "wrong argument type " + receivedObject.getMetaClass().getRealClass() + " (expected " + expectedType + ")");
    }

    public RaiseException newEOFError() {
        return this.newRaiseException(this.getEOFError(), "End of file reached");
    }

    public RaiseException newEOFError(String message2) {
        return this.newRaiseException(this.getEOFError(), message2);
    }

    public RaiseException newZeroDivisionError() {
        return this.newRaiseException(this.getZeroDivisionError(), "divided by 0");
    }

    public RaiseException newFloatDomainError(String message2) {
        return this.newRaiseException(this.getFloatDomainError(), message2);
    }

    public RaiseException newMathDomainError(String message2) {
        return this.newRaiseException(this.getMathDomainError(), "Numerical argument is out of domain - \"" + message2 + "\"");
    }

    public RaiseException newEncodingError(String message2) {
        return this.newRaiseException(this.getEncodingError(), message2);
    }

    public RaiseException newEncodingCompatibilityError(String message2) {
        return this.newRaiseException(this.getEncodingCompatibilityError(), message2);
    }

    public RaiseException newConverterNotFoundError(String message2) {
        return this.newRaiseException(this.getConverterNotFoundError(), message2);
    }

    public RaiseException newFiberError(String message2) {
        return this.newRaiseException(this.getFiberError(), message2);
    }

    public RaiseException newUndefinedConversionError(String message2) {
        return this.newRaiseException(this.getUndefinedConversionError(), message2);
    }

    public RaiseException newInvalidByteSequenceError(String message2) {
        return this.newRaiseException(this.getInvalidByteSequenceError(), message2);
    }

    public RaiseException newRaiseException(RubyClass exceptionClass, String message2) {
        return new RaiseException(this, exceptionClass, message2, true);
    }

    private RaiseException newLightweightErrnoException(RubyClass exceptionClass, String message2) {
        if (RubyInstanceConfig.ERRNO_BACKTRACE) {
            return new RaiseException(this, exceptionClass, message2, true);
        }
        return new RaiseException(this, exceptionClass, ERRNO_BACKTRACE_MESSAGE, RubyArray.newEmptyArray(this), true);
    }

    public RaiseException newLightweightStopIterationError(String message2) {
        if (RubyInstanceConfig.STOPITERATION_BACKTRACE) {
            return new RaiseException(this, this.stopIteration, message2, true);
        }
        return new RaiseException(this, this.stopIteration, STOPIERATION_BACKTRACE_MESSAGE, RubyArray.newEmptyArray(this), true);
    }

    public RubyObject.Data newData(RubyClass objectClass, Object sval) {
        return new RubyObject.Data(this, objectClass, sval);
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public ObjectSpace getObjectSpace() {
        return this.objectSpace;
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public boolean isGlobalAbortOnExceptionEnabled() {
        return this.globalAbortOnExceptionEnabled;
    }

    public void setGlobalAbortOnExceptionEnabled(boolean enable2) {
        this.globalAbortOnExceptionEnabled = enable2;
    }

    public boolean isDoNotReverseLookupEnabled() {
        return this.doNotReverseLookupEnabled;
    }

    public void setDoNotReverseLookupEnabled(boolean b2) {
        this.doNotReverseLookupEnabled = b2;
    }

    public void registerInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val == null) {
            val = new IdentityHashMap<Object, Object>();
            this.inspect.set(val);
        }
        val.put(obj, null);
    }

    public boolean isInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        return val == null ? false : val.containsKey(obj);
    }

    public void unregisterInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val != null) {
            val.remove(obj);
        }
    }

    private IRubyObject recursiveListAccess() {
        Map<String, RubyHash> hash2 = this.recursive.get();
        String sym = this.getCurrentContext().getFrameName();
        IRubyObject list2 = this.getNil();
        if (hash2 == null) {
            hash2 = new HashMap<String, RubyHash>();
            this.recursive.set(hash2);
        } else {
            list2 = hash2.get(sym);
        }
        if (list2 == null || list2.isNil()) {
            list2 = RubyHash.newHash(this);
            hash2.put(sym, (RubyHash)list2);
        }
        return list2;
    }

    private void recursiveListClear() {
        Map<String, RubyHash> hash2 = this.recursive.get();
        if (hash2 != null) {
            hash2.clear();
        }
    }

    private void recursivePush(IRubyObject list2, IRubyObject obj, IRubyObject paired_obj) {
        if (paired_obj == null) {
            ((RubyHash)list2).op_aset(this.getCurrentContext(), obj, this.getTrue());
        } else {
            IRubyObject pair_list = ((RubyHash)list2).fastARef(obj);
            if (pair_list == null) {
                ((RubyHash)list2).op_aset(this.getCurrentContext(), obj, paired_obj);
            } else {
                if (!(pair_list instanceof RubyHash)) {
                    IRubyObject other_paired_obj = pair_list;
                    pair_list = RubyHash.newHash(this);
                    ((RubyHash)pair_list).op_aset(this.getCurrentContext(), other_paired_obj, this.getTrue());
                    ((RubyHash)list2).op_aset(this.getCurrentContext(), obj, pair_list);
                }
                ((RubyHash)pair_list).op_aset(this.getCurrentContext(), paired_obj, this.getTrue());
            }
        }
    }

    private void recursivePop(IRubyObject list2, IRubyObject obj, IRubyObject paired_obj) {
        if (paired_obj != null) {
            IRubyObject pair_list = ((RubyHash)list2).fastARef(obj);
            if (pair_list == null) {
                throw this.newTypeError("invalid inspect_tbl pair_list for " + this.getCurrentContext().getFrameName());
            }
            if (pair_list instanceof RubyHash) {
                ((RubyHash)pair_list).delete(this.getCurrentContext(), paired_obj, Block.NULL_BLOCK);
                if (!((RubyHash)pair_list).isEmpty()) {
                    return;
                }
            }
        }
        ((RubyHash)list2).delete(this.getCurrentContext(), obj, Block.NULL_BLOCK);
    }

    private boolean recursiveCheck(IRubyObject list2, IRubyObject obj_id, IRubyObject paired_obj_id) {
        IRubyObject paired_result;
        IRubyObject pair_list = ((RubyHash)list2).fastARef(obj_id);
        if (pair_list == null) {
            return false;
        }
        return paired_obj_id == null || !(!(pair_list instanceof RubyHash) ? pair_list != paired_obj_id : (paired_result = ((RubyHash)pair_list).fastARef(paired_obj_id)) == null || paired_result.isNil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject execRecursiveI(ExecRecursiveParams p2) {
        IRubyObject result2 = null;
        this.recursivePush(p2.list, p2.objid, p2.pairid);
        try {
            result2 = p2.func.call(p2.obj, false);
        }
        finally {
            this.recursivePop(p2.list, p2.objid, p2.pairid);
        }
        return result2;
    }

    private IRubyObject execRecursiveInternal(RecursiveFunction func, IRubyObject obj, IRubyObject pairid, boolean outer) {
        boolean outermost;
        ExecRecursiveParams p2 = new ExecRecursiveParams();
        p2.list = this.recursiveListAccess();
        p2.objid = obj.id();
        boolean bl = outermost = outer && !this.recursiveCheck(p2.list, this.recursiveKey, null);
        if (this.recursiveCheck(p2.list, p2.objid, pairid)) {
            if (outer && !outermost) {
                throw new RecursiveError(p2.list);
            }
            return func.call(obj, true);
        }
        IRubyObject result2 = null;
        p2.func = func;
        p2.obj = obj;
        p2.pairid = pairid;
        if (outermost) {
            this.recursivePush(p2.list, this.recursiveKey, null);
            try {
                result2 = this.execRecursiveI(p2);
            }
            catch (RecursiveError e) {
                if (e.tag != p2.list) {
                    throw e;
                }
                result2 = p2.list;
            }
            this.recursivePop(p2.list, this.recursiveKey, null);
            if (result2 == p2.list) {
                result2 = func.call(obj, true);
            }
        } else {
            result2 = this.execRecursiveI(p2);
        }
        return result2;
    }

    public IRubyObject execRecursive(RecursiveFunction func, IRubyObject obj) {
        if (!this.inRecursiveListOperation.get().booleanValue()) {
            throw this.newThreadError("BUG: execRecursive called outside recursiveListOperation");
        }
        return this.execRecursiveInternal(func, obj, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject execRecursiveOuter(RecursiveFunction func, IRubyObject obj) {
        try {
            IRubyObject iRubyObject = this.execRecursiveInternal(func, obj, null, true);
            return iRubyObject;
        }
        finally {
            this.recursiveListClear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IRubyObject> T recursiveListOperation(Callable<T> body) {
        try {
            this.inRecursiveListOperation.set(true);
            IRubyObject iRubyObject = (IRubyObject)body.call();
            return (T)iRubyObject;
        }
        catch (Exception e) {
            Helpers.throwException(e);
            T t = null;
            return t;
        }
        finally {
            this.recursiveListClear();
            this.inRecursiveListOperation.set(false);
        }
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public void setObjectSpaceEnabled(boolean objectSpaceEnabled) {
        this.objectSpaceEnabled = objectSpaceEnabled;
    }

    public boolean isSiphashEnabled() {
        return this.siphashEnabled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getJRubyHome() {
        return this.config.getJRubyHome();
    }

    public void setJRubyHome(String home2) {
        this.config.setJRubyHome(home2);
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }

    public boolean is2_0() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGlobalState() {
        Ruby ruby2 = this;
        synchronized (ruby2) {
            return this.globalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incGlobalState() {
        Ruby ruby2 = this;
        synchronized (ruby2) {
            this.globalState = this.globalState + 1L & 0xFFFFFFFF8FFFFFFFL;
        }
    }

    public static boolean isSecurityRestricted() {
        return securityRestricted;
    }

    public static void setSecurityRestricted(boolean restricted) {
        securityRestricted = restricted;
    }

    public POSIX getPosix() {
        return this.posix;
    }

    public void setRecordSeparatorVar(GlobalVariable recordSeparatorVar) {
        this.recordSeparatorVar = recordSeparatorVar;
    }

    public GlobalVariable getRecordSeparatorVar() {
        return this.recordSeparatorVar;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ExecutorService getFiberExecutor() {
        return this.fiberExecutor;
    }

    public Map<String, DateTimeZone> getTimezoneCache() {
        return this.timeZoneCache;
    }

    @Deprecated
    public int getConstantGeneration() {
        return -1;
    }

    public Invalidator getConstantInvalidator(String constantName) {
        Invalidator invalidator = this.constantNameInvalidators.get(constantName);
        if (invalidator != null) {
            return invalidator;
        }
        return this.addConstantInvalidator(constantName);
    }

    private Invalidator addConstantInvalidator(String constantName) {
        Invalidator invalidator = OptoFactory.newConstantInvalidator();
        this.constantNameInvalidators.putIfAbsent(constantName, invalidator);
        return this.constantNameInvalidators.get(constantName);
    }

    public Invalidator getCheckpointInvalidator() {
        return this.checkpointInvalidator;
    }

    public <E extends Enum<E>> void loadConstantSet(RubyModule module, Class<E> enumClass) {
        for (Enum e : EnumSet.allOf(enumClass)) {
            Constant c = (Constant)((Object)e);
            if (!Character.isUpperCase(c.name().charAt(0))) continue;
            module.setConstant(c.name(), this.newFixnum(c.intValue()));
        }
    }

    public void loadConstantSet(RubyModule module, String constantSetName) {
        for (Constant c : ConstantSet.getConstantSet(constantSetName)) {
            if (!Character.isUpperCase(c.name().charAt(0))) continue;
            module.setConstant(c.name(), this.newFixnum(c.intValue()));
        }
    }

    public long getNextDynamicMethodSerial() {
        return this.dynamicMethodSerial.getAndIncrement();
    }

    public int getNextModuleGeneration() {
        return this.moduleGeneration.incrementAndGet();
    }

    public Object getHierarchyLock() {
        return this.hierarchyLock;
    }

    public SelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    public RuntimeCache getRuntimeCache() {
        return this.runtimeCache;
    }

    @Deprecated
    public ProfiledMethods getProfiledMethods() {
        return this.profiledMethods;
    }

    @Deprecated
    void addProfiledMethod(String name2, DynamicMethod method) {
        if (!this.config.isProfiling()) {
            return;
        }
        if (method.isUndefined()) {
            return;
        }
        this.getProfiledMethods().addProfiledMethod(name2, method);
    }

    public void incrementExceptionCount() {
        this.exceptionCount.incrementAndGet();
    }

    public int getExceptionCount() {
        return this.exceptionCount.get();
    }

    public void incrementBacktraceCount() {
        this.backtraceCount.incrementAndGet();
    }

    public int getBacktraceCount() {
        return this.backtraceCount.get();
    }

    public void incrementWarningCount() {
        this.warningCount.incrementAndGet();
    }

    public int getWarningCount() {
        return this.warningCount.get();
    }

    public void incrementCallerCount() {
        this.callerCount.incrementAndGet();
    }

    public int getCallerCount() {
        return this.callerCount.get();
    }

    public void reopenFixnum() {
        this.fixnumInvalidator.invalidate();
        this.fixnumReopened = true;
    }

    public Invalidator getFixnumInvalidator() {
        return this.fixnumInvalidator;
    }

    public boolean isFixnumReopened() {
        return this.fixnumReopened;
    }

    public void reopenFloat() {
        this.floatInvalidator.invalidate();
        this.floatReopened = true;
    }

    public Invalidator getFloatInvalidator() {
        return this.floatInvalidator;
    }

    public boolean isFloatReopened() {
        return this.floatReopened;
    }

    public boolean isBootingCore() {
        return this.bootingCore;
    }

    public boolean isBooting() {
        return this.bootingRuntime;
    }

    public CoverageData getCoverageData() {
        return this.coverageData;
    }

    public Random getRandom() {
        return this.random;
    }

    public long getHashSeedK0() {
        return this.hashSeedK0;
    }

    public long getHashSeedK1() {
        return this.hashSeedK1;
    }

    public StaticScopeFactory getStaticScopeFactory() {
        return this.staticScopeFactory;
    }

    public FFI getFFI() {
        return this.ffi;
    }

    public void setFFI(FFI ffi2) {
        this.ffi = ffi2;
    }

    public RubyString getDefinedMessage(DefinedMessage definedMessage) {
        return this.definedMessages.get((Object)definedMessage);
    }

    public RubyString getThreadStatus(RubyThread.Status status2) {
        return this.threadStatuses.get((Object)status2);
    }

    public RubyString freezeAndDedupString(RubyString string2) {
        RubyString deduped;
        if (string2.getMetaClass().isSingleton()) {
            RubyString duped = string2.strDup(this);
            duped.setFrozen(true);
            return duped;
        }
        WeakReference<RubyString> dedupedRef = this.dedupMap.get(string2);
        if (dedupedRef == null || (deduped = (RubyString)dedupedRef.get()) == null) {
            deduped = string2.strDup(this);
            deduped.setFrozen(true);
            this.dedupMap.put(string2, new WeakReference<RubyString>(deduped));
        }
        return deduped;
    }

    public int getRuntimeNumber() {
        return this.runtimeNumber;
    }

    private void setNetworkStack() {
        block4: {
            try {
                if (this.config.getIPv4Preferred()) {
                    System.setProperty("java.net.preferIPv4Stack", "true");
                } else {
                    System.setProperty("java.net.preferIPv4Stack", "false");
                }
            }
            catch (AccessControlException ace) {
                if (!this.isVerbose()) break block4;
                LOG.warn("warning: unable to set network stack system property due to security restrictions, please set it manually as JVM parameter (-Djava.net.preferIPv4Stack=true|false)", new Object[0]);
            }
        }
    }

    @Override
    public Object constant() {
        return this.constant;
    }

    @Deprecated
    public int getSafeLevel() {
        return 0;
    }

    @Deprecated
    public void setSafeLevel(int safeLevel) {
    }

    @Deprecated
    public void checkSafeString(IRubyObject object) {
    }

    @Deprecated
    public void secure(int level2) {
    }

    private void addLoadParseToStats() {
        if (this.parserStats != null) {
            this.parserStats.addLoadParse();
        }
    }

    private void addEvalParseToStats() {
        if (this.parserStats != null) {
            this.parserStats.addEvalParse();
        }
    }

    private void addJRubyModuleParseToStats() {
        if (this.parserStats != null) {
            this.parserStats.addJRubyModuleParse();
        }
    }

    @Deprecated
    public CallbackFactory callbackFactory(Class<?> type2) {
        throw new RuntimeException("callback-style handles are no longer supported in JRuby");
    }

    @Deprecated
    public boolean is1_8() {
        return false;
    }

    @Deprecated
    public boolean is1_9() {
        return true;
    }

    public FilenoUtil getFilenoUtil() {
        return this.filenoUtil;
    }

    public void addToObjectSpace(boolean useObjectSpace, IRubyObject object) {
        this.objectSpacer.addToObjectSpace(this, useObjectSpace, object);
    }

    static {
        if (SafePropertyAccessor.isSecurityProtected("jruby.reflected.handles")) {
            securityRestricted = true;
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkCreateClassLoader();
                }
                catch (SecurityException se) {
                    securityRestricted = true;
                }
            }
        }
        threadLocalRuntime = new ThreadLocal();
        DISABLED_OBJECTSPACE = new ObjectSpacer(){

            @Override
            public void addToObjectSpace(Ruby runtime, boolean useObjectSpace, IRubyObject object) {
            }
        };
        ENABLED_OBJECTSPACE = new ObjectSpacer(){

            @Override
            public void addToObjectSpace(Ruby runtime, boolean useObjectSpace, IRubyObject object) {
                if (useObjectSpace) {
                    runtime.objectSpace.add(object);
                }
            }
        };
        RUNTIME_NUMBER = new AtomicInteger(0);
    }

    private static interface ObjectSpacer {
        public void addToObjectSpace(Ruby var1, boolean var2, IRubyObject var3);
    }

    private static class ExecRecursiveParams {
        public RecursiveFunction func;
        public IRubyObject list;
        public IRubyObject obj;
        public IRubyObject objid;
        public IRubyObject pairid;
    }

    private static class RecursiveError
    extends Error
    implements Unrescuable {
        public final Object tag;

        public RecursiveError(Object tag2) {
            this.tag = tag2;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static interface RecursiveFunction {
        public IRubyObject call(IRubyObject var1, boolean var2);
    }

    public class CallTraceFuncHook
    extends EventHook {
        private RubyProc traceFunc;
        private EnumSet<RubyEvent> interest = EnumSet.allOf(RubyEvent.class);

        public void setTraceFunc(RubyProc traceFunc) {
            this.traceFunc = traceFunc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eventHandler(ThreadContext context, String eventName, String file2, int line, String name2, IRubyObject type2) {
            if (!context.isWithinTrace()) {
                if (file2 == null) {
                    file2 = "(ruby)";
                }
                if (type2 == null) {
                    type2 = Ruby.this.getNil();
                }
                RubyBinding binding2 = RubyBinding.newBinding(Ruby.this, context.currentBinding());
                context.preTrace();
                try {
                    this.traceFunc.call(context, new IRubyObject[]{Ruby.this.newString(eventName), Ruby.this.newString(file2), Ruby.this.newFixnum(line), name2 != null ? Ruby.this.newSymbol(name2) : Ruby.this.getNil(), binding2, type2});
                }
                finally {
                    context.postTrace();
                }
            }
        }

        @Override
        public boolean isInterestedInEvent(RubyEvent event2) {
            return this.interest.contains((Object)event2);
        }
    }
}

