/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.basic;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.ObjectLocation;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.LocationImpl;
import java.lang.invoke.MethodHandle;

public abstract class BasicLocations {
    static final int LONG_SIZE = 1;
    static final int OBJECT_SIZE = 1;

    public static abstract class ArrayLocation
    extends LocationImpl {
        protected final int index;
        protected final Location arrayLocation;

        public ArrayLocation(int index2, Location arrayLocation) {
            this.index = index2;
            this.arrayLocation = arrayLocation;
        }

        protected final Object getArray(DynamicObject store, boolean condition) {
            return this.arrayLocation.get(store, condition);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.index;
            return result2;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ArrayLocation other = (ArrayLocation)obj;
            return this.index == other.index;
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        protected String getWhereString() {
            return "[" + this.index + "]";
        }
    }

    public static class BooleanLocationDecorator
    extends PrimitiveLocationDecorator
    implements BooleanLocation {
        public BooleanLocationDecorator(LocationImpl.InternalLongLocation longLocation) {
            super(longLocation);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getBoolean(store, condition);
        }

        @Override
        public boolean getBoolean(DynamicObject store, boolean condition) {
            return this.getLong(store, condition) != 0L;
        }

        @Override
        public void setBoolean(DynamicObject store, boolean value2, Shape shape) {
            this.setLongInternal(store, value2 ? 1 : 0);
        }

        @Override
        public void setBoolean(DynamicObject store, boolean value2) {
            this.setBoolean(store, value2, null);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value2) throws IncompatibleLocationException {
            if (!this.canStore(value2)) {
                throw BooleanLocationDecorator.incompatibleLocation();
            }
            this.setBoolean(store, (Boolean)value2, null);
        }

        @Override
        public final boolean getBoolean(DynamicObject store, Shape shape) {
            return this.getBoolean(store, BooleanLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value2) {
            return value2 instanceof Boolean;
        }

        @Override
        public final void setBoolean(DynamicObject store, boolean value2, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setBoolean(store, value2, newShape);
        }

        @Override
        public Class<Boolean> getType() {
            return Boolean.TYPE;
        }
    }

    public static class DoubleLocationDecorator
    extends PrimitiveLocationDecorator
    implements DoubleLocation {
        private final boolean allowInt;

        public DoubleLocationDecorator(LocationImpl.InternalLongLocation longLocation, boolean allowInt) {
            super(longLocation);
            this.allowInt = allowInt;
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getDouble(store, condition);
        }

        @Override
        public double getDouble(DynamicObject store, boolean condition) {
            return Double.longBitsToDouble(this.getLong(store, condition));
        }

        @Override
        public void setDouble(DynamicObject store, double value2, Shape shape) {
            this.setLongInternal(store, Double.doubleToRawLongBits(value2));
        }

        @Override
        public void setDouble(DynamicObject store, double value2) {
            this.setDouble(store, value2, null);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value2) throws IncompatibleLocationException {
            if (!this.canStore(value2)) {
                throw DoubleLocationDecorator.incompatibleLocation();
            }
            this.setDouble(store, ((Number)value2).doubleValue(), null);
        }

        @Override
        public final double getDouble(DynamicObject store, Shape shape) {
            return this.getDouble(store, DoubleLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value2) {
            return value2 instanceof Double || this.allowInt && value2 instanceof Integer;
        }

        @Override
        public final void setDouble(DynamicObject store, double value2, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setDouble(store, value2, newShape);
        }

        @Override
        public Class<Double> getType() {
            return Double.TYPE;
        }
    }

    public static abstract class FieldLocation
    extends LocationImpl {
        private final int index;

        public FieldLocation(int index2) {
            this.index = index2;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.index;
            return result2;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            FieldLocation other = (FieldLocation)obj;
            return this.index == other.index;
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        protected String getWhereString() {
            return "@" + this.index;
        }
    }

    public static class IntLocationDecorator
    extends PrimitiveLocationDecorator
    implements IntLocation {
        public IntLocationDecorator(LocationImpl.InternalLongLocation longLocation) {
            super(longLocation);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getInt(store, condition);
        }

        @Override
        public int getInt(DynamicObject store, boolean condition) {
            return (int)this.getLong(store, condition);
        }

        @Override
        public void setInt(DynamicObject store, int value2, Shape shape) throws FinalLocationException {
            this.setLong(store, value2, shape);
        }

        @Override
        public final void setInt(DynamicObject store, int value2) throws FinalLocationException {
            this.setInt(store, value2, null);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value2) throws IncompatibleLocationException {
            if (!this.canStore(value2)) {
                throw IntLocationDecorator.incompatibleLocation();
            }
            this.setLongInternal(store, ((Integer)value2).intValue());
        }

        @Override
        public final int getInt(DynamicObject store, Shape shape) {
            return this.getInt(store, IntLocationDecorator.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value2) {
            return value2 instanceof Integer;
        }

        @Override
        public final void setInt(DynamicObject store, int value2, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value2);
        }

        @Override
        public Class<Integer> getType() {
            return Integer.TYPE;
        }
    }

    public static class LongArrayLocation
    extends ArrayLocation
    implements LocationImpl.InternalLongLocation {
        protected final boolean allowInt;

        public LongArrayLocation(int index2, Location arrayLocation, boolean allowInt) {
            super(index2, arrayLocation);
            this.allowInt = allowInt;
        }

        public LongArrayLocation(int index2, Location arrayLocation) {
            this(index2, arrayLocation, false);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value2) throws IncompatibleLocationException {
            if (!this.canStore(value2)) {
                throw LongArrayLocation.incompatibleLocation();
            }
            this.setLongInternal(store, ((Number)value2).longValue());
        }

        @Override
        public long getLong(DynamicObject store, boolean condition) {
            return ((long[])this.getArray(store, condition))[this.index];
        }

        @Override
        public final void setLongInternal(DynamicObject store, long value2) {
            ((long[])this.getArray((DynamicObject)store, (boolean)false))[this.index] = value2;
        }

        @Override
        public void setLong(DynamicObject store, long value2, Shape shape) throws FinalLocationException {
            this.setLongInternal(store, value2);
        }

        @Override
        public final void setLong(DynamicObject store, long value2, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value2);
        }

        @Override
        public final void setLong(DynamicObject store, long value2) throws FinalLocationException {
            this.setLong(store, value2, null);
        }

        @Override
        public final long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, LongArrayLocation.checkShape(store, shape));
        }

        @Override
        public final boolean canStore(Object value2) {
            return value2 instanceof Long || this.allowInt && value2 instanceof Integer;
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }

        @Override
        public int primitiveArrayCount() {
            return 1;
        }
    }

    public static class LongFieldLocation
    extends MethodHandleFieldLocation
    implements LocationImpl.InternalLongLocation {
        public LongFieldLocation(int index2, MethodHandle getter, MethodHandle setter) {
            super(index2, getter, setter);
        }

        public static LongLocation create(LocationImpl.InternalLongLocation longLocation, boolean allowInt) {
            if (!allowInt && longLocation instanceof LongLocationDecorator || longLocation instanceof LongLocationDecorator && ((LongLocationDecorator)longLocation).allowInt == allowInt) {
                return longLocation;
            }
            return new LongLocationDecorator(longLocation, allowInt);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value2) throws IncompatibleLocationException {
            if (!this.canStore(value2)) {
                throw LongFieldLocation.incompatibleLocation();
            }
            this.setLongInternal(store, (Long)value2);
        }

        @Override
        public final boolean canStore(Object value2) {
            return value2 instanceof Long;
        }

        @Override
        public final void setLong(DynamicObject store, long value2, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value2);
        }

        @Override
        public long getLong(DynamicObject store, boolean condition) {
            try {
                return this.getter.invokeExact(store);
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void setLong(DynamicObject store, long value2, Shape shape) {
            this.setLongInternal(store, value2);
        }

        @Override
        public final void setLong(DynamicObject store, long value2) throws FinalLocationException {
            this.setLong(store, value2, null);
        }

        @Override
        public final void setLongInternal(DynamicObject store, long value2) {
            try {
                this.setter.invokeExact(store, value2);
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public final long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, LongFieldLocation.checkShape(store, shape));
        }

        @Override
        public final int primitiveFieldCount() {
            return 1;
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }
    }

    public static class LongLocationDecorator
    extends PrimitiveLocationDecorator
    implements LocationImpl.InternalLongLocation {
        protected final boolean allowInt;

        public LongLocationDecorator(LocationImpl.InternalLongLocation longLocation, boolean allowInt) {
            super(longLocation);
            this.allowInt = allowInt;
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value2) throws IncompatibleLocationException {
            if (!this.canStore(value2)) {
                throw LongLocationDecorator.incompatibleLocation();
            }
            this.setLongInternal(store, ((Number)value2).longValue());
        }

        @Override
        public final boolean canStore(Object value2) {
            return value2 instanceof Long || this.allowInt && value2 instanceof Integer;
        }

        @Override
        public final void setLong(DynamicObject store, long value2, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value2);
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }
    }

    public static abstract class MethodHandleFieldLocation
    extends FieldLocation {
        protected final MethodHandle getter;
        protected final MethodHandle setter;

        public MethodHandleFieldLocation(int index2, MethodHandle getter, MethodHandle setter) {
            super(index2);
            this.getter = getter;
            this.setter = setter;
        }
    }

    public static class ObjectArrayLocation
    extends ArrayLocation
    implements ObjectLocation {
        public ObjectArrayLocation(int index2, Location arrayLocation) {
            super(index2, arrayLocation);
        }

        @Override
        public Object get(DynamicObject store, boolean condition) {
            return ((Object[])this.getArray(store, condition))[this.index];
        }

        @Override
        public final void setInternal(DynamicObject store, Object value2) throws IncompatibleLocationException {
            ((Object[])this.getArray((DynamicObject)store, (boolean)false))[this.index] = value2;
        }

        @Override
        public boolean canStore(Object value2) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public final boolean isNonNull() {
            return false;
        }

        @Override
        public int objectArrayCount() {
            return 1;
        }
    }

    public static class ObjectFieldLocation
    extends MethodHandleFieldLocation
    implements ObjectLocation {
        public ObjectFieldLocation(int index2, MethodHandle getter, MethodHandle setter) {
            super(index2, getter, setter);
        }

        @Override
        public Object get(DynamicObject store, boolean condition) {
            try {
                return this.getter.invokeExact(store);
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public final void setInternal(DynamicObject store, Object value2) throws IncompatibleLocationException {
            try {
                this.setter.invokeExact(store, value2);
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean canStore(Object value2) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public boolean isNonNull() {
            return false;
        }

        @Override
        public int objectFieldCount() {
            return 1;
        }
    }

    public static abstract class PrimitiveLocationDecorator
    extends LocationImpl {
        private final LocationImpl.InternalLongLocation longLocation;

        public PrimitiveLocationDecorator(LocationImpl.InternalLongLocation longLocation) {
            this.longLocation = longLocation;
        }

        public final long getLong(DynamicObject store, Shape shape) {
            return this.longLocation.getLong(store, shape);
        }

        public final long getLong(DynamicObject store, boolean condition) {
            return this.longLocation.getLong(store, condition);
        }

        public final void setLong(DynamicObject store, long value2, Shape shape) throws FinalLocationException {
            this.longLocation.setLong(store, value2, shape);
        }

        public final void setLong(DynamicObject store, long value2) throws FinalLocationException {
            this.longLocation.setLong(store, value2);
        }

        public final void setLongInternal(DynamicObject store, long value2) {
            this.longLocation.setLongInternal(store, value2);
        }

        @Override
        public final int primitiveFieldCount() {
            return ((LocationImpl)((Object)this.longLocation)).primitiveFieldCount();
        }

        @Override
        public final int primitiveArrayCount() {
            return ((LocationImpl)((Object)this.longLocation)).primitiveArrayCount();
        }
    }

    public static abstract class SimpleLongFieldLocation
    extends FieldLocation
    implements LocationImpl.InternalLongLocation {
        public SimpleLongFieldLocation(int index2) {
            super(index2);
        }

        @Override
        public final Object get(DynamicObject store, boolean condition) {
            return this.getLong(store, condition);
        }

        @Override
        public final void setInternal(DynamicObject store, Object value2) throws IncompatibleLocationException {
            if (!this.canStore(value2)) {
                throw SimpleLongFieldLocation.incompatibleLocation();
            }
            this.setLongInternal(store, ((Number)value2).longValue());
        }

        @Override
        public final boolean canStore(Object value2) {
            return value2 instanceof Long;
        }

        @Override
        public final void setLong(DynamicObject store, long value2, Shape oldShape, Shape newShape) {
            store.setShapeAndGrow(oldShape, newShape);
            this.setLongInternal(store, value2);
        }

        @Override
        public abstract long getLong(DynamicObject var1, boolean var2);

        @Override
        public final long getLong(DynamicObject store, Shape shape) {
            return this.getLong(store, SimpleLongFieldLocation.checkShape(store, shape));
        }

        @Override
        public final void setLong(DynamicObject store, long value2) {
            this.setLong(store, value2, null);
        }

        @Override
        public void setLong(DynamicObject store, long value2, Shape shape) {
            this.setLongInternal(store, value2);
        }

        @Override
        public abstract void setLongInternal(DynamicObject var1, long var2);

        @Override
        public final int primitiveFieldCount() {
            return 1;
        }

        @Override
        public Class<Long> getType() {
            return Long.TYPE;
        }
    }

    public static abstract class SimpleObjectFieldLocation
    extends FieldLocation
    implements ObjectLocation {
        public SimpleObjectFieldLocation(int index2) {
            super(index2);
        }

        @Override
        public abstract Object get(DynamicObject var1, boolean var2);

        @Override
        public abstract void setInternal(DynamicObject var1, Object var2);

        @Override
        public boolean canStore(Object value2) {
            return true;
        }

        @Override
        public Class<? extends Object> getType() {
            return Object.class;
        }

        @Override
        public boolean isNonNull() {
            return false;
        }

        @Override
        public int objectFieldCount() {
            return 1;
        }
    }
}

