/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;

public class UnionAssumption
implements Assumption {
    private final String name;
    private final Assumption first;
    private final Assumption second;

    public UnionAssumption(String name2, Assumption first2, Assumption second) {
        this.name = name2;
        this.first = first2;
        this.second = second;
    }

    public UnionAssumption(Assumption first2, Assumption second) {
        this(null, first2, second);
    }

    @Override
    public void check() throws InvalidAssumptionException {
        this.first.check();
        this.second.check();
    }

    @Override
    public void invalidate() {
        this.first.invalidate();
        this.second.invalidate();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.first.isValid() && this.second.isValid();
    }
}

