/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCloneable;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import sun.misc.Unsafe;

public final class NodeUtil {
    private static final FieldOffsetProvider unsafeFieldOffsetProvider = new FieldOffsetProvider(){

        @Override
        public long objectFieldOffset(Field field2) {
            return unsafe.objectFieldOffset(field2);
        }

        @Override
        public int getTypeSize(Class<?> clazz) {
            if (!clazz.isPrimitive()) {
                return Unsafe.ARRAY_OBJECT_INDEX_SCALE;
            }
            if (clazz == Integer.TYPE) {
                return Unsafe.ARRAY_INT_INDEX_SCALE;
            }
            throw new UnsupportedOperationException("unsupported field type: " + clazz);
        }
    };
    private static final Unsafe unsafe = NodeUtil.getUnsafe();

    static Iterator<Node> makeIterator(Node node) {
        return NodeClass.get(node.getClass()).makeIterator(node);
    }

    public static Iterator<Node> makeRecursiveIterator(Node node) {
        return new RecursiveNodeIterator(node);
    }

    private static long[] toLongArray(List<Long> list2) {
        long[] array = new long[list2.size()];
        int i2 = 0;
        while (i2 < list2.size()) {
            array[i2] = list2.get(i2);
            ++i2;
        }
        return array;
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    public static <T extends Node> T cloneNode(T orig) {
        long fieldOffset;
        Node clone = orig.copy();
        NodeClass nodeClass = NodeClass.get(clone.getClass());
        unsafe.putObject(clone, nodeClass.parentOffset, null);
        long[] lArray = nodeClass.childOffsets;
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            fieldOffset = lArray[n2];
            Node child = (Node)unsafe.getObject(orig, fieldOffset);
            if (child != null) {
                Node clonedChild = NodeUtil.cloneNode(child);
                unsafe.putObject(clonedChild, nodeClass.parentOffset, clone);
                unsafe.putObject(clone, fieldOffset, clonedChild);
            }
            ++n2;
        }
        lArray = nodeClass.childrenOffsets;
        n = lArray.length;
        n2 = 0;
        while (n2 < n) {
            fieldOffset = lArray[n2];
            Object[] children = (Object[])unsafe.getObject(orig, fieldOffset);
            if (children != null) {
                Object[] clonedChildren = (Object[])Array.newInstance(children.getClass().getComponentType(), children.length);
                int i2 = 0;
                while (i2 < children.length) {
                    if (children[i2] != null) {
                        Node clonedChild = NodeUtil.cloneNode((Node)children[i2]);
                        clonedChildren[i2] = clonedChild;
                        unsafe.putObject(clonedChild, nodeClass.parentOffset, clone);
                    }
                    ++i2;
                }
                unsafe.putObject(clone, fieldOffset, clonedChildren);
            }
            ++n2;
        }
        lArray = nodeClass.cloneableOffsets;
        n = lArray.length;
        n2 = 0;
        while (n2 < n) {
            fieldOffset = lArray[n2];
            Object cloneable = unsafe.getObject(clone, fieldOffset);
            if (cloneable != null && cloneable == unsafe.getObject(orig, fieldOffset)) {
                unsafe.putObject(clone, fieldOffset, ((NodeCloneable)cloneable).clone());
            }
            ++n2;
        }
        return (T)clone;
    }

    public static List<Node> findNodeChildren(Node node) {
        long fieldOffset;
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeClass nodeClass = NodeClass.get(node.getClass());
        long[] lArray = nodeClass.childOffsets;
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            fieldOffset = lArray[n2];
            Object child = unsafe.getObject(node, fieldOffset);
            if (child != null) {
                nodes.add((Node)child);
            }
            ++n2;
        }
        lArray = nodeClass.childrenOffsets;
        n = lArray.length;
        n2 = 0;
        while (n2 < n) {
            fieldOffset = lArray[n2];
            Object[] children = (Object[])unsafe.getObject(node, fieldOffset);
            if (children != null) {
                Object[] objectArray = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object child = objectArray[n4];
                    if (child != null) {
                        nodes.add((Node)child);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return nodes;
    }

    public static boolean replaceChild(Node parent, Node oldChild, Node newChild) {
        long fieldOffset;
        NodeClass nodeClass = NodeClass.get(parent.getClass());
        long[] lArray = nodeClass.getChildOffsets();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            fieldOffset = lArray[n2];
            if (unsafe.getObject(parent, fieldOffset) == oldChild) {
                assert (NodeUtil.assertAssignable(nodeClass, fieldOffset, newChild));
                unsafe.putObject(parent, fieldOffset, newChild);
                return true;
            }
            ++n2;
        }
        lArray = nodeClass.getChildrenOffsets();
        n = lArray.length;
        n2 = 0;
        while (n2 < n) {
            fieldOffset = lArray[n2];
            Object arrayObject = unsafe.getObject(parent, fieldOffset);
            if (arrayObject != null) {
                Object[] array = (Object[])arrayObject;
                int i2 = 0;
                while (i2 < array.length) {
                    if (array[i2] == oldChild) {
                        assert (NodeUtil.assertAssignable(nodeClass, fieldOffset, newChild));
                        array[i2] = newChild;
                        return true;
                    }
                    ++i2;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean assertAssignable(NodeClass clazz, long fieldOffset, Object newValue) {
        if (newValue == null) {
            return true;
        }
        NodeField[] nodeFieldArray = clazz.getFields();
        int n = nodeFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeField field2 = nodeFieldArray[n2];
            if (field2.getOffset() == fieldOffset) {
                if (field2.getKind() == NodeFieldKind.CHILD) {
                    if (field2.getType().isAssignableFrom(newValue.getClass())) {
                        return true;
                    }
                    assert (false) : "Child class " + newValue.getClass().getName() + " is not assignable to field \"" + field2.getName() + "\" of type " + field2.getType().getName();
                    return false;
                }
                if (field2.getKind() == NodeFieldKind.CHILDREN) {
                    if (field2.getType().getComponentType().isAssignableFrom(newValue.getClass())) {
                        return true;
                    }
                    assert (false) : "Child class " + newValue.getClass().getName() + " is not assignable to field \"" + field2.getName() + "\" of type " + field2.getType().getName();
                    return false;
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    private static Field[] getAllFields(Class<? extends Object> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        if (clazz.getSuperclass() != null) {
            return NodeUtil.concat(NodeUtil.getAllFields(clazz.getSuperclass()), declaredFields);
        }
        return declaredFields;
    }

    public static <T> T[] concat(T[] first2, T[] second) {
        T[] result2 = Arrays.copyOf(first2, first2.length + second.length);
        System.arraycopy(second, 0, result2, first2.length, second.length);
        return result2;
    }

    public static Node getNthParent(Node node, int n) {
        Node parent = node;
        int i2 = 0;
        while (i2 < n) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
            ++i2;
        }
        return parent;
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClass) {
        if (clazz.getAnnotation(annotationClass) != null) {
            return clazz.getAnnotation(annotationClass);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            if (intf.getAnnotation(annotationClass) != null) {
                return intf.getAnnotation(annotationClass);
            }
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            return NodeUtil.findAnnotation(clazz.getSuperclass(), annotationClass);
        }
        return null;
    }

    public static <T> T findParent(Node start2, Class<T> clazz) {
        Node parent = start2.getParent();
        if (parent == null) {
            return null;
        }
        if (clazz.isInstance(parent)) {
            return clazz.cast(parent);
        }
        return NodeUtil.findParent(parent, clazz);
    }

    public static <T> List<T> findAllParents(Node start2, Class<T> clazz) {
        ArrayList<T> parents = new ArrayList<T>();
        T parent = NodeUtil.findParent(start2, clazz);
        while (parent != null) {
            parents.add(parent);
            parent = NodeUtil.findParent((Node)parent, clazz);
        }
        return parents;
    }

    public static List<Node> collectNodes(Node parent, Node child) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node current2 = child;
        while (current2 != null) {
            nodes.add(current2);
            if (current2 == parent) {
                return nodes;
            }
            current2 = current2.getParent();
        }
        throw new IllegalArgumentException("Node " + parent + " is not a parent of " + child + ".");
    }

    public static <T> T findFirstNodeInstance(Node root, Class<T> clazz) {
        for (Node childNode : NodeUtil.findNodeChildren(root)) {
            if (clazz.isInstance(childNode)) {
                return clazz.cast(childNode);
            }
            T node = NodeUtil.findFirstNodeInstance(childNode, clazz);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static <T> List<T> findAllNodeInstances(Node root, final Class<T> clazz) {
        final ArrayList nodeList = new ArrayList();
        root.accept(new NodeVisitor(){

            @Override
            public boolean visit(Node node) {
                if (clazz.isInstance(node)) {
                    nodeList.add(clazz.cast(node));
                }
                return true;
            }
        });
        return nodeList;
    }

    public static <T> List<T> findNodeInstancesShallow(Node root, final Class<T> clazz) {
        final ArrayList nodeList = new ArrayList();
        root.accept(new NodeVisitor(){

            @Override
            public boolean visit(Node node) {
                if (clazz.isInstance(node)) {
                    nodeList.add(clazz.cast(node));
                    return false;
                }
                return true;
            }
        });
        return nodeList;
    }

    public static int countNodes(Node root) {
        Iterator<Node> nodeIterator = NodeUtil.makeRecursiveIterator(root);
        int count2 = 0;
        while (nodeIterator.hasNext()) {
            nodeIterator.next();
            ++count2;
        }
        return count2;
    }

    public static int countNodes(Node root, NodeCountFilter filter) {
        Iterator<Node> nodeIterator = NodeUtil.makeRecursiveIterator(root);
        int count2 = 0;
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.next();
            if (node == null || !filter.isCounted(node)) continue;
            ++count2;
        }
        return count2;
    }

    public static String printCompactTreeToString(Node node) {
        StringWriter out = new StringWriter();
        NodeUtil.printCompactTree(new PrintWriter(out), null, node, 1);
        return out.toString();
    }

    public static void printCompactTree(OutputStream out, Node node) {
        NodeUtil.printCompactTree(new PrintWriter(out), null, node, 1);
    }

    private static void printCompactTree(PrintWriter p2, Node parent, Node node, int level2) {
        if (node == null) {
            return;
        }
        int i2 = 0;
        while (i2 < level2) {
            p2.print("  ");
            ++i2;
        }
        if (parent == null) {
            p2.println(NodeUtil.nodeName(node));
        } else {
            p2.print(NodeUtil.getNodeFieldName(parent, node, "unknownField"));
            p2.print(" = ");
            p2.println(NodeUtil.nodeName(node));
        }
        for (Node child : node.getChildren()) {
            NodeUtil.printCompactTree(p2, node, child, level2 + 1);
        }
        p2.flush();
    }

    public static String printSourceAttributionTree(Node node) {
        StringWriter out = new StringWriter();
        NodeUtil.printSourceAttributionTree(new PrintWriter(out), null, node, 1);
        return out.toString();
    }

    public static void printSourceAttributionTree(OutputStream out, Node node) {
        NodeUtil.printSourceAttributionTree(new PrintWriter(out), null, node, 1);
    }

    private static void printSourceAttributionTree(PrintWriter p2, Node parent, Node node, int level2) {
        SourceSection sourceSection;
        if (node == null) {
            return;
        }
        if (parent == null && (sourceSection = node.getSourceSection()) != null) {
            String txt = sourceSection.getSource().getCode();
            p2.println("Full source len=(" + txt.length() + ")  ___" + txt + "___");
            p2.println("AST source attribution:");
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < level2) {
            sb.append("| ");
            ++i2;
        }
        if (parent != null) {
            sb.append(NodeUtil.getNodeFieldName(parent, node, ""));
        }
        sb.append("  (" + node.getClass().getSimpleName() + ")  ");
        sb.append(NodeUtil.printSyntaxTags(node));
        sb.append(NodeUtil.displaySourceAttribution(node));
        p2.println(sb.toString());
        for (Node child : node.getChildren()) {
            NodeUtil.printSourceAttributionTree(p2, node, child, level2 + 1);
        }
        p2.flush();
    }

    private static String getNodeFieldName(Node parent, Node node, String defaultName) {
        NodeField[] fields2;
        NodeField[] nodeFieldArray = fields2 = NodeClass.get(parent.getClass()).fields;
        int n = fields2.length;
        int n2 = 0;
        while (n2 < n) {
            NodeField field2 = nodeFieldArray[n2];
            Object value2 = field2.loadValue(parent);
            if (field2.getKind() == NodeFieldKind.CHILD && value2 == node) {
                return field2.getName();
            }
            if (field2.getKind() == NodeFieldKind.CHILDREN) {
                int index2 = 0;
                Object[] objectArray = (Object[])value2;
                int n3 = objectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object arrayNode = objectArray[n4];
                    if (arrayNode == node) {
                        return String.valueOf(field2.getName()) + "[" + index2 + "]";
                    }
                    ++index2;
                    ++n4;
                }
            }
            ++n2;
        }
        return defaultName;
    }

    public static String printSyntaxTags(Object node) {
        if (node instanceof ProbeNode.WrapperNode) {
            Probe probe = ((ProbeNode.WrapperNode)node).getProbe();
            Collection<SyntaxTag> syntaxTags = probe.getSyntaxTags();
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            sb.append("[");
            for (SyntaxTag tag2 : syntaxTags) {
                sb.append(prefix);
                prefix = ",";
                sb.append(tag2.toString());
            }
            sb.append("]");
            return sb.toString();
        }
        return "";
    }

    public static void printTree(OutputStream out, Node node) {
        NodeUtil.printTree(new PrintWriter(out), node);
    }

    public static String printTreeToString(Node node) {
        StringWriter out = new StringWriter();
        NodeUtil.printTree(new PrintWriter(out), node);
        return out.toString();
    }

    public static void printTree(PrintWriter p2, Node node) {
        NodeUtil.printTree(p2, node, 1);
        p2.println();
        p2.flush();
    }

    private static void printTree(PrintWriter p2, Node node, int level2) {
        if (node == null) {
            p2.print("null");
            return;
        }
        p2.print(NodeUtil.nodeName(node));
        ArrayList<NodeField> childFields = new ArrayList<NodeField>();
        String sep = "";
        p2.print("(");
        NodeField[] nodeFieldArray = NodeClass.get(node.getClass()).fields;
        int n = nodeFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeField field2 = nodeFieldArray[n2];
            if (field2.getKind() == NodeFieldKind.CHILD || field2.getKind() == NodeFieldKind.CHILDREN) {
                childFields.add(field2);
            } else if (field2.getKind() == NodeFieldKind.DATA) {
                p2.print(sep);
                sep = ", ";
                p2.print(field2.getName());
                p2.print(" = ");
                p2.print(field2.loadValue(node));
            }
            ++n2;
        }
        p2.print(")");
        if (childFields.size() != 0) {
            p2.print(" {");
            for (NodeField field2 : childFields) {
                NodeUtil.printNewLine(p2, level2);
                p2.print(field2.getName());
                Object value2 = field2.loadValue(node);
                if (value2 == null) {
                    p2.print(" = null ");
                    continue;
                }
                if (field2.getKind() == NodeFieldKind.CHILD) {
                    p2.print(" = ");
                    NodeUtil.printTree(p2, (Node)value2, level2 + 1);
                    continue;
                }
                if (field2.getKind() != NodeFieldKind.CHILDREN) continue;
                NodeUtil.printChildren(p2, level2, value2);
            }
            NodeUtil.printNewLine(p2, level2 - 1);
            p2.print("}");
        }
    }

    private static void printChildren(PrintWriter p2, int level2, Object value2) {
        Object[] children = (Object[])value2;
        p2.print(" = [");
        String sep = "";
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            p2.print(sep);
            sep = ", ";
            NodeUtil.printTree(p2, (Node)child, level2 + 1);
            ++n2;
        }
        p2.print("]");
    }

    private static void printNewLine(PrintWriter p2, int level2) {
        p2.println();
        int i2 = 0;
        while (i2 < level2) {
            p2.print("    ");
            ++i2;
        }
    }

    private static String nodeName(Node node) {
        return node.getClass().getSimpleName();
    }

    private static String displaySourceAttribution(Node node) {
        SourceSection section = node.getSourceSection();
        if (section instanceof NullSourceSection) {
            return "source: " + section.getShortDescription();
        }
        if (section != null) {
            String srcText = section.getCode();
            StringBuilder sb = new StringBuilder();
            sb.append("source:");
            sb.append(" (" + section.getCharIndex() + "," + (section.getCharEndIndex() - 1) + ")");
            sb.append(" len=" + srcText.length());
            sb.append(" text=\"" + srcText + "\"");
            return sb.toString();
        }
        return "";
    }

    public static boolean verify(Node root) {
        Iterable<Node> children = root.getChildren();
        for (Node child : children) {
            if (child == null) continue;
            if (child.getParent() != root) {
                throw new AssertionError((Object)(String.valueOf(NodeUtil.toStringWithClass(child)) + ": actual parent=" + NodeUtil.toStringWithClass(child.getParent()) + " expected parent=" + NodeUtil.toStringWithClass(root)));
            }
            NodeUtil.verify(child);
        }
        return true;
    }

    private static String toStringWithClass(Object obj) {
        return obj == null ? "null" : obj + "(" + obj.getClass().getName() + ")";
    }

    static void traceRewrite(Node oldNode, Node newNode, CharSequence reason2) {
        if (TruffleOptions.TraceRewritesFilterFromCost != null && NodeUtil.filterByKind(oldNode, TruffleOptions.TraceRewritesFilterFromCost)) {
            return;
        }
        if (TruffleOptions.TraceRewritesFilterToCost != null && NodeUtil.filterByKind(newNode, TruffleOptions.TraceRewritesFilterToCost)) {
            return;
        }
        String filter = TruffleOptions.TraceRewritesFilterClass;
        Class<?> from = oldNode.getClass();
        Class<?> to = newNode.getClass();
        if (filter != null && (NodeUtil.filterByContainsClassName(from, filter) || NodeUtil.filterByContainsClassName(to, filter))) {
            return;
        }
        SourceSection reportedSourceSection = oldNode.getEncapsulatingSourceSection();
        PrintStream out = System.out;
        out.printf("[truffle]   rewrite %-50s |From %-40s |To %-40s |Reason %s%s%n", oldNode.toString(), NodeUtil.formatNodeInfo(oldNode), NodeUtil.formatNodeInfo(newNode), reason2 != null && reason2.length() > 0 ? reason2 : "unknown", reportedSourceSection != null ? " at " + reportedSourceSection.getShortDescription() : "");
    }

    private static String formatNodeInfo(Node node) {
        String cost = "?";
        switch (node.getCost()) {
            case NONE: {
                cost = "G";
                break;
            }
            case MONOMORPHIC: {
                cost = "M";
                break;
            }
            case POLYMORPHIC: {
                cost = "P";
                break;
            }
            case MEGAMORPHIC: {
                cost = "G";
                break;
            }
            default: {
                cost = "?";
            }
        }
        return String.valueOf(cost) + " " + node.getClass().getSimpleName();
    }

    private static boolean filterByKind(Node node, NodeCost cost) {
        return node.getCost() == cost;
    }

    private static boolean filterByContainsClassName(Class<? extends Node> from, String filter) {
        Class<? extends Node> currentFrom = from;
        while (currentFrom != null) {
            if (currentFrom.getName().contains(filter)) {
                return false;
            }
            currentFrom = currentFrom.getSuperclass();
        }
        return true;
    }

    public static interface FieldOffsetProvider {
        public long objectFieldOffset(Field var1);

        public int getTypeSize(Class<?> var1);
    }

    public static final class NodeClass {
        private static final ClassValue<NodeClass> nodeClasses = new ClassValue<NodeClass>(){

            @Override
            protected NodeClass computeValue(final Class<?> clazz) {
                if (!$assertionsDisabled && !Node.class.isAssignableFrom(clazz)) {
                    throw new AssertionError();
                }
                return AccessController.doPrivileged(new PrivilegedAction<NodeClass>(){

                    @Override
                    public NodeClass run() {
                        return new NodeClass(clazz, unsafeFieldOffsetProvider);
                    }
                });
            }
        };
        private final NodeField[] fields;
        private final long parentOffset;
        private final long[] childOffsets;
        private final long[] childrenOffsets;
        private final long[] cloneableOffsets;
        private final Class<? extends Node> clazz;

        public static NodeClass get(Class<? extends Node> clazz) {
            return nodeClasses.get(clazz);
        }

        public NodeClass(Class<? extends Node> clazz, FieldOffsetProvider fieldOffsetProvider) {
            ArrayList<NodeField> fieldsList = new ArrayList<NodeField>();
            long parentFieldOffset = -1L;
            ArrayList<Long> childOffsetsList = new ArrayList<Long>();
            ArrayList<Long> childrenOffsetsList = new ArrayList<Long>();
            ArrayList<Long> cloneableOffsetsList = new ArrayList<Long>();
            Field[] fieldArray = NodeUtil.getAllFields(clazz);
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field2 = fieldArray[n2];
                if (!Modifier.isStatic(field2.getModifiers()) && !field2.isSynthetic()) {
                    NodeFieldKind kind;
                    if (field2.getDeclaringClass() == Node.class && field2.getName().equals("parent")) {
                        assert (Node.class.isAssignableFrom(field2.getType()));
                        kind = NodeFieldKind.PARENT;
                        parentFieldOffset = fieldOffsetProvider.objectFieldOffset(field2);
                    } else if (field2.getAnnotation(Node.Child.class) != null) {
                        NodeClass.checkChildField(field2);
                        kind = NodeFieldKind.CHILD;
                        childOffsetsList.add(fieldOffsetProvider.objectFieldOffset(field2));
                    } else if (field2.getAnnotation(Node.Children.class) != null) {
                        NodeClass.checkChildrenField(field2);
                        kind = NodeFieldKind.CHILDREN;
                        childrenOffsetsList.add(fieldOffsetProvider.objectFieldOffset(field2));
                    } else if (NodeCloneable.class.isAssignableFrom(field2.getType())) {
                        kind = NodeFieldKind.DATA;
                        cloneableOffsetsList.add(fieldOffsetProvider.objectFieldOffset(field2));
                    } else {
                        kind = NodeFieldKind.DATA;
                    }
                    fieldsList.add(new NodeField(kind, field2.getType(), field2.getName(), fieldOffsetProvider.objectFieldOffset(field2)));
                }
                ++n2;
            }
            if (parentFieldOffset < 0L) {
                throw new AssertionError((Object)"parent field not found");
            }
            this.fields = fieldsList.toArray(new NodeField[fieldsList.size()]);
            this.parentOffset = parentFieldOffset;
            this.childOffsets = NodeUtil.toLongArray(childOffsetsList);
            this.childrenOffsets = NodeUtil.toLongArray(childrenOffsetsList);
            this.cloneableOffsets = NodeUtil.toLongArray(cloneableOffsetsList);
            this.clazz = clazz;
        }

        private static boolean isNodeType(Class<?> clazz) {
            return Node.class.isAssignableFrom(clazz) || clazz.isInterface() && NodeInterface.class.isAssignableFrom(clazz);
        }

        private static void checkChildField(Field field2) {
            if (!NodeClass.isNodeType(field2.getType())) {
                throw new AssertionError((Object)("@Child field type must be a subclass of Node or an interface extending NodeInterface (" + field2 + ")"));
            }
            if (Modifier.isFinal(field2.getModifiers())) {
                throw new AssertionError((Object)("@Child field must not be final (" + field2 + ")"));
            }
        }

        private static void checkChildrenField(Field field2) {
            if (!field2.getType().isArray() || !NodeClass.isNodeType(field2.getType().getComponentType())) {
                throw new AssertionError((Object)("@Children field type must be an array of a subclass of Node or an interface extending NodeInterface (" + field2 + ")"));
            }
            if (!Modifier.isFinal(field2.getModifiers())) {
                throw new AssertionError((Object)("@Children field must be final (" + field2 + ")"));
            }
        }

        public NodeField[] getFields() {
            return this.fields;
        }

        public long getParentOffset() {
            return this.parentOffset;
        }

        public long[] getChildOffsets() {
            return this.childOffsets;
        }

        public long[] getChildrenOffsets() {
            return this.childrenOffsets;
        }

        public int hashCode() {
            return Arrays.hashCode(this.fields) ^ Arrays.hashCode(this.childOffsets) ^ Arrays.hashCode(this.childrenOffsets) ^ Long.valueOf(this.parentOffset).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeClass) {
                NodeClass other = (NodeClass)obj;
                return Arrays.equals(this.fields, other.fields) && Arrays.equals(this.childOffsets, other.childOffsets) && Arrays.equals(this.childrenOffsets, other.childrenOffsets) && this.parentOffset == other.parentOffset;
            }
            return false;
        }

        public Iterator<Node> makeIterator(Node node) {
            assert (this.clazz.isInstance(node));
            return new NodeIterator(node);
        }

        private final class NodeIterator
        implements Iterator<Node> {
            private final Node node;
            private final int childrenCount;
            private int index;

            protected NodeIterator(Node node) {
                this.node = node;
                this.index = 0;
                this.childrenCount = this.childrenCount();
            }

            private int childrenCount() {
                int nodeCount = NodeClass.this.childOffsets.length;
                long[] lArray = NodeClass.this.childrenOffsets;
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long fieldOffset = lArray[n2];
                    Object[] children = (Object[])unsafe.getObject(this.node, fieldOffset);
                    if (children != null) {
                        nodeCount += children.length;
                    }
                    ++n2;
                }
                return nodeCount;
            }

            private Node nodeAt(int idx) {
                int nodeCount = NodeClass.this.childOffsets.length;
                if (idx < nodeCount) {
                    return (Node)unsafe.getObject(this.node, NodeClass.this.childOffsets[idx]);
                }
                long[] lArray = NodeClass.this.childrenOffsets;
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long fieldOffset = lArray[n2];
                    Object[] nodeArray = (Object[])unsafe.getObject(this.node, fieldOffset);
                    if (idx < nodeCount + nodeArray.length) {
                        return (Node)nodeArray[idx - nodeCount];
                    }
                    nodeCount += nodeArray.length;
                    ++n2;
                }
                return null;
            }

            private void forward() {
                if (this.index < this.childrenCount) {
                    ++this.index;
                }
            }

            @Override
            public boolean hasNext() {
                return this.index < this.childrenCount;
            }

            @Override
            public Node next() {
                try {
                    Node node = this.nodeAt(this.index);
                    return node;
                }
                finally {
                    this.forward();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface NodeCountFilter {
        public boolean isCounted(Node var1);
    }

    public static final class NodeField {
        private final NodeFieldKind kind;
        private final Class<?> type;
        private final String name;
        private long offset;

        protected NodeField(NodeFieldKind kind, Class<?> type2, String name2, long offset2) {
            this.kind = kind;
            this.type = type2;
            this.name = name2;
            this.offset = offset2;
        }

        public NodeFieldKind getKind() {
            return this.kind;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public long getOffset() {
            return this.offset;
        }

        public Object loadValue(Node node) {
            if (this.type == Boolean.TYPE) {
                return unsafe.getBoolean(node, this.offset);
            }
            if (this.type == Byte.TYPE) {
                return unsafe.getByte(node, this.offset);
            }
            if (this.type == Short.TYPE) {
                return unsafe.getShort(node, this.offset);
            }
            if (this.type == Character.TYPE) {
                return Character.valueOf(unsafe.getChar(node, this.offset));
            }
            if (this.type == Integer.TYPE) {
                return unsafe.getInt(node, this.offset);
            }
            if (this.type == Long.TYPE) {
                return unsafe.getLong(node, this.offset);
            }
            if (this.type == Float.TYPE) {
                return Float.valueOf(unsafe.getFloat(node, this.offset));
            }
            if (this.type == Double.TYPE) {
                return unsafe.getDouble(node, this.offset);
            }
            return unsafe.getObject(node, this.offset);
        }

        public int hashCode() {
            return this.kind.hashCode() | this.type.hashCode() | this.name.hashCode() | Long.valueOf(this.offset).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeField) {
                NodeField other = (NodeField)obj;
                return this.offset == other.offset && this.name.equals(other.name) && this.type.equals(other.type) && this.kind.equals((Object)other.kind);
            }
            return false;
        }
    }

    public static enum NodeFieldKind {
        PARENT,
        CHILD,
        CHILDREN,
        DATA;

    }

    private static final class RecursiveNodeIterator
    implements Iterator<Node> {
        private final List<Iterator<Node>> iteratorStack = new ArrayList<Iterator<Node>>();

        public RecursiveNodeIterator(final Node node) {
            this.iteratorStack.add(new Iterator<Node>(){
                private boolean visited;

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Node next() {
                    if (this.visited) {
                        throw new NoSuchElementException();
                    }
                    this.visited = true;
                    return node;
                }

                @Override
                public boolean hasNext() {
                    return !this.visited;
                }
            });
        }

        @Override
        public boolean hasNext() {
            return this.peekIterator() != null;
        }

        @Override
        public Node next() {
            Iterator<Node> childIterator;
            Iterator<Node> iterator = this.peekIterator();
            if (iterator == null) {
                throw new NoSuchElementException();
            }
            Node node = iterator.next();
            if (node != null && (childIterator = NodeUtil.makeIterator(node)).hasNext()) {
                this.iteratorStack.add(childIterator);
            }
            return node;
        }

        private Iterator<Node> peekIterator() {
            int tos = this.iteratorStack.size() - 1;
            while (tos >= 0) {
                Iterator<Node> iterable = this.iteratorStack.get(tos);
                if (iterable.hasNext()) {
                    return iterable;
                }
                this.iteratorStack.remove(tos--);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

