/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument.impl;

import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LineToSourceSectionMap
implements Probe.ProbeListener {
    private static final boolean TRACE = false;
    private static final PrintStream OUT = System.out;
    private final Map<LineLocation, Collection<SourceSection>> lineToSourceSectionsMap = new HashMap<LineLocation, Collection<SourceSection>>();

    private static void trace(String msg) {
        OUT.println("LineToSourceSectionMap: " + msg);
    }

    @Override
    public void startASTProbing(Source source2) {
    }

    @Override
    public void newProbeInserted(Probe probe) {
        SourceSection sourceSection = probe.getProbedSourceSection();
        if (sourceSection != null && !(sourceSection instanceof NullSourceSection)) {
            LineLocation lineLocation = sourceSection.getLineLocation();
            this.addSourceSectionToLine(lineLocation, sourceSection);
        }
    }

    @Override
    public void probeTaggedAs(Probe probe, SyntaxTag tag2, Object tagValue) {
    }

    @Override
    public void endASTProbing(Source source2) {
    }

    protected void addSourceSectionToLine(LineLocation line, SourceSection sourceSection) {
        if (!this.lineToSourceSectionsMap.containsKey(line)) {
            ArrayList<SourceSection> newSourceSectionList = new ArrayList<SourceSection>(2);
            newSourceSectionList.add(sourceSection);
            this.lineToSourceSectionsMap.put(line, newSourceSectionList);
        } else {
            Collection<SourceSection> existingSourceSectionList = this.lineToSourceSectionsMap.get(line);
            existingSourceSectionList.add(sourceSection);
        }
    }

    public Collection<SourceSection> getSourceSectionsAtLine(LineLocation line) {
        Collection<SourceSection> sourceSectionList = this.lineToSourceSectionsMap.get(line);
        if (sourceSectionList == null) {
            return Collections.emptyList();
        }
        return sourceSectionList;
    }

    public Collection<SourceSection> getSourceSectionsAtLineNumber(int lineNumber) {
        Set<LineLocation> keySet = this.lineToSourceSectionsMap.keySet();
        if (keySet.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SourceSection> sourceSections = new ArrayList<SourceSection>();
        for (LineLocation line : keySet) {
            if (line.getLineNumber() != lineNumber) continue;
            sourceSections.addAll(this.lineToSourceSectionsMap.get(line));
        }
        return sourceSections;
    }
}

