/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument.impl;

import com.oracle.truffle.api.instrument.ASTPrinter;
import com.oracle.truffle.api.instrument.InstrumentationNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public class DefaultASTPrinter
implements ASTPrinter {
    @Override
    public void printTree(PrintWriter p2, Node node, int maxDepth, Node markNode) {
        this.printTree(p2, node, maxDepth, markNode, 1);
        p2.println();
        p2.flush();
    }

    @Override
    public String printTreeToString(Node node, int maxDepth, Node markNode) {
        StringWriter out = new StringWriter();
        this.printTree(new PrintWriter(out), node, maxDepth, markNode);
        return out.toString();
    }

    @Override
    public String printTreeToString(Node node, int maxDepth) {
        return this.printTreeToString(node, maxDepth, null);
    }

    protected void printTree(PrintWriter p2, Node node, int maxDepth, Node markNode, int level2) {
        if (node == null) {
            p2.print("null");
            return;
        }
        p2.print(DefaultASTPrinter.nodeName(node));
        p2.print("(");
        if (node instanceof InstrumentationNode) {
            p2.print(DefaultASTPrinter.instrumentInfo((InstrumentationNode)((Object)node)));
        }
        p2.print(DefaultASTPrinter.sourceInfo(node));
        p2.print(NodeUtil.printSyntaxTags(node));
        ArrayList<NodeUtil.NodeField> childFields = new ArrayList<NodeUtil.NodeField>();
        NodeUtil.NodeField[] nodeFieldArray = NodeUtil.NodeClass.get(node.getClass()).getFields();
        int n = nodeFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeUtil.NodeField field2 = nodeFieldArray[n2];
            if (field2.getKind() == NodeUtil.NodeFieldKind.CHILD || field2.getKind() == NodeUtil.NodeFieldKind.CHILDREN) {
                childFields.add(field2);
            } else {
                field2.getKind();
            }
            ++n2;
        }
        p2.print(")");
        if (level2 <= maxDepth && childFields.size() != 0) {
            p2.print(" {");
            for (NodeUtil.NodeField field2 : childFields) {
                Object value2 = field2.loadValue(node);
                if (value2 == null) {
                    DefaultASTPrinter.printNewLine(p2, level2);
                    p2.print(field2.getName());
                    p2.print(" = null ");
                    continue;
                }
                if (field2.getKind() == NodeUtil.NodeFieldKind.CHILD) {
                    this.printChild(p2, maxDepth, markNode, level2, field2, value2);
                    continue;
                }
                if (field2.getKind() == NodeUtil.NodeFieldKind.CHILDREN) {
                    this.printChildren(p2, maxDepth, markNode, level2, field2, value2);
                    continue;
                }
                DefaultASTPrinter.printNewLine(p2, level2);
                p2.print(field2.getName());
            }
            DefaultASTPrinter.printNewLine(p2, level2 - 1);
            p2.print("}");
        }
    }

    protected void printChildren(PrintWriter p2, int maxDepth, Node markNode, int level2, NodeUtil.NodeField field2, Object value2) {
        DefaultASTPrinter.printNewLine(p2, level2);
        p2.print(field2.getName());
        Node[] children = (Node[])value2;
        p2.print(" = [");
        String sep = "";
        Node[] nodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Node child = nodeArray[n2];
            p2.print(sep);
            sep = ", ";
            this.printTree(p2, child, maxDepth, markNode, level2 + 1);
            ++n2;
        }
        p2.print("]");
    }

    protected void printChild(PrintWriter p2, int maxDepth, Node markNode, int level2, NodeUtil.NodeField field2, Object value2) {
        Node valueNode = (Node)value2;
        DefaultASTPrinter.printNewLine(p2, level2, valueNode == markNode);
        p2.print(field2.getName());
        p2.print(" = ");
        this.printTree(p2, valueNode, maxDepth, markNode, level2 + 1);
    }

    protected static void printNewLine(PrintWriter p2, int level2, boolean mark2) {
        p2.println();
        int i2 = 0;
        while (i2 < level2) {
            if (mark2 && i2 == 0) {
                p2.print(" -->");
            } else {
                p2.print("    ");
            }
            ++i2;
        }
    }

    protected static void printNewLine(PrintWriter p2, int level2) {
        DefaultASTPrinter.printNewLine(p2, level2, false);
    }

    protected static String nodeName(Node node) {
        return node.getClass().getSimpleName();
    }

    protected static String sourceInfo(Node node) {
        SourceSection src = node.getSourceSection();
        if (src != null) {
            if (src instanceof NullSourceSection) {
                NullSourceSection nullSection = (NullSourceSection)src;
                return nullSection.getShortDescription();
            }
            return String.valueOf(src.getSource().getName()) + ":" + src.getStartLine();
        }
        return "";
    }

    protected static String instrumentInfo(InstrumentationNode node) {
        String info = node.instrumentationInfo();
        return info == null ? "" : info;
    }
}

