/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.InstrumentationNode;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.TruffleEventReceiver;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;

public final class Instrument {
    private final TruffleEventReceiver toolEventreceiver;
    private final String instrumentInfo;
    private boolean isDisposed = false;
    private Probe probe = null;

    public static Instrument create(TruffleEventReceiver receiver2, String instrumentInfo) {
        return new Instrument(receiver2, instrumentInfo);
    }

    public static Instrument create(TruffleEventReceiver receiver2) {
        return new Instrument(receiver2, null);
    }

    private Instrument(TruffleEventReceiver receiver2, String instrumentInfo) {
        this.toolEventreceiver = receiver2;
        this.instrumentInfo = instrumentInfo;
    }

    public void dispose() throws IllegalStateException {
        if (this.isDisposed) {
            throw new IllegalStateException("Attempt to dispose an already disposed Instrumennt");
        }
        if (this.probe != null) {
            this.probe.disposeInstrument(this);
        }
        this.isDisposed = true;
    }

    Probe getProbe() {
        return this.probe;
    }

    void setAttachedTo(Probe probe) {
        this.probe = probe;
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    InstrumentNode addToChain(InstrumentNode nextNode) {
        return new InstrumentNode(nextNode);
    }

    InstrumentNode removeFromChain(InstrumentNode instrumentNode) {
        boolean found = false;
        if (instrumentNode != null) {
            if (instrumentNode.getInstrument() == this) {
                return instrumentNode.nextInstrument;
            }
            found = instrumentNode.removeFromChain(this);
        }
        if (!found) {
            throw new IllegalStateException("Couldn't find instrument node to remove: " + this);
        }
        return instrumentNode;
    }

    @NodeInfo(cost=NodeCost.NONE)
    final class InstrumentNode
    extends Node
    implements TruffleEventReceiver,
    InstrumentationNode {
        @Node.Child
        private InstrumentNode nextInstrument;

        private InstrumentNode(InstrumentNode nextNode) {
            this.nextInstrument = nextNode;
        }

        private Instrument getInstrument() {
            return Instrument.this;
        }

        private boolean removeFromChain(Instrument instrument) {
            assert (this.getInstrument() != instrument);
            if (this.nextInstrument == null) {
                return false;
            }
            if (this.nextInstrument.getInstrument() == instrument) {
                if (this.nextInstrument.nextInstrument == null) {
                    this.nextInstrument = null;
                } else {
                    this.nextInstrument.replace(this.nextInstrument.nextInstrument);
                }
                return true;
            }
            return this.nextInstrument.removeFromChain(instrument);
        }

        @Override
        public void enter(Node node, VirtualFrame frame) {
            Instrument.this.toolEventreceiver.enter(node, frame);
            if (this.nextInstrument != null) {
                this.nextInstrument.enter(node, frame);
            }
        }

        @Override
        public void returnVoid(Node node, VirtualFrame frame) {
            Instrument.this.toolEventreceiver.returnVoid(node, frame);
            if (this.nextInstrument != null) {
                this.nextInstrument.returnVoid(node, frame);
            }
        }

        @Override
        public void returnValue(Node node, VirtualFrame frame, Object result2) {
            Instrument.this.toolEventreceiver.returnValue(node, frame, result2);
            if (this.nextInstrument != null) {
                this.nextInstrument.returnValue(node, frame, result2);
            }
        }

        @Override
        public void returnExceptional(Node node, VirtualFrame frame, Exception exception2) {
            Instrument.this.toolEventreceiver.returnExceptional(node, frame, exception2);
            if (this.nextInstrument != null) {
                this.nextInstrument.returnExceptional(node, frame, exception2);
            }
        }

        @Override
        public String instrumentationInfo() {
            if (Instrument.this.instrumentInfo != null) {
                return Instrument.this.instrumentInfo;
            }
            return Instrument.this.toolEventreceiver.getClass().getSimpleName();
        }
    }
}

