/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.ConvertDouble;
import org.jruby.util.Numeric;

@JRubyClass(name={"Numeric"}, include={"Comparable"})
public class RubyNumeric
extends RubyObject {
    protected static final ObjectAllocator NUMERIC_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNumeric(runtime, klass);
        }
    };
    public static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final ByteListCaller18 biteListCaller18 = new ByteListCaller18();
    private static final ByteListCaller19 biteListCaller19 = new ByteListCaller19();

    public static RubyClass createNumericClass(Ruby runtime) {
        RubyClass numeric = runtime.defineClass("Numeric", runtime.getObject(), NUMERIC_ALLOCATOR);
        runtime.setNumeric(numeric);
        numeric.index = 17;
        numeric.setReifiedClass(RubyNumeric.class);
        numeric.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyNumeric;
            }
        };
        numeric.includeModule(runtime.getComparable());
        numeric.defineAnnotatedMethods(RubyNumeric.class);
        return numeric;
    }

    private static IRubyObject convertToNum(double val, Ruby runtime) {
        if (val >= 9.223372036854776E18 || val < -9.223372036854776E18) {
            return RubyBignum.newBignum(runtime, val);
        }
        return RubyFixnum.newFixnum(runtime, (long)val);
    }

    public RubyNumeric(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public RubyNumeric(RubyClass metaClass) {
        super(metaClass);
    }

    public RubyNumeric(Ruby runtime, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime, metaClass, useObjectSpace);
    }

    @Deprecated
    public RubyNumeric(Ruby runtime, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime, metaClass, useObjectSpace, canBeTainted);
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public long getLongValue() {
        return 0L;
    }

    public BigInteger getBigIntegerValue() {
        return BigInteger.ZERO;
    }

    public static RubyNumeric newNumeric(Ruby runtime) {
        return new RubyNumeric(runtime, runtime.getNumeric());
    }

    public static int num2int(IRubyObject arg2) {
        long num = RubyNumeric.num2long(arg2);
        RubyNumeric.checkInt(arg2, num);
        return (int)num;
    }

    public static void checkInt(IRubyObject arg2, long num) {
        if (num < Integer.MIN_VALUE) {
            RubyNumeric.tooSmall(arg2, num);
        } else if (num > Integer.MAX_VALUE) {
            RubyNumeric.tooBig(arg2, num);
        } else {
            return;
        }
    }

    private static void tooSmall(IRubyObject arg2, long num) {
        throw arg2.getRuntime().newRangeError("integer " + num + " too small to convert to `int'");
    }

    private static void tooBig(IRubyObject arg2, long num) {
        throw arg2.getRuntime().newRangeError("integer " + num + " too big to convert to `int'");
    }

    public static byte num2chr(IRubyObject arg2) {
        String value2;
        if (arg2 instanceof RubyString && (value2 = ((RubyString)arg2).toString()) != null && value2.length() > 0) {
            return (byte)value2.charAt(0);
        }
        return (byte)RubyNumeric.num2int(arg2);
    }

    public static long num2long(IRubyObject arg2) {
        if (arg2 instanceof RubyFixnum) {
            return ((RubyFixnum)arg2).getLongValue();
        }
        return RubyNumeric.other2long(arg2);
    }

    private static long other2long(IRubyObject arg2) throws RaiseException {
        if (arg2.isNil()) {
            throw arg2.getRuntime().newTypeError("no implicit conversion from nil to integer");
        }
        if (arg2 instanceof RubyFloat) {
            return RubyNumeric.float2long((RubyFloat)arg2);
        }
        if (arg2 instanceof RubyBignum) {
            return RubyBignum.big2long((RubyBignum)arg2);
        }
        return arg2.convertToInteger().getLongValue();
    }

    private static long float2long(RubyFloat flt) {
        double aFloat = flt.getDoubleValue();
        if (aFloat <= 9.223372036854776E18 && aFloat >= -9.223372036854776E18) {
            return (long)aFloat;
        }
        throw flt.getRuntime().newRangeError("float " + aFloat + " out of range of integer");
    }

    public static IRubyObject dbl2num(Ruby runtime, double val) {
        if (Double.isInfinite(val)) {
            throw runtime.newFloatDomainError(val < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(val)) {
            throw runtime.newFloatDomainError("NaN");
        }
        return RubyNumeric.convertToNum(val, runtime);
    }

    public static double num2dbl(IRubyObject arg2) {
        if (arg2 instanceof RubyFloat) {
            return ((RubyFloat)arg2).getDoubleValue();
        }
        if (arg2 instanceof RubyString) {
            throw arg2.getRuntime().newTypeError("no implicit conversion to float from string");
        }
        if (arg2 == arg2.getRuntime().getNil()) {
            throw arg2.getRuntime().newTypeError("no implicit conversion to float from nil");
        }
        return RubyKernel.new_float(arg2, arg2).getDoubleValue();
    }

    public static IRubyObject dbl_cmp(Ruby runtime, double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return runtime.getNil();
        }
        return a == b ? RubyFixnum.zero(runtime) : (a > b ? RubyFixnum.one(runtime) : RubyFixnum.minus_one(runtime));
    }

    public static long fix2long(IRubyObject arg2) {
        return ((RubyFixnum)arg2).getLongValue();
    }

    public static int fix2int(IRubyObject arg2) {
        long num = arg2 instanceof RubyFixnum ? RubyNumeric.fix2long(arg2) : RubyNumeric.num2long(arg2);
        RubyNumeric.checkInt(arg2, num);
        return (int)num;
    }

    public static int fix2int(RubyFixnum arg2) {
        long num = arg2.getLongValue();
        RubyNumeric.checkInt(arg2, num);
        return (int)num;
    }

    public static RubyInteger str2inum(Ruby runtime, RubyString str, int base) {
        return RubyNumeric.str2inum(runtime, str, base, false);
    }

    public static RubyNumeric int2fix(Ruby runtime, long val) {
        return RubyFixnum.newFixnum(runtime, val);
    }

    public static IRubyObject num2fix(IRubyObject val) {
        if (val instanceof RubyFixnum) {
            return val;
        }
        if (val instanceof RubyBignum) {
            throw val.getRuntime().newRangeError("integer " + val + " out of range of fixnum");
        }
        return RubyFixnum.newFixnum(val.getRuntime(), RubyNumeric.num2long(val));
    }

    public static RubyInteger str2inum(Ruby runtime, RubyString str, int base, boolean strict) {
        ByteList s2 = str.getByteList();
        return ConvertBytes.byteListToInum(runtime, s2, base, strict);
    }

    public static RubyFloat str2fnum(Ruby runtime, RubyString arg2) {
        return RubyNumeric.str2fnum(runtime, arg2, false);
    }

    public static RubyFloat str2fnum(Ruby runtime, RubyString arg2, boolean strict) {
        return RubyNumeric.str2fnumCommon(runtime, arg2, strict, biteListCaller18);
    }

    public static RubyFloat str2fnum19(Ruby runtime, RubyString arg2, boolean strict) {
        return RubyNumeric.str2fnumCommon(runtime, arg2, strict, biteListCaller19);
    }

    private static RubyFloat str2fnumCommon(Ruby runtime, RubyString arg2, boolean strict, ByteListCaller caller2) {
        double ZERO = 0.0;
        try {
            return new RubyFloat(runtime, caller2.yield(arg2, strict));
        }
        catch (NumberFormatException e) {
            if (strict) {
                throw runtime.newArgumentError("invalid value for Float(): " + arg2.callMethod(runtime.getCurrentContext(), "inspect").toString());
            }
            return new RubyFloat(runtime, 0.0);
        }
    }

    protected IRubyObject[] getCoerced(ThreadContext context, IRubyObject other, boolean error2) {
        IRubyObject result2;
        try {
            result2 = other.callMethod(context, "coerce", this);
        }
        catch (RaiseException e) {
            if (error2) {
                throw this.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(result2 instanceof RubyArray) || ((RubyArray)result2).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return ((RubyArray)result2).toJavaArray();
    }

    protected IRubyObject callCoerced(ThreadContext context, String method2, IRubyObject other, boolean err) {
        IRubyObject[] args2 = this.getCoerced(context, other, err);
        if (args2 == null) {
            return this.getRuntime().getNil();
        }
        return args2[0].callMethod(context, method2, args2[1]);
    }

    public IRubyObject callCoerced(ThreadContext context, String method2, IRubyObject other) {
        IRubyObject[] args2 = this.getCoerced(context, other, false);
        if (args2 == null) {
            return this.getRuntime().getNil();
        }
        return args2[0].callMethod(context, method2, args2[1]);
    }

    protected final IRubyObject coerceBody(ThreadContext context, IRubyObject other) {
        return other.callMethod(context, "coerce", this);
    }

    protected final RubyArray doCoerce(ThreadContext context, IRubyObject other, boolean err) {
        IRubyObject result2;
        try {
            result2 = this.coerceBody(context, other);
        }
        catch (RaiseException e) {
            if (err) {
                throw this.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(result2 instanceof RubyArray) || ((RubyArray)result2).getLength() != 2) {
            if (err) {
                throw this.getRuntime().newTypeError("coerce must return [x, y]");
            }
            return null;
        }
        return (RubyArray)result2;
    }

    protected final IRubyObject coerceBin(ThreadContext context, String method2, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, true);
        return ary.eltInternal(0).callMethod(context, method2, ary.eltInternal(1));
    }

    protected final IRubyObject coerceCmp(ThreadContext context, String method2, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return this.getRuntime().getNil();
        }
        return ary.eltInternal(0).callMethod(context, method2, ary.eltInternal(1));
    }

    protected final IRubyObject coerceRelOp(ThreadContext context, String method2, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return RubyComparable.cmperr(this, other);
        }
        return this.unwrapCoerced(context, method2, other, ary);
    }

    private final IRubyObject unwrapCoerced(ThreadContext context, String method2, IRubyObject other, RubyArray ary) {
        IRubyObject result2 = ary.eltInternal(0).callMethod(context, method2, ary.eltInternal(1));
        if (result2.isNil()) {
            return RubyComparable.cmperr(this, other);
        }
        return result2;
    }

    public RubyNumeric asNumeric() {
        return this;
    }

    @JRubyMethod(name={"singleton_method_added"})
    public IRubyObject sadded(IRubyObject name2) {
        throw this.getRuntime().newTypeError("can't define singleton method " + name2 + " for " + this.getType().getName());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject arg2) {
        throw this.getRuntime().newTypeError("can't copy " + this.getType().getName());
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(IRubyObject other) {
        if (this.getMetaClass() == other.getMetaClass()) {
            return this.getRuntime().newArray(other, (IRubyObject)this);
        }
        RubyFloat cdr = RubyKernel.new_float(this, this);
        RubyFloat car = RubyKernel.new_float(this, other);
        return this.getRuntime().newArray((IRubyObject)car, (IRubyObject)cdr);
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"i"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject num_imaginary(ThreadContext context) {
        return RubyComplex.newComplexRaw(context.runtime, RubyFixnum.zero(context.runtime), this);
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext context) {
        RubyArray ary = RubyFixnum.zero(context.runtime).doCoerce(context, this, true);
        return ary.eltInternal(0).callMethod(context, "-", ary.eltInternal(1));
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(IRubyObject other) {
        if (this == other) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this.getClass() != other.getClass()) {
            return this.getRuntime().getFalse();
        }
        return RubyNumeric.equalInternal(context, this, other) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"quo", "fdiv"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "/", other);
    }

    @JRubyMethod(name={"quo"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject quo_19(ThreadContext context, IRubyObject other) {
        return RubyRational.newRationalRaw(context.runtime, this).callMethod(context, "/", other);
    }

    @JRubyMethod(name={"div"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject div(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "/", other).convertToFloat().floor();
    }

    @JRubyMethod(name={"div"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject div19(ThreadContext context, IRubyObject other) {
        RubyNumeric numeric;
        if (other instanceof RubyNumeric && (numeric = (RubyNumeric)other).zero_p(context).isTrue()) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.callMethod(context, "/", other).callMethod(context, "floor");
    }

    @JRubyMethod(name={"divmod"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        return RubyArray.newArray(this.getRuntime(), this.div(context, other), this.modulo(context, other));
    }

    @JRubyMethod(name={"divmod"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject divmod19(ThreadContext context, IRubyObject other) {
        return RubyArray.newArray(this.getRuntime(), this.div(context, other), this.modulo19(context, other));
    }

    @JRubyMethod(name={"fdiv"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        return Helpers.invoke(context, (IRubyObject)this.convertToFloat(), "/", other);
    }

    @JRubyMethod(name={"modulo"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject modulo(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "%", other);
    }

    @JRubyMethod(name={"modulo"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject modulo19(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "-", other.callMethod(context, "*", this.callMethod(context, "div", other)));
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext context, IRubyObject dividend) {
        IRubyObject z = this.callMethod(context, "%", dividend);
        RubyNumeric x = this;
        RubyFixnum zero = RubyFixnum.zero(this.getRuntime());
        if (!RubyNumeric.equalInternal(context, z, zero) && (x.callMethod(context, "<", (IRubyObject)zero).isTrue() && dividend.callMethod(context, ">", zero).isTrue() || x.callMethod(context, ">", (IRubyObject)zero).isTrue() && dividend.callMethod(context, "<", zero).isTrue())) {
            return z.callMethod(context, "-", dividend);
        }
        return z;
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext context) {
        if (this.callMethod(context, "<", (IRubyObject)RubyFixnum.zero(this.getRuntime())).isTrue()) {
            return this.callMethod(context, "-@");
        }
        return this;
    }

    @JRubyMethod(name={"magnitude"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @JRubyMethod(name={"to_int"})
    public IRubyObject to_int(ThreadContext context) {
        return Helpers.invoke(context, this, "to_i");
    }

    @JRubyMethod(name={"real?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject scalar_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext context) {
        return RubyNumeric.equalInternal(context, this, RubyFixnum.zero(this.getRuntime())) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p(ThreadContext context) {
        if (this.callMethod(context, "zero?").isTrue()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return this.convertToFloat().floor();
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return this.convertToFloat().ceil();
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        return this.convertToFloat().round();
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate() {
        return this.convertToFloat().truncate();
    }

    @JRubyMethod
    public IRubyObject step(ThreadContext context, IRubyObject arg0, Block block) {
        return block.isGiven() ? this.stepCommon(context, arg0, RubyFixnum.one(context.runtime), block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "step", arg0);
    }

    @JRubyMethod
    public IRubyObject step(ThreadContext context, IRubyObject to, IRubyObject step2, Block block) {
        return block.isGiven() ? this.stepCommon(context, to, step2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "step", new IRubyObject[]{to, step2});
    }

    private IRubyObject stepCommon(ThreadContext context, IRubyObject to, IRubyObject step2, Block block) {
        Ruby runtime = context.runtime;
        if (this instanceof RubyFixnum && to instanceof RubyFixnum && step2 instanceof RubyFixnum) {
            RubyNumeric.fixnumStep(context, runtime, ((RubyFixnum)this).getLongValue(), ((RubyFixnum)to).getLongValue(), ((RubyFixnum)step2).getLongValue(), block);
        } else if (this instanceof RubyFloat || to instanceof RubyFloat || step2 instanceof RubyFloat) {
            RubyNumeric.floatStep19(context, runtime, this, to, step2, false, block);
        } else {
            RubyNumeric.duckStep(context, runtime, this, to, step2, block);
        }
        return this;
    }

    private static void fixnumStep(ThreadContext context, Ruby runtime, long from, long to, long step2, Block block) {
        if (step2 == 0L) {
            throw runtime.newArgumentError("step cannot be 0");
        }
        if (step2 > 0L) {
            long i2;
            long tov = Long.MAX_VALUE - step2;
            if (to < tov) {
                tov = to;
            }
            for (i2 = from; i2 <= tov; i2 += step2) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i2));
            }
            if (i2 <= to) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i2));
            }
        } else {
            long i3;
            long tov = Long.MIN_VALUE - step2;
            if (to > tov) {
                tov = to;
            }
            for (i3 = from; i3 >= tov; i3 += step2) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i3));
            }
            if (i3 >= to) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i3));
            }
        }
    }

    protected static void floatStep(ThreadContext context, Ruby runtime, IRubyObject from, IRubyObject to, IRubyObject step2, Block block) {
        double beg = RubyNumeric.num2dbl(from);
        double end2 = RubyNumeric.num2dbl(to);
        double unit = RubyNumeric.num2dbl(step2);
        if (unit == 0.0) {
            throw runtime.newArgumentError("step cannot be 0");
        }
        double n = (end2 - beg) / unit;
        double err = (Math.abs(beg) + Math.abs(end2) + Math.abs(end2 - beg)) / Math.abs(unit) * 2.220446049250313E-16;
        if (err > 0.5) {
            err = 0.5;
        }
        n = Math.floor(n + err) + 1.0;
        long i2 = 0L;
        while ((double)i2 < n) {
            block.yield(context, RubyFloat.newFloat(runtime, (double)i2 * unit + beg));
            ++i2;
        }
    }

    static void floatStep19(ThreadContext context, Ruby runtime, IRubyObject from, IRubyObject to, IRubyObject step2, boolean excl, Block block) {
        double beg = RubyNumeric.num2dbl(from);
        double end2 = RubyNumeric.num2dbl(to);
        double unit = RubyNumeric.num2dbl(step2);
        if (unit == 0.0) {
            throw runtime.newArgumentError("step cannot be 0");
        }
        double n = (end2 - beg) / unit;
        double err = (Math.abs(beg) + Math.abs(end2) + Math.abs(end2 - beg)) / Math.abs(unit) * 2.220446049250313E-16;
        if (Double.isInfinite(unit)) {
            if (unit > 0.0) {
                block.yield(context, RubyFloat.newFloat(runtime, beg));
            }
        } else {
            if (err > 0.5) {
                err = 0.5;
            }
            n = Math.floor(n + err);
            if (!excl) {
                n += 1.0;
            }
            long i2 = 0L;
            while ((double)i2 < n) {
                block.yield(context, RubyFloat.newFloat(runtime, (double)i2 * unit + beg));
                ++i2;
            }
        }
    }

    private static void duckStep(ThreadContext context, Ruby runtime, IRubyObject from, IRubyObject to, IRubyObject step2, Block block) {
        String cmpString;
        IRubyObject i2 = from;
        String string2 = cmpString = step2.callMethod(context, ">", RubyFixnum.zero(runtime)).isTrue() ? ">" : "<";
        while (!i2.callMethod(context, cmpString, to).isTrue()) {
            block.yield(context, i2);
            i2 = i2.callMethod(context, "+", step2);
        }
    }

    protected final IRubyObject op_num_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        return Helpers.invokedynamic(context, other, MethodNames.OP_EQUAL, (IRubyObject)this);
    }

    @JRubyMethod(name={"numerator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject numerator(ThreadContext context) {
        return RubyRational.newRationalConvert(context, this).callMethod(context, "numerator");
    }

    @JRubyMethod(name={"denominator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject denominator(ThreadContext context) {
        return RubyRational.newRationalConvert(context, this).callMethod(context, "denominator");
    }

    @JRubyMethod(name={"to_c"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_c(ThreadContext context) {
        return RubyComplex.newComplexCanonicalize(context, this);
    }

    @JRubyMethod(name={"real"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject real(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"imaginary", "imag"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject image(ThreadContext context) {
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"abs2"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject abs2(ThreadContext context) {
        return Numeric.f_mul(context, this, this);
    }

    @JRubyMethod(name={"arg", "angle", "phase"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject arg(ThreadContext context) {
        double value2 = this.getDoubleValue();
        if (Double.isNaN(value2)) {
            return this;
        }
        if (Numeric.f_negative_p(context, this) || value2 == 0.0 && 1.0 / value2 == Double.NEGATIVE_INFINITY) {
            return context.runtime.getMath().getConstant("PI");
        }
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"rectangular", "rect"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rect(ThreadContext context) {
        return context.runtime.newArray((IRubyObject)this, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod(name={"polar"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject polar(ThreadContext context) {
        return context.runtime.newArray(Numeric.f_abs(context, this), Numeric.f_arg(context, this));
    }

    @JRubyMethod(name={"conjugate", "conj"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject conjugate(ThreadContext context) {
        return this;
    }

    @Override
    public Object toJava(Class target) {
        return JavaUtil.getNumericConverter(target).coerce(this, target);
    }

    public static class NumberTooLargeException
    extends NumberFormatException {
        private static final long serialVersionUID = -1835120694982699449L;

        public NumberTooLargeException() {
        }

        public NumberTooLargeException(String message2) {
            super(message2);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class InvalidIntegerException
    extends NumberFormatException {
        private static final long serialVersionUID = 55019452543252148L;

        public InvalidIntegerException() {
        }

        public InvalidIntegerException(String message2) {
            super(message2);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class ByteListCaller19
    implements ByteListCaller {
        private ByteListCaller19() {
        }

        @Override
        public double yield(RubyString arg2, boolean strict) {
            return ConvertDouble.byteListToDouble19(arg2.getByteList(), strict);
        }
    }

    private static class ByteListCaller18
    implements ByteListCaller {
        private ByteListCaller18() {
        }

        @Override
        public double yield(RubyString arg2, boolean strict) {
            return ConvertDouble.byteListToDouble(arg2.getByteList(), strict);
        }
    }

    private static interface ByteListCaller {
        public double yield(RubyString var1, boolean var2);
    }
}

